"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectLevelMrApprovals = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals}
*/
class ProjectLevelMrApprovals extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_level_mr_approvals gitlab_project_level_mr_approvals} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectLevelMrApprovalsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project_level_mr_approvals',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._disableOverridingApproversPerMergeRequest = config.disableOverridingApproversPerMergeRequest;
        this._id = config.id;
        this._mergeRequestsAuthorApproval = config.mergeRequestsAuthorApproval;
        this._mergeRequestsDisableCommittersApproval = config.mergeRequestsDisableCommittersApproval;
        this._projectId = config.projectId;
        this._requirePasswordToApprove = config.requirePasswordToApprove;
        this._resetApprovalsOnPush = config.resetApprovalsOnPush;
    }
    get disableOverridingApproversPerMergeRequest() {
        return this.getBooleanAttribute('disable_overriding_approvers_per_merge_request');
    }
    set disableOverridingApproversPerMergeRequest(value) {
        this._disableOverridingApproversPerMergeRequest = value;
    }
    resetDisableOverridingApproversPerMergeRequest() {
        this._disableOverridingApproversPerMergeRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableOverridingApproversPerMergeRequestInput() {
        return this._disableOverridingApproversPerMergeRequest;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get mergeRequestsAuthorApproval() {
        return this.getBooleanAttribute('merge_requests_author_approval');
    }
    set mergeRequestsAuthorApproval(value) {
        this._mergeRequestsAuthorApproval = value;
    }
    resetMergeRequestsAuthorApproval() {
        this._mergeRequestsAuthorApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAuthorApprovalInput() {
        return this._mergeRequestsAuthorApproval;
    }
    get mergeRequestsDisableCommittersApproval() {
        return this.getBooleanAttribute('merge_requests_disable_committers_approval');
    }
    set mergeRequestsDisableCommittersApproval(value) {
        this._mergeRequestsDisableCommittersApproval = value;
    }
    resetMergeRequestsDisableCommittersApproval() {
        this._mergeRequestsDisableCommittersApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsDisableCommittersApprovalInput() {
        return this._mergeRequestsDisableCommittersApproval;
    }
    get projectId() {
        return this.getNumberAttribute('project_id');
    }
    set projectId(value) {
        this._projectId = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectIdInput() {
        return this._projectId;
    }
    get requirePasswordToApprove() {
        return this.getBooleanAttribute('require_password_to_approve');
    }
    set requirePasswordToApprove(value) {
        this._requirePasswordToApprove = value;
    }
    resetRequirePasswordToApprove() {
        this._requirePasswordToApprove = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirePasswordToApproveInput() {
        return this._requirePasswordToApprove;
    }
    get resetApprovalsOnPush() {
        return this.getBooleanAttribute('reset_approvals_on_push');
    }
    set resetApprovalsOnPush(value) {
        this._resetApprovalsOnPush = value;
    }
    resetResetApprovalsOnPush() {
        this._resetApprovalsOnPush = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resetApprovalsOnPushInput() {
        return this._resetApprovalsOnPush;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            disable_overriding_approvers_per_merge_request: cdktf.booleanToTerraform(this._disableOverridingApproversPerMergeRequest),
            id: cdktf.stringToTerraform(this._id),
            merge_requests_author_approval: cdktf.booleanToTerraform(this._mergeRequestsAuthorApproval),
            merge_requests_disable_committers_approval: cdktf.booleanToTerraform(this._mergeRequestsDisableCommittersApproval),
            project_id: cdktf.numberToTerraform(this._projectId),
            require_password_to_approve: cdktf.booleanToTerraform(this._requirePasswordToApprove),
            reset_approvals_on_push: cdktf.booleanToTerraform(this._resetApprovalsOnPush),
        };
    }
}
exports.ProjectLevelMrApprovals = ProjectLevelMrApprovals;
_a = JSII_RTTI_SYMBOL_1;
ProjectLevelMrApprovals[_a] = { fqn: "@cdktf/provider-gitlab.ProjectLevelMrApprovals", version: "0.1.53" };
// =================
// STATIC PROPERTIES
// =================
ProjectLevelMrApprovals.tfResourceType = "gitlab_project_level_mr_approvals";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvamVjdC1sZXZlbC1tci1hcHByb3ZhbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcHJvamVjdC1sZXZlbC1tci1hcHByb3ZhbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFJQSwrQkFBK0I7QUFrRC9COztFQUVFO0FBQ0YsTUFBYSx1QkFBd0IsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBT2xFLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQXFDO1FBQ3BGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsbUNBQW1DO1lBQzFELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsUUFBUTtnQkFDdEIsZUFBZSxFQUFFLFFBQVE7Z0JBQ3pCLHlCQUF5QixFQUFFLFdBQVc7YUFDdkM7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7U0FDNUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLE1BQU0sQ0FBQyx5Q0FBeUMsQ0FBQztRQUNuRyxJQUFJLENBQUMsR0FBRyxHQUFHLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFDckIsSUFBSSxDQUFDLDRCQUE0QixHQUFHLE1BQU0sQ0FBQywyQkFBMkIsQ0FBQztRQUN2RSxJQUFJLENBQUMsdUNBQXVDLEdBQUcsTUFBTSxDQUFDLHNDQUFzQyxDQUFDO1FBQzdGLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsTUFBTSxDQUFDLHdCQUF3QixDQUFDO1FBQ2pFLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7SUFDM0QsQ0FBQztJQVFELElBQVcseUNBQXlDO1FBQ2xELE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGdEQUFnRCxDQUFDLENBQUM7SUFDcEYsQ0FBQztJQUNELElBQVcseUNBQXlDLENBQUMsS0FBa0M7UUFDckYsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLEtBQUssQ0FBQztJQUMxRCxDQUFDO0lBQ00sOENBQThDO1FBQ25ELElBQUksQ0FBQywwQ0FBMEMsR0FBRyxTQUFTLENBQUM7SUFDOUQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDhDQUE4QztRQUN2RCxPQUFPLElBQUksQ0FBQywwQ0FBMEMsQ0FBQztJQUN6RCxDQUFDO0lBSUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDcEUsQ0FBQztJQUNELElBQVcsMkJBQTJCLENBQUMsS0FBa0M7UUFDdkUsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQztJQUM1QyxDQUFDO0lBQ00sZ0NBQWdDO1FBQ3JDLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxTQUFTLENBQUM7SUFDaEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdDQUFnQztRQUN6QyxPQUFPLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztJQUMzQyxDQUFDO0lBSUQsSUFBVyxzQ0FBc0M7UUFDL0MsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsNENBQTRDLENBQUMsQ0FBQztJQUNoRixDQUFDO0lBQ0QsSUFBVyxzQ0FBc0MsQ0FBQyxLQUFrQztRQUNsRixJQUFJLENBQUMsdUNBQXVDLEdBQUcsS0FBSyxDQUFDO0lBQ3ZELENBQUM7SUFDTSwyQ0FBMkM7UUFDaEQsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLFNBQVMsQ0FBQztJQUMzRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMkNBQTJDO1FBQ3BELE9BQU8sSUFBSSxDQUFDLHVDQUF1QyxDQUFDO0lBQ3RELENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQWE7UUFDaEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2pFLENBQUM7SUFDRCxJQUFXLHdCQUF3QixDQUFDLEtBQWtDO1FBQ3BFLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUM7SUFDekMsQ0FBQztJQUNNLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsU0FBUyxDQUFDO0lBQzdDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw2QkFBNkI7UUFDdEMsT0FBTyxJQUFJLENBQUMseUJBQXlCLENBQUM7SUFDeEMsQ0FBQztJQUlELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDN0QsQ0FBQztJQUNELElBQVcsb0JBQW9CLENBQUMsS0FBa0M7UUFDaEUsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQztJQUNyQyxDQUFDO0lBQ00seUJBQXlCO1FBQzlCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxTQUFTLENBQUM7SUFDekMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztJQUNwQyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCw4Q0FBOEMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLDBDQUEwQyxDQUFDO1lBQ3pILEVBQUUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztZQUNyQyw4QkFBOEIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLDRCQUE0QixDQUFDO1lBQzNGLDBDQUEwQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsdUNBQXVDLENBQUM7WUFDbEgsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO1lBQ3BELDJCQUEyQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUM7WUFDckYsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztTQUM5RSxDQUFDO0lBQ0osQ0FBQzs7QUF2S0gsMERBd0tDOzs7QUF0S0Msb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyxzQ0FBYyxHQUFHLG1DQUFtQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dpdGxhYi9yL3Byb2plY3RfbGV2ZWxfbXJfYXBwcm92YWxzXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgUHJvamVjdExldmVsTXJBcHByb3ZhbHNDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgLyoqXG4gICogQnkgZGVmYXVsdCwgdXNlcnMgYXJlIGFibGUgdG8gZWRpdCB0aGUgYXBwcm92YWwgcnVsZXMgaW4gbWVyZ2UgcmVxdWVzdHMuIElmIHNldCB0byB0cnVlLFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dpdGxhYi9yL3Byb2plY3RfbGV2ZWxfbXJfYXBwcm92YWxzI2Rpc2FibGVfb3ZlcnJpZGluZ19hcHByb3ZlcnNfcGVyX21lcmdlX3JlcXVlc3QgUHJvamVjdExldmVsTXJBcHByb3ZhbHMjZGlzYWJsZV9vdmVycmlkaW5nX2FwcHJvdmVyc19wZXJfbWVyZ2VfcmVxdWVzdH1cbiAgKi9cbiAgcmVhZG9ubHkgZGlzYWJsZU92ZXJyaWRpbmdBcHByb3ZlcnNQZXJNZXJnZVJlcXVlc3Q/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dpdGxhYi9yL3Byb2plY3RfbGV2ZWxfbXJfYXBwcm92YWxzI2lkIFByb2plY3RMZXZlbE1yQXBwcm92YWxzI2lkfVxuICAqXG4gICogUGxlYXNlIGJlIGF3YXJlIHRoYXQgdGhlIGlkIGZpZWxkIGlzIGF1dG9tYXRpY2FsbHkgYWRkZWQgdG8gYWxsIHJlc291cmNlcyBpbiBUZXJyYWZvcm0gcHJvdmlkZXJzIHVzaW5nIGEgVGVycmFmb3JtIHByb3ZpZGVyIFNESyB2ZXJzaW9uIGJlbG93IDIuXG4gICogSWYgeW91IGV4cGVyaWVuY2UgcHJvYmxlbXMgc2V0dGluZyB0aGlzIHZhbHVlIGl0IG1pZ2h0IG5vdCBiZSBzZXR0YWJsZS4gUGxlYXNlIHRha2UgYSBsb29rIGF0IHRoZSBwcm92aWRlciBkb2N1bWVudGF0aW9uIHRvIGVuc3VyZSBpdCBzaG91bGQgYmUgc2V0dGFibGUuXG4gICovXG4gIHJlYWRvbmx5IGlkPzogc3RyaW5nO1xuICAvKipcbiAgKiBTZXQgdG8gYHRydWVgIGlmIHlvdSB3YW50IHRvIGFsbG93IG1lcmdlIHJlcXVlc3QgYXV0aG9ycyB0byBzZWxmLWFwcHJvdmUgbWVyZ2UgcmVxdWVzdHMuIEF1dGhvcnNcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9naXRsYWIvci9wcm9qZWN0X2xldmVsX21yX2FwcHJvdmFscyNtZXJnZV9yZXF1ZXN0c19hdXRob3JfYXBwcm92YWwgUHJvamVjdExldmVsTXJBcHByb3ZhbHMjbWVyZ2VfcmVxdWVzdHNfYXV0aG9yX2FwcHJvdmFsfVxuICAqL1xuICByZWFkb25seSBtZXJnZVJlcXVlc3RzQXV0aG9yQXBwcm92YWw/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFNldCB0byBgdHJ1ZWAgaWYgeW91IHdhbnQgdG8gcHJldmVudCBhcHByb3ZhbCBvZiBtZXJnZSByZXF1ZXN0cyBieSBtZXJnZSByZXF1ZXN0IGNvbW1pdHRlcnMuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ2l0bGFiL3IvcHJvamVjdF9sZXZlbF9tcl9hcHByb3ZhbHMjbWVyZ2VfcmVxdWVzdHNfZGlzYWJsZV9jb21taXR0ZXJzX2FwcHJvdmFsIFByb2plY3RMZXZlbE1yQXBwcm92YWxzI21lcmdlX3JlcXVlc3RzX2Rpc2FibGVfY29tbWl0dGVyc19hcHByb3ZhbH1cbiAgKi9cbiAgcmVhZG9ubHkgbWVyZ2VSZXF1ZXN0c0Rpc2FibGVDb21taXR0ZXJzQXBwcm92YWw/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBJRCBvZiB0aGUgcHJvamVjdCB0byBjaGFuZ2UgTVIgYXBwcm92YWwgY29uZmlndXJhdGlvbi5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9naXRsYWIvci9wcm9qZWN0X2xldmVsX21yX2FwcHJvdmFscyNwcm9qZWN0X2lkIFByb2plY3RMZXZlbE1yQXBwcm92YWxzI3Byb2plY3RfaWR9XG4gICovXG4gIHJlYWRvbmx5IHByb2plY3RJZDogbnVtYmVyO1xuICAvKipcbiAgKiBTZXQgdG8gYHRydWVgIGlmIHlvdSB3YW50IHRvIHJlcXVpcmUgYXV0aGVudGljYXRpb24gd2hlbiBhcHByb3ZpbmcgYSBtZXJnZSByZXF1ZXN0LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dpdGxhYi9yL3Byb2plY3RfbGV2ZWxfbXJfYXBwcm92YWxzI3JlcXVpcmVfcGFzc3dvcmRfdG9fYXBwcm92ZSBQcm9qZWN0TGV2ZWxNckFwcHJvdmFscyNyZXF1aXJlX3Bhc3N3b3JkX3RvX2FwcHJvdmV9XG4gICovXG4gIHJlYWRvbmx5IHJlcXVpcmVQYXNzd29yZFRvQXBwcm92ZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogU2V0IHRvIGB0cnVlYCBpZiB5b3Ugd2FudCB0byByZW1vdmUgYWxsIGFwcHJvdmFscyBpbiBhIG1lcmdlIHJlcXVlc3Qgd2hlbiBuZXcgY29tbWl0cyBhcmUgcHVzaGVkIHRvIGl0cyBzb3VyY2UgYnJhbmNoLiBEZWZhdWx0IGlzIGB0cnVlYC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9naXRsYWIvci9wcm9qZWN0X2xldmVsX21yX2FwcHJvdmFscyNyZXNldF9hcHByb3ZhbHNfb25fcHVzaCBQcm9qZWN0TGV2ZWxNckFwcHJvdmFscyNyZXNldF9hcHByb3ZhbHNfb25fcHVzaH1cbiAgKi9cbiAgcmVhZG9ubHkgcmVzZXRBcHByb3ZhbHNPblB1c2g/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9naXRsYWIvci9wcm9qZWN0X2xldmVsX21yX2FwcHJvdmFscyBnaXRsYWJfcHJvamVjdF9sZXZlbF9tcl9hcHByb3ZhbHN9XG4qL1xuZXhwb3J0IGNsYXNzIFByb2plY3RMZXZlbE1yQXBwcm92YWxzIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtUmVzb3VyY2Uge1xuXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBQUk9QRVJUSUVTXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgdGZSZXNvdXJjZVR5cGUgPSBcImdpdGxhYl9wcm9qZWN0X2xldmVsX21yX2FwcHJvdmFsc1wiO1xuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgLyoqXG4gICogQ3JlYXRlIGEgbmV3IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ2l0bGFiL3IvcHJvamVjdF9sZXZlbF9tcl9hcHByb3ZhbHMgZ2l0bGFiX3Byb2plY3RfbGV2ZWxfbXJfYXBwcm92YWxzfSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBQcm9qZWN0TGV2ZWxNckFwcHJvdmFsc0NvbmZpZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBQcm9qZWN0TGV2ZWxNckFwcHJvdmFsc0NvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnZ2l0bGFiX3Byb2plY3RfbGV2ZWxfbXJfYXBwcm92YWxzJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2dpdGxhYicsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzMuMTQuMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiAzLjE0LjAnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGVcbiAgICB9KTtcbiAgICB0aGlzLl9kaXNhYmxlT3ZlcnJpZGluZ0FwcHJvdmVyc1Blck1lcmdlUmVxdWVzdCA9IGNvbmZpZy5kaXNhYmxlT3ZlcnJpZGluZ0FwcHJvdmVyc1Blck1lcmdlUmVxdWVzdDtcbiAgICB0aGlzLl9pZCA9IGNvbmZpZy5pZDtcbiAgICB0aGlzLl9tZXJnZVJlcXVlc3RzQXV0aG9yQXBwcm92YWwgPSBjb25maWcubWVyZ2VSZXF1ZXN0c0F1dGhvckFwcHJvdmFsO1xuICAgIHRoaXMuX21lcmdlUmVxdWVzdHNEaXNhYmxlQ29tbWl0dGVyc0FwcHJvdmFsID0gY29uZmlnLm1lcmdlUmVxdWVzdHNEaXNhYmxlQ29tbWl0dGVyc0FwcHJvdmFsO1xuICAgIHRoaXMuX3Byb2plY3RJZCA9IGNvbmZpZy5wcm9qZWN0SWQ7XG4gICAgdGhpcy5fcmVxdWlyZVBhc3N3b3JkVG9BcHByb3ZlID0gY29uZmlnLnJlcXVpcmVQYXNzd29yZFRvQXBwcm92ZTtcbiAgICB0aGlzLl9yZXNldEFwcHJvdmFsc09uUHVzaCA9IGNvbmZpZy5yZXNldEFwcHJvdmFsc09uUHVzaDtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gZGlzYWJsZV9vdmVycmlkaW5nX2FwcHJvdmVyc19wZXJfbWVyZ2VfcmVxdWVzdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kaXNhYmxlT3ZlcnJpZGluZ0FwcHJvdmVyc1Blck1lcmdlUmVxdWVzdD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZGlzYWJsZU92ZXJyaWRpbmdBcHByb3ZlcnNQZXJNZXJnZVJlcXVlc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZGlzYWJsZV9vdmVycmlkaW5nX2FwcHJvdmVyc19wZXJfbWVyZ2VfcmVxdWVzdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGlzYWJsZU92ZXJyaWRpbmdBcHByb3ZlcnNQZXJNZXJnZVJlcXVlc3QodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2Rpc2FibGVPdmVycmlkaW5nQXBwcm92ZXJzUGVyTWVyZ2VSZXF1ZXN0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGlzYWJsZU92ZXJyaWRpbmdBcHByb3ZlcnNQZXJNZXJnZVJlcXVlc3QoKSB7XG4gICAgdGhpcy5fZGlzYWJsZU92ZXJyaWRpbmdBcHByb3ZlcnNQZXJNZXJnZVJlcXVlc3QgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRpc2FibGVPdmVycmlkaW5nQXBwcm92ZXJzUGVyTWVyZ2VSZXF1ZXN0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rpc2FibGVPdmVycmlkaW5nQXBwcm92ZXJzUGVyTWVyZ2VSZXF1ZXN0O1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SWQoKSB7XG4gICAgdGhpcy5faWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkO1xuICB9XG5cbiAgLy8gbWVyZ2VfcmVxdWVzdHNfYXV0aG9yX2FwcHJvdmFsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21lcmdlUmVxdWVzdHNBdXRob3JBcHByb3ZhbD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgbWVyZ2VSZXF1ZXN0c0F1dGhvckFwcHJvdmFsKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ21lcmdlX3JlcXVlc3RzX2F1dGhvcl9hcHByb3ZhbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWVyZ2VSZXF1ZXN0c0F1dGhvckFwcHJvdmFsKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9tZXJnZVJlcXVlc3RzQXV0aG9yQXBwcm92YWwgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNZXJnZVJlcXVlc3RzQXV0aG9yQXBwcm92YWwoKSB7XG4gICAgdGhpcy5fbWVyZ2VSZXF1ZXN0c0F1dGhvckFwcHJvdmFsID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtZXJnZVJlcXVlc3RzQXV0aG9yQXBwcm92YWxJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWVyZ2VSZXF1ZXN0c0F1dGhvckFwcHJvdmFsO1xuICB9XG5cbiAgLy8gbWVyZ2VfcmVxdWVzdHNfZGlzYWJsZV9jb21taXR0ZXJzX2FwcHJvdmFsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21lcmdlUmVxdWVzdHNEaXNhYmxlQ29tbWl0dGVyc0FwcHJvdmFsPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBtZXJnZVJlcXVlc3RzRGlzYWJsZUNvbW1pdHRlcnNBcHByb3ZhbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdtZXJnZV9yZXF1ZXN0c19kaXNhYmxlX2NvbW1pdHRlcnNfYXBwcm92YWwnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1lcmdlUmVxdWVzdHNEaXNhYmxlQ29tbWl0dGVyc0FwcHJvdmFsKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9tZXJnZVJlcXVlc3RzRGlzYWJsZUNvbW1pdHRlcnNBcHByb3ZhbCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1lcmdlUmVxdWVzdHNEaXNhYmxlQ29tbWl0dGVyc0FwcHJvdmFsKCkge1xuICAgIHRoaXMuX21lcmdlUmVxdWVzdHNEaXNhYmxlQ29tbWl0dGVyc0FwcHJvdmFsID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtZXJnZVJlcXVlc3RzRGlzYWJsZUNvbW1pdHRlcnNBcHByb3ZhbElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tZXJnZVJlcXVlc3RzRGlzYWJsZUNvbW1pdHRlcnNBcHByb3ZhbDtcbiAgfVxuXG4gIC8vIHByb2plY3RfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcHJvamVjdElkPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBwcm9qZWN0SWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdwcm9qZWN0X2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBwcm9qZWN0SWQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3Byb2plY3RJZCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwcm9qZWN0SWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcHJvamVjdElkO1xuICB9XG5cbiAgLy8gcmVxdWlyZV9wYXNzd29yZF90b19hcHByb3ZlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcXVpcmVQYXNzd29yZFRvQXBwcm92ZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcmVxdWlyZVBhc3N3b3JkVG9BcHByb3ZlKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3JlcXVpcmVfcGFzc3dvcmRfdG9fYXBwcm92ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWlyZVBhc3N3b3JkVG9BcHByb3ZlKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9yZXF1aXJlUGFzc3dvcmRUb0FwcHJvdmUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZXF1aXJlUGFzc3dvcmRUb0FwcHJvdmUoKSB7XG4gICAgdGhpcy5fcmVxdWlyZVBhc3N3b3JkVG9BcHByb3ZlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXF1aXJlUGFzc3dvcmRUb0FwcHJvdmVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVxdWlyZVBhc3N3b3JkVG9BcHByb3ZlO1xuICB9XG5cbiAgLy8gcmVzZXRfYXBwcm92YWxzX29uX3B1c2ggLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVzZXRBcHByb3ZhbHNPblB1c2g/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHJlc2V0QXBwcm92YWxzT25QdXNoKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3Jlc2V0X2FwcHJvdmFsc19vbl9wdXNoJyk7XG4gIH1cbiAgcHVibGljIHNldCByZXNldEFwcHJvdmFsc09uUHVzaCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcmVzZXRBcHByb3ZhbHNPblB1c2ggPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRSZXNldEFwcHJvdmFsc09uUHVzaCgpIHtcbiAgICB0aGlzLl9yZXNldEFwcHJvdmFsc09uUHVzaCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVzZXRBcHByb3ZhbHNPblB1c2hJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcmVzZXRBcHByb3ZhbHNPblB1c2g7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGRpc2FibGVfb3ZlcnJpZGluZ19hcHByb3ZlcnNfcGVyX21lcmdlX3JlcXVlc3Q6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9kaXNhYmxlT3ZlcnJpZGluZ0FwcHJvdmVyc1Blck1lcmdlUmVxdWVzdCksXG4gICAgICBpZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5faWQpLFxuICAgICAgbWVyZ2VfcmVxdWVzdHNfYXV0aG9yX2FwcHJvdmFsOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fbWVyZ2VSZXF1ZXN0c0F1dGhvckFwcHJvdmFsKSxcbiAgICAgIG1lcmdlX3JlcXVlc3RzX2Rpc2FibGVfY29tbWl0dGVyc19hcHByb3ZhbDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX21lcmdlUmVxdWVzdHNEaXNhYmxlQ29tbWl0dGVyc0FwcHJvdmFsKSxcbiAgICAgIHByb2plY3RfaWQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3Byb2plY3RJZCksXG4gICAgICByZXF1aXJlX3Bhc3N3b3JkX3RvX2FwcHJvdmU6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9yZXF1aXJlUGFzc3dvcmRUb0FwcHJvdmUpLFxuICAgICAgcmVzZXRfYXBwcm92YWxzX29uX3B1c2g6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9yZXNldEFwcHJvdmFsc09uUHVzaCksXG4gICAgfTtcbiAgfVxufVxuIl19