import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defaults to false. Default to Auto DevOps pipeline for all projects within this group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#auto_devops_enabled Group#auto_devops_enabled}
    */
    readonly autoDevopsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Defaults to 2. See https://docs.gitlab.com/ee/api/groups.html#options-for-default_branch_protection
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#default_branch_protection Group#default_branch_protection}
    */
    readonly defaultBranchProtection?: number;
    /**
    * The description of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#description Group#description}
    */
    readonly description?: string;
    /**
    * Defaults to false. Disable email notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#emails_disabled Group#emails_disabled}
    */
    readonly emailsDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#id Group#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Defaults to true. Enable/disable Large File Storage (LFS) for the projects in this group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#lfs_enabled Group#lfs_enabled}
    */
    readonly lfsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Defaults to false. Disable the capability of a group from getting mentioned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#mentions_disabled Group#mentions_disabled}
    */
    readonly mentionsDisabled?: boolean | cdktf.IResolvable;
    /**
    * The name of this group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#name Group#name}
    */
    readonly name: string;
    /**
    * Id of the parent group (creates a nested group).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#parent_id Group#parent_id}
    */
    readonly parentId?: number;
    /**
    * The path of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#path Group#path}
    */
    readonly path: string;
    /**
    * Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#prevent_forking_outside_group Group#prevent_forking_outside_group}
    */
    readonly preventForkingOutsideGroup?: boolean | cdktf.IResolvable;
    /**
    * Defaults to maintainer. Determine if developers can create projects in the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#project_creation_level Group#project_creation_level}
    */
    readonly projectCreationLevel?: string;
    /**
    * Defaults to false. Allow users to request member access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#request_access_enabled Group#request_access_enabled}
    */
    readonly requestAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Defaults to false. Require all users in this group to setup Two-factor authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#require_two_factor_authentication Group#require_two_factor_authentication}
    */
    readonly requireTwoFactorAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Defaults to false. Prevent sharing a project with another group within this group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#share_with_group_lock Group#share_with_group_lock}
    */
    readonly shareWithGroupLock?: boolean | cdktf.IResolvable;
    /**
    * Defaults to owner. Allowed to create subgroups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#subgroup_creation_level Group#subgroup_creation_level}
    */
    readonly subgroupCreationLevel?: string;
    /**
    * Defaults to 48. Time before Two-factor authentication is enforced (in hours).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#two_factor_grace_period Group#two_factor_grace_period}
    */
    readonly twoFactorGracePeriod?: number;
    /**
    * The group's visibility. Can be `private`, `internal`, or `public`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/group#visibility_level Group#visibility_level}
    */
    readonly visibilityLevel?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group gitlab_group}
*/
export declare class Group extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group gitlab_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupConfig
    */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _autoDevopsEnabled?;
    get autoDevopsEnabled(): boolean | cdktf.IResolvable;
    set autoDevopsEnabled(value: boolean | cdktf.IResolvable);
    resetAutoDevopsEnabled(): void;
    get autoDevopsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultBranchProtection?;
    get defaultBranchProtection(): number;
    set defaultBranchProtection(value: number);
    resetDefaultBranchProtection(): void;
    get defaultBranchProtectionInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _emailsDisabled?;
    get emailsDisabled(): boolean | cdktf.IResolvable;
    set emailsDisabled(value: boolean | cdktf.IResolvable);
    resetEmailsDisabled(): void;
    get emailsDisabledInput(): boolean | cdktf.IResolvable | undefined;
    get fullName(): string;
    get fullPath(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lfsEnabled?;
    get lfsEnabled(): boolean | cdktf.IResolvable;
    set lfsEnabled(value: boolean | cdktf.IResolvable);
    resetLfsEnabled(): void;
    get lfsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mentionsDisabled?;
    get mentionsDisabled(): boolean | cdktf.IResolvable;
    set mentionsDisabled(value: boolean | cdktf.IResolvable);
    resetMentionsDisabled(): void;
    get mentionsDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentId?;
    get parentId(): number;
    set parentId(value: number);
    resetParentId(): void;
    get parentIdInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _preventForkingOutsideGroup?;
    get preventForkingOutsideGroup(): boolean | cdktf.IResolvable;
    set preventForkingOutsideGroup(value: boolean | cdktf.IResolvable);
    resetPreventForkingOutsideGroup(): void;
    get preventForkingOutsideGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _projectCreationLevel?;
    get projectCreationLevel(): string;
    set projectCreationLevel(value: string);
    resetProjectCreationLevel(): void;
    get projectCreationLevelInput(): string | undefined;
    private _requestAccessEnabled?;
    get requestAccessEnabled(): boolean | cdktf.IResolvable;
    set requestAccessEnabled(value: boolean | cdktf.IResolvable);
    resetRequestAccessEnabled(): void;
    get requestAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _requireTwoFactorAuthentication?;
    get requireTwoFactorAuthentication(): boolean | cdktf.IResolvable;
    set requireTwoFactorAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireTwoFactorAuthentication(): void;
    get requireTwoFactorAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    get runnersToken(): string;
    private _shareWithGroupLock?;
    get shareWithGroupLock(): boolean | cdktf.IResolvable;
    set shareWithGroupLock(value: boolean | cdktf.IResolvable);
    resetShareWithGroupLock(): void;
    get shareWithGroupLockInput(): boolean | cdktf.IResolvable | undefined;
    private _subgroupCreationLevel?;
    get subgroupCreationLevel(): string;
    set subgroupCreationLevel(value: string);
    resetSubgroupCreationLevel(): void;
    get subgroupCreationLevelInput(): string | undefined;
    private _twoFactorGracePeriod?;
    get twoFactorGracePeriod(): number;
    set twoFactorGracePeriod(value: number);
    resetTwoFactorGracePeriod(): void;
    get twoFactorGracePeriodInput(): number | undefined;
    private _visibilityLevel?;
    get visibilityLevel(): string;
    set visibilityLevel(value: string);
    resetVisibilityLevel(): void;
    get visibilityLevelInput(): string | undefined;
    get webUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
