import java.io.*;
import java.util.*;

public class TestHull{
    
    private ConvexHull hullA,hullB;
    private Vector vertA;
    private Vector vertB;

    public TestHull(Domain D){
	vertA = D.copyAtoms();
	vertB = D.copyAtoms();
	
	try{
	    hullA = new ConvexHull(vertA);
	    hullB = new ConvexHull(vertB);
	    print2File(hullA,"Original");
	}catch(ConvexHullException ce){System.out.println(ce);}

	calcInter();
    }
    
    public static void print2File(ConvexHull hull, String prefix){
	try{
	    PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(prefix+"_hull.off")));
	    hull.writeOFF(pw);
	    pw.close();
	}catch(IOException e){System.out.println(e);}
    }
    
    public void calcInter(){
	
	Vertex vc;
	Vector intVert = new Vector();
	
	vc = findCenter(hullA.getVertices());

	System.out.println("FIRST CV DONE");
	System.out.println("Volume of CH : "+calcVolume(hullA));
	System.out.println();
	transHull(hullA,vc);
	print2File(hullA,"TransA");
	System.out.println("SECOND CV DONE");
	System.out.println("Volume of TCHA : "+calcVolume(hullA));
	System.out.println();
	transHull(hullB,vc);
	System.out.println("THIRD CV DONE");
	System.out.println("Volume of TCHA : "+calcVolume(hullB));
	System.out.println();
	print2File(hullB,"TransB");
    }
    
    public static double calcVolume(ConvexHull ch){
	Vertex oC = new Vertex(0.0,0.0,0.0);
	double volume = 0;
	
	//Intersection Volume
	for (Enumeration f = (ch.getFaces()).elements();f.hasMoreElements();){
	    Triangle p = (Triangle)f.nextElement();
	    volume+=p.volume6(oC)/6;
	}
	return volume;
    }
    
	//Transforms the Hull to a swelling Hull by THRES
	public void transHull(ConvexHull hull, Vertex center){
	Vector vertices = hull.getVertices();
	for (Enumeration v = vertices.elements();v.hasMoreElements();){
		Vertex vert = (Vertex)v.nextElement();
		Vertex vc = Vertex.vectorDiff(vert,center);
		vc=Vertex.vectorMult(vc,((DomainInter.THRES+vc.norm())/vc.norm()));
		vc=Vertex.vectorAdd(vc,center);
		vert.setCoords(vc.x,vc.y,vc.z);
	}
	}
    
	//Transforms the Hull to a swelling Hull by THRES
	public void transHull(ConvexHull hull){
	Vector vertices = hull.getVertices();
	for (Enumeration v = vertices.elements();v.hasMoreElements();){
		Vertex vert = (Vertex)v.nextElement();
		Vertex vc = new Vertex(vert.x,vert.y,vert.z);
		Vector faces = hull.getFaces(vert);
		Vertex n = new Vertex();
		double Theta = 1;
		int count = 0;
		for (Enumeration t = faces.elements();t.hasMoreElements();){
		Triangle tr = (Triangle)t.nextElement();
		Vertex tn = tr.triangleNorm();
		if(count!=0){
			n = Vertex.vectorAdd(n,tn);
			n.normalize();
			Theta *= Math.cos(Vertex.angle(tn,n)/2);
		}else{
			n = tr.triangleNorm();
		}
		count++;
		}
		vc = Vertex.vectorAdd(vc,Vertex.vectorMult(n,DomainInter.THRES/Theta));
		vert.setCoords(vc.x,vc.y,vc.z);
	}
	}
       
    //Finds the center of a set of vertices
    public static Vertex findCenter(Vector vertices){
	double[] c = {0.0,0.0,0.0};
	Vertex cv;
	
	for (Enumeration v = vertices.elements();v.hasMoreElements();){
	    double[] x = ((Vertex)v.nextElement()).getCoords();
	    c[0]+=x[0];
	    c[1]+=x[1];
	    c[2]+=x[2];
	}
	c[0]=c[0]/vertices.size();
	c[1]=c[1]/vertices.size();
	c[2]=c[2]/vertices.size();
	cv = new Vertex(c[0],c[1],c[2]);
	return cv;
    }
}
