import java.util.Vector;
import java.util.Iterator;

public class Protein {
    
    private String ProtID;
    private Vector Atoms;
//  private Sequence AminoAcidSeq;
    
    public Protein(String ProtID, Vector Atoms) {
	this.ProtID = ProtID;
	this.Atoms = Atoms;
    }
    
    public String getID() {
	return ProtID;
    }
    
    public Vector getAtoms() {
	return Atoms;
    }
    
    public Vector getBackbone() {
	Vector Backbone = new Vector();
	for (Iterator j = Atoms.iterator(); j.hasNext();){
	    Atom atom = (Atom)j.next();
	    if(atom.isBackbone())
		Backbone.addElement(atom);
	}
	return Backbone;
    }
    
    public Vector getSimpleBackbone() {
	Vector Backbone = new Vector();
	for (Iterator j = Atoms.iterator(); j.hasNext();){
	    Atom atom = (Atom)j.next();
	    if(atom.isCarbonAlfa())
		Backbone.addElement(atom);
	}
	return Backbone;
    }
    
    public Vector getDomains(Vector DomIdent) {
	Vector Domains = new Vector();
	
	    for (Iterator i = DomIdent.iterator(); i.hasNext();){
		SubChain subChain = (SubChain)i.next();
		Vector DomAtoms = new Vector();
		
		for (Iterator j = Atoms.iterator(); j.hasNext();){
		    Atom atom = (Atom)j.next();
		    String chainID = new String(""+atom.getChainID());
		    String subChainID = new String(""+subChain.getChainID());
		    if(chainID.equalsIgnoreCase(subChainID)&&subChain.getBegin()<=atom.getAtomID()&&atom.getAtomID()<=subChain.getEnd()){
			DomAtoms.add(atom);
		    }
		}
		Domains.add(new Domain(new String(subChain.getChainID()+"_"+subChain.getBegin()+"_"+subChain.getEnd()),DomAtoms));
	    }
	    
	    return Domains;
    }

    public Vector getSimpleDomains(Vector DomIdent) {
	Vector Domains = new Vector();

	    for (Iterator i = DomIdent.iterator(); i.hasNext();){
		SubChain subChain = (SubChain)i.next();
		Vector DomAtoms = new Vector();
		Vector sideChain = null;
		Atom sca = new Atom(0,0,0);

		for (Iterator j = Atoms.iterator(); j.hasNext();){
		    Atom atom = (Atom)j.next();
		    String chainID = new String(""+atom.getChainID());
		    String subChainID = new String(""+subChain.getChainID());
		    if(chainID.equalsIgnoreCase(subChainID)&&subChain.getBegin()<=atom.getAtomID()&&atom.getAtomID()<=subChain.getEnd()){
			if(atom.isCarbonAlfa()){
			    sideChain = new Vector();
			    sca = new Atom(atom.getAtomID(),atom.getChainID(),"SCA",atom.getResidue(),0,0,0);
			    DomAtoms.add(atom);
			}else if (atom.isSideChain())
			    sideChain.add(atom);

			if(atom.isNitrogen()&&sideChain!=null){
			    for (Iterator k = sideChain.iterator(); k.hasNext();){
				Atom sa = (Atom)k.next();
				sca.x+=sa.x;
				sca.y+=sa.y;
				sca.z+=sa.z;
			    }
			    sca.x=sca.x/sideChain.size();
			    sca.y=sca.y/sideChain.size();
			    sca.z=sca.z/sideChain.size();
			    DomAtoms.add(sca);
			}
		    }
		}
		Domains.add(new Domain(new String(subChain.getChainID()+"_"+subChain.getBegin()+"_"+subChain.getEnd()),DomAtoms));
	    }
	    return Domains;
    }
}
