import java.io.*;
import java.util.Date;
import java.lang.Math;

public class Interaction {

    public static final int NOM  = 6;
    public static final int BB   = 0;
    public static final int PCA  = 1;
    public static final int IBB  = 2;
    public static final int IPCA = 3;
    public static final int CH   = 4;
    public static final int AA   = 5;
    
    public static final int XX  = 1;
    public static final int YY  = 2;
    public static final int ZZ  = 3;
    
    public static double THRES;
    
    Domain[] domA, domB;
    double[] intVolume;// Volume of the Intersection
    int[] noA, noB; // Number of atoms of Domain A and B in intVolume
    BBox BbC;

    public Interaction(Domain DA, Domain DB){
	DomainInter.THRES=5;
	domA = new Domain[NOM];
	domB = new Domain[NOM];
	for(int i=0;i<NOM;i++){
	    domA[i] = DA.cloneDomain();
	    domB[i] = DB.cloneDomain();
	}
	noA = new int[NOM];
	noB = new int[NOM];
	intVolume = new double[NOM];
	BbC = new BBox();
	
	doComp(AA);
	
	//writeDom(AA);
    }
    
    public Interaction(Domain DA, Domain DB, double thresh){
	DomainInter.THRES=thresh;
	domA = new Domain[NOM];
	domB = new Domain[NOM];
	for(int i=0;i<NOM;i++){
	    domA[i] = DA.cloneDomain();
	    domB[i] = DB.cloneDomain();
	}
	noA = new int[NOM];
	noB = new int[NOM];
	intVolume = new double[NOM];
	BbC = new BBox();

	for(int i=0;i<NOM;i++)
	    doComp(i);

	//doComp(AA);

	//writeDom();
	//writeFile();
    }
    
    public boolean interacts(){
	if(noA[AA]>=5||noB[AA]>=5)
	    return true;
	else
	    return false;
    }

    public boolean interacts(int Method){
	if(noA[Method]>=5||noB[Method]>=5)
	    return true;
	else
	    return false;
    }
    
    public void doComp(int M){
	BBox BbA,BbB;
	PCA execPCA;
	Hull execHull;
	CheckInter execAA;
	int oldNoA, oldNoB;
        int iterate = 1;
	boolean flag = true;
	
	switch(M){
	case 0:
	    //System.out.println("---------------Method BB----------------");
	    BbA=domA[BB].getBBox();
	    BbB=domB[BB].getBBox();
	    calcInter(BbA,BbB,BB);
	    //System.out.println("Inter. Volume: "+intVolume[BB]);
	    noA[BB]=domA[BB].getNoAtoms(BbC);
	    noB[BB]=domB[BB].getNoAtoms(BbC);
	    //System.out.println("Atoms of A in Vol: "+noA[BB]);
	    //System.out.println("Atoms of B in Vol: "+noB[BB]);
	break;
	case 1:
	    //System.out.println("---------------Method PCA----------------");
	    execPCA = new PCA(domA[PCA],domB[PCA]);
	    BbA=domA[PCA].getBBox();
	    BbB=domB[PCA].getBBox();
	    calcInter(BbA,BbB,PCA);
	    //System.out.println("Inter. Volume: "+intVolume[PCA]);
	    noA[PCA]=domA[PCA].getNoAtoms(BbC);
	    noB[PCA]=domB[PCA].getNoAtoms(BbC);
	    //System.out.println("Atoms of A in Vol: "+noA[PCA]);
	    //System.out.println("Atoms of B in Vol: "+noB[PCA]);
	break;
	case 2:
	    oldNoA=0;
	    oldNoB=0;
	    //System.out.println("---------------Method IBB----------------");
	    while(iterate<4&&flag==true){
	    //System.out.println("Iteration: "+iterate);
	    BbA=domA[IBB].getBBox();
	    BbB=domB[IBB].getBBox();
	    calcInter(BbA,BbB,IBB);
	    //System.out.println("Inter. Volume: "+intVolume[IBB]);
	    noA[IBB]=domA[IBB].getNoAtoms(BbC);
	    noB[IBB]=domB[IBB].getNoAtoms(BbC);
	    //System.out.println("Atoms of A in Vol: "+noA[IBB]);
	    //System.out.println("Atoms of B in Vol: "+noB[IBB]);
	    if(noA[IBB]==0||noB[IBB]==0||(noA[IBB]==oldNoA&&noB[IBB]==oldNoB))
	    	flag=false;
	    oldNoA=noA[IBB];
	    oldNoB=noB[IBB];
	    domA[IBB].deleteAtoms(BbC);
	    domB[IBB].deleteAtoms(BbC);
	    iterate++;
	    }
	break;
	case 3:
	    oldNoA=0;
	    oldNoB=0;
	    //System.out.println("---------------Method IPCA----------------");
	    while(iterate<4&&flag==true){
	    //System.out.println("Iteration: "+iterate);
	    execPCA = new PCA(domA[IPCA],domB[IPCA]);
	    BbA=domA[IPCA].getBBox();
	    BbB=domB[IPCA].getBBox();
	    calcInter(BbA,BbB,IPCA);
	    //System.out.println("Inter. Volume: "+intVolume[IPCA]);
	    noA[IPCA]=domA[IPCA].getNoAtoms(BbC);
	    noB[IPCA]=domB[IPCA].getNoAtoms(BbC);
	    //System.out.println("Atoms of A in Vol: "+noA[IPCA]);
	    //System.out.println("Atoms of B in Vol: "+noB[IPCA]);
	    if(noA[IPCA]==0||noB[IPCA]==0||(noA[IPCA]==oldNoA&&noB[IPCA]==oldNoB))
		flag=false;
	    oldNoA=noA[IPCA];
	    oldNoB=noB[IPCA];
	    domA[IPCA].deleteAtoms(BbC);
	    domB[IPCA].deleteAtoms(BbC);
	    iterate++;
	    }
	break;
	case 4:
	    //System.out.println("---------------Method CH----------------");
	    execHull = new Hull(domA[CH],domB[CH]);
	    noA[CH]=execHull.getAtomA();
	    noB[CH]=execHull.getAtomB();
	    intVolume[CH]=execHull.getIntVol();
	    //System.out.println("Inter. Volume: "+intVolume[CH]);
	    //System.out.println("Atoms of A in Vol: "+noA[CH]);
	    //System.out.println("Atoms of B in Vol: "+noB[CH]);
	break;
	case 5:
	    //System.out.println("---------------Method AA----------------");
	    execAA = new CheckInter(domA[AA],domB[AA]);
	    noA[AA]=execAA.getAtomA();
	    noB[AA]=execAA.getAtomB();
	    intVolume[AA]=execAA.getIntVol();
	    //System.out.println("Inter. Volume: "+intVolume[AA]);
	    //System.out.println("Atoms of A in Vol: "+noA[AA]);
	    //System.out.println("Atoms of B in Vol: "+noB[AA]);
	    break;
	}
    }
    
    private void setInterBox(double bmax, double amin, double amax, double bmin, int axes){
	double dmin;
	double dmax;
	if((bmax-amin)<(amax-bmin)){
	    dmax=bmax;
	    dmin=amin;
	}else{
	    dmax=amax;
	    dmin=bmin;
	}
	switch (axes) {
	case 1: BbC.xmin=dmin; BbC.xmax=dmax; break;
	case 2: BbC.ymin=dmin; BbC.ymax=dmax; break;
	case 3: BbC.zmin=dmin; BbC.zmax=dmax; break;
	}
    }
    
    public void calcInter(BBox A, BBox B, int Method){
	double xInt,yInt,zInt;
	BbC.resetBBox();
	
	if((A.xmin>=B.xmax)||(B.xmin>=A.xmax))
	    xInt=0;
	else{
	    xInt = Math.min(B.xmax-A.xmin,A.xmax-B.xmin);
	    setInterBox(B.xmax,A.xmin,A.xmax,B.xmin,XX);
	}
	
	if((A.ymin>=B.ymax)||(B.ymin>=A.ymax))
	    yInt=0;
	else{
	    yInt = Math.min(B.ymax-A.ymin,A.ymax-B.ymin);
	    setInterBox(B.ymax,A.ymin,A.ymax,B.ymin,YY);
	}
	
	if((A.zmin>=B.zmax)||(B.zmin>=A.zmax))
	    zInt=0;
	else{
	    zInt = Math.min(B.zmax-A.zmin,A.zmax-B.zmin);
	    setInterBox(B.zmax,A.zmin,A.zmax,B.zmin,ZZ);
	}
	//intVolume[Method]=xInt*yInt*zInt;
	intVolume[Method]=BbC.getVolume();
    }
    
    public void writeDom(){
	String postfix = new String();
	for(int j=0;j<NOM;j++){
	    switch(j){
	    case 0: postfix = "BB"; break;
	    case 1: postfix = "PCA"; break;
	    case 2: postfix = "IBB"; break;
	    case 3: postfix = "IPCA"; break;
	    case 4: postfix = "CH"; break;
	    case 5: postfix = "AA"; break;
	    }
	    domA[j].print2File(postfix);
	    domB[j].print2File(postfix);
	}
    }
    
    public void writeDom(int M){
	domA[M].print2File();
	domB[M].print2File();
    }
    
    public void writeFile(){
	PrintWriter fileOut = null;
	Date cDate = new Date();
	try{
	  fileOut = new PrintWriter(new FileWriter("out_"+domA[BB].getDomainName()+"_"+domB[BB].getDomainName()+".txt"));
	  fileOut.println("DomainA:"+domA[BB].getDomainName()+"\tDomainB:"+domB[BB].getDomainName());
	  for(int i=0;i<NOM;i++){
	      switch(i){
	      case 0: fileOut.println("BB"+"\t"+intVolume[i]+"\t"+noA[i]+"\t"+noB[i]); break;
	      case 1: fileOut.println("PCA"+"\t"+intVolume[i]+"\t"+noA[i]+"\t"+noB[i]); break;
	      case 2: fileOut.println("IBB"+"\t"+intVolume[i]+"\t"+noA[i]+"\t"+noB[i]); break;
	      case 3: fileOut.println("IPCA"+"\t"+intVolume[i]+"\t"+noA[i]+"\t"+noB[i]); break;
	      case 4: fileOut.println("CH"+"\t"+intVolume[i]+"\t"+noA[i]+"\t"+noB[i]); break;
	      case 5: fileOut.println("AA"+"\t"+intVolume[i]+"\t"+noA[i]+"\t"+noB[i]); break;
	      }
	  }
	  fileOut.println("Date:"+cDate);
	  fileOut.close();
      } catch(Exception e){System.out.println(e);}
    }
   
}
