/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.termination.standard;

import ca.ubc.cs.beta.aclib.termination.ConditionType;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aclib.termination.standard.AbstractTerminationCondition;
import java.util.Collection;
import java.util.Collections;

public class WallClockLimitCondition
extends AbstractTerminationCondition
implements TerminationCondition {
    private final long applicationStartTime;
    private final long applicationEndTime;
    private final double runTimeInSeconds;

    public WallClockLimitCondition(long applicationStartTime, double runTimeInSeconds) {
        this.applicationStartTime = applicationStartTime;
        this.applicationEndTime = applicationStartTime + (long)(runTimeInSeconds * 1000.0);
        this.runTimeInSeconds = runTimeInSeconds;
    }

    @Override
    public boolean haveToStop() {
        return System.currentTimeMillis() >= this.applicationEndTime;
    }

    @Override
    public double getWallTime() {
        return System.currentTimeMillis() - this.applicationStartTime;
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        return Collections.singleton(new ValueMaxStatus(ConditionType.WALLTIME, (double)(System.currentTimeMillis() - this.applicationStartTime) / 1000.0, this.runTimeInSeconds, "WALLCLOCK", "Wall-clock Time Budget", "s"));
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "Wall-clock Limit (" + (double)(System.currentTimeMillis() - this.applicationStartTime) / 1000.0 + " s) has been reached";
        }
        return "";
    }
}

