/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.termination.standard;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aclib.termination.ConditionType;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aclib.termination.standard.AbstractTerminationCondition;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Collection;
import java.util.Collections;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CPULimitCondition
extends AbstractTerminationCondition {
    private final double tunerTimeLimit;
    private AtomicDouble currentTime;
    private final String NAME = "CPUTIME";
    private final boolean countACTime;

    public CPULimitCondition(double tunerTimeLimit, boolean countACTime) {
        this.tunerTimeLimit = tunerTimeLimit;
        this.currentTime = new AtomicDouble(0.0);
        this.countACTime = countACTime;
    }

    @Override
    public double getTunerTime() {
        return this.currentTime.get() + (this.countACTime ? CPUTime.getCPUTime() : 0.0);
    }

    @Override
    public boolean haveToStop() {
        return this.tunerTimeLimit <= this.getTunerTime();
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        double tunerTime = this.getTunerTime();
        return Collections.singleton(new ValueMaxStatus(ConditionType.TUNERTIME, tunerTime, this.tunerTimeLimit, "CPUTIME", "Configuration Time Budget", "s"));
    }

    @Override
    public synchronized void notifyRun(AlgorithmRun run) {
        this.currentTime.addAndGet(Math.max(0.1, run.getRuntime()));
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "Tuner Time Limit (" + this.tunerTimeLimit + " s) has been reached";
        }
        return "";
    }
}

