/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.experimental.queuefacade.general;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmEvaluatorShutdownException;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.experimental.queuefacade.general.TargetAlgorithmEvaluatorQueueResultContext;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TargetAlgorithmEvaluatorQueueFacade<K extends TargetAlgorithmEvaluatorQueueResultContext> {
    private final TargetAlgorithmEvaluator tae;
    private final LinkedBlockingQueue<K> queue = new LinkedBlockingQueue();
    private final boolean throwExceptions;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger outstandingRuns = new AtomicInteger(0);
    private final AtomicInteger queuedAndOutstandingRuns = new AtomicInteger(0);

    public TargetAlgorithmEvaluatorQueueFacade(TargetAlgorithmEvaluator tae, boolean throwExceptions) {
        this.tae = tae;
        this.throwExceptions = throwExceptions;
    }

    public synchronized TargetAlgorithmEvaluator getTargetAlgorithmEvaluator() {
        return this.tae;
    }

    public synchronized void evaluateRunAsync(K context, RunConfig runConfig) {
        this.evaluateRunAsync(context, Collections.singletonList(runConfig));
    }

    public synchronized void evaluateRunAsync(K context, List<RunConfig> runConfigs) {
        this.evaluateRunAsync(context, runConfigs, null);
    }

    public synchronized void evaluateRunAsync(K context, List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        context.setRunConfigs(runConfigs);
        this.outstandingRuns.incrementAndGet();
        this.queuedAndOutstandingRuns.incrementAndGet();
        try {
            this.tae.evaluateRunsAsync(runConfigs, new QueueingTargetAlgorithmEvaluatorCallback(this, context), obs);
        }
        catch (RuntimeException e) {
            this.outstandingRuns.decrementAndGet();
            this.queuedAndOutstandingRuns.decrementAndGet();
            throw e;
        }
    }

    public synchronized K poll() {
        TargetAlgorithmEvaluatorQueueResultContext context = (TargetAlgorithmEvaluatorQueueResultContext)this.queue.poll();
        if (context != null) {
            this.queuedAndOutstandingRuns.decrementAndGet();
        }
        return (K)this.checkForException(context);
    }

    public synchronized K take() throws InterruptedException {
        TargetAlgorithmEvaluatorQueueResultContext context = (TargetAlgorithmEvaluatorQueueResultContext)this.queue.take();
        if (context != null) {
            this.queuedAndOutstandingRuns.decrementAndGet();
        }
        return (K)this.checkForException(context);
    }

    public synchronized K poll(long timeout, TimeUnit unit) throws InterruptedException {
        TargetAlgorithmEvaluatorQueueResultContext context = (TargetAlgorithmEvaluatorQueueResultContext)this.queue.poll(timeout, unit);
        if (context != null) {
            this.queuedAndOutstandingRuns.decrementAndGet();
        }
        return (K)this.checkForException(context);
    }

    public synchronized K peek() {
        return (K)this.checkForException((TargetAlgorithmEvaluatorQueueResultContext)this.queue.peek());
    }

    public synchronized int getApproximateNumberOutstandingRuns() {
        return this.outstandingRuns.get();
    }

    public synchronized int getApproximateNumberOfQueuedRuns() {
        return this.queue.size();
    }

    public synchronized int getNumberOfOutstandingAndQueuedRuns() {
        return this.queuedAndOutstandingRuns.get();
    }

    private K checkForException(K context) {
        if (context == null) {
            return context;
        }
        if (this.throwExceptions && context.getRuntimeException() != null) {
            throw context.getRuntimeException();
        }
        return context;
    }

    private static class QueueingTargetAlgorithmEvaluatorCallback
    implements TargetAlgorithmEvaluatorCallback {
        private final K context;
        final /* synthetic */ TargetAlgorithmEvaluatorQueueFacade this$0;

        public QueueingTargetAlgorithmEvaluatorCallback(K context) {
            this.this$0 = var1_1;
            this.context = context;
        }

        @Override
        public void onSuccess(List<AlgorithmRun> runs) {
            this.context.setAlgorithmRuns(runs);
            try {
                this.this$0.queue.put(this.context);
                this.this$0.outstandingRuns.decrementAndGet();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.onFailure(new TargetAlgorithmEvaluatorShutdownException(e));
            }
        }

        @Override
        public void onFailure(RuntimeException e) {
            this.context.setAlgorithmRuns(null);
            this.context.setRuntimeException(e);
            try {
                this.this$0.queue.put(this.context);
                this.this$0.outstandingRuns.decrementAndGet();
            }
            catch (InterruptedException e2) {
                try {
                    this.this$0.queue.put(this.context);
                }
                catch (InterruptedException e1) {
                    this.this$0.log.warn("Interrupted Exception again this result will be swallowed", (Throwable)e);
                    e1.printStackTrace();
                }
                this.this$0.outstandingRuns.decrementAndGet();
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

