/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aclib.algorithmrun.AbstractAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final double wallclockMultScaleFactor;
    private final double startAt;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
        this.wallclockMultScaleFactor = 0.95;
        this.startAt = 0.05;
    }

    public WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, double scaleFactor, double startAt) {
        super(tae);
        this.wallclockMultScaleFactor = scaleFactor;
        this.startAt = startAt;
    }

    @Override
    public final List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.processRuns(this.tae.evaluateRun(runConfigs, new WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver(obs)));
    }

    public List<AlgorithmRun> processRuns(List<AlgorithmRun> runs) {
        ArrayList<AlgorithmRun> myRuns = new ArrayList<AlgorithmRun>(runs.size());
        for (AlgorithmRun run : runs) {
            myRuns.add(this.processRun(run));
        }
        return myRuns;
    }

    public AlgorithmRun processRun(AlgorithmRun run) {
        if (run.getRunResult().equals((Object)RunResult.KILLED) && run.getRuntime() == 0.0 && run.getWallclockExecutionTime() > this.startAt) {
            return new WalltimeAsRuntimeKillableAlgorithmRun(run);
        }
        return run;
    }

    @Override
    public final void evaluateRunsAsync(List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                runs = WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
                this.handler.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myHandler, new WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver(obs));
    }

    private class WalltimeAsRuntimeKillableAlgorithmRun
    implements KillableAlgorithmRun {
        private static final long serialVersionUID = 9082975671200245863L;
        AlgorithmRun wrappedRun;
        KillableAlgorithmRun wrappedKillableRun;

        public WalltimeAsRuntimeKillableAlgorithmRun(AlgorithmRun r) {
            if (r instanceof KillableAlgorithmRun) {
                this.wrappedKillableRun = (KillableAlgorithmRun)r;
            }
            this.wrappedRun = r;
        }

        @Override
        public AlgorithmExecutionConfig getExecutionConfig() {
            return this.wrappedRun.getExecutionConfig();
        }

        @Override
        public RunConfig getRunConfig() {
            return this.wrappedRun.getRunConfig();
        }

        @Override
        public RunResult getRunResult() {
            return this.wrappedRun.getRunResult();
        }

        @Override
        public double getRuntime() {
            return Math.max(this.wrappedRun.getWallclockExecutionTime() * WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator.this.wallclockMultScaleFactor, 0.0);
        }

        @Override
        public double getRunLength() {
            return this.wrappedRun.getRunLength();
        }

        @Override
        public double getQuality() {
            return this.wrappedRun.getQuality();
        }

        @Override
        public long getResultSeed() {
            return this.wrappedRun.getResultSeed();
        }

        @Override
        public String getResultLine() {
            return AbstractAlgorithmRun.getResultLine(this);
        }

        @Override
        public String getAdditionalRunData() {
            return this.wrappedRun.getAdditionalRunData();
        }

        @Override
        public void run() {
            this.wrappedRun.run();
        }

        @Override
        public Object call() {
            return this.wrappedRun.call();
        }

        @Override
        public boolean isRunCompleted() {
            return this.wrappedRun.isRunCompleted();
        }

        @Override
        public boolean isRunResultWellFormed() {
            return this.wrappedRun.isRunResultWellFormed();
        }

        @Override
        public String rawResultLine() {
            return "[Probably not accurate:]" + this.wrappedRun.rawResultLine();
        }

        @Override
        public double getWallclockExecutionTime() {
            return this.wrappedRun.getWallclockExecutionTime();
        }

        @Override
        public void kill() {
            if (this.wrappedKillableRun != null) {
                this.wrappedKillableRun.kill();
            }
        }

        public String toString() {
            return AbstractAlgorithmRun.toString(this);
        }
    }

    private class WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private TargetAlgorithmEvaluatorRunObserver obs;

        WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        @Override
        public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
            ArrayList<KillableAlgorithmRun> myRuns = new ArrayList<KillableAlgorithmRun>(runs.size());
            for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                if (killableAlgorithmRun.getRunResult().equals((Object)RunResult.RUNNING)) {
                    if (killableAlgorithmRun.getRuntime() == 0.0 && killableAlgorithmRun.getWallclockExecutionTime() > WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator.this.startAt) {
                        myRuns.add(new WalltimeAsRuntimeKillableAlgorithmRun(killableAlgorithmRun));
                        continue;
                    }
                    myRuns.add(killableAlgorithmRun);
                    continue;
                }
                myRuns.add(killableAlgorithmRun);
            }
            if (this.obs != null) {
                this.obs.currentStatus(myRuns);
            }
        }
    }
}

