/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetryCrashedRunsTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private AtomicInteger runCount = new AtomicInteger(0);
    private final int retryCount;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public RetryCrashedRunsTargetAlgorithmEvaluator(int retryCount, TargetAlgorithmEvaluator tae) {
        super(tae);
        if (retryCount < 0) {
            throw new IllegalArgumentException("Retry Count should be atleast 0");
        }
        this.retryCount = retryCount;
        if (tae.isRunFinal()) {
            this.log.warn("Target Algorithm Evaluator {} issues final runs, retrying will be a waste of time", (Object)tae.getClass().getSimpleName());
        }
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        List<AlgorithmRun> runs = this.tae.evaluateRun(runConfigs, obs);
        runs = new ArrayList<AlgorithmRun>(runs);
        for (int i = 1; i <= this.retryCount; ++i) {
            HashMap<RunConfig, Integer> crashedRuns = new HashMap<RunConfig, Integer>();
            boolean crashedRunsExist = false;
            for (int j = 0; j < runs.size(); ++j) {
                AlgorithmRun run = runs.get(j);
                if (!run.getRunResult().equals((Object)RunResult.CRASHED)) continue;
                crashedRuns.put(run.getRunConfig(), j);
                crashedRunsExist = true;
            }
            if (!crashedRunsExist) {
                this.log.debug("No crashed runs to retry");
                break;
            }
            this.log.info("Retrying {} crashed runs (Attempt {})", (Object)crashedRuns.size(), (Object)i);
            ArrayList<RunConfig> crashRCs = new ArrayList<RunConfig>(crashedRuns.keySet().size());
            crashRCs.addAll(crashedRuns.keySet());
            List<AlgorithmRun> retriedRuns = this.tae.evaluateRun(crashRCs, obs);
            for (AlgorithmRun run : retriedRuns) {
                runs.set((Integer)crashedRuns.get(run.getRunConfig()), run);
            }
        }
        this.runCount.addAndGet(runs.size());
        return runs;
    }

    @Override
    public int getRunCount() {
        return this.runCount.get();
    }

    @Override
    public void seek(List<AlgorithmRun> runs) {
        this.tae.seek(runs);
        this.runCount.addAndGet(runs.size());
    }

    @Override
    public void evaluateRunsAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        this.log.warn("Cannot retry runs that are asynchronous at the moment");
        this.tae.evaluateRunsAsync(runConfigs, handler, obs);
    }
}

