/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluator {
    ExecutorService execService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("Abstract Blocking TAE Async Processing Thread"));
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractSyncTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig) {
        super(execConfig);
    }

    @Override
    public void evaluateRunsAsync(final List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback handler, final TargetAlgorithmEvaluatorRunObserver obs) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    List<AlgorithmRun> runs = AbstractSyncTargetAlgorithmEvaluator.this.evaluateRun(runConfigs, obs);
                    handler.onSuccess(runs);
                }
                catch (RuntimeException e) {
                    handler.onFailure(e);
                }
                catch (Throwable t) {
                    AbstractSyncTargetAlgorithmEvaluator.this.log.error("Uncaught throwable occured ", t);
                }
            }
        };
        if (this.areRunsPersisted()) {
            run.run();
        } else {
            this.execService.execute(run);
        }
    }

    protected abstract void subtypeShutdown();

    @Override
    public final void notifyShutdown() {
        this.execService.shutdown();
        this.subtypeShutdown();
    }
}

