/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.runhistory;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runhistory.KeyObjectManager;
import ca.ubc.cs.beta.aclib.runhistory.RunData;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class NewRunHistory
implements RunHistory {
    private final OverallObjective perInstanceObjectiveFunction;
    private final OverallObjective aggregateInstanceObjectiveFunction;
    private final RunObjective runObj;
    private int iteration = 0;
    private final KeyObjectManager<ParamConfiguration> paramConfigurationList = new KeyObjectManager();
    private final List<RunData> runHistoryList = new ArrayList<RunData>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private double totalRuntimeSum = 0.0;
    private final Map<ParamConfiguration, Map<ProblemInstance, LinkedHashMap<Long, Double>>> configToPerformanceMap = new HashMap<ParamConfiguration, Map<ProblemInstance, LinkedHashMap<Long, Double>>>();
    private final HashMap<ProblemInstance, List<Long>> seedsUsedByInstance = new HashMap();
    private final LinkedHashMap<ParamConfiguration, Integer> configToNumRunsMap = new LinkedHashMap();
    private final HashMap<ParamConfiguration, Set<ProblemInstanceSeedPair>> cappedRuns = new HashMap();
    private Set<ProblemInstance> instancesRanSet = new HashSet<ProblemInstance>();
    private final HashMap<ParamConfiguration, List<AlgorithmRun>> configToRunMap = new HashMap();
    private static final DecimalFormat format = new DecimalFormat("#######.####");

    public NewRunHistory(OverallObjective intraInstanceObjective, OverallObjective interInstanceObjective, RunObjective runObj) {
        this.perInstanceObjectiveFunction = intraInstanceObjective;
        this.aggregateInstanceObjectiveFunction = interInstanceObjective;
        this.runObj = runObj;
    }

    @Override
    public void append(AlgorithmRun run) throws DuplicateRunException {
        Double dOldValue;
        LinkedHashMap<Long, Double> seedToPerformanceMap;
        this.log.trace("Appending Run {}", (Object)run);
        if (run.getRunResult().equals((Object)RunResult.RUNNING)) {
            throw new IllegalArgumentException("Runs with Run Result RUNNING cannot be saved to a RunHistory object");
        }
        ParamConfiguration config = run.getRunConfig().getParamConfiguration();
        ProblemInstanceSeedPair pisp = run.getRunConfig().getProblemInstanceSeedPair();
        ProblemInstance pi = pisp.getInstance();
        long seed = run.getResultSeed();
        Double runResult = this.runObj.getObjective(run);
        List<Long> instanceSeedList = this.seedsUsedByInstance.get(pi);
        if (instanceSeedList == null) {
            instanceSeedList = new LinkedList<Long>();
            this.seedsUsedByInstance.put(pi, instanceSeedList);
        }
        instanceSeedList.add(seed);
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceToPerformanceMap = this.configToPerformanceMap.get(config);
        if (instanceToPerformanceMap == null) {
            instanceToPerformanceMap = new HashMap<ProblemInstance, LinkedHashMap<Long, Double>>();
            this.configToPerformanceMap.put(config, instanceToPerformanceMap);
        }
        if ((seedToPerformanceMap = instanceToPerformanceMap.get(pi)) == null) {
            seedToPerformanceMap = new LinkedHashMap();
            instanceToPerformanceMap.put(pi, seedToPerformanceMap);
        }
        if ((dOldValue = seedToPerformanceMap.put(seed, runResult)) != null) {
            Set<ProblemInstanceSeedPair> cappedRunsForConfig = this.cappedRuns.get(config);
            if (cappedRunsForConfig != null && cappedRunsForConfig.contains(pisp)) {
                cappedRunsForConfig.remove(pisp);
            } else {
                AlgorithmRun matchingRun = null;
                for (AlgorithmRun algoRun : this.getAlgorithmRunData(config)) {
                    if (!algoRun.getRunConfig().getProblemInstanceSeedPair().equals(run.getRunConfig().getProblemInstanceSeedPair())) continue;
                    matchingRun = algoRun;
                }
                Object[] args = new Object[]{matchingRun, run, config, pi, dOldValue};
                this.log.error("RunHistory already contains a run with identical config, instance and seed \n Original Run:{}\nRun:{}\nConfig:{}\nInstance:{}\nPrevious Performance:{}", args);
                throw new DuplicateRunException("Duplicate Run Detected", run);
            }
        }
        if (this.configToRunMap.get(config) == null) {
            this.configToRunMap.put(config, new ArrayList());
        }
        this.configToRunMap.get(config).add(run);
        this.totalRuntimeSum += Math.max(0.1, run.getRuntime());
        int thetaIdx = this.paramConfigurationList.getOrCreateKey(config);
        int instanceIdx = pi.getInstanceID();
        RunResult result = run.getRunResult();
        boolean cappedRun = result.equals((Object)RunResult.TIMEOUT) && run.getRunConfig().hasCutoffLessThanMax() || result.equals((Object)RunResult.KILLED);
        this.runHistoryList.add(new RunData(this.iteration, thetaIdx, instanceIdx, run, runResult, cappedRun));
        if (this.configToNumRunsMap.get(config) == null) {
            this.configToNumRunsMap.put(config, 1);
        } else {
            this.configToNumRunsMap.put(config, this.configToNumRunsMap.get(config) + 1);
        }
        this.instancesRanSet.add(pi);
        if (cappedRun) {
            if (!this.cappedRuns.containsKey(config)) {
                this.cappedRuns.put(config, new LinkedHashSet());
            }
            this.cappedRuns.get(config).add(pisp);
        }
        Object[] args = new Object[]{this.iteration, this.paramConfigurationList.getKey(config), pi.getInstanceID(), pisp.getSeed(), format.format(run.getRunConfig().getCutoffTime())};
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        Map<ProblemInstance, Map<Long, Double>> foo = Collections.emptyMap();
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, foo);
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, double minimumResponseValue) {
        Map<ProblemInstance, Map<Long, Double>> foo = Collections.emptyMap();
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, foo, minimumResponseValue);
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        return this.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, Double.NEGATIVE_INFINITY);
    }

    @Override
    public double getEmpiricalCost(ParamConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues, double minimumResponseValue) {
        if (!this.configToPerformanceMap.containsKey(config) && hallucinatedValues.isEmpty()) {
            return Double.MAX_VALUE;
        }
        ArrayList<Double> instanceCosts = new ArrayList<Double>();
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        if (instanceSeedToPerformanceMap == null) {
            instanceSeedToPerformanceMap = new HashMap<ProblemInstance, LinkedHashMap<Long, Double>>();
        }
        HashSet<ProblemInstance> instancesToUse = new HashSet<ProblemInstance>();
        instancesToUse.addAll(instanceSet);
        HashSet<ProblemInstance> instancesToKeep = new HashSet<ProblemInstance>(instanceSeedToPerformanceMap.keySet());
        instancesToKeep.addAll(hallucinatedValues.keySet());
        instancesToUse.retainAll(instancesToKeep);
        for (ProblemInstance pi : instancesToUse) {
            HashMap<Long, Double> seedToPerformanceMap = new HashMap<Long, Double>();
            if (instanceSeedToPerformanceMap.get(pi) != null) {
                seedToPerformanceMap.putAll((Map)instanceSeedToPerformanceMap.get(pi));
            }
            if (hallucinatedValues.get(pi) != null) {
                seedToPerformanceMap.putAll(hallucinatedValues.get(pi));
            }
            ArrayList<Double> localCosts = new ArrayList<Double>();
            for (Map.Entry ent : seedToPerformanceMap.entrySet()) {
                localCosts.add(Math.max(minimumResponseValue, (Double)ent.getValue()));
            }
            instanceCosts.add(this.perInstanceObjectiveFunction.aggregate(localCosts, cutoffTime));
        }
        return this.aggregateInstanceObjectiveFunction.aggregate(instanceCosts, cutoffTime);
    }

    @Override
    public RunObjective getRunObjective() {
        return this.runObj;
    }

    @Override
    public OverallObjective getOverallObjective() {
        return this.perInstanceObjectiveFunction;
    }

    @Override
    public void incrementIteration() {
        ++this.iteration;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public Set<ProblemInstance> getInstancesRan(ParamConfiguration config) {
        if (!this.configToPerformanceMap.containsKey(config)) {
            return new HashSet<ProblemInstance>();
        }
        return new HashSet<ProblemInstance>(this.configToPerformanceMap.get(config).keySet());
    }

    @Override
    public Set<ProblemInstanceSeedPair> getAlgorithmInstanceSeedPairsRan(ParamConfiguration config) {
        if (!this.configToPerformanceMap.containsKey(config)) {
            return new HashSet<ProblemInstanceSeedPair>();
        }
        HashSet<ProblemInstanceSeedPair> pispSet = new HashSet<ProblemInstanceSeedPair>();
        Map<ProblemInstance, LinkedHashMap<Long, Double>> instanceSeedToPerformanceMap = this.configToPerformanceMap.get(config);
        for (Map.Entry<ProblemInstance, LinkedHashMap<Long, Double>> kv : instanceSeedToPerformanceMap.entrySet()) {
            ProblemInstance pi = kv.getKey();
            Map hConfigInst = kv.getValue();
            for (Long seed : hConfigInst.keySet()) {
                pispSet.add(new ProblemInstanceSeedPair(pi, seed));
            }
        }
        return pispSet;
    }

    @Override
    public Set<ProblemInstanceSeedPair> getCappedAlgorithmInstanceSeedPairs(ParamConfiguration config) {
        if (!this.cappedRuns.containsKey(config)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.cappedRuns.get(config));
    }

    @Override
    public int getTotalNumRunsOfConfig(ParamConfiguration config) {
        Integer value = this.configToNumRunsMap.get(config);
        if (value != null) {
            return value;
        }
        return 0;
    }

    @Override
    public double getTotalRunCost() {
        return this.totalRuntimeSum;
    }

    @Override
    public double[] getRunResponseValues() {
        double[] responseValues = new double[this.runHistoryList.size()];
        int i = 0;
        for (RunData runData : this.runHistoryList) {
            responseValues[i] = runData.getResponseValue();
            ++i;
        }
        return responseValues;
    }

    @Override
    public boolean[] getCensoredFlagForRuns() {
        boolean[] responseValues = new boolean[this.runHistoryList.size()];
        int i = 0;
        for (RunData runData : this.runHistoryList) {
            responseValues[i] = runData.getRun().getRunResult().equals((Object)RunResult.TIMEOUT) && runData.getRun().getRunConfig().hasCutoffLessThanMax() || runData.getRun().getRunResult().equals((Object)RunResult.KILLED);
            ++i;
        }
        return responseValues;
    }

    @Override
    public Set<ProblemInstance> getUniqueInstancesRan() {
        return Collections.unmodifiableSet(this.instancesRanSet);
    }

    @Override
    public Set<ParamConfiguration> getUniqueParamConfigurations() {
        return Collections.unmodifiableSet(this.configToNumRunsMap.keySet());
    }

    @Override
    public int[][] getParameterConfigurationInstancesRanByIndex() {
        int[][] result = new int[this.runHistoryList.size()][2];
        int i = 0;
        for (RunData runData : this.runHistoryList) {
            result[i][0] = runData.getThetaIdx();
            result[i][1] = runData.getInstanceidx();
            ++i;
        }
        return result;
    }

    @Override
    public List<ParamConfiguration> getAllParameterConfigurationsRan() {
        ArrayList<ParamConfiguration> runs = new ArrayList<ParamConfiguration>(this.paramConfigurationList.size());
        for (int i = 1; i <= this.paramConfigurationList.size(); ++i) {
            runs.add(this.paramConfigurationList.getValue(i));
        }
        return runs;
    }

    @Override
    public double[][] getAllConfigurationsRanInValueArrayForm() {
        double[][] configs = new double[this.paramConfigurationList.size()][];
        for (int i = 1; i <= this.paramConfigurationList.size(); ++i) {
            configs[i - 1] = this.paramConfigurationList.getValue(i).toValueArray();
        }
        return configs;
    }

    @Override
    public List<AlgorithmRun> getAlgorithmRuns() {
        ArrayList<AlgorithmRun> runs = new ArrayList<AlgorithmRun>(this.runHistoryList.size());
        for (RunData runData : this.getAlgorithmRunData()) {
            runs.add(runData.getRun());
        }
        return runs;
    }

    @Override
    public List<RunData> getAlgorithmRunData() {
        return Collections.unmodifiableList(this.runHistoryList);
    }

    @Override
    public int getThetaIdx(ParamConfiguration config) {
        Integer thetaIdx = this.paramConfigurationList.getKey(config);
        if (thetaIdx == null) {
            return -1;
        }
        return thetaIdx;
    }

    @Override
    public int getOrCreateThetaIdx(ParamConfiguration config) {
        return this.paramConfigurationList.getOrCreateKey(config);
    }

    @Override
    public int getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(ParamConfiguration config) {
        Map<ProblemInstance, LinkedHashMap<Long, Double>> runs = this.configToPerformanceMap.get(config);
        int total = 0;
        for (Map.Entry<ProblemInstance, LinkedHashMap<Long, Double>> ent : runs.entrySet()) {
            total += ent.getValue().size();
        }
        return total;
    }

    @Override
    public Map<ProblemInstance, LinkedHashMap<Long, Double>> getPerformanceForConfig(ParamConfiguration config) {
        Map<ProblemInstance, LinkedHashMap<Long, Double>> map = this.configToPerformanceMap.get(config);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<AlgorithmRun> getAlgorithmRunData(ParamConfiguration config) {
        List<AlgorithmRun> runs = this.configToRunMap.get(config);
        if (runs != null) {
            return Collections.unmodifiableList(runs);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getSeedsUsedByInstance(ProblemInstance pi) {
        if (this.seedsUsedByInstance.get(pi) == null) {
            this.seedsUsedByInstance.put(pi, new ArrayList());
        }
        return Collections.unmodifiableList(this.seedsUsedByInstance.get(pi));
    }
}

