/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.initialization.table;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aclib.initialization.doublingcapping.DoublingCappingInitializationProcedure;
import ca.ubc.cs.beta.aclib.initialization.table.UnbiasChallengerInitializationProcedureOptions;
import ca.ubc.cs.beta.aclib.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.aclib.objectives.ObjectiveHelper;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class UnbiasChallengerInitializationProcedure
implements InitializationProcedure {
    private final ThreadSafeRunHistory runHistory;
    private final ParamConfiguration initialIncumbent;
    private final TargetAlgorithmEvaluator tae;
    private final UnbiasChallengerInitializationProcedureOptions opts;
    private final Logger log = LoggerFactory.getLogger(DoublingCappingInitializationProcedure.class);
    private final int maxIncumbentRuns;
    private final List<ProblemInstance> instances;
    private final InstanceSeedGenerator insc;
    private volatile ParamConfiguration incumbent;
    private final TerminationCondition termCond;
    private final double cutoffTime;
    private final SeedableRandomPool pool;
    private boolean deterministicInstanceOrdering;
    private final ParamConfigurationSpace configSpace;
    private final int numberOfChallengers;
    private final int numberOfRunsPerChallenger;
    private final ObjectiveHelper objHelp;
    private final double cpuTimeLimit;

    public UnbiasChallengerInitializationProcedure(ThreadSafeRunHistory runHistory, ParamConfiguration initialIncumbent, TargetAlgorithmEvaluator tae, UnbiasChallengerInitializationProcedureOptions opts, InstanceSeedGenerator insc, List<ProblemInstance> instances, int maxIncumbentRuns, TerminationCondition termCond, double cutoffTime, SeedableRandomPool pool, boolean deterministicInstanceOrdering, ObjectiveHelper objHelp) {
        this.runHistory = runHistory;
        this.initialIncumbent = initialIncumbent;
        this.tae = tae;
        this.opts = opts;
        this.instances = instances;
        this.maxIncumbentRuns = maxIncumbentRuns;
        this.insc = insc;
        this.incumbent = initialIncumbent;
        this.termCond = termCond;
        this.cutoffTime = cutoffTime;
        this.pool = pool;
        this.deterministicInstanceOrdering = deterministicInstanceOrdering;
        this.configSpace = initialIncumbent.getConfigurationSpace();
        this.cpuTimeLimit = opts.cpulimit;
        if (this.cpuTimeLimit <= 0.0) {
            throw new ParameterException("Time must be greater than zero");
        }
        this.numberOfRunsPerChallenger = opts.numberOfRunsPerChallenger;
        this.numberOfChallengers = opts.numberOfChallengers;
        if (maxIncumbentRuns < this.numberOfRunsPerChallenger) {
            throw new ParameterException("Number of runs per challenger is less than the number permitted:" + maxIncumbentRuns);
        }
        if (!insc.allInstancesHaveSameNumberOfSeeds()) {
            throw new ParameterException("All instances are required to have the same number of seeds available");
        }
        if ((double)this.numberOfChallengers > this.configSpace.getUpperBoundOnSize()) {
            throw new ParameterException("Too many challengers have been requested, configuration space size is at most " + this.configSpace.getUpperBoundOnSize() + " but we want to use " + this.numberOfChallengers);
        }
        if ((double)this.numberOfChallengers > this.configSpace.getLowerBoundOnSize() / 10.0) {
            this.log.warn("Configuration space size ({}) isn't much bigger than the number of challengers we are using in initialization ({}), this isn't an error but depending on conditionality and forbidden rules, we may not be able to satisfy this requirement", (Object)this.configSpace.getLowerBoundOnSize(), (Object)this.numberOfChallengers);
        }
        if (this.numberOfRunsPerChallenger * this.numberOfChallengers <= 0) {
            throw new ParameterException("Challengers requested " + this.numberOfChallengers + " runsPerChallenger:" + this.numberOfRunsPerChallenger + " must both be positive");
        }
        this.objHelp = objHelp;
    }

    @Override
    public void run() {
        try {
            Random rand = this.pool.getRandom("UNBIASED_CHALLENGER_TABLE_INITIALIZATION");
            List<ProblemInstanceSeedPair> selectedPisps = this.getProblemInstanceSeedPairs(rand);
            HashSet<ProblemInstance> selectedPis = new HashSet<ProblemInstance>();
            for (ProblemInstanceSeedPair pisp : selectedPisps) {
                selectedPis.add(pisp.getInstance());
            }
            Set<ParamConfiguration> thetas = this.getParameterConfigurations(rand, Collections.singleton(this.initialIncumbent));
            List<Pair<ProblemInstanceSeedPair, ParamConfiguration>> pispConfigs = this.createPairs(rand, selectedPisps, thetas);
            List<AlgorithmRun> incumbentRuns = this.scheduleInitialIncumbent(selectedPisps);
            this.initializeRuns(pispConfigs);
            this.log.debug("Waiting for all outstanding evaluations to complete");
            this.tae.waitForOutstandingEvaluations();
            this.log.info("All outstanding runs completed, inspecting best configuration");
            if (incumbentRuns.size() == 0) {
                throw new IllegalStateException("Expected Default Configuration to have finished running at this point");
            }
            try {
                this.runHistory.append(incumbentRuns);
            }
            catch (DuplicateRunException e) {
                throw new IllegalStateException(e);
            }
            ParamConfiguration bestConfiguration = this.selectMinimumConfiguration(selectedPis, thetas);
            double minCost = this.runHistory.getEmpiricalCost(bestConfiguration, selectedPis, this.cutoffTime);
            double incCost = this.runHistory.getEmpiricalCost(this.initialIncumbent, selectedPis, this.cutoffTime);
            if (incCost > minCost) {
                this.log.info("Challenger {} ({}) looks better than initial incumbent {} ({}) scheduling censored runs ( {} vs. {} )", new Object[]{this.runHistory.getThetaIdx(bestConfiguration), bestConfiguration, this.runHistory.getThetaIdx(this.initialIncumbent), this.initialIncumbent, minCost, incCost});
                List<AlgorithmRun> runs = this.runHistory.getAlgorithmRunData(bestConfiguration);
                HashSet<ProblemInstanceSeedPair> pispsToRun = new HashSet<ProblemInstanceSeedPair>();
                for (AlgorithmRun run : runs) {
                    if (run.getRunResult().isDecided() || !run.getRunConfig().hasCutoffLessThanMax()) continue;
                    pispsToRun.add(run.getRunConfig().getProblemInstanceSeedPair());
                }
                ArrayList<RunConfig> rcs = new ArrayList<RunConfig>();
                for (ProblemInstanceSeedPair pisp : pispsToRun) {
                    rcs.add(new RunConfig(pisp, this.cutoffTime, bestConfiguration, false));
                }
                this.log.info("Solved runs {} ", this.runHistory.getAlgorithmRunData(bestConfiguration));
                this.log.info("Unsolved {}", rcs);
                this.log.info("Scheduling {} incomplete runs for {} ({}) ", new Object[]{rcs.size(), this.runHistory.getThetaIdx(bestConfiguration), bestConfiguration});
                List<AlgorithmRun> completedRuns = this.tae.evaluateRun(rcs);
                try {
                    this.runHistory.append(completedRuns);
                }
                catch (DuplicateRunException e) {
                    throw new IllegalStateException(e);
                }
                minCost = this.runHistory.getEmpiricalCost(bestConfiguration, selectedPis, this.cutoffTime);
            }
            if (incCost > minCost) {
                this.log.info("Best challengers performance on set is {} versus initial incumbent {}, setting new incumbent", (Object)minCost, (Object)incCost);
                this.incumbent = bestConfiguration;
            } else {
                this.log.info("Best challengers performance on set is {} versus initial incumbent {}, leaving incumbent alone", (Object)minCost, (Object)incCost);
                this.incumbent = this.initialIncumbent;
            }
            this.log.info("Initialization procedure completed ({} total runs, total cpu time used {}), selected incumbent is {} ({})", new Object[]{this.runHistory.getAlgorithmRunData().size(), this.runHistory.getTotalRunCost(), this.runHistory.getThetaIdx(this.incumbent), this.incumbent.getFriendlyIDHex()});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.incumbent = this.initialIncumbent;
            return;
        }
        System.exit(0);
    }

    private ParamConfiguration selectMinimumConfiguration(Set<ProblemInstance> selectedPis, Set<ParamConfiguration> thetas) {
        double minCost = Double.MAX_VALUE;
        ParamConfiguration bestConfiguration = null;
        for (ParamConfiguration config : thetas) {
            double cost = this.runHistory.getEmpiricalCost(config, selectedPis, this.cutoffTime);
            if (bestConfiguration == null) {
                bestConfiguration = config;
            }
            if (!(minCost > cost)) continue;
            bestConfiguration = config;
            minCost = cost;
        }
        return bestConfiguration;
    }

    private void initializeRuns(List<Pair<ProblemInstanceSeedPair, ParamConfiguration>> pispConfigs) throws InterruptedException {
        final LinkedBlockingQueue<Pair<ProblemInstanceSeedPair, ParamConfiguration>> unSolvedPispThetasQueue = new LinkedBlockingQueue<Pair<ProblemInstanceSeedPair, ParamConfiguration>>();
        unSolvedPispThetasQueue.addAll(pispConfigs);
        final Set solvedPisps = Collections.newSetFromMap(new ConcurrentHashMap());
        final AtomicBoolean killNow = new AtomicBoolean(false);
        TargetAlgorithmEvaluatorRunObserver killAtTimeoutObserver = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                if (killNow.get()) {
                    for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                        killableAlgorithmRun.kill();
                    }
                }
            }
        };
        int allPairsSize = pispConfigs.size();
        final Semaphore runCompleted = new Semaphore(unSolvedPispThetasQueue.size());
        ConcurrentHashMap<Pair, Double> nextCutoffTime = new ConcurrentHashMap<Pair, Double>();
        for (Pair<ProblemInstanceSeedPair, ParamConfiguration> p : pispConfigs) {
            nextCutoffTime.put(p, -1.0);
        }
        block1: while (true) {
            int i = 0;
            while (true) {
                if (i >= pispConfigs.size()) continue block1;
                while (!runCompleted.tryAcquire(1L, TimeUnit.SECONDS)) {
                }
                final Pair pair = (Pair)unSolvedPispThetasQueue.poll();
                if (pair == null) {
                    if (solvedPisps.size() == allPairsSize) {
                        this.log.debug("All runs are considered done");
                        break block1;
                    }
                    --i;
                } else {
                    TargetAlgorithmEvaluatorCallback taeCallback = new TargetAlgorithmEvaluatorCallback(){

                        @Override
                        public void onSuccess(List<AlgorithmRun> runs) {
                            try {
                                UnbiasChallengerInitializationProcedure.this.runHistory.append(runs);
                            }
                            catch (DuplicateRunException e) {
                                throw new IllegalStateException(e);
                            }
                            if (runs.get(0).getRunResult().isDecided() || !runs.get(0).getRunConfig().hasCutoffLessThanMax()) {
                                if (runs.get(0).getRunResult().isDecided()) {
                                    UnbiasChallengerInitializationProcedure.this.log.info("Run completed successfully: {} ", (Object)runs.get(0));
                                }
                                solvedPisps.add(pair);
                            } else {
                                unSolvedPispThetasQueue.add(pair);
                            }
                            runCompleted.release();
                        }

                        @Override
                        public void onFailure(RuntimeException e) {
                            UnbiasChallengerInitializationProcedure.this.log.error("Error occurred during initialization", (Throwable)e);
                        }
                    };
                    double kappa = this.getNextKappa(pair, allPairsSize, solvedPisps.size(), (Double)nextCutoffTime.get(pair));
                    if (this.runHistory.getTotalRunCost() > this.cpuTimeLimit) {
                        killNow.set(true);
                        this.log.info("Initialization procedure has used {}, time limit: {}, halting procedure...", (Object)this.runHistory.getTotalRunCost(), (Object)this.cpuTimeLimit);
                        break block1;
                    }
                    if (kappa < 0.0) {
                        throw new IllegalStateException("Still continuing with run, but the kappa time is zero.");
                    }
                    nextCutoffTime.put(pair, kappa);
                    this.tae.evaluateRunsAsync(Collections.singletonList(new RunConfig((ProblemInstanceSeedPair)pair.getFirst(), kappa, (ParamConfiguration)pair.getSecond(), kappa < this.cutoffTime)), taeCallback, killAtTimeoutObserver);
                }
                ++i;
            }
            break;
        }
    }

    public double getNextKappa(Pair<ProblemInstanceSeedPair, ParamConfiguration> pair, int allPairsSize, int solvedPisSize, double lastKappa) {
        double kappaFromShareRemaining = (this.cpuTimeLimit - this.runHistory.getTotalRunCost()) / (double)(allPairsSize - solvedPisSize);
        double kappaNextStep = 2.0 * lastKappa;
        double kappaMax = this.cutoffTime;
        double kappa = Math.min(Math.max(kappaNextStep, kappaFromShareRemaining), kappaMax);
        return Math.max(kappa, 1.0);
    }

    @Override
    public ParamConfiguration getIncumbent() {
        return this.incumbent;
    }

    private List<AlgorithmRun> scheduleInitialIncumbent(List<ProblemInstanceSeedPair> selectedPisps) {
        final List<AlgorithmRun> incumbentRuns = Collections.synchronizedList(new ArrayList(selectedPisps.size()));
        ArrayList<RunConfig> rcs = new ArrayList<RunConfig>(selectedPisps.size());
        for (ProblemInstanceSeedPair pisp : selectedPisps) {
            rcs.add(new RunConfig(pisp, this.cutoffTime, this.initialIncumbent));
        }
        this.runHistory.getOrCreateThetaIdx(this.initialIncumbent);
        this.log.info("Scheduling {} runs for initial configuration", (Object)rcs.size());
        this.tae.evaluateRunsAsync(rcs, new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                UnbiasChallengerInitializationProcedure.this.log.info("Default configuration runs are done");
                incumbentRuns.addAll(runs);
            }

            @Override
            public void onFailure(RuntimeException e) {
                UnbiasChallengerInitializationProcedure.this.log.error("Error occurred during initialization", (Throwable)e);
            }
        });
        return incumbentRuns;
    }

    private List<Pair<ProblemInstanceSeedPair, ParamConfiguration>> createPairs(Random rand, List<ProblemInstanceSeedPair> selectedPisps, Set<ParamConfiguration> thetas) {
        ArrayList<Pair<ProblemInstanceSeedPair, ParamConfiguration>> pispConfigs = new ArrayList<Pair<ProblemInstanceSeedPair, ParamConfiguration>>(thetas.size() * selectedPisps.size());
        for (ParamConfiguration config : thetas) {
            for (ProblemInstanceSeedPair pisp : selectedPisps) {
                pispConfigs.add(new Pair<ProblemInstanceSeedPair, ParamConfiguration>(pisp, config));
            }
        }
        Collections.shuffle(pispConfigs, rand);
        return pispConfigs;
    }

    private Set<ParamConfiguration> getParameterConfigurations(Random rand, Set<ParamConfiguration> excluded) {
        this.log.info("Generating {} configurations for use in initialization", (Object)this.numberOfChallengers);
        HashSet<ParamConfiguration> thetas = new HashSet<ParamConfiguration>(this.numberOfChallengers);
        thetas.addAll(excluded);
        while (thetas.size() - excluded.size() < this.numberOfChallengers) {
            boolean created = false;
            for (int i = 0; i < 1000; ++i) {
                ParamConfiguration config = this.configSpace.getRandomConfiguration(rand);
                if (config.equals(this.configSpace.getDefaultConfiguration())) {
                    --i;
                    continue;
                }
                boolean newConfiguration = thetas.add(config);
                if (!newConfiguration) continue;
                created = true;
                break;
            }
            if (created) continue;
            throw new IllegalStateException("After 1000 attempts we were unable to generate another unique configuration. We already have " + thetas.size() + " this can happen if you request too many configurations in initialization, or if the space is incredibly conditional / has many forbidden configurations.");
        }
        thetas.removeAll(excluded);
        return thetas;
    }

    private List<ProblemInstanceSeedPair> getProblemInstanceSeedPairs(Random rand) {
        ArrayList<ProblemInstanceSeedPair> selectedPisps = new ArrayList<ProblemInstanceSeedPair>();
        this.log.info("Generating {} Problem Instance Seed Pairs for use in initialization", (Object)this.numberOfRunsPerChallenger);
        ArrayList<ProblemInstance> shuffledPis = new ArrayList<ProblemInstance>(this.instances);
        Collections.shuffle(shuffledPis, rand);
        block0: while (selectedPisps.size() < this.numberOfRunsPerChallenger) {
            for (ProblemInstance pi : shuffledPis) {
                if (!this.insc.hasNextSeed(pi)) {
                    throw new IllegalStateException("Should not have been able to generate this many requests for configurations");
                }
                long seed = this.insc.getNextSeed(pi);
                ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, seed);
                selectedPisps.add(pisp);
                if (selectedPisps.size() < this.numberOfRunsPerChallenger) continue;
                continue block0;
            }
        }
        return selectedPisps;
    }
}

