/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.initialization.doublingcapping;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aclib.initialization.doublingcapping.DoublingCappingInitializationProcedureOptions;
import ca.ubc.cs.beta.aclib.misc.MapList;
import ca.ubc.cs.beta.aclib.objectives.ObjectiveHelper;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.seedgenerator.SetInstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.experimental.queuefacade.basic.BasicTargetAlgorithmEvaluatorQueue;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.experimental.queuefacade.basic.BasicTargetAlgorithmEvaluatorQueueResultContext;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import com.beust.jcommander.ParameterException;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DoublingCappingInitializationProcedure
implements InitializationProcedure {
    private final ThreadSafeRunHistory runHistory;
    private final ParamConfiguration initialIncumbent;
    private final TargetAlgorithmEvaluator tae;
    private final DoublingCappingInitializationProcedureOptions opts;
    private final Logger log = LoggerFactory.getLogger(DoublingCappingInitializationProcedure.class);
    private final int maxIncumbentRuns;
    private final List<ProblemInstance> instances;
    private final InstanceSeedGenerator insc;
    private ParamConfiguration incumbent;
    private final TerminationCondition termCond;
    private final double cutoffTime;
    private final SeedableRandomPool pool;
    private boolean deterministicInstanceOrdering;
    private final ParamConfigurationSpace configSpace;
    private final int numberOfChallengers;
    private final int numberOfRunsPerChallenger;
    private final ObjectiveHelper objHelp;

    public DoublingCappingInitializationProcedure(ThreadSafeRunHistory runHistory, ParamConfiguration initialIncumbent, TargetAlgorithmEvaluator tae, DoublingCappingInitializationProcedureOptions opts, InstanceSeedGenerator insc, List<ProblemInstance> instances, int maxIncumbentRuns, TerminationCondition termCond, double cutoffTime, SeedableRandomPool pool, boolean deterministicInstanceOrdering, ObjectiveHelper objHelp) {
        this.runHistory = runHistory;
        this.initialIncumbent = initialIncumbent;
        this.tae = tae;
        this.opts = opts;
        this.instances = instances;
        this.maxIncumbentRuns = maxIncumbentRuns;
        this.insc = insc;
        this.incumbent = initialIncumbent;
        this.termCond = termCond;
        this.cutoffTime = cutoffTime;
        this.pool = pool;
        this.deterministicInstanceOrdering = deterministicInstanceOrdering;
        this.configSpace = initialIncumbent.getConfigurationSpace();
        this.numberOfChallengers = opts.numberOfChallengers;
        this.numberOfRunsPerChallenger = opts.numberOfRunsPerChallenger;
        this.objHelp = objHelp;
    }

    @Override
    public void run() {
        int i;
        this.log.warn("Doubling Capping initialization procedure is EXPERIMENTAL currently. It may not work in all scenarios, such as those with small configurations and/or instance distributions. Termination conditions will be updated but not actually checked until after the procedure is completed, and state restoration will not properly restore the state (some runs will be lost). Finally as it has a lot of edge cases bugs are likely, the bugs should only manifest themselves as a crash");
        if (this.numberOfChallengers == 1) {
            throw new ParameterException("Number of Challengers must be greater than 1, use CLASSIC initialization ");
        }
        this.log.error("TAE Notify and Events need to be handled");
        this.log.info("Using Doubling Capping Initialization");
        ParamConfiguration incumbent = this.initialIncumbent;
        this.log.info("Configuration Set as initial Incumbent: {}", (Object)incumbent);
        double startKappa = this.cutoffTime;
        int divisions = 1;
        while (startKappa / 2.0 > 1.0) {
            startKappa /= 2.0;
            ++divisions;
        }
        HashSet<ParamConfiguration> randomConfigurations = new HashSet<ParamConfiguration>();
        int totalFirstRoundChallengers = this.numberOfChallengers * this.numberOfRunsPerChallenger * divisions;
        if ((double)totalFirstRoundChallengers > this.configSpace.getUpperBoundOnSize()) {
            throw new IllegalStateException("Doubling Capping initialization won't work with this configuration space as it's too small, use classic");
        }
        Random configRandom = this.pool.getRandom("DOUBLING_INITIALIZATION_CONFIGS");
        while (randomConfigurations.size() < totalFirstRoundChallengers) {
            randomConfigurations.add(this.configSpace.getRandomConfiguration(configRandom));
        }
        ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>(totalFirstRoundChallengers);
        Random pispRandom = this.pool.getRandom("DOUBLING_INITIALIZATION_PISPS");
        int i2 = 0;
        int attempts = 0;
        while (i2 < totalFirstRoundChallengers) {
            ProblemInstance pi;
            if (this.insc instanceof SetInstanceSeedGenerator) {
                this.insc.reinit();
            }
            if (!this.insc.hasNextSeed(pi = this.instances.get(pispRandom.nextInt(this.instances.size())))) {
                --i2;
                if (attempts > 10000) {
                    throw new IllegalStateException("Could not generate anymore problem instance seed pairs, probably the number of instances * number of seeds is too small compared to the number of challengers and runs per challenge to use in initialization");
                }
            } else {
                attempts = 0;
                ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, this.insc.getNextSeed(pi));
                pisps.add(pisp);
            }
            ++i2;
            ++attempts;
        }
        this.log.debug("Doubling capping has generated {} distinct configurations and {} problem instance seed pairs", (Object)randomConfigurations.size(), (Object)pisps.size());
        LinkedBlockingQueue<ParamConfiguration> configsQueue = new LinkedBlockingQueue<ParamConfiguration>();
        configsQueue.addAll(randomConfigurations);
        LinkedBlockingQueue<ProblemInstanceSeedPair> pispsQueue = new LinkedBlockingQueue<ProblemInstanceSeedPair>();
        pispsQueue.addAll(pisps);
        LinkedBlockingQueue<RunConfig> runsToDo = new LinkedBlockingQueue<RunConfig>();
        for (double kappa = startKappa; kappa <= this.cutoffTime; kappa *= 2.0) {
            for (i = 0; i < this.numberOfChallengers * this.numberOfRunsPerChallenger; ++i) {
                ParamConfiguration config = i == 0 ? this.initialIncumbent : (ParamConfiguration)configsQueue.poll();
                RunConfig rc = new RunConfig((ProblemInstanceSeedPair)pispsQueue.poll(), kappa, config, kappa < this.cutoffTime);
                runsToDo.add(rc);
            }
        }
        this.log.debug("Doubling capping has generated {} runs to do", runsToDo);
        MapList<RunResult, AlgorithmRun> runs = new MapList<RunResult, AlgorithmRun>(new EnumMap(RunResult.class));
        this.phaseOneRuns(runsToDo, runs);
        HashSet<AlgorithmRun> phaseTwoRuns = new HashSet<AlgorithmRun>();
        phaseTwoRuns.addAll(runs.getList(RunResult.SAT));
        phaseTwoRuns.addAll(runs.getList(RunResult.UNSAT));
        if (phaseTwoRuns.size() < this.numberOfChallengers) {
            this.log.info("Insufficient runs with SAT and UNSAT were found {} but needed {}, using some TIMEOUT runs for Phase 2 of initialization", (Object)phaseTwoRuns.size(), (Object)this.numberOfChallengers);
            List<AlgorithmRun> timeouts = runs.getList(RunResult.TIMEOUT);
            for (i = 0; phaseTwoRuns.size() < this.numberOfChallengers && i < timeouts.size(); ++i) {
                phaseTwoRuns.add(timeouts.get(i));
            }
        }
        if (phaseTwoRuns.size() < this.numberOfChallengers) {
            this.log.info("Phase one did not have enough completed runs ({}) to satisfy request of challengers: {}", (Object)phaseTwoRuns.size(), (Object)this.numberOfChallengers);
        } else {
            this.log.info("Beginning Phase 2 of initialization with {} completed runs", (Object)phaseTwoRuns.size());
        }
        HashSet<RunConfig> existingRunConfigs = new HashSet<RunConfig>();
        HashSet<ParamConfiguration> configs = new HashSet<ParamConfiguration>();
        HashSet<ProblemInstanceSeedPair> phaseTwoPisps = new HashSet<ProblemInstanceSeedPair>();
        MapList<ParamConfiguration, AlgorithmRun> phaseTwoResults = new MapList<ParamConfiguration, AlgorithmRun>(new HashMap());
        MapList<ParamConfiguration, ProblemInstanceSeedPair> phaseTwoPispResults = MapList.getHashMapList();
        final ConcurrentHashMap previouslyExistingRun = new ConcurrentHashMap();
        for (AlgorithmRun run : phaseTwoRuns) {
            existingRunConfigs.add(run.getRunConfig());
            configs.add(run.getRunConfig().getParamConfiguration());
            phaseTwoPisps.add(run.getRunConfig().getProblemInstanceSeedPair());
            phaseTwoResults.addToList(run.getRunConfig().getParamConfiguration(), run);
            phaseTwoPispResults.addToList(run.getRunConfig().getParamConfiguration(), run.getRunConfig().getProblemInstanceSeedPair());
            if (phaseTwoResults.get(run.getRunConfig().getParamConfiguration()).size() <= 1) continue;
            this.log.warn("[BUG Detected]: Expected that only run one would be completed for a given configuration, but got {}", phaseTwoResults.get(run.getRunConfig().getParamConfiguration()));
        }
        ArrayList configToIterate = new ArrayList(configs);
        Random diShuffle = this.pool.getRandom("DOUBLING_INITIALIZATION_SHUFFLE");
        Collections.shuffle(configToIterate, diShuffle);
        if (!configs.contains(this.initialIncumbent)) {
            this.log.debug("Initial Incumbent did not pass first round, adding to set");
            configToIterate.add(configToIterate.get(0));
            configToIterate.set(0, this.initialIncumbent);
        }
        ArrayList pispsToIterate = new ArrayList(phaseTwoPisps);
        Collections.shuffle(pispsToIterate, diShuffle);
        final AtomicDouble bestPerformance = new AtomicDouble(Double.MAX_VALUE);
        TargetAlgorithmEvaluatorRunObserver phaseTwoObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                ArrayList<? extends KillableAlgorithmRun> objRuns = new ArrayList<KillableAlgorithmRun>(runs);
                objRuns.add((KillableAlgorithmRun)previouslyExistingRun.get(runs.get(0).getRunConfig().getParamConfiguration()));
                double myPerformance = DoublingCappingInitializationProcedure.this.objHelp.computeObjective(runs);
                if (myPerformance > bestPerformance.get()) {
                    for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                        killableAlgorithmRun.kill();
                    }
                    return;
                }
            }
        };
        BasicTargetAlgorithmEvaluatorQueue phaseTwoTaeQueue = new BasicTargetAlgorithmEvaluatorQueue(this.tae, true);
        for (int i3 = 0; i3 < Math.min(this.numberOfChallengers, configToIterate.size()); ++i3) {
            ParamConfiguration config = (ParamConfiguration)configToIterate.get(i3);
            ArrayList<RunConfig> runsForConfig = new ArrayList<RunConfig>();
            for (int j = 0; j < Math.min(this.numberOfRunsPerChallenger, phaseTwoPisps.size()); ++j) {
                ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)pispsToIterate.get(j);
                runsForConfig.add(new RunConfig(pisp, this.cutoffTime, config));
            }
            this.log.debug("Scheduling {} runs for config {}", (Object)runsForConfig.size(), (Object)config);
            phaseTwoTaeQueue.evaluateRunAsync(runsForConfig, phaseTwoObs);
        }
        ParamConfiguration newIncumbent = null;
        while (phaseTwoTaeQueue.getNumberOfOutstandingAndQueuedRuns() > 0) {
            try {
                List<AlgorithmRun> currentResults = phaseTwoTaeQueue.take().getAlgorithmRuns();
                double myPerformance = this.objHelp.computeObjective(currentResults);
                if (bestPerformance.get() > myPerformance) {
                    double previousBest = bestPerformance.get();
                    bestPerformance.set(myPerformance);
                    newIncumbent = currentResults.get(0).getRunConfig().getParamConfiguration();
                    this.log.debug("New Incumbent set to {} with performance {} previous best was {} ", new Object[]{newIncumbent, myPerformance, previousBest});
                }
                try {
                    for (AlgorithmRun run : currentResults) {
                        this.insc.take(run.getRunConfig().getProblemInstanceSeedPair().getInstance(), run.getRunConfig().getProblemInstanceSeedPair().getSeed());
                    }
                    this.runHistory.append(currentResults);
                }
                catch (DuplicateRunException e) {
                    throw new IllegalStateException(e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted Exception occurred during start up, cannot continue, every invariant I am designed to hold true can not be assured.");
            }
        }
        this.log.info("Initialization Procedure Completed. Selected incumbent {} ({}) incumbent has performance: {} ", new Object[]{this.runHistory.getThetaIdx(incumbent), incumbent, bestPerformance.get()});
        this.incumbent = newIncumbent;
    }

    private void phaseOneRuns(LinkedBlockingQueue<RunConfig> runsToDo, MapList<RunResult, AlgorithmRun> runs) {
        int completedRuns = 0;
        final AtomicBoolean allRunsCompleted = new AtomicBoolean(false);
        AtomicBoolean incumbentSolved = new AtomicBoolean(false);
        TargetAlgorithmEvaluatorRunObserver obs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                if (allRunsCompleted.get()) {
                    DoublingCappingInitializationProcedure.this.log.debug("Phase One completed killing in progress runs {}", runs);
                    for (KillableAlgorithmRun killableAlgorithmRun : runs) {
                        killableAlgorithmRun.kill();
                    }
                }
            }
        };
        this.log.info("Beginning Phase One Runs");
        double lastKappa = 0.0;
        BasicTargetAlgorithmEvaluatorQueue taeQueue = new BasicTargetAlgorithmEvaluatorQueue(this.tae, true);
        block8: while (completedRuns < this.numberOfChallengers) {
            try {
                BasicTargetAlgorithmEvaluatorQueueResultContext context;
                RunConfig rc = runsToDo.poll();
                if (rc != null) {
                    while (incumbentSolved.get() && rc.getParamConfiguration().equals(this.initialIncumbent)) {
                        rc = runsToDo.poll();
                        if (rc != null) continue;
                        continue block8;
                    }
                    if (lastKappa != rc.getCutoffTime()) {
                        lastKappa = rc.getCutoffTime();
                        this.log.info("Beginning Phase One Runs with Cutoff time {} (s)", (Object)lastKappa);
                    }
                    taeQueue.evaluateRunAsync(Collections.singletonList(rc), obs);
                    context = taeQueue.poll();
                } else {
                    context = taeQueue.take();
                }
                while (context != null) {
                    AlgorithmRun run = context.getAlgorithmRuns().get(0);
                    this.log.debug("Run Returned: {}", (Object)run);
                    switch (run.getRunResult()) {
                        case SAT: 
                        case UNSAT: {
                            if (run.getRunConfig().getParamConfiguration().equals(this.initialIncumbent)) {
                                if (incumbentSolved.get()) break;
                                incumbentSolved.set(true);
                                this.log.debug("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                                runs.addToList(run.getRunResult(), run);
                                break;
                            }
                            this.log.debug("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                            runs.addToList(run.getRunResult(), run);
                            break;
                        }
                        case TIMEOUT: {
                            if (run.getRunConfig().hasCutoffLessThanMax()) break;
                            if (run.getRunConfig().getParamConfiguration().equals(this.initialIncumbent)) {
                                if (incumbentSolved.get()) break;
                                incumbentSolved.set(true);
                                this.log.debug("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                                runs.addToList(run.getRunResult(), run);
                                break;
                            }
                            this.log.debug("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                            runs.addToList(run.getRunResult(), run);
                            break;
                        }
                        case KILLED: {
                            this.log.debug("Killed run detected in First round: {}", (Object)run);
                            break;
                        }
                        case CRASHED: {
                            if (run.getRunConfig().hasCutoffLessThanMax()) break;
                            if (run.getRunConfig().getParamConfiguration().equals(this.initialIncumbent)) {
                                incumbentSolved.set(true);
                            }
                            this.log.debug("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                            runs.addToList(run.getRunResult(), run);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Got unexpected run result back " + (Object)((Object)context.getAlgorithmRuns().get(0).getRunResult()));
                        }
                    }
                    context = taeQueue.poll();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted prematurely");
            }
        }
        this.log.debug("Notifying existing Phase One runs to terminate");
        allRunsCompleted.set(true);
        this.log.info("Phase One Runs Complete");
    }

    @Override
    public ParamConfiguration getIncumbent() {
        return this.incumbent;
    }
}

