/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.initialization.classic;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.exceptions.OutOfTimeException;
import ca.ubc.cs.beta.aclib.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aclib.initialization.classic.ClassicInitializationProcedureOptions;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.RunHistoryHelper;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicInitializationProcedure
implements InitializationProcedure {
    private final ThreadSafeRunHistory runHistory;
    private final ParamConfiguration initialIncumbent;
    private final TargetAlgorithmEvaluator tae;
    private final ClassicInitializationProcedureOptions opts;
    private final Logger log = LoggerFactory.getLogger(ClassicInitializationProcedure.class);
    private final int maxIncumbentRuns;
    private final List<ProblemInstance> instances;
    private final InstanceSeedGenerator insc;
    private final ParamConfiguration incumbent;
    private final TerminationCondition termCond;
    private final double cutoffTime;
    private final SeedableRandomPool pool;
    private boolean deterministicInstanceOrdering;

    public ClassicInitializationProcedure(ThreadSafeRunHistory runHistory, ParamConfiguration initialIncumbent, TargetAlgorithmEvaluator tae, ClassicInitializationProcedureOptions opts, InstanceSeedGenerator insc, List<ProblemInstance> instances, int maxIncumbentRuns, TerminationCondition termCond, double cutoffTime, SeedableRandomPool pool, boolean deterministicInstanceOrdering) {
        this.runHistory = runHistory;
        this.initialIncumbent = initialIncumbent;
        this.tae = tae;
        this.opts = opts;
        this.instances = instances;
        this.maxIncumbentRuns = maxIncumbentRuns;
        this.insc = insc;
        this.incumbent = initialIncumbent;
        this.termCond = termCond;
        this.cutoffTime = cutoffTime;
        this.pool = pool;
        this.deterministicInstanceOrdering = deterministicInstanceOrdering;
    }

    @Override
    public void run() {
        this.log.info("Using Classic Initialization");
        ParamConfiguration incumbent = this.initialIncumbent;
        this.log.info("Configuration Set as Incumbent: {}", (Object)incumbent);
        int N = this.opts.initialIncumbentRuns;
        N = Math.min(N, this.instances.size());
        N = Math.min(N, this.maxIncumbentRuns);
        this.log.debug("Scheduling default configuration for {} runs", (Object)N);
        for (int i = 0; i < N; ++i) {
            ProblemInstanceSeedPair pisp = RunHistoryHelper.getRandomInstanceSeedWithFewestRunsFor(this.runHistory, this.insc, incumbent, this.instances, this.pool.getRandom("CLASSIC_INITIALIZATION"), this.deterministicInstanceOrdering);
            this.log.trace("New Problem Instance Seed Pair generated {}", (Object)pisp);
            RunConfig incumbentRunConfig = new RunConfig(pisp, this.cutoffTime, incumbent);
            try {
                this.evaluateRun(incumbentRunConfig);
                continue;
            }
            catch (OutOfTimeException e) {
                this.log.warn("Ran out of time while evaluating the default configuration on the first run, this is most likely a configuration error");
                throw new IllegalStateException("Out of time on the first run");
            }
        }
    }

    @Override
    public ParamConfiguration getIncumbent() {
        return this.incumbent;
    }

    protected List<AlgorithmRun> evaluateRun(RunConfig runConfig) {
        return this.evaluateRun(Collections.singletonList(runConfig));
    }

    protected List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        if (this.termCond.haveToStop()) {
            throw new OutOfTimeException();
        }
        this.log.info("Initialization: Scheduling {} run(s):", (Object)runConfigs.size());
        for (RunConfig rc : runConfigs) {
            Object[] args = new Object[]{this.runHistory.getThetaIdx(rc.getParamConfiguration()) != -1 ? " " + this.runHistory.getThetaIdx(rc.getParamConfiguration()) : "", rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime()};
            this.log.info("Initialization: Scheduling run for config{} ({}) on instance {} with seed {} and captime {}", args);
        }
        List<AlgorithmRun> completedRuns = this.tae.evaluateRun(runConfigs);
        for (AlgorithmRun run : completedRuns) {
            RunConfig rc = run.getRunConfig();
            Object[] args = new Object[]{this.runHistory.getThetaIdx(rc.getParamConfiguration()) != -1 ? " " + this.runHistory.getThetaIdx(rc.getParamConfiguration()) : "", rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime(), run.getResultLine(), run.getWallclockExecutionTime()};
            this.log.info("Initialization: Completed run for config{} ({}) on instance {} with seed {} and captime {} => Result: {}, wallclock time: {} seconds", args);
        }
        this.updateRunHistory(completedRuns);
        return completedRuns;
    }

    protected List<AlgorithmRun> updateRunHistory(List<AlgorithmRun> runs) {
        for (AlgorithmRun run : runs) {
            try {
                this.runHistory.append(run);
            }
            catch (DuplicateRunException e) {
                throw new IllegalStateException(e);
            }
        }
        return runs;
    }
}

