/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.eventsystem.handlers;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;

public class ParamConfigurationIncumbentChangerOriginTracker
implements EventHandler<IncumbentPerformanceChangeEvent> {
    private final ParamConfigurationOriginTracker configTracker;
    private final ThreadSafeRunHistory runHistory;
    private double cutoffTime;
    ParamConfiguration lastIncumbent;

    public ParamConfigurationIncumbentChangerOriginTracker(ParamConfigurationOriginTracker configTracker, ThreadSafeRunHistory runHistory, double cutoffTime) {
        this.configTracker = configTracker;
        this.runHistory = runHistory;
        this.cutoffTime = cutoffTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleEvent(IncumbentPerformanceChangeEvent event) {
        if (event.incumbentChanged()) {
            this.configTracker.addConfiguration(event.getIncumbent(), "Incumbent", "Performance=" + event.getEmpiricalPerformance(), "Runs=" + event.getIncumbentRunCount());
            if (this.lastIncumbent != null) {
                this.runHistory.readLock();
                try {
                    this.configTracker.addConfiguration(this.lastIncumbent, "Displaced Incumbent", "Performance=" + this.runHistory.getEmpiricalCost(this.lastIncumbent, this.runHistory.getInstancesRan(this.lastIncumbent), this.cutoffTime), "Runs=" + this.runHistory.getTotalNumRunsOfConfig(this.lastIncumbent));
                }
                finally {
                    this.runHistory.releaseReadLock();
                }
            }
            this.lastIncumbent = event.getIncumbent();
        }
    }
}

