/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.configspace.tracking;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.tracking.ParamConfigurationOriginTracker;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RealParamConfigurationOriginTracker
implements ParamConfigurationOriginTracker {
    private final ConcurrentHashMap<ParamConfiguration, ConcurrentHashMap<String, String>> originTracker = new ConcurrentHashMap();
    private final ConcurrentHashMap<ParamConfiguration, Long> firstGenerated = new ConcurrentHashMap();
    private final ConcurrentHashMap<ParamConfiguration, AtomicInteger> generationCount = new ConcurrentHashMap();
    private final LinkedBlockingQueue<ParamConfiguration> insertionOrderTracker = new LinkedBlockingQueue();
    private final Set<String> originNames = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentHashMap<ParamConfiguration, Object> originConfigs = new ConcurrentHashMap();
    private final Object dummyObject = new Object();

    @Override
    public void addConfiguration(ParamConfiguration config, String origin, String ... addlData) {
        this.originTracker.putIfAbsent(config, new ConcurrentHashMap());
        StringBuilder sb = new StringBuilder("");
        this.generationCount.putIfAbsent(config, new AtomicInteger(0));
        this.generationCount.get(config).incrementAndGet();
        for (String addlDatum : addlData) {
            sb.append(addlDatum).append("; ");
        }
        this.originTracker.get(config).put(origin, sb.toString());
        this.firstGenerated.putIfAbsent(config, System.currentTimeMillis());
        Object alreadyExisted = this.originConfigs.putIfAbsent(config, this.dummyObject);
        if (alreadyExisted == null) {
            this.insertionOrderTracker.add(config);
        }
        this.originNames.add(origin);
    }

    @Override
    public Map<String, String> getOrigins(ParamConfiguration config) {
        return this.originTracker.get(config);
    }

    @Override
    public Long getCreationTime(ParamConfiguration config) {
        return this.firstGenerated.get(config);
    }

    @Override
    public Set<String> getOriginNames() {
        return Collections.unmodifiableSet(this.originNames);
    }

    @Override
    public Iterator<ParamConfiguration> iterator() {
        return this.insertionOrderTracker.iterator();
    }

    @Override
    public int size() {
        return this.originTracker.size();
    }

    @Override
    public int getGenerationCount(ParamConfiguration config) {
        AtomicInteger genCount = this.generationCount.get(config);
        if (genCount == null) {
            return 0;
        }
        return genCount.get();
    }
}

