/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrunner;

import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.ConcurrentAlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.SingleThreadedAlgorithmRunner;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomaticConfiguratorFactory {
    private static int maxThreads = Runtime.getRuntime().availableProcessors();
    private static Logger log = LoggerFactory.getLogger(AutomaticConfiguratorFactory.class);

    public static AlgorithmRunner getSingleThreadedAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs, CommandLineTargetAlgorithmEvaluatorOptions options, BlockingQueue<Integer> executionIDs) {
        return new SingleThreadedAlgorithmRunner(execConfig, runConfigs, obs, options, executionIDs);
    }

    public static AlgorithmRunner getConcurrentAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs, CommandLineTargetAlgorithmEvaluatorOptions options, BlockingQueue<Integer> executionIDs) {
        if (runConfigs.size() == 1) {
            return AutomaticConfiguratorFactory.getSingleThreadedAlgorithmRunner(execConfig, runConfigs, obs, options, executionIDs);
        }
        if (options.cores > maxThreads) {
            log.warn("Number of cores requested is seemingly greater than the number of available cores. This may affect runtime measurements");
        }
        return AutomaticConfiguratorFactory.getConcurrentAlgorithmRunner(execConfig, runConfigs, options.cores, obs, options, executionIDs);
    }

    public static AlgorithmRunner getConcurrentAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs, int nThreads, TargetAlgorithmEvaluatorRunObserver obs, CommandLineTargetAlgorithmEvaluatorOptions options, BlockingQueue<Integer> executionIDs) {
        log.debug("Concurrent Algorithm Runner created allowing {} threads", (Object)nThreads);
        return new ConcurrentAlgorithmRunner(execConfig, runConfigs, nThreads, obs, options, executionIDs);
    }
}

