/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrun;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.exceptions.IllegalWrapperOutputException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.watch.StopWatch;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;

public abstract class AbstractAlgorithmRun
implements Runnable,
AlgorithmRun {
    private static final long serialVersionUID = -1860615761848618478L;
    protected final RunConfig runConfig;
    protected final AlgorithmExecutionConfig execConfig;
    private RunResult acResult;
    private double runtime;
    private double runLength;
    private double quality;
    private long resultSeed;
    private String rawResultLine;
    private boolean resultSet = false;
    private boolean runResultWellFormed = false;
    private double wallClockTime = 0.0;
    private StopWatch wallClockTimer = new StopWatch();
    private String additionalRunData = "";

    protected synchronized void setResult(RunResult acResult, double runtime, double runLength, double quality, long resultSeed, String rawResultLine, String additionalRunData) {
        this.setResult(acResult, runtime, runLength, quality, resultSeed, rawResultLine, true, additionalRunData);
    }

    protected void setAbortResult(String rawResultLine) {
        this.setResult(RunResult.ABORT, this.runConfig.getCutoffTime(), 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, "");
    }

    protected void setCrashResult(String rawResultLine) {
        this.setResult(RunResult.CRASHED, this.runConfig.getCutoffTime(), 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, rawResultLine);
    }

    protected void startWallclockTimer() {
        this.wallClockTimer.start();
    }

    protected void stopWallclockTimer() {
        this.wallClockTime = (double)this.wallClockTimer.stop() / 1000.0;
    }

    protected long getCurrentWallClockTime() {
        return this.wallClockTimer.time();
    }

    protected synchronized void setResult(RunResult acResult, double runtime, double runLength, double quality, long resultSeed, String rawResultLine, boolean runResultWellFormed, String additionalRunData) {
        if (Double.isNaN(runtime) || runtime < 0.0) {
            throw new IllegalWrapperOutputException("Runtime is NaN or negative", rawResultLine);
        }
        if (Double.isNaN(runLength) || runLength < 0.0 && runLength != -1.0) {
            throw new IllegalWrapperOutputException("RunLength (" + runLength + ") is NaN or negative (and not -1)", rawResultLine);
        }
        if (Double.isNaN(quality)) {
            throw new IllegalWrapperOutputException("Quality needs to be a number", rawResultLine);
        }
        if (acResult == null) {
            throw new IllegalStateException("Run Result cannot be null");
        }
        this.acResult = acResult;
        this.runtime = Math.min(runtime, Double.MAX_VALUE);
        this.runLength = Math.min(runLength, Double.MAX_VALUE);
        this.quality = quality;
        this.resultSeed = resultSeed;
        if (this.saveRawResultLine()) {
            this.rawResultLine = rawResultLine;
        }
        this.runResultWellFormed = runResultWellFormed;
        this.additionalRunData = additionalRunData;
        if (this.additionalRunData == null) {
            throw new IllegalArgumentException("Additional Run Data cannot be NULL");
        }
        this.resultSet = true;
        if (!(this instanceof KillableAlgorithmRun) && this.acResult.equals((Object)RunResult.RUNNING)) {
            throw new IllegalStateException("Only " + KillableAlgorithmRun.class.getSimpleName() + " may be set as " + (Object)((Object)RunResult.RUNNING));
        }
    }

    public AbstractAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig) {
        if (execConfig == null || runConfig == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.runConfig = runConfig;
        this.execConfig = execConfig;
    }

    @Override
    public abstract void run();

    @Override
    public final Object call() {
        this.run();
        return null;
    }

    @Override
    public final AlgorithmExecutionConfig getExecutionConfig() {
        return this.execConfig;
    }

    @Override
    public final RunConfig getRunConfig() {
        return this.runConfig;
    }

    @Override
    public final RunResult getRunResult() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.acResult;
    }

    @Override
    public final double getRuntime() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.runtime;
    }

    @Override
    public final double getRunLength() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.runLength;
    }

    @Override
    public final double getQuality() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.quality;
    }

    @Override
    public final long getResultSeed() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this.resultSeed;
    }

    private final String _getResultLine() {
        return AbstractAlgorithmRun.getResultLine(this);
    }

    public static final String getResultLine(AlgorithmRun run) {
        String resultLine = run.getRunResult().name() + ", " + run.getRuntime() + ", " + run.getRunLength() + ", " + run.getQuality() + ", " + run.getResultSeed();
        if (run.getAdditionalRunData().trim().length() > 0) {
            resultLine = resultLine + "," + run.getAdditionalRunData();
        }
        return resultLine;
    }

    @Override
    public final String getResultLine() {
        if (!this.isRunResultWellFormed()) {
            throw new IllegalStateException("Execution Result was not well formed");
        }
        return this._getResultLine();
    }

    @Override
    public final synchronized boolean isRunCompleted() {
        if (this.acResult == null) {
            return false;
        }
        return !this.acResult.equals((Object)RunResult.RUNNING);
    }

    @Override
    public final synchronized boolean isRunResultWellFormed() {
        if (!this.isResultSet()) {
            throw new IllegalStateException("Run has not yet completed: " + this.toString());
        }
        return this.runResultWellFormed;
    }

    @Override
    public final String rawResultLine() {
        if (!this.isResultSet()) {
            throw new IllegalStateException("Run has not yet completed: " + this.toString());
        }
        if (this.saveRawResultLine()) {
            return this.rawResultLine;
        }
        return "[Raw Result Line Not Saved]";
    }

    public final int hashCode() {
        return this.runConfig.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof AlgorithmRun) {
            AlgorithmRun aro = (AlgorithmRun)o;
            return aro.getExecutionConfig().equals(this.execConfig) && aro.getRunConfig().equals(this.runConfig);
        }
        return false;
    }

    public String toString() {
        return AbstractAlgorithmRun.toString(this);
    }

    public static String toString(AlgorithmRun run) {
        return run.getRunConfig().toString() + " ==> <" + run.getResultLine() + "> W:(" + run.getWallclockExecutionTime() + ")";
    }

    protected void setWallclockExecutionTime(double time) {
        if (time < 0.0) {
            throw new IllegalArgumentException("Time must be positive");
        }
        this.wallClockTime = time;
    }

    @Override
    public double getWallclockExecutionTime() {
        return this.wallClockTime;
    }

    @Override
    public String getAdditionalRunData() {
        return this.additionalRunData;
    }

    protected boolean isResultSet() {
        return this.resultSet;
    }

    private boolean saveRawResultLine() {
        return false;
    }
}

