/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.acquisitionfunctions;

import ca.ubc.cs.beta.aclib.acquisitionfunctions.AcquisitionFunction;
import ca.ubc.cs.beta.aclib.acquisitionfunctions.ExpectedExponentialImprovement;
import ca.ubc.cs.beta.aclib.acquisitionfunctions.ExpectedImprovement;
import ca.ubc.cs.beta.aclib.acquisitionfunctions.LCBEIRoundRobin;
import ca.ubc.cs.beta.aclib.acquisitionfunctions.LowerConfidenceBound;
import ca.ubc.cs.beta.aclib.acquisitionfunctions.SimpleAcquisitionFunction;

public enum AcquisitionFunctions implements AcquisitionFunction
{
    EXPONENTIAL(ExpectedExponentialImprovement.class),
    SIMPLE(SimpleAcquisitionFunction.class),
    LCB(LowerConfidenceBound.class),
    EI(ExpectedImprovement.class),
    LCBEIRR(LCBEIRoundRobin.class);

    private AcquisitionFunction internal;

    private AcquisitionFunctions(Class<? extends AcquisitionFunction> c) {
        if (c == null) {
            throw new IllegalArgumentException("This Expected Improvement Function is not implemented at the moment: " + this.toString());
        }
        Class[] args = new Class[]{};
        try {
            this.internal = c.getConstructor(args).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Expected improvement function doesn't have the correct constructor");
        }
    }

    private AcquisitionFunctions() {
        this.internal = null;
    }

    public AcquisitionFunction getFunction() {
        return this.internal;
    }

    @Override
    public double[] computeAcquisitionFunctionValue(double f_min_samples, double[] predmean, double[] predvar) {
        return this.internal.computeAcquisitionFunctionValue(f_min_samples, predmean, predvar);
    }
}

