/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.statistics.distribution;

import net.sf.doodleproject.numerics4j.exception.NumericException;
import net.sf.doodleproject.numerics4j.statistics.distribution.Distribution;

public abstract class DiscreteDistribution
implements Distribution {
    public abstract double cumulativeProbability(int var1) throws NumericException;

    protected double simpleCumulativeProbability(int x0, int x1) throws NumericException {
        double p = 0.0;
        for (int x = x0; x <= x1; ++x) {
            p += this.probability(x);
        }
        return p;
    }

    protected int findInverseCumulativeProbability(double p, int lower, int initial, int upper) throws NumericException {
        int x = initial;
        double p0 = this.cumulativeProbability(x);
        while (p0 <= p && x < upper) {
            p0 = this.cumulativeProbability(++x);
        }
        while (p0 > p && x >= lower) {
            p0 = this.cumulativeProbability(--x);
        }
        return x;
    }

    public abstract int inverseCumulativeProbability(double var1) throws NumericException;

    public abstract double probability(int var1) throws NumericException;
}

