/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.sf.doodleproject.numerics4j.random.RNG;
import net.sf.doodleproject.numerics4j.random.RandomRNG;

public class WeibullRandomVariable
extends AbstractContinuousRandomVariable {
    private double location;
    private double scale;
    private double shape;

    public WeibullRandomVariable() {
        this(1.0, 1.0, 0.0);
    }

    public WeibullRandomVariable(double a, double b) {
        this(a, b, 0.0, new RandomRNG());
    }

    public WeibullRandomVariable(double a, double b, double c) {
        this(a, b, c, new RandomRNG());
    }

    public WeibullRandomVariable(double a, double b, double c, RNG source) {
        super(source);
        this.setShape(a);
        this.setScale(b);
        this.setLocation(c);
    }

    public WeibullRandomVariable(double a, double b, RNG source) {
        this(a, b, 0.0, source);
    }

    public static double nextRandomVariable(double shape, double scale, double location, RNG source) {
        double u;
        while ((u = source.nextRandomNumber()) <= 0.0) {
        }
        return Math.pow(-Math.log(u), 1.0 / shape) * scale + location;
    }

    private double getLocation() {
        return this.location;
    }

    private double getScale() {
        return this.scale;
    }

    private double getShape() {
        return this.shape;
    }

    public double nextRandomVariable() {
        return WeibullRandomVariable.nextRandomVariable(this.getShape(), this.getScale(), this.getLocation(), this.getSource());
    }

    private void setLocation(double l) {
        if (Double.isNaN(l)) {
            throw new IllegalArgumentException("location parameter must be a number.");
        }
        this.location = l;
    }

    private void setScale(double b) {
        if (b <= 0.0 || Double.isNaN(b)) {
            throw new IllegalArgumentException("scale must be positive.");
        }
        this.scale = b;
    }

    private void setShape(double a) {
        if (a <= 0.0 || Double.isNaN(a)) {
            throw new IllegalArgumentException("shape must be positive.");
        }
        this.shape = a;
    }
}

