/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.AbstractDiscreteRandomVariable;
import net.sf.doodleproject.numerics4j.random.GammaRandomVariable;
import net.sf.doodleproject.numerics4j.random.PoissonRandomVariable;
import net.sf.doodleproject.numerics4j.random.RNG;
import net.sf.doodleproject.numerics4j.random.RandomRNG;

public class NegativeBinomialRandomVariable
extends AbstractDiscreteRandomVariable {
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public NegativeBinomialRandomVariable() {
        this(1, 0.5);
    }

    public NegativeBinomialRandomVariable(int r, double p) {
        this(r, p, new RandomRNG());
    }

    public NegativeBinomialRandomVariable(int r, double p, RNG source) {
        super(source);
        this.setNumberOfSuccesses(r);
        this.setProbabilityOfSuccess(p);
    }

    public static int nextRandomVariable(int r, double p, RNG source) {
        double y = GammaRandomVariable.nextRandomVariable(r, (1.0 - p) / p, source);
        return PoissonRandomVariable.nextRandomVariable(y, source);
    }

    private int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    private double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public int nextRandomVariable() {
        return NegativeBinomialRandomVariable.nextRandomVariable(this.getNumberOfSuccesses(), this.getProbabilityOfSuccess(), this.getSource());
    }

    private void setNumberOfSuccesses(int r) {
        if (r <= 0) {
            throw new IllegalArgumentException("number of successes must be positive.");
        }
        this.numberOfSuccesses = r;
    }

    private void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

