/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.RNG;

public class LinearCongruentialRNG
implements RNG {
    private long modulus;
    private long multiplier;
    private long seed;
    private long shift;

    public LinearCongruentialRNG(long m, long a) {
        this(m, a, 0L);
    }

    public LinearCongruentialRNG(long m, long a, long c) {
        this(m, a, c, System.currentTimeMillis());
    }

    public LinearCongruentialRNG(long m, long a, long c, long s) {
        this.setModulus(m);
        this.setMultiplier(a);
        this.setShift(c);
        this.setSeed(s);
    }

    private long getModulus() {
        return this.modulus;
    }

    private long getMultiplier() {
        return this.multiplier;
    }

    private long getSeed() {
        return this.seed;
    }

    private long getShift() {
        return this.shift;
    }

    public double nextRandomNumber() {
        long r;
        long m = this.getModulus();
        this.seed = r = (this.getMultiplier() * this.getSeed() + this.getShift()) % m;
        return (double)r / (double)m;
    }

    private void setModulus(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("modulus must be positive.");
        }
        this.modulus = value;
    }

    private void setMultiplier(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("multiplier must be positive.");
        }
        this.multiplier = value;
    }

    private void setSeed(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("seed must be positive.");
        }
        this.seed = value;
    }

    private void setShift(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("shift must be non-negative.");
        }
        this.shift = value;
    }
}

