/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.AbstractDiscreteRandomVariable;
import net.sf.doodleproject.numerics4j.random.RNG;
import net.sf.doodleproject.numerics4j.random.RandomRNG;

public class BernoulliRandomVariable
extends AbstractDiscreteRandomVariable {
    private double probabilityOfSuccess;

    public BernoulliRandomVariable() {
        this(0.5);
    }

    public BernoulliRandomVariable(double p) {
        this(p, new RandomRNG());
    }

    public BernoulliRandomVariable(double p, RNG source) {
        super(source);
        this.setProbabilityOfSuccess(p);
    }

    public static int nextRandomVariable(double p, RNG source) {
        return p <= source.nextRandomNumber() ? 1 : 0;
    }

    private double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public int nextRandomVariable() {
        return BernoulliRandomVariable.nextRandomVariable(this.getProbabilityOfSuccess(), this.getSource());
    }

    private void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

