/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf.utils;

public class Gaussian {
    public static double phi(double x) {
        return Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double phi(double x, double mu, double sigma) {
        return Gaussian.phi((x - mu) / sigma) / sigma;
    }

    public static double Phi(double z) {
        if (z < -8.0) {
            return 0.0;
        }
        if (z > 8.0) {
            return 1.0;
        }
        double sum = 0.0;
        double term = z;
        int i = 3;
        while (sum + term != sum) {
            sum += term;
            term = term * z * z / (double)i;
            i += 2;
        }
        return 0.5 + sum * Gaussian.phi(z);
    }

    public static double Phi(double z, double mu, double sigma) {
        return Gaussian.Phi((z - mu) / sigma);
    }

    public static double PhiInverse(double y) {
        return Gaussian.PhiInverse(y, 1.0E-8, -8.0, 8.0);
    }

    private static double PhiInverse(double y, double delta, double lo, double hi) {
        double mid = lo + (hi - lo) / 2.0;
        if (hi - lo < delta) {
            return mid;
        }
        if (Gaussian.Phi(mid) > y) {
            return Gaussian.PhiInverse(y, delta, lo, mid);
        }
        return Gaussian.PhiInverse(y, delta, mid, hi);
    }

    public static double errorFunctionInverse(double z) {
        return Gaussian.PhiInverse(0.5 * z + 0.5) / Math.sqrt(2.0);
    }
}

