/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.configurator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.configspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aclib.eventsystem.EventManager;
import ca.ubc.cs.beta.aclib.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.AutomaticConfigurationEnd;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.state.StateRestoredEvent;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.exceptions.OutOfTimeException;
import ca.ubc.cs.beta.aclib.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aclib.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.random.RandomUtil;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.runhistory.RunHistoryHelper;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistoryWrapper;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.smac.SMACOptions;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.state.StateSerializer;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.termination.CompositeTerminationCondition;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.termination.standard.ConfigurationSpaceExhaustedCondition;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import com.beust.jcommander.ParameterException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAlgorithmFramework {
    protected ThreadSafeRunHistory runHistory;
    protected final long applicationStartTime = System.currentTimeMillis();
    protected final ParamConfigurationSpace configSpace;
    protected final double cutoffTime;
    protected final List<ProblemInstance> instances;
    protected final TargetAlgorithmEvaluator tae;
    protected final SMACOptions options;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StateFactory stateFactory;
    private int iteration = 0;
    protected ParamConfiguration incumbent = null;
    private final int MAX_RUNS_FOR_INCUMBENT;
    private final List<TrajectoryFileEntry> tfes = new ArrayList<TrajectoryFileEntry>();
    protected InstanceSeedGenerator instanceSeedGen;
    private final ParamConfiguration initialIncumbent;
    private final EventManager evtManager;
    protected SeedableRandomPool pool;
    private final CompositeTerminationCondition termCond;
    protected final ParamConfigurationOriginTracker configTracker;
    private final InitializationProcedure initProc;
    private final AtomicBoolean shouldWriteStateOnCrash = new AtomicBoolean(false);
    private static final String OBJECT_MAP_POOL_KEY = "POOL";
    private static final String OBJECT_MAP_INSTANCE_SEED_GEN_KEY = "INSTANCE_SEED_GEN";
    boolean outOfTime = false;
    double timedOutRunCost;
    private int selectionCount = 0;
    private static double currentIncumbentCost;
    private static final double BEST_POSSIBLE_VALUE = 0.0;
    private static final double UNCOMPETITIVE_CAPTIME = 0.0;

    public AbstractAlgorithmFramework(SMACOptions smacOptions, List<ProblemInstance> instances, TargetAlgorithmEvaluator algoEval, StateFactory stateFactory, ParamConfigurationSpace configSpace, InstanceSeedGenerator instanceSeedGen, ParamConfiguration initialIncumbent, EventManager manager, ThreadSafeRunHistory rh, SeedableRandomPool pool, CompositeTerminationCondition termCond, ParamConfigurationOriginTracker originTracker, InitializationProcedure initProc) {
        this.instances = instances;
        this.cutoffTime = smacOptions.scenarioConfig.algoExecOptions.cutoffTime;
        this.options = smacOptions;
        this.tae = algoEval;
        this.stateFactory = stateFactory;
        this.configSpace = configSpace;
        this.runHistory = rh;
        this.instanceSeedGen = instanceSeedGen;
        this.initialIncumbent = initialIncumbent;
        this.evtManager = manager;
        this.pool = pool;
        this.termCond = termCond;
        if (initialIncumbent.isForbiddenParamConfiguration()) {
            throw new ParameterException("Initial Incumbent specified is forbidden: " + this.initialIncumbent.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
        }
        long time = System.currentTimeMillis();
        Date d = new Date(time);
        DateFormat df = DateFormat.getDateTimeInstance();
        this.log.info("Automatic Configuration Start Time is {}", (Object)df.format(d));
        if (instanceSeedGen.getInitialInstanceSeedCount() < this.options.maxIncumbentRuns) {
            this.log.info("Clamping number of runs to {} due to lack of instance/seeds pairs", (Object)instanceSeedGen.getInitialInstanceSeedCount());
            this.MAX_RUNS_FOR_INCUMBENT = instanceSeedGen.getInitialInstanceSeedCount();
        } else {
            this.MAX_RUNS_FOR_INCUMBENT = smacOptions.maxIncumbentRuns;
            this.log.info("Maximimum Number of Runs for the Incumbent Initialized to {}", (Object)this.MAX_RUNS_FOR_INCUMBENT);
        }
        ConfigurationSpaceExhaustedCondition cond = new ConfigurationSpaceExhaustedCondition(configSpace, this.MAX_RUNS_FOR_INCUMBENT);
        cond.registerWithEventManager(this.evtManager);
        termCond.addCondition((TerminationCondition)cond);
        this.configTracker = originTracker;
        this.initProc = initProc;
        if (this.options.saveRunsEveryIteration && this.options.scenarioConfig.algoExecOptions.cutoffTime <= 600.0) {
            this.log.warn("Saving runs every iteration is discouraged for small cap times and may cause a significant amount of overhead due to file I/O.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (AbstractAlgorithmFramework.this.shouldWriteStateOnCrash.get()) {
                    AbstractAlgorithmFramework.this.log.info("Making best attempt to save state. This state may be dirty, in that it was taken in the middle of an iteration and consequently may not be restorable. It may also be corrupt depending on the exact reason we are shutting down.");
                    AbstractAlgorithmFramework.this.saveState("SHUTDOWN", true);
                } else {
                    AbstractAlgorithmFramework.this.log.debug("State Saved Already, Skipping Shutdown Version");
                }
            }
        }));
    }

    public ParamConfiguration getInitialIncumbent() {
        return this.initialIncumbent;
    }

    public ParamConfiguration getIncumbent() {
        return this.incumbent;
    }

    public void restoreState(StateDeserializer sd) {
        try {
            this.log.info("Restoring State");
            int myIteration = sd.getIteration();
            if (myIteration >= 0) {
                this.iteration = myIteration;
            } else {
                this.log.info("No iteration info found it state file, staying at iteration 0");
            }
            this.runHistory = new ThreadSafeRunHistoryWrapper(sd.getRunHistory());
            Map map = sd.getObjectStateMap();
            if (map.get(OBJECT_MAP_POOL_KEY) != null) {
                this.pool = (SeedableRandomPool)map.get(OBJECT_MAP_POOL_KEY);
            } else {
                this.log.info("Incomplete state detected using existing Random Pool object");
            }
            if (map.get(OBJECT_MAP_INSTANCE_SEED_GEN_KEY) != null) {
                this.instanceSeedGen = (InstanceSeedGenerator)map.get(OBJECT_MAP_INSTANCE_SEED_GEN_KEY);
            } else {
                this.log.info("Incomplete state detected using existing instance seed generator");
            }
            if (this.pool == null) {
                throw new IllegalStateException("The pool we restored was null, this state file cannot be restored in SMAC");
            }
            if (this.instanceSeedGen == null) {
                throw new IllegalStateException("The instance seed generator we restored was null, this state file cannot be restored in SMAC");
            }
            this.incumbent = sd.getIncumbent();
            if (this.incumbent == null) {
                this.incumbent = this.initialIncumbent;
            }
            HashSet<ProblemInstanceSeedPair> allPisps = new HashSet<ProblemInstanceSeedPair>();
            for (AlgorithmRun run : this.runHistory.getAlgorithmRuns()) {
                ProblemInstanceSeedPair pisp = run.getRunConfig().getProblemInstanceSeedPair();
                allPisps.add(run.getRunConfig().getProblemInstanceSeedPair());
                this.log.debug("Blacklisting problem instance seed pair: {} ", (Object)pisp);
                this.instanceSeedGen.take(pisp.getInstance(), pisp.getSeed());
            }
            if (this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent).size() != allPisps.size()) {
                throw new ParameterException("Incumbent has been run on " + this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent).size() + " problem instance seed pair(s), but there have been a total of " + allPisps.size() + " run. This generally means the state data used to restore SMAC needs to be repaired to preserve this invariant. Please run the state data through the state-merge utility to repair this invariant");
            }
            this.log.info("Incumbent Set To {}", (Object)this.incumbent);
            this.tae.seek(this.runHistory.getAlgorithmRuns());
            for (AlgorithmRun run : this.runHistory.getAlgorithmRuns()) {
                this.termCond.notifyRun(run);
            }
            this.fireEvent((AutomaticConfiguratorEvent)new StateRestoredEvent((TerminationCondition)this.termCond, this.iteration, this.runHistory, this.incumbent));
            this.log.info("Restored to Iteration {}", (Object)this.iteration);
        }
        catch (RuntimeException e) {
            this.tae.notifyShutdown();
            throw e;
        }
    }

    protected boolean shouldSave() {
        return true;
    }

    private void saveState() {
        this.saveState("it", (this.iteration - 1 & this.iteration) == 0 || this.options.saveRunsEveryIteration);
    }

    private synchronized void saveState(String id, boolean saveFullState) {
        StateSerializer state = this.stateFactory.getStateSerializer(id, this.iteration);
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put(OBJECT_MAP_POOL_KEY, this.pool);
        objMap.put(OBJECT_MAP_INSTANCE_SEED_GEN_KEY, this.instanceSeedGen);
        state.setObjectStateMap(objMap);
        if (saveFullState) {
            state.setRunHistory((RunHistory)this.runHistory);
        }
        state.setIncumbent(this.incumbent);
        state.save();
    }

    protected boolean have_to_stop(int iteration) {
        this.outOfTime = true;
        this.outOfTime = this.termCond.haveToStop();
        return this.outOfTime;
    }

    public void logIncumbent() {
        this.logIncumbent(-1);
    }

    public void logIncumbent(int iteration) {
        if (iteration > 0) {
            Object[] arr = new Object[]{iteration, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
            this.log.info("At end of iteration {}, incumbent is {} ({}) ", arr);
        } else {
            this.log.info("Incumbent currently is: {} ({}) ", (Object)this.runHistory.getThetaIdx(this.incumbent), (Object)this.incumbent);
        }
    }

    public int getIteration() {
        return this.iteration;
    }

    private void fireEvent(AutomaticConfiguratorEvent evt) {
        this.evtManager.fireEvent(evt);
        this.evtManager.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                if (this.pool == null) {
                    throw new IllegalStateException("pool is null, this was unexpected");
                }
                if (this.iteration == 0) {
                    this.incumbent = this.initialIncumbent;
                    this.log.info("Initial Incumbent set as Incumbent: {}", (Object)this.incumbent);
                    this.iteration = 0;
                    this.log.debug("Initialization Procedure Started");
                    this.initProc.run();
                    this.log.debug("Initialization Procedure Completed");
                    this.incumbent = this.initProc.getIncumbent();
                    this.logConfiguration("New Incumbent", this.incumbent);
                    this.updateIncumbentCost();
                    this.logIncumbent(this.iteration);
                }
                this.fireEvent((AutomaticConfiguratorEvent)new IncumbentPerformanceChangeEvent((TerminationCondition)this.termCond, currentIncumbentCost, this.incumbent, (long)this.runHistory.getTotalNumRunsOfConfig(this.incumbent), this.initialIncumbent));
                try {
                    while (!this.have_to_stop(this.iteration + 1)) {
                        this.shouldWriteStateOnCrash.set(true);
                        if (this.shouldSave()) {
                            this.saveState();
                        }
                        this.runHistory.incrementIteration();
                        ++this.iteration;
                        this.log.info("Starting Iteration {}", (Object)this.iteration);
                        this.fireEvent((AutomaticConfiguratorEvent)new ModelBuildStartEvent((TerminationCondition)this.termCond));
                        AutoStartStopWatch t = new AutoStartStopWatch();
                        this.learnModel((RunHistory)this.runHistory, this.configSpace);
                        this.log.info("Model Learn Time: {} (s)", (Object)((double)t.time() / 1000.0));
                        this.fireEvent((AutomaticConfiguratorEvent)new ModelBuildEndEvent((TerminationCondition)this.termCond, this.getModel()));
                        ArrayList<ParamConfiguration> challengers = new ArrayList<ParamConfiguration>();
                        challengers.addAll(this.selectConfigurations());
                        double learnModelTime = (double)t.stop() / 1000.0;
                        double intensifyTime = Math.ceil(learnModelTime) * (this.options.intensificationPercentage / (1.0 - this.options.intensificationPercentage));
                        this.intensify(challengers, intensifyTime);
                        this.logIncumbent(this.iteration);
                    }
                }
                catch (OutOfTimeException e) {
                    this.logIncumbent(this.iteration);
                }
                this.saveState("it", true);
                this.shouldWriteStateOnCrash.set(false);
                this.log.info("SMAC Completed");
                if (this.options.stateOpts.cleanOldStatesOnSuccess) {
                    this.log.info("Cleaning old states");
                    this.stateFactory.purgePreviousStates();
                }
            }
            catch (RuntimeException e) {
                try {
                    this.saveState("CRASH", true);
                    this.shouldWriteStateOnCrash.set(false);
                }
                catch (RuntimeException e2) {
                    this.log.error("SMAC has encountered an exception, and encountered another exception while trying to save the local state. NOTE: THIS PARTICULAR ERROR DID NOT CAUSE SMAC TO FAIL, the original culprit follows further below. (This second error is potentially another / seperate issue, or a disk failure of some kind.) When submitting bug/error reports, please include enough context for *BOTH* exceptions \n  ", (Throwable)e2);
                    throw e;
                }
                throw e;
            }
        }
        finally {
            this.fireEvent((AutomaticConfiguratorEvent)new AutomaticConfigurationEnd((TerminationCondition)this.termCond, this.incumbent, currentIncumbentCost));
            this.tae.notifyShutdown();
        }
    }

    protected void learnModel(RunHistory runHistory, ParamConfigurationSpace configSpace) {
    }

    public void logIncumbentPerformance(SortedMap<TrajectoryFileEntry, Double> tfePerformance) {
        TrajectoryFileEntry tfe = null;
        double testSetPerformance = Double.POSITIVE_INFINITY;
        ParamConfiguration lastIncumbent = null;
        double lastEmpericalPerformance = Double.POSITIVE_INFINITY;
        double lastTestSetPerformance = Double.POSITIVE_INFINITY;
        for (Map.Entry<TrajectoryFileEntry, Double> ents : tfePerformance.entrySet()) {
            Object[] args2;
            tfe = ents.getKey();
            double empiricalPerformance = tfe.getEmpericalPerformance();
            testSetPerformance = ents.getValue();
            double tunerTime = tfe.getTunerTime();
            ParamConfiguration formerIncumbent = tfe.getConfiguration();
            if (formerIncumbent.equals(lastIncumbent) && empiricalPerformance == lastEmpericalPerformance && lastTestSetPerformance == testSetPerformance) continue;
            lastIncumbent = formerIncumbent;
            lastEmpericalPerformance = empiricalPerformance;
            lastTestSetPerformance = testSetPerformance;
            if (Double.isInfinite(testSetPerformance)) {
                args2 = new Object[]{this.runHistory.getThetaIdx(formerIncumbent), formerIncumbent, tunerTime, empiricalPerformance};
                this.log.info("Total Objective of Incumbent {} ({}) at time {} on training set: {}", args2);
                continue;
            }
            args2 = new Object[]{this.runHistory.getThetaIdx(formerIncumbent), formerIncumbent, tunerTime, empiricalPerformance, testSetPerformance};
            this.log.info("Total Objective of Incumbent {} ({}) at time {} on training set: {}; on test set: {}", args2);
        }
    }

    public void logSMACResult(SortedMap<TrajectoryFileEntry, Double> tfePerformance) {
        TrajectoryFileEntry tfe = null;
        double testSetPerformance = Double.POSITIVE_INFINITY;
        tfe = tfePerformance.lastKey();
        testSetPerformance = (Double)tfePerformance.get(tfe);
        if (tfe != null && !tfe.getConfiguration().equals((Object)this.incumbent)) {
            throw new IllegalStateException("Last TFE should be Incumbent");
        }
        ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent).iterator().next();
        RunConfig runConfig = new RunConfig(pisp, this.cutoffTime, this.incumbent);
        String cmd = this.tae.getManualCallString(runConfig);
        Object[] args = new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, cmd};
        this.log.info("**********************************************");
        if (Double.isInfinite(testSetPerformance)) {
            Object[] args2 = new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime)};
            this.log.info("Total Objective of Final Incumbent {} ({}) on training set: {}", args2);
        } else {
            Object[] args2 = new Object[]{this.runHistory.getThetaIdx(this.incumbent), this.incumbent, this.runHistory.getEmpiricalCost(this.incumbent, this.runHistory.getUniqueInstancesRan(), this.cutoffTime), testSetPerformance};
            this.log.info("Total Objective of Final Incumbent {} ({}) on training set: {}; on test set: {}", args2);
        }
        this.log.info("Sample Call for Final Incumbent {} ({}) \n{} ", args);
        this.log.info("Complete Configuration (no inactive conditionals):{}", (Object)this.incumbent.getFormattedParamString(ParamConfiguration.StringFormat.STATEFILE_SYNTAX_NO_INACTIVE));
        this.log.info("Complete Configuration (including inactive conditionals):{}", (Object)this.incumbent.getFormattedParamString(ParamConfiguration.StringFormat.STATEFILE_SYNTAX));
    }

    protected Object getModel() {
        return null;
    }

    protected List<ParamConfiguration> selectConfigurations() {
        ParamConfiguration config = this.configSpace.getRandomConfiguration(this.pool.getRandom("ROAR_RANDOM_CONFIG"));
        this.log.debug("Selecting a random configuration {}", (Object)config);
        this.configTracker.addConfiguration(config, "RANDOM", new String[]{"SelectionCount=" + this.selectionCount});
        return Collections.singletonList(config);
    }

    private void intensify(List<ParamConfiguration> challengers, double timeBound) {
        double initialTime = this.runHistory.getTotalRunCost();
        this.log.info("Calling intensify with {} challenger(s)", (Object)challengers.size());
        for (int i = 0; i < challengers.size(); ++i) {
            double timeUsed = this.runHistory.getTotalRunCost() - initialTime;
            if (timeUsed > timeBound && i > 1) {
                this.log.info("Out of time for intensification timeBound: {} (s); used: {}  (s)", (Object)timeBound, (Object)timeUsed);
                break;
            }
            this.log.info("Intensification timeBound: {} (s); used: {}  (s)", (Object)timeBound, (Object)timeUsed);
            this.challengeIncumbent(challengers.get(i));
        }
    }

    private void challengeIncumbent(ParamConfiguration challenger) {
        this.fireEvent((AutomaticConfiguratorEvent)new ChallengeStartEvent((TerminationCondition)this.termCond, challenger));
        this.challengeIncumbent(challenger, true);
    }

    private void challengeIncumbent(ParamConfiguration challenger, boolean runIncumbent) {
        if (runIncumbent) {
            if (this.runHistory.getTotalNumRunsOfConfig(this.incumbent) < this.MAX_RUNS_FOR_INCUMBENT) {
                this.log.debug("Performing additional run with the incumbent ");
                ProblemInstanceSeedPair pisp = RunHistoryHelper.getRandomInstanceSeedWithFewestRunsFor((ThreadSafeRunHistory)this.runHistory, (InstanceSeedGenerator)this.instanceSeedGen, (ParamConfiguration)this.incumbent, this.instances, (Random)this.pool.getRandom("CHALLENGE_INCUMBENT_INSTANCE_SELECTION"), (boolean)this.options.deterministicInstanceOrdering);
                RunConfig incumbentRunConfig = this.getRunConfig(pisp, this.cutoffTime, this.incumbent);
                this.evaluateRun(incumbentRunConfig);
                this.updateIncumbentCost();
                this.fireEvent((AutomaticConfiguratorEvent)new IncumbentPerformanceChangeEvent((TerminationCondition)this.termCond, currentIncumbentCost, this.incumbent, (long)this.runHistory.getTotalNumRunsOfConfig(this.incumbent), this.incumbent));
                if (this.options.alwaysRunInitialConfiguration && !this.incumbent.equals((Object)this.initialIncumbent)) {
                    Object[] args = new Object[]{this.runHistory.getThetaIdx(this.initialIncumbent), this.initialIncumbent, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
                    this.log.info("Trying challenge with initial configuration {} ({}) first (current incumbent {} ({})", args);
                    this.challengeIncumbent(this.initialIncumbent, false);
                    this.log.info("Challenge with initial configuration done");
                }
            } else {
                this.log.debug("Already have performed max runs ({}) for incumbent", (Object)this.MAX_RUNS_FOR_INCUMBENT);
            }
        }
        if (challenger.equals((Object)this.incumbent)) {
            Object[] args = new Object[]{this.runHistory.getThetaIdx(challenger), challenger, this.runHistory.getThetaIdx(this.incumbent), this.incumbent};
            this.log.info("Challenger {} ({}) is equal to the incumbent {} ({}); not evaluating it further ", args);
            return;
        }
        int N = this.options.initialChallengeRuns;
        while (true) {
            HashSet sMissing = new HashSet(this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent));
            sMissing.removeAll(this.runHistory.getAlgorithmInstanceSeedPairsRan(challenger));
            List<ProblemInstanceSeedPair> aMissing = new ArrayList();
            aMissing.addAll(sMissing);
            int runsToMake = Math.min(N, aMissing.size());
            if (runsToMake == 0) {
                this.log.info("Aborting challenge of incumbent. Incumbent has " + this.runHistory.getTotalNumRunsOfConfig(this.incumbent) + " runs, challenger has " + this.runHistory.getTotalNumRunsOfConfig(challenger) + " runs, and the maximum runs for any config is set to " + this.MAX_RUNS_FOR_INCUMBENT + ".");
                return;
            }
            Collections.sort(aMissing);
            int[] permutations = RandomUtil.getPermutation((int)aMissing.size(), (int)0, (Random)this.pool.getRandom("CHALLENGE_INCUMBENT_SHUFFLE"));
            RandomUtil.permuteList(aMissing, (int[])permutations);
            aMissing = aMissing.subList(0, runsToMake);
            if (this.log.isTraceEnabled()) {
                for (ProblemInstanceSeedPair pisp : aMissing) {
                    this.log.trace("Missing Problem Instance Seed Pair {}", (Object)pisp);
                }
            }
            this.log.trace("Permuting elements according to {}", (Object)Arrays.toString(permutations));
            double bound_inc = Double.POSITIVE_INFINITY;
            HashSet<ProblemInstance> missingInstances = null;
            HashSet<ProblemInstance> missingPlusCommon = null;
            if (this.options.adaptiveCapping.booleanValue()) {
                missingInstances = new HashSet<ProblemInstance>();
                for (int i = 0; i < runsToMake; ++i) {
                    missingInstances.add(((ProblemInstanceSeedPair)aMissing.get(i)).getInstance());
                }
                missingPlusCommon = new HashSet<ProblemInstance>();
                missingPlusCommon.addAll(missingInstances);
                Set piCommon = this.runHistory.getInstancesRan(this.incumbent);
                piCommon.retainAll(this.runHistory.getInstancesRan(challenger));
                missingPlusCommon.addAll(piCommon);
                bound_inc = this.runHistory.getEmpiricalCost(this.incumbent, missingPlusCommon, this.cutoffTime) + Math.pow(10.0, -3.0);
            }
            Object[] args2 = new Object[]{N, this.runHistory.getThetaIdx(challenger) != -1 ? " " + this.runHistory.getThetaIdx(challenger) : "", challenger, bound_inc};
            this.log.info("Performing up to {} run(s) for challenger{} ({}) up to a total bound of {} ", args2);
            ArrayList<RunConfig> runsToEval = new ArrayList<RunConfig>(this.options.scenarioConfig.algoExecOptions.taeOpts.maxConcurrentAlgoExecs);
            if (this.options.adaptiveCapping.booleanValue() && this.incumbentImpossibleToBeat(challenger, (ProblemInstanceSeedPair)aMissing.get(0), aMissing, missingPlusCommon, this.cutoffTime, bound_inc)) {
                this.log.info("Challenger cannot beat incumbent => scheduling empty run");
                runsToEval.add(this.getBoundedRunConfig(aMissing.get(0), 0.0, challenger));
                if (runsToMake != 1) {
                    throw new IllegalStateException("Error in empty run scheduling: empty runs should only be scheduled in first iteration of intensify.");
                }
            } else {
                for (int i = 0; i < runsToMake; ++i) {
                    RunConfig runConfig;
                    ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)aMissing.get(0);
                    if (this.options.adaptiveCapping.booleanValue()) {
                        double capTime = this.computeCap(challenger, pisp, aMissing, missingPlusCommon, this.cutoffTime, bound_inc);
                        if (capTime < this.cutoffTime) {
                            if (capTime <= 0.0) break;
                            runConfig = this.getBoundedRunConfig(pisp, capTime, challenger);
                        } else {
                            runConfig = this.getRunConfig(pisp, this.cutoffTime, challenger);
                        }
                    } else {
                        runConfig = this.getRunConfig(pisp, this.cutoffTime, challenger);
                    }
                    runsToEval.add(runConfig);
                    sMissing.remove(pisp);
                    aMissing.remove(0);
                    if (runsToEval.size() != this.options.scenarioConfig.algoExecOptions.taeOpts.maxConcurrentAlgoExecs) continue;
                    this.evaluateRun(runsToEval);
                    runsToEval.clear();
                }
            }
            if (runsToEval.size() > 0) {
                this.evaluateRun(runsToEval);
                runsToEval.clear();
            }
            Set piCommon = this.runHistory.getInstancesRan(this.incumbent);
            piCommon.retainAll(this.runHistory.getInstancesRan(challenger));
            double incCost = this.runHistory.getEmpiricalCost(this.incumbent, piCommon, this.cutoffTime);
            double chalCost = this.runHistory.getEmpiricalCost(challenger, piCommon, this.cutoffTime);
            Object[] args = new Object[]{piCommon.size(), this.runHistory.getUniqueInstancesRan().size(), this.runHistory.getThetaIdx(challenger), challenger.getFriendlyIDHex(), chalCost, this.runHistory.getThetaIdx(this.incumbent), this.incumbent, incCost};
            this.log.info("Based on {} common runs on (up to) {} instances, challenger {} ({})  has a lower bound {} and incumbent {} ({}) has obj {}", args);
            if (incCost + Math.pow(10.0, -6.0) < chalCost) {
                this.log.info("Challenger {} ({}) is worse; aborting its evaluation", (Object)this.runHistory.getThetaIdx(challenger), (Object)challenger);
                this.configTracker.addConfiguration(challenger, "Challenge-Round-" + this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(challenger), new String[]{"Continue=False", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
                break;
            }
            if (sMissing.isEmpty()) {
                if (chalCost < incCost - Math.pow(10.0, -6.0)) {
                    this.configTracker.addConfiguration(challenger, "Final-Challenge-Round", new String[]{"NewIncumbent=True", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
                    this.changeIncumbentTo(challenger);
                    break;
                }
                this.configTracker.addConfiguration(challenger, "Final-Challenge-Round", new String[]{"NewIncumbent=False", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost});
                this.log.info("Challenger {} ({}) has all the runs of the incumbent, but did not outperform it", (Object)this.runHistory.getThetaIdx(challenger), (Object)challenger);
                break;
            }
            this.configTracker.addConfiguration(challenger, "Challenge-Round-" + this.runHistory.getTotalNumRunsOfConfig(challenger), new String[]{"Continue=True", "IncumbentCost=" + incCost, "ChallengeCost=" + chalCost, "RunsNeededLeft=" + (this.runHistory.getTotalNumRunsOfConfig(this.incumbent) - this.runHistory.getTotalNumRunsOfConfig(challenger))});
            Object[] args3 = new Object[]{this.runHistory.getThetaIdx(challenger), challenger, N *= 2};
            this.log.trace("Increasing additional number of runs for challenger {} ({}) to : {} ", args3);
        }
    }

    private void logConfiguration(String type, ParamConfiguration challenger) {
        ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)this.runHistory.getAlgorithmInstanceSeedPairsRan(this.incumbent).iterator().next();
        RunConfig config = new RunConfig(pisp, this.cutoffTime, challenger);
        String cmd = this.tae.getManualCallString(config);
        Object[] args = new Object[]{type, this.runHistory.getThetaIdx(challenger), challenger, cmd};
        this.log.info("Sample Call for {} {} ({}) \n{} ", args);
    }

    private void changeIncumbentTo(ParamConfiguration challenger) {
        Set cappedConfigs = this.runHistory.getCappedAlgorithmInstanceSeedPairs(challenger);
        if (!cappedConfigs.isEmpty()) {
            throw new IllegalStateException("Incumbent seemingly has capped runs:" + cappedConfigs);
        }
        ParamConfiguration oldIncumbent = this.incumbent;
        this.incumbent = challenger;
        this.updateIncumbentCost();
        this.log.info("Incumbent Changed to: {} ({})", (Object)this.runHistory.getThetaIdx(challenger), (Object)challenger);
        this.logConfiguration("New Incumbent", challenger);
        this.fireEvent((AutomaticConfiguratorEvent)new IncumbentPerformanceChangeEvent((TerminationCondition)this.termCond, currentIncumbentCost, this.incumbent, (long)this.runHistory.getTotalNumRunsOfConfig(this.incumbent), oldIncumbent));
    }

    private double computeCap(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double bound_inc) {
        if (this.incumbentImpossibleToBeat(challenger, pisp, aMissing, instanceSet, cutofftime, bound_inc)) {
            return 0.0;
        }
        return this.computeCapBinSearch(challenger, pisp, aMissing, instanceSet, cutofftime, bound_inc, 0.0, cutofftime);
    }

    private boolean incumbentImpossibleToBeat(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double bound_inc) {
        return this.lowerBoundOnEmpiricalPerformance(challenger, pisp, aMissing, instanceSet, cutofftime, 0.0) > bound_inc;
    }

    private double computeCapBinSearch(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> missingInstances, double cutofftime, double bound_inc, double lowerBound, double upperBound) {
        if (upperBound - lowerBound < Math.pow(10.0, -6.0)) {
            double capTime = upperBound + Math.pow(10.0, -3.0);
            return capTime * this.options.capSlack + this.options.capAddSlack;
        }
        double mean = (upperBound + lowerBound) / 2.0;
        double predictedPerformance = this.lowerBoundOnEmpiricalPerformance(challenger, pisp, aMissing, missingInstances, cutofftime, mean);
        if (predictedPerformance < bound_inc) {
            return this.computeCapBinSearch(challenger, pisp, aMissing, missingInstances, cutofftime, bound_inc, mean, upperBound);
        }
        return this.computeCapBinSearch(challenger, pisp, aMissing, missingInstances, cutofftime, bound_inc, lowerBound, mean);
    }

    private double lowerBoundOnEmpiricalPerformance(ParamConfiguration challenger, ProblemInstanceSeedPair pisp, List<ProblemInstanceSeedPair> aMissing, Set<ProblemInstance> instanceSet, double cutofftime, double probe) {
        HashMap hallucinatedValues = new HashMap();
        for (ProblemInstanceSeedPair missingPisp : aMissing) {
            ProblemInstance pi = missingPisp.getInstance();
            if (hallucinatedValues.get(pi) == null) {
                hallucinatedValues.put(pi, new HashMap());
            }
            double hallucinatedValue = 0.0;
            if (pisp.equals((Object)missingPisp)) {
                hallucinatedValue = probe;
            }
            ((Map)hallucinatedValues.get(pi)).put(missingPisp.getSeed(), hallucinatedValue);
        }
        return this.runHistory.getEmpiricalCost(challenger, instanceSet, cutofftime, hallucinatedValues);
    }

    private void updateIncumbentCost() {
        currentIncumbentCost = this.runHistory.getEmpiricalCost(this.incumbent, new HashSet<ProblemInstance>(this.instances), this.cutoffTime);
        this.log.debug("Incumbent Cost now: {}", (Object)currentIncumbentCost);
    }

    protected RunConfig getRunConfig(ProblemInstanceSeedPair pisp, double cutofftime, ParamConfiguration configuration) {
        RunConfig rc = new RunConfig(pisp, cutofftime, configuration);
        this.log.trace("RunConfig generated {}", (Object)rc);
        return rc;
    }

    private RunConfig getBoundedRunConfig(ProblemInstanceSeedPair pisp, double capTime, ParamConfiguration challenger) {
        RunConfig rc = new RunConfig(pisp, capTime, challenger, true);
        this.log.trace("RunConfig generated {}", (Object)rc);
        return rc;
    }

    protected List<AlgorithmRun> updateRunHistory(List<AlgorithmRun> runs) {
        for (AlgorithmRun run : runs) {
            try {
                this.runHistory.append(run);
            }
            catch (DuplicateRunException e) {
                throw new IllegalStateException(e);
            }
        }
        return runs;
    }

    protected List<AlgorithmRun> evaluateRun(RunConfig runConfig) {
        return this.evaluateRun(Collections.singletonList(runConfig));
    }

    protected List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        if (this.have_to_stop(this.iteration)) {
            this.log.info("Cannot schedule any more runs, out of time");
            throw new OutOfTimeException();
        }
        this.log.info("Iteration {}: Scheduling {} run(s):", (Object)this.iteration, (Object)runConfigs.size());
        for (RunConfig rc : runConfigs) {
            Object[] args = new Object[]{this.iteration, this.runHistory.getThetaIdx(rc.getParamConfiguration()) != -1 ? " " + this.runHistory.getThetaIdx(rc.getParamConfiguration()) : "", rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime()};
            this.log.info("Iteration {}: Scheduling run for config{} ({}) on instance {} with seed {} and captime {}", args);
        }
        List completedRuns = this.tae.evaluateRun(runConfigs);
        for (AlgorithmRun run : completedRuns) {
            RunConfig rc = run.getRunConfig();
            Object[] args = new Object[]{this.iteration, this.runHistory.getThetaIdx(rc.getParamConfiguration()) != -1 ? " " + this.runHistory.getThetaIdx(rc.getParamConfiguration()) : "", rc.getParamConfiguration(), rc.getProblemInstanceSeedPair().getInstance().getInstanceID(), rc.getProblemInstanceSeedPair().getSeed(), rc.getCutoffTime(), run.getRunResult(), this.options.scenarioConfig.runObj.getObjective(run), run.getWallclockExecutionTime()};
            this.log.info("Iteration {}: Completed run for config{} ({}) on instance {} with seed {} and captime {} => Result: {}, response: {}, wallclock time: {} seconds", args);
        }
        this.updateRunHistory(completedRuns);
        return completedRuns;
    }

    public double getEmpericalPerformance(ParamConfiguration config) {
        HashSet<ProblemInstance> pis = new HashSet<ProblemInstance>();
        pis.addAll(this.instances);
        return this.runHistory.getEmpiricalCost(config, pis, this.cutoffTime);
    }

    public List<TrajectoryFileEntry> getTrajectoryFileEntries() {
        return Collections.unmodifiableList(this.tfes);
    }

    public String getTerminationReason() {
        return this.termCond.getTerminationReason();
    }
}

