from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="GroupsResponseItem")


@attr.s(auto_attribs=True)
class GroupsResponseItem:
    """
    Example:
        {'creation_time': 123456789, 'id': 'your-group-id'}

    Attributes:
        creation_time (Union[Unset, int]): timestamp
        id (Union[Unset, str]):
    """

    creation_time: Union[Unset, int] = UNSET
    id: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        creation_time = self.creation_time
        id = self.id

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if creation_time is not UNSET:
            field_dict["creation_time"] = creation_time
        if id is not UNSET:
            field_dict["id"] = id

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        creation_time = d.pop("creation_time", UNSET)

        id = d.pop("id", UNSET)

        groups_response_item = cls(
            creation_time=creation_time,
            id=id,
        )

        groups_response_item.additional_properties = d
        return groups_response_item

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
