from typing import Any, Dict, Optional

import httpx

from ...client import Client
from ...models.root_type_for_detailed_user_response import RootTypeForDetailedUserResponse
from ...types import Response


def _get_kwargs(
    user_username: str,
    *,
    client: Client,
) -> Dict[str, Any]:
    url = "{}/users/{UserUsername}".format(client.base_url, UserUsername=user_username)

    headers: Dict[str, Any] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    return {
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
    }


def _parse_response(*, response: httpx.Response) -> Optional[RootTypeForDetailedUserResponse]:
    if response.status_code == 200:
        response_200 = RootTypeForDetailedUserResponse.from_dict(response.json())

        return response_200
    return None


def _build_response(*, response: httpx.Response) -> Response[RootTypeForDetailedUserResponse]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    user_username: str,
    *,
    client: Client,
) -> Response[RootTypeForDetailedUserResponse]:
    """Get-User

    Args:
        user_username (str):

    Returns:
        Response[RootTypeForDetailedUserResponse]
    """

    kwargs = _get_kwargs(
        user_username=user_username,
        client=client,
    )

    response = httpx.get(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)


def sync(
    user_username: str,
    *,
    client: Client,
) -> Optional[RootTypeForDetailedUserResponse]:
    """Get-User

    Args:
        user_username (str):

    Returns:
        Response[RootTypeForDetailedUserResponse]
    """

    return sync_detailed(
        user_username=user_username,
        client=client,
    ).parsed


async def asyncio_detailed(
    user_username: str,
    *,
    client: Client,
) -> Response[RootTypeForDetailedUserResponse]:
    """Get-User

    Args:
        user_username (str):

    Returns:
        Response[RootTypeForDetailedUserResponse]
    """

    kwargs = _get_kwargs(
        user_username=user_username,
        client=client,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.get(**kwargs)

    return _build_response(response=response)


async def asyncio(
    user_username: str,
    *,
    client: Client,
) -> Optional[RootTypeForDetailedUserResponse]:
    """Get-User

    Args:
        user_username (str):

    Returns:
        Response[RootTypeForDetailedUserResponse]
    """

    return (
        await asyncio_detailed(
            user_username=user_username,
            client=client,
        )
    ).parsed
