from typing import Any, Dict

import httpx

from ...client import Client
from ...types import Response


def _get_kwargs(
    media_id: str,
    *,
    client: Client,
) -> Dict[str, Any]:
    url = "{}/media/{MediaId}".format(client.base_url, MediaId=media_id)

    headers: Dict[str, Any] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    return {
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
    }


def _build_response(*, response: httpx.Response) -> Response[Any]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=None,
    )


def sync_detailed(
    media_id: str,
    *,
    client: Client,
) -> Response[Any]:
    """Download-Media

    Args:
        media_id (str):

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        media_id=media_id,
        client=client,
    )

    response = httpx.get(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)


async def asyncio_detailed(
    media_id: str,
    *,
    client: Client,
) -> Response[Any]:
    """Download-Media

    Args:
        media_id (str):

    Returns:
        Response[Any]
    """

    kwargs = _get_kwargs(
        media_id=media_id,
        client=client,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.get(**kwargs)

    return _build_response(response=response)
