# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gino_admin', 'gino_admin.routes']

package_data = \
{'': ['*'], 'gino_admin': ['static/*', 'templates/*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'Sanic-Jinja2>=0.7.5,<0.8.0',
 'Sanic>=19.12.2,<20.0.0',
 'aiofiles>=0.5.0,<0.6.0',
 'expiring_dict>=1.1.0,<2.0.0',
 'gino>=0.8.7,<0.9.0',
 'passlib>=1.7.2,<2.0.0',
 'sanic-auth>=0.2.0,<0.3.0']

setup_kwargs = {
    'name': 'gino-admin',
    'version': '0.0.7',
    'description': 'Admin Panel for PostgreSQL DB with Gino ORM and Sanic',
    'long_description': 'gino_admin\n----------\n\n|badge1| |badge3| |badge2| \n\n.. |badge1| image:: https://img.shields.io/pypi/v/gino_admin \n.. |badge2| image:: https://img.shields.io/pypi/l/gino_admin\n.. |badge3| image:: https://img.shields.io/pypi/pyversions/gino_admin\n\n\nAdmin Panel for PostgreSQL DB with Gino ORM and Sanic\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/table_view_new.png\n  :width: 250\n  :alt: Table view\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/table_view_new.png\n  :width: 250\n  :alt: Load Presets\n\nHow to install\n--------------\n\n.. code-block:: python\n    \n    pip install gino_admin\n    \n\nUsage example\n-------------\n\nFull example placed in \'examples\' folder:\n\n.. code-block:: python\n    \n    examples/\n\n\nHow to use\n----------\n\n\nCreate in your project \'admin.py\' file and use `add_admin_panel` from from gino_admin import add_admin_panel\n\n\nExample:\n\n.. code-block:: python\n    \n    \n    from from gino_admin import add_admin_panel\n    \n    \n    add_admin_panel(\n        app, db, [User, Place, City, GiftCard], custom_hash_method=custom_hash_method\n    )\n        \n    \nWhere:\n\n    \'app\' - your Sanic application\n    \'db\' : from gino.ext.sanic import Gino; db = Gino() and [User, Place, City, GiftCard] - list of models that you want to add in Admin Panel to maintain\n        \n    custom_hash_method - optional parameter to define you own hash method to encrypt all \'_hash\' columns of your Models.\n    In admin panel _hash fields will be displayed without \'_hash\' prefix and fields values will be  hidden like \'******\'\n\n\nOr you can use admin as a standalone App, when you need to define Sanic Application first (check \'example\' folder)\n\nVersion 0.0.7 Updates:\n----------------------\n1. Fixes: datetime issue in \'Copy\' action, delete all modal\n2. New feature "Presets" (define multiple CSV files with data - upload all with one click).\n3. New feature "Drop DB" (full clean up & recreate tables).\n\nNew features can be find under menu with \'Cogs\' near \'SQL-Runner\' button.\n\nScreen with update.\n\n\nPresets\n-------\nLoad multiple CSV to DB in order by one click.\n\n\'Presets\' feature allows to define folder with DB presets described in yml format.\nPresets described that CSV-s files and in that order\n\nCheck also \'example/\' folder.\n\n\nExample:\n\n.. code-block:: python\n\n    name: First Preset\n    description: "Init DB with minimal data"\n    files:\n      users: csv/user.csv\n      gifts: csv/gift.csv\n\n\nCheck examples/src/csv_to_upload for example with presets files.\n\n\nIn order defined in yml, Gino-Admin will load csv files to models.\n\'files:\' describe that file (right sight) must be loaded to the model (left side).\n\nIn current example: load data from csv/user.csv to Users table, csv/gift.csv to Gifts.\n\nDon\'t forget to setup path to folder with presets like with **\'presets_folder\'** argument.\n\n.. code-block:: python\n\n    ...\n\n    current_path = os.path.dirname(os.path.abspath(__file__))\n\n    add_admin_panel(\n        app,\n        db,\n        [User, Place, City, GiftCard, Country],\n        custom_hash_method=custom_hash_method,\n        presets_folder=os.path.join(current_path, "csv_to_upload"),\n    )\n\nCheck example project for more clearly example.\n\n\nDrop DB\n-------\n\nDrop DB feature used for doing full clean up DB - it drop all tables & create them after Drop for all models in Admin Panel.\n\n\n\nUpload from CSV\n---------------\n\nFiles samples for example project can be found here: **examples/src/csv_to_upload**\n\n\nVersion 0.0.6 Updates:\n----------------------\n1. Clean up template, hide row controls under menu.\n2. Added \'Copy\' option to DB row.\n3. Now errors showed correct in table view pages in process of Delete, Copy, CSV Upload\n4. Added possible to work without auth (for Debug purposes). Set env variable \'ADMIN_AUTH_DISABLE=True\'\n5. Template updated\n6. Added export Table\'s Data to CSV\n7. First version of SQL-query execution (run any query and get answer from PostgreSQL)\n8. Fixed error display on csv upload\n\n\n\nAuthentication\n--------------\n\n1. To disable authorisation:\n\nSet environment variable \'ADMIN_AUTH_DISABLE=1\'\n\n.. code-block:: python\n\n    os.environ[\'ADMIN_AUTH_DISABLE\'] = \'1\'\n\nor from shell:\n\n.. code-block:: python\n\n        export ADMIN_AUTH_DISABLE=1\n\n\n2. To define admin user & password:\n\ncheck example/ folder to get code snippets\n\n\n.. code-block:: python\n\n    app = Sanic()\n\n    app.config["ADMIN_USER"] = "admin"\n    app.config["ADMIN_PASSWORD"] = "1234"\n\n\nLimitations\n-----------\n\nFor correct work of Admin Panel all models MUST contain unique \'id\' field.\n\'id\' used to identify row (one element) for Edit & Delete operations.\n\nso if you define model, for example, User:\n\n.. code-block:: python\n\n    class User(db.Model):\n\n        __tablename__ = "users"\n\n        id = db.Column(db.String(), unique=True, primary_key=True)\n\nid also can be Integer/BigInteger:\n\n\n.. code-block:: python\n\n    class User(db.Model):\n\n        __tablename__ = "users"\n\n        id = db.Column(db.BigInteger(), unique=True, primary_key=True)\n\n\nSupported operations\n--------------------\n\n- Auth by login/pass with cookie check\n- Create(Add new) item by one for the Model\n- Search/sort in tables\n- Upload/export data from/to CSV\n- Delete all rows/per element\n- Copy existed element (data table row)\n- Edit existed data (table row)\n- SQL-Runner (execute SQL-queries)\n- Load DB Presets (bunch of CSV)\n- Drop DB (Full clean up behavior: Drop tables & Recreate)\n\n\nTODO:\n\n- Select multiple for delete/copy\n- Deepcopy element (recursive copy all rows/objects that depend on chosen as ForeignKey)\n- Edit multiple items (?)\n- Roles & User store in DB\n- Filters in Table\'s columns\n- History logs on changes (log for admin panel actions)\n- Add possible to add new Presets from GUI\n\n\n\nContributions\n---------------\n\nContributions and feature requests are very welcome!\n\n\nIf you have time and want to fix:\nPlease open issues with that you want to add\nor write to me in Telegram: @xnuinside or mail: xnuinside@gmail.com\n\n\nDeveloper guide\n_______________\n\nProject use pre-commit hooks, so you need setup them\n\nJust run:\n\n.. code-block:: python\n\n    pre-commit install\n\nto install git hooks in your .git/ directory.\n\n\nScreens:\n--------\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/table_view_new.png\n  :width: 250\n  :alt: Table view\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/copy_item.png\n  :width: 250\n  :alt: Features per row\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/sql_runner.png\n  :width: 250\n  :alt: SQL-runner\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/add_item.png\n  :width: 250\n  :alt: Add item\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/auth.png\n  :width: 250\n  :alt: Simple auth\n\n.. image:: https://github.com/xnuinside/gino_admin/blob/master/docs/img/display_errors_on_upload_from_csv.png\n  :width: 250\n  :alt: Display errors on upload data from CSV\n\n\n',
    'author': 'xnuinside',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/gino_admin',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
