# -*- coding:utf-8 -*-
# Author：wancong
# Date: 2018-04-30
from pyhanlp import *


def demo_word_distance():
    """ 语义距离

    >>> demo_word_distance()
    词A   	词B   	语义距离      	语义相似度
    <BLANKLINE>
    香蕉   	香蕉   	0              	1.0000000000
    香蕉   	苹果   	19980          	0.9999997311
    香蕉   	白菜   	2628369        	0.9999646244
    香蕉   	水果   	32967          	0.9999995563
    香蕉   	蔬菜   	2630367        	0.9999645975
    香蕉   	自行车  	1854515628     	0.9750398066
    香蕉   	公交车  	1854535619     	0.9750395376
    香蕉   	飞机   	1857307833     	0.9750022259
    香蕉   	买    	39729797433    	0.4652709248
    香蕉   	卖    	39729897333    	0.4652695802
    香蕉   	购入   	39729797433    	0.4652709248
    香蕉   	新年   	4981789224     	0.9329493801
    香蕉   	春节   	4981789224     	0.9329493801
    香蕉   	丢失   	46784535633    	0.3703201856
    香蕉   	补办   	39205230527    	0.4723311464
    香蕉   	办理   	39205222533    	0.4723312540
    香蕉   	送给   	40831595534    	0.4504416652
    香蕉   	寻找   	41124601233    	0.4464980592
    香蕉   	孩子   	6734891367     	0.9093541255
    香蕉   	教室   	1548030420     	0.9791648353
    香蕉   	教师   	7516908567     	0.8988288432
    香蕉   	会计   	7547972472     	0.8984107496
    苹果   	香蕉   	19980          	0.9999997311
    苹果   	苹果   	0              	1.0000000000
    苹果   	白菜   	2608389        	0.9999648933
    苹果   	水果   	12987          	0.9999998252
    苹果   	蔬菜   	2610387        	0.9999648664
    苹果   	自行车  	1854535608     	0.9750395377
    苹果   	公交车  	1854555599     	0.9750392686
    苹果   	飞机   	1857327813     	0.9750019570
    苹果   	买    	39729817413    	0.4652706559
    苹果   	卖    	39729917313    	0.4652693113
    苹果   	购入   	39729817413    	0.4652706559
    苹果   	新年   	4981809204     	0.9329491112
    苹果   	春节   	4981809204     	0.9329491112
    苹果   	丢失   	46784555613    	0.3703199167
    苹果   	补办   	39205250507    	0.4723308775
    苹果   	办理   	39205242513    	0.4723309851
    苹果   	送给   	40831615514    	0.4504413963
    苹果   	寻找   	41124621213    	0.4464977903
    苹果   	孩子   	6734871387     	0.9093543944
    苹果   	教室   	1548050400     	0.9791645663
    苹果   	教师   	7516888587     	0.8988291121
    苹果   	会计   	7547952492     	0.8984110185
    白菜   	香蕉   	2628369        	0.9999646244
    白菜   	苹果   	2608389        	0.9999648933
    白菜   	白菜   	0              	1.0000000000
    白菜   	水果   	2595402        	0.9999650681
    白菜   	蔬菜   	1998           	0.9999999731
    白菜   	自行车  	1857143997     	0.9750044310
    白菜   	公交车  	1857163988     	0.9750041620
    白菜   	飞机   	1859936202     	0.9749668503
    白菜   	买    	39732425802    	0.4652355492
    白菜   	卖    	39732525702    	0.4652342046
    白菜   	购入   	39732425802    	0.4652355492
    白菜   	新年   	4984417593     	0.9329140045
    白菜   	春节   	4984417593     	0.9329140045
    白菜   	丢失   	46787164002    	0.3702848100
    白菜   	补办   	39207858896    	0.4722957708
    白菜   	办理   	39207850902    	0.4722958784
    白菜   	送给   	40834223903    	0.4504062896
    白菜   	寻找   	41127229602    	0.4464626836
    白菜   	孩子   	6732262998     	0.9093895011
    白菜   	教室   	1550658789     	0.9791294597
    白菜   	教师   	7514280198     	0.8988642188
    白菜   	会计   	7545344103     	0.8984461252
    水果   	香蕉   	32967          	0.9999995563
    水果   	苹果   	12987          	0.9999998252
    水果   	白菜   	2595402        	0.9999650681
    水果   	水果   	0              	1.0000000000
    水果   	蔬菜   	2597400        	0.9999650412
    水果   	自行车  	1854548595     	0.9750393629
    水果   	公交车  	1854568586     	0.9750390939
    水果   	飞机   	1857340800     	0.9750017822
    水果   	买    	39729830400    	0.4652704811
    水果   	卖    	39729930300    	0.4652691365
    水果   	购入   	39729830400    	0.4652704811
    水果   	新年   	4981822191     	0.9329489364
    水果   	春节   	4981822191     	0.9329489364
    水果   	丢失   	46784568600    	0.3703197419
    水果   	补办   	39205263494    	0.4723307027
    水果   	办理   	39205255500    	0.4723308103
    水果   	送给   	40831628501    	0.4504412215
    水果   	寻找   	41124634200    	0.4464976155
    水果   	孩子   	6734858400     	0.9093545692
    水果   	教室   	1548063387     	0.9791643915
    水果   	教师   	7516875600     	0.8988292869
    水果   	会计   	7547939505     	0.8984111933
    蔬菜   	香蕉   	2630367        	0.9999645975
    蔬菜   	苹果   	2610387        	0.9999648664
    蔬菜   	白菜   	1998           	0.9999999731
    蔬菜   	水果   	2597400        	0.9999650412
    蔬菜   	蔬菜   	0              	1.0000000000
    蔬菜   	自行车  	1857145995     	0.9750044041
    蔬菜   	公交车  	1857165986     	0.9750041351
    蔬菜   	飞机   	1859938200     	0.9749668234
    蔬菜   	买    	39732427800    	0.4652355223
    蔬菜   	卖    	39732527700    	0.4652341777
    蔬菜   	购入   	39732427800    	0.4652355223
    蔬菜   	新年   	4984419591     	0.9329139777
    蔬菜   	春节   	4984419591     	0.9329139777
    蔬菜   	丢失   	46787166000    	0.3702847831
    蔬菜   	补办   	39207860894    	0.4722957440
    蔬菜   	办理   	39207852900    	0.4722958515
    蔬菜   	送给   	40834225901    	0.4504062627
    蔬菜   	寻找   	41127231600    	0.4464626567
    蔬菜   	孩子   	6732261000     	0.9093895280
    蔬菜   	教室   	1550660787     	0.9791294328
    蔬菜   	教师   	7514278200     	0.8988642457
    蔬菜   	会计   	7545342105     	0.8984461521
    自行车  	香蕉   	1854515628     	0.9750398066
    自行车  	苹果   	1854535608     	0.9750395377
    自行车  	白菜   	1857143997     	0.9750044310
    自行车  	水果   	1854548595     	0.9750393629
    自行车  	蔬菜   	1857145995     	0.9750044041
    自行车  	自行车  	0              	1.0000000000
    自行车  	公交车  	19991          	0.9999997309
    自行车  	飞机   	2792205        	0.9999624193
    自行车  	买    	37875281805    	0.4902311182
    自行车  	卖    	37875381705    	0.4902297736
    自行车  	购入   	37875281805    	0.4902311182
    自行车  	新年   	3127273596     	0.9579095735
    自行车  	春节   	3127273596     	0.9579095735
    自行车  	丢失   	44930020005    	0.3952803790
    自行车  	补办   	37350714899    	0.4972913398
    自行车  	办理   	37350706905    	0.4972914474
    自行车  	送给   	38977079906    	0.4754018586
    自行车  	寻找   	39270085605    	0.4714582526
    自行车  	孩子   	8589406995     	0.8843939321
    自行车  	教室   	306485208      	0.9958749714
    自行车  	教师   	9371424195     	0.8738686498
    自行车  	会计   	9402488100     	0.8734505562
    公交车  	香蕉   	1854535619     	0.9750395376
    公交车  	苹果   	1854555599     	0.9750392686
    公交车  	白菜   	1857163988     	0.9750041620
    公交车  	水果   	1854568586     	0.9750390939
    公交车  	蔬菜   	1857165986     	0.9750041351
    公交车  	自行车  	19991          	0.9999997309
    公交车  	公交车  	0              	1.0000000000
    公交车  	飞机   	2772214        	0.9999626884
    公交车  	买    	37875261814    	0.4902313872
    公交车  	卖    	37875361714    	0.4902300427
    公交车  	购入   	37875261814    	0.4902313872
    公交车  	新年   	3127253605     	0.9579098426
    公交车  	春节   	3127253605     	0.9579098426
    公交车  	丢失   	44930000014    	0.3952806480
    公交车  	补办   	37350694908    	0.4972916089
    公交车  	办理   	37350686914    	0.4972917165
    公交车  	送给   	38977059915    	0.4754021276
    公交车  	寻找   	39270065614    	0.4714585217
    公交车  	孩子   	8589426986     	0.8843936631
    公交车  	教室   	306505199      	0.9958747023
    公交车  	教师   	9371444186     	0.8738683807
    公交车  	会计   	9402508091     	0.8734502872
    飞机   	香蕉   	1857307833     	0.9750022259
    飞机   	苹果   	1857327813     	0.9750019570
    飞机   	白菜   	1859936202     	0.9749668503
    飞机   	水果   	1857340800     	0.9750017822
    飞机   	蔬菜   	1859938200     	0.9749668234
    飞机   	自行车  	2792205        	0.9999624193
    飞机   	公交车  	2772214        	0.9999626884
    飞机   	飞机   	0              	1.0000000000
    飞机   	买    	37872489600    	0.4902686988
    飞机   	卖    	37872589500    	0.4902673543
    飞机   	购入   	37872489600    	0.4902686988
    飞机   	新年   	3124481391     	0.9579471542
    飞机   	春节   	3124481391     	0.9579471542
    飞机   	丢失   	44927227800    	0.3953179597
    飞机   	补办   	37347922694    	0.4973289205
    飞机   	办理   	37347914700    	0.4973290281
    飞机   	送给   	38974287701    	0.4754394393
    飞机   	寻找   	39267293400    	0.4714958333
    飞机   	孩子   	8592199200     	0.8843563514
    飞机   	教室   	309277413      	0.9958373907
    飞机   	教师   	9374216400     	0.8738310691
    飞机   	会计   	9405280305     	0.8734129755
    买    	香蕉   	39729797433    	0.4652709248
    买    	苹果   	39729817413    	0.4652706559
    买    	白菜   	39732425802    	0.4652355492
    买    	水果   	39729830400    	0.4652704811
    买    	蔬菜   	39732427800    	0.4652355223
    买    	自行车  	37875281805    	0.4902311182
    买    	公交车  	37875261814    	0.4902313872
    买    	飞机   	37872489600    	0.4902686988
    买    	买    	0              	1.0000000000
    买    	卖    	99900          	0.9999986554
    买    	购入   	0              	1.0000000000
    买    	新年   	34748008209    	0.5323215446
    买    	春节   	34748008209    	0.5323215446
    买    	丢失   	7054738200     	0.9050492608
    买    	补办   	524566906      	0.9929397783
    买    	办理   	524574900      	0.9929396707
    买    	送给   	1101798101     	0.9851707404
    买    	寻找   	1394803800     	0.9812271344
    买    	孩子   	46464688800    	0.3746250503
    买    	教室   	38181767013    	0.4861060895
    买    	教师   	47246706000    	0.3640997680
    买    	会计   	47277769905    	0.3636816744
    卖    	香蕉   	39729897333    	0.4652695802
    卖    	苹果   	39729917313    	0.4652693113
    卖    	白菜   	39732525702    	0.4652342046
    卖    	水果   	39729930300    	0.4652691365
    卖    	蔬菜   	39732527700    	0.4652341777
    卖    	自行车  	37875381705    	0.4902297736
    卖    	公交车  	37875361714    	0.4902300427
    卖    	飞机   	37872589500    	0.4902673543
    卖    	买    	99900          	0.9999986554
    卖    	卖    	0              	1.0000000000
    卖    	购入   	99900          	0.9999986554
    卖    	新年   	34748108109    	0.5323202001
    卖    	春节   	34748108109    	0.5323202001
    卖    	丢失   	7054638300     	0.9050506054
    卖    	补办   	524666806      	0.9929384338
    卖    	办理   	524674800      	0.9929383262
    卖    	送给   	1101698201     	0.9851720850
    卖    	寻找   	1394703900     	0.9812284790
    卖    	孩子   	46464788700    	0.3746237057
    卖    	教室   	38181866913    	0.4861047450
    卖    	教师   	47246805900    	0.3640984234
    卖    	会计   	47277869805    	0.3636803298
    购入   	香蕉   	39729797433    	0.4652709248
    购入   	苹果   	39729817413    	0.4652706559
    购入   	白菜   	39732425802    	0.4652355492
    购入   	水果   	39729830400    	0.4652704811
    购入   	蔬菜   	39732427800    	0.4652355223
    购入   	自行车  	37875281805    	0.4902311182
    购入   	公交车  	37875261814    	0.4902313872
    购入   	飞机   	37872489600    	0.4902686988
    购入   	买    	0              	1.0000000000
    购入   	卖    	99900          	0.9999986554
    购入   	购入   	0              	1.0000000000
    购入   	新年   	34748008209    	0.5323215446
    购入   	春节   	34748008209    	0.5323215446
    购入   	丢失   	7054738200     	0.9050492608
    购入   	补办   	524566906      	0.9929397783
    购入   	办理   	524574900      	0.9929396707
    购入   	送给   	1101798101     	0.9851707404
    购入   	寻找   	1394803800     	0.9812271344
    购入   	孩子   	46464688800    	0.3746250503
    购入   	教室   	38181767013    	0.4861060895
    购入   	教师   	47246706000    	0.3640997680
    购入   	会计   	47277769905    	0.3636816744
    新年   	香蕉   	4981789224     	0.9329493801
    新年   	苹果   	4981809204     	0.9329491112
    新年   	白菜   	4984417593     	0.9329140045
    新年   	水果   	4981822191     	0.9329489364
    新年   	蔬菜   	4984419591     	0.9329139777
    新年   	自行车  	3127273596     	0.9579095735
    新年   	公交车  	3127253605     	0.9579098426
    新年   	飞机   	3124481391     	0.9579471542
    新年   	买    	34748008209    	0.5323215446
    新年   	卖    	34748108109    	0.5323202001
    新年   	购入   	34748008209    	0.5323215446
    新年   	新年   	0              	1.0000000000
    新年   	春节   	0              	1.0000000000
    新年   	丢失   	41802746409    	0.4373708055
    新年   	补办   	34223441303    	0.5393817663
    新年   	办理   	34223433309    	0.5393818739
    新年   	送给   	35849806310    	0.5174922850
    新年   	寻找   	36142812009    	0.5135486791
    新年   	孩子   	11716680591    	0.8423035056
    新年   	教室   	3433758804     	0.9537845449
    新年   	教师   	12498697791    	0.8317782233
    新年   	会计   	12529761696    	0.8313601297
    春节   	香蕉   	4981789224     	0.9329493801
    春节   	苹果   	4981809204     	0.9329491112
    春节   	白菜   	4984417593     	0.9329140045
    春节   	水果   	4981822191     	0.9329489364
    春节   	蔬菜   	4984419591     	0.9329139777
    春节   	自行车  	3127273596     	0.9579095735
    春节   	公交车  	3127253605     	0.9579098426
    春节   	飞机   	3124481391     	0.9579471542
    春节   	买    	34748008209    	0.5323215446
    春节   	卖    	34748108109    	0.5323202001
    春节   	购入   	34748008209    	0.5323215446
    春节   	新年   	0              	1.0000000000
    春节   	春节   	0              	1.0000000000
    春节   	丢失   	41802746409    	0.4373708055
    春节   	补办   	34223441303    	0.5393817663
    春节   	办理   	34223433309    	0.5393818739
    春节   	送给   	35849806310    	0.5174922850
    春节   	寻找   	36142812009    	0.5135486791
    春节   	孩子   	11716680591    	0.8423035056
    春节   	教室   	3433758804     	0.9537845449
    春节   	教师   	12498697791    	0.8317782233
    春节   	会计   	12529761696    	0.8313601297
    丢失   	香蕉   	46784535633    	0.3703201856
    丢失   	苹果   	46784555613    	0.3703199167
    丢失   	白菜   	46787164002    	0.3702848100
    丢失   	水果   	46784568600    	0.3703197419
    丢失   	蔬菜   	46787166000    	0.3702847831
    丢失   	自行车  	44930020005    	0.3952803790
    丢失   	公交车  	44930000014    	0.3952806480
    丢失   	飞机   	44927227800    	0.3953179597
    丢失   	买    	7054738200     	0.9050492608
    丢失   	卖    	7054638300     	0.9050506054
    丢失   	购入   	7054738200     	0.9050492608
    丢失   	新年   	41802746409    	0.4373708055
    丢失   	春节   	41802746409    	0.4373708055
    丢失   	丢失   	0              	1.0000000000
    丢失   	补办   	7579305106     	0.8979890392
    丢失   	办理   	7579313100     	0.8979889316
    丢失   	送给   	5952940099     	0.9198785204
    丢失   	寻找   	5659934400     	0.9238221264
    丢失   	孩子   	53519427000    	0.2796743111
    丢失   	教室   	45236505213    	0.3911553504
    丢失   	教师   	54301444200    	0.2691490288
    丢失   	会计   	54332508105    	0.2687309352
    补办   	香蕉   	39205230527    	0.4723311464
    补办   	苹果   	39205250507    	0.4723308775
    补办   	白菜   	39207858896    	0.4722957708
    补办   	水果   	39205263494    	0.4723307027
    补办   	蔬菜   	39207860894    	0.4722957440
    补办   	自行车  	37350714899    	0.4972913398
    补办   	公交车  	37350694908    	0.4972916089
    补办   	飞机   	37347922694    	0.4973289205
    补办   	买    	524566906      	0.9929397783
    补办   	卖    	524666806      	0.9929384338
    补办   	购入   	524566906      	0.9929397783
    补办   	新年   	34223441303    	0.5393817663
    补办   	春节   	34223441303    	0.5393817663
    补办   	丢失   	7579305106     	0.8979890392
    补办   	补办   	0              	1.0000000000
    补办   	办理   	7994           	0.9999998924
    补办   	送给   	1626365007     	0.9781105187
    补办   	寻找   	1919370706     	0.9741669128
    补办   	孩子   	45940121894    	0.3816852719
    补办   	教室   	37657200107    	0.4931663112
    补办   	教师   	46722139094    	0.3711599896
    补办   	会计   	46753202999    	0.3707418960
    办理   	香蕉   	39205222533    	0.4723312540
    办理   	苹果   	39205242513    	0.4723309851
    办理   	白菜   	39207850902    	0.4722958784
    办理   	水果   	39205255500    	0.4723308103
    办理   	蔬菜   	39207852900    	0.4722958515
    办理   	自行车  	37350706905    	0.4972914474
    办理   	公交车  	37350686914    	0.4972917165
    办理   	飞机   	37347914700    	0.4973290281
    办理   	买    	524574900      	0.9929396707
    办理   	卖    	524674800      	0.9929383262
    办理   	购入   	524574900      	0.9929396707
    办理   	新年   	34223433309    	0.5393818739
    办理   	春节   	34223433309    	0.5393818739
    办理   	丢失   	7579313100     	0.8979889316
    办理   	补办   	7994           	0.9999998924
    办理   	办理   	0              	1.0000000000
    办理   	送给   	1626373001     	0.9781104112
    办理   	寻找   	1919378700     	0.9741668052
    办理   	孩子   	45940113900    	0.3816853795
    办理   	教室   	37657192113    	0.4931664188
    办理   	教师   	46722131100    	0.3711600972
    办理   	会计   	46753195005    	0.3707420036
    送给   	香蕉   	40831595534    	0.4504416652
    送给   	苹果   	40831615514    	0.4504413963
    送给   	白菜   	40834223903    	0.4504062896
    送给   	水果   	40831628501    	0.4504412215
    送给   	蔬菜   	40834225901    	0.4504062627
    送给   	自行车  	38977079906    	0.4754018586
    送给   	公交车  	38977059915    	0.4754021276
    送给   	飞机   	38974287701    	0.4754394393
    送给   	买    	1101798101     	0.9851707404
    送给   	卖    	1101698201     	0.9851720850
    送给   	购入   	1101798101     	0.9851707404
    送给   	新年   	35849806310    	0.5174922850
    送给   	春节   	35849806310    	0.5174922850
    送给   	丢失   	5952940099     	0.9198785204
    送给   	补办   	1626365007     	0.9781105187
    送给   	办理   	1626373001     	0.9781104112
    送给   	送给   	0              	1.0000000000
    送给   	寻找   	293005699      	0.9960563940
    送给   	孩子   	47566486901    	0.3597957907
    送给   	教室   	39283565114    	0.4712768299
    送给   	教师   	48348504101    	0.3492705084
    送给   	会计   	48379568006    	0.3488524148
    寻找   	香蕉   	41124601233    	0.4464980592
    寻找   	苹果   	41124621213    	0.4464977903
    寻找   	白菜   	41127229602    	0.4464626836
    寻找   	水果   	41124634200    	0.4464976155
    寻找   	蔬菜   	41127231600    	0.4464626567
    寻找   	自行车  	39270085605    	0.4714582526
    寻找   	公交车  	39270065614    	0.4714585217
    寻找   	飞机   	39267293400    	0.4714958333
    寻找   	买    	1394803800     	0.9812271344
    寻找   	卖    	1394703900     	0.9812284790
    寻找   	购入   	1394803800     	0.9812271344
    寻找   	新年   	36142812009    	0.5135486791
    寻找   	春节   	36142812009    	0.5135486791
    寻找   	丢失   	5659934400     	0.9238221264
    寻找   	补办   	1919370706     	0.9741669128
    寻找   	办理   	1919378700     	0.9741668052
    寻找   	送给   	293005699      	0.9960563940
    寻找   	寻找   	0              	1.0000000000
    寻找   	孩子   	47859492600    	0.3558521847
    寻找   	教室   	39576570813    	0.4673332240
    寻找   	教师   	48641509800    	0.3453269024
    寻找   	会计   	48672573705    	0.3449088088
    孩子   	香蕉   	6734891367     	0.9093541255
    孩子   	苹果   	6734871387     	0.9093543944
    孩子   	白菜   	6732262998     	0.9093895011
    孩子   	水果   	6734858400     	0.9093545692
    孩子   	蔬菜   	6732261000     	0.9093895280
    孩子   	自行车  	8589406995     	0.8843939321
    孩子   	公交车  	8589426986     	0.8843936631
    孩子   	飞机   	8592199200     	0.8843563514
    孩子   	买    	46464688800    	0.3746250503
    孩子   	卖    	46464788700    	0.3746237057
    孩子   	购入   	46464688800    	0.3746250503
    孩子   	新年   	11716680591    	0.8423035056
    孩子   	春节   	11716680591    	0.8423035056
    孩子   	丢失   	53519427000    	0.2796743111
    孩子   	补办   	45940121894    	0.3816852719
    孩子   	办理   	45940113900    	0.3816853795
    孩子   	送给   	47566486901    	0.3597957907
    孩子   	寻找   	47859492600    	0.3558521847
    孩子   	孩子   	0              	1.0000000000
    孩子   	教室   	8282921787     	0.8885189607
    孩子   	教师   	782017200      	0.9894747177
    孩子   	会计   	813081105      	0.9890566241
    教室   	香蕉   	1548030420     	0.9791648353
    教室   	苹果   	1548050400     	0.9791645663
    教室   	白菜   	1550658789     	0.9791294597
    教室   	水果   	1548063387     	0.9791643915
    教室   	蔬菜   	1550660787     	0.9791294328
    教室   	自行车  	306485208      	0.9958749714
    教室   	公交车  	306505199      	0.9958747023
    教室   	飞机   	309277413      	0.9958373907
    教室   	买    	38181767013    	0.4861060895
    教室   	卖    	38181866913    	0.4861047450
    教室   	购入   	38181767013    	0.4861060895
    教室   	新年   	3433758804     	0.9537845449
    教室   	春节   	3433758804     	0.9537845449
    教室   	丢失   	45236505213    	0.3911553504
    教室   	补办   	37657200107    	0.4931663112
    教室   	办理   	37657192113    	0.4931664188
    教室   	送给   	39283565114    	0.4712768299
    教室   	寻找   	39576570813    	0.4673332240
    教室   	孩子   	8282921787     	0.8885189607
    教室   	教室   	0              	1.0000000000
    教室   	教师   	9064938987     	0.8779936784
    教室   	会计   	9096002892     	0.8775755849
    教师   	香蕉   	7516908567     	0.8988288432
    教师   	苹果   	7516888587     	0.8988291121
    教师   	白菜   	7514280198     	0.8988642188
    教师   	水果   	7516875600     	0.8988292869
    教师   	蔬菜   	7514278200     	0.8988642457
    教师   	自行车  	9371424195     	0.8738686498
    教师   	公交车  	9371444186     	0.8738683807
    教师   	飞机   	9374216400     	0.8738310691
    教师   	买    	47246706000    	0.3640997680
    教师   	卖    	47246805900    	0.3640984234
    教师   	购入   	47246706000    	0.3640997680
    教师   	新年   	12498697791    	0.8317782233
    教师   	春节   	12498697791    	0.8317782233
    教师   	丢失   	54301444200    	0.2691490288
    教师   	补办   	46722139094    	0.3711599896
    教师   	办理   	46722131100    	0.3711600972
    教师   	送给   	48348504101    	0.3492705084
    教师   	寻找   	48641509800    	0.3453269024
    教师   	孩子   	782017200      	0.9894747177
    教师   	教室   	9064938987     	0.8779936784
    教师   	教师   	0              	1.0000000000
    教师   	会计   	31063905       	0.9995819064
    会计   	香蕉   	7547972472     	0.8984107496
    会计   	苹果   	7547952492     	0.8984110185
    会计   	白菜   	7545344103     	0.8984461252
    会计   	水果   	7547939505     	0.8984111933
    会计   	蔬菜   	7545342105     	0.8984461521
    会计   	自行车  	9402488100     	0.8734505562
    会计   	公交车  	9402508091     	0.8734502872
    会计   	飞机   	9405280305     	0.8734129755
    会计   	买    	47277769905    	0.3636816744
    会计   	卖    	47277869805    	0.3636803298
    会计   	购入   	47277769905    	0.3636816744
    会计   	新年   	12529761696    	0.8313601297
    会计   	春节   	12529761696    	0.8313601297
    会计   	丢失   	54332508105    	0.2687309352
    会计   	补办   	46753202999    	0.3707418960
    会计   	办理   	46753195005    	0.3707420036
    会计   	送给   	48379568006    	0.3488524148
    会计   	寻找   	48672573705    	0.3449088088
    会计   	孩子   	813081105      	0.9890566241
    会计   	教室   	9096002892     	0.8775755849
    会计   	教师   	31063905       	0.9995819064
    会计   	会计   	0              	1.0000000000
    """
    CoreSynonymDictionary = JClass("com.hankcs.hanlp.dictionary.CoreSynonymDictionary")

    word_array = [
        "香蕉",
        "苹果",
        "白菜",
        "水果",
        "蔬菜",
        "自行车",
        "公交车",
        "飞机",
        "买",
        "卖",
        "购入",
        "新年",
        "春节",
        "丢失",
        "补办",
        "办理",
        "送给",
        "寻找",
        "孩子",
        "教室",
        "教师",
        "会计",
    ]
    print("%-5s\t%-5s\t%-10s\t%-5s\n" % ("词A", "词B", "语义距离", "语义相似度"))
    for a in word_array:
        for b in word_array:
            print("%-5s\t%-5s\t%-15d\t%-5.10f" % (a, b, CoreSynonymDictionary.distance(a, b),
                CoreSynonymDictionary.similarity(a, b)))


if __name__ == "__main__":
    import doctest
    doctest.testmod(verbose=True, optionflags=doctest.NORMALIZE_WHITESPACE)
