# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from Tea.converter import TeaConverter


class ListAnalyticsDataRequestCondition(TeaModel):
    def __init__(self, field_name=None, operate=None, value=None, between_start=None, between_end=None):
        self.field_name = TeaConverter.to_unicode(field_name)  # type: unicode
        self.operate = TeaConverter.to_unicode(operate)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode
        self.between_start = TeaConverter.to_unicode(between_start)  # type: unicode
        self.between_end = TeaConverter.to_unicode(between_end)  # type: unicode

    def validate(self):
        self.validate_required(self.field_name, 'field_name')
        self.validate_required(self.operate, 'operate')

    def to_map(self):
        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.operate is not None:
            result['Operate'] = self.operate
        if self.value is not None:
            result['Value'] = self.value
        if self.between_start is not None:
            result['BetweenStart'] = self.between_start
        if self.between_end is not None:
            result['BetweenEnd'] = self.between_end
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Operate') is not None:
            self.operate = m.get('Operate')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('BetweenStart') is not None:
            self.between_start = m.get('BetweenStart')
        if m.get('BetweenEnd') is not None:
            self.between_end = m.get('BetweenEnd')
        return self


class ListAnalyticsDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, iso_id=None, api_path=None, page_size=None, condition=None,
                 page_num=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.iso_id = TeaConverter.to_unicode(iso_id)  # type: unicode
        self.api_path = TeaConverter.to_unicode(api_path)  # type: unicode
        self.page_size = page_size  # type: int
        self.condition = condition  # type: list[ListAnalyticsDataRequestCondition]
        self.page_num = page_num  # type: int

    def validate(self):
        self.validate_required(self.iot_instance_id, 'iot_instance_id')
        self.validate_required(self.api_path, 'api_path')
        if self.condition:
            for k in self.condition:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iso_id is not None:
            result['IsoId'] = self.iso_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Condition'] = []
        if self.condition is not None:
            for k in self.condition:
                result['Condition'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsoId') is not None:
            self.iso_id = m.get('IsoId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.condition = []
        if m.get('Condition') is not None:
            for k in m.get('Condition'):
                temp_model = ListAnalyticsDataRequestCondition()
                self.condition.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        return self


class ListAnalyticsDataResponseData(TeaModel):
    def __init__(self, has_next=None, result_json=None, count=None, page_num=None, page_size=None):
        self.has_next = has_next  # type: bool
        self.result_json = TeaConverter.to_unicode(result_json)  # type: unicode
        self.count = count  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        self.validate_required(self.has_next, 'has_next')
        self.validate_required(self.result_json, 'result_json')
        self.validate_required(self.count, 'count')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.result_json is not None:
            result['ResultJson'] = self.result_json
        if self.count is not None:
            result['Count'] = self.count
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('ResultJson') is not None:
            self.result_json = m.get('ResultJson')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAnalyticsDataResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: ListAnalyticsDataResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListAnalyticsDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchBindDevicesIntoProjectRequestDevices(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchBindDevicesIntoProjectRequest(TeaModel):
    def __init__(self, iot_instance_id=None, devices=None, project_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.devices = devices  # type: list[BatchBindDevicesIntoProjectRequestDevices]
        self.project_id = TeaConverter.to_unicode(project_id)  # type: unicode

    def validate(self):
        self.validate_required(self.devices, 'devices')
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchBindDevicesIntoProjectRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindDevicesIntoProjectResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: bool

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindProductsIntoProjectRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_keys = product_keys  # type: list[unicode]
        self.project_id = TeaConverter.to_unicode(project_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_keys, 'product_keys')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindProductsIntoProjectResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: bool

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectDevicesRequestDevices(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchUnbindProjectDevicesRequest(TeaModel):
    def __init__(self, devices=None, iot_instance_id=None, project_id=None):
        self.devices = devices  # type: list[BatchUnbindProjectDevicesRequestDevices]
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.project_id = TeaConverter.to_unicode(project_id)  # type: unicode

    def validate(self):
        self.validate_required(self.devices, 'devices')
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchUnbindProjectDevicesRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectDevicesResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: bool

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectProductsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_keys = product_keys  # type: list[unicode]
        self.project_id = TeaConverter.to_unicode(project_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_keys, 'product_keys')
        self.validate_required(self.project_id, 'project_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectProductsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: bool

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class SyncSpeechByCombinationRequest(TeaModel):
    def __init__(self, combination_list=None, iot_id=None, product_key=None, device_name=None, iot_instance_id=None):
        self.combination_list = combination_list  # type: list[unicode]
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.combination_list, 'combination_list')

    def to_map(self):
        result = dict()
        if self.combination_list is not None:
            result['CombinationList'] = self.combination_list
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CombinationList') is not None:
            self.combination_list = m.get('CombinationList')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class SyncSpeechByCombinationResponseData(TeaModel):
    def __init__(self, id=None, retry_count=None):
        self.id = TeaConverter.to_unicode(id)  # type: unicode
        self.retry_count = retry_count  # type: int

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.retry_count, 'retry_count')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        return self


class SyncSpeechByCombinationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: SyncSpeechByCombinationResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = SyncSpeechByCombinationResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class OpenIotServiceRequest(TeaModel):
    def __init__(self, owner_id=None):
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class OpenIotServiceResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.order_id = TeaConverter.to_unicode(order_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateRulengDistributeJobRequest(TeaModel):
    def __init__(self, product_key=None, source_instance_id=None, target_instance_id=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateRulengDistributeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListTaskByPageRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, page_no=None, job_id=None, device=None, status=None,
                 device_name=None, job_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = TeaConverter.to_unicode(page_size)  # type: unicode
        self.page_no = TeaConverter.to_unicode(page_no)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.device = device  # type: dict[unicode, any]
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageShrinkRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, page_no=None, job_id=None, device_shrink=None,
                 status=None, device_name=None, job_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = TeaConverter.to_unicode(page_size)  # type: unicode
        self.page_no = TeaConverter.to_unicode(page_no)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.device_shrink = TeaConverter.to_unicode(device_shrink)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device_shrink is not None:
            result['Device'] = self.device_shrink
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device_shrink = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageResponseDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, task_id=None, product_key=None, device_name=None, iot_id=None,
                 progress=None, utc_queue_time=None, utc_modified=None, status_detail=None, status=None, product_name=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.progress = progress  # type: int
        self.utc_queue_time = TeaConverter.to_unicode(utc_queue_time)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status_detail = TeaConverter.to_unicode(status_detail)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.utc_queue_time, 'utc_queue_time')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status_detail, 'status_detail')
        self.validate_required(self.status, 'status')
        self.validate_required(self.product_name, 'product_name')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        return self


class ListTaskByPageResponseData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListTaskByPageResponseDataData]

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskByPageResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskByPageResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.page = page  # type: int
        self.data = data  # type: ListTaskByPageResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page, 'page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListTaskByPageResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, limit=None, job_id=None, next_token=None, device=None, status=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.limit = limit  # type: int
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.next_token = TeaConverter.to_unicode(next_token)  # type: unicode
        self.device = device  # type: dict[unicode, any]
        self.status = TeaConverter.to_unicode(status)  # type: unicode

    def validate(self):
        self.validate_required(self.limit, 'limit')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskShrinkRequest(TeaModel):
    def __init__(self, iot_instance_id=None, limit=None, job_id=None, next_token=None, device_shrink=None,
                 status=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.limit = limit  # type: int
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.next_token = TeaConverter.to_unicode(next_token)  # type: unicode
        self.device_shrink = TeaConverter.to_unicode(device_shrink)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode

    def validate(self):
        self.validate_required(self.limit, 'limit')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device_shrink is not None:
            result['Device'] = self.device_shrink
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device_shrink = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, task_id=None, product_key=None, device_name=None, iot_id=None,
                 progress=None, utc_queue_time=None, utc_modified=None, status=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.progress = TeaConverter.to_unicode(progress)  # type: unicode
        self.utc_queue_time = TeaConverter.to_unicode(utc_queue_time)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.utc_queue_time, 'utc_queue_time')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListTaskResponseDataData]

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, next_token=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.next_token = TeaConverter.to_unicode(next_token)  # type: unicode
        self.data = data  # type: ListTaskResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryJobStatisticsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryJobStatisticsResponseData(TeaModel):
    def __init__(self, total=None, queued=None, sent=None, in_progress=None, succeeded=None, failed=None,
                 rejected=None, time_out=None, cancelled=None):
        self.total = total  # type: int
        self.queued = queued  # type: int
        self.sent = sent  # type: int
        self.in_progress = in_progress  # type: int
        self.succeeded = succeeded  # type: int
        self.failed = failed  # type: int
        self.rejected = rejected  # type: int
        self.time_out = time_out  # type: int
        self.cancelled = cancelled  # type: int

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.queued, 'queued')
        self.validate_required(self.sent, 'sent')
        self.validate_required(self.in_progress, 'in_progress')
        self.validate_required(self.succeeded, 'succeeded')
        self.validate_required(self.failed, 'failed')
        self.validate_required(self.rejected, 'rejected')
        self.validate_required(self.time_out, 'time_out')
        self.validate_required(self.cancelled, 'cancelled')

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.queued is not None:
            result['Queued'] = self.queued
        if self.sent is not None:
            result['Sent'] = self.sent
        if self.in_progress is not None:
            result['InProgress'] = self.in_progress
        if self.succeeded is not None:
            result['Succeeded'] = self.succeeded
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.rejected is not None:
            result['Rejected'] = self.rejected
        if self.time_out is not None:
            result['TimeOut'] = self.time_out
        if self.cancelled is not None:
            result['Cancelled'] = self.cancelled
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Queued') is not None:
            self.queued = m.get('Queued')
        if m.get('Sent') is not None:
            self.sent = m.get('Sent')
        if m.get('InProgress') is not None:
            self.in_progress = m.get('InProgress')
        if m.get('Succeeded') is not None:
            self.succeeded = m.get('Succeeded')
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Rejected') is not None:
            self.rejected = m.get('Rejected')
        if m.get('TimeOut') is not None:
            self.time_out = m.get('TimeOut')
        if m.get('Cancelled') is not None:
            self.cancelled = m.get('Cancelled')
        return self


class QueryJobStatisticsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryJobStatisticsResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryJobStatisticsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, status=None, page_size=None, current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListJobResponseDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, utc_create=None, utc_modified=None, status=None, description=None,
                 type=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')
        self.validate_required(self.description, 'description')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListJobResponseData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListJobResponseDataData]

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListJobResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page = page  # type: int
        self.data = data  # type: ListJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page, 'page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryJobResponseDataRolloutConfig(TeaModel):
    def __init__(self, maximum_per_minute=None):
        self.maximum_per_minute = maximum_per_minute  # type: int

    def validate(self):
        self.validate_required(self.maximum_per_minute, 'maximum_per_minute')

    def to_map(self):
        result = dict()
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        return self


class QueryJobResponseDataTimeoutConfig(TeaModel):
    def __init__(self, in_progress_timeout_in_minutes=None):
        self.in_progress_timeout_in_minutes = in_progress_timeout_in_minutes  # type: int

    def validate(self):
        self.validate_required(self.in_progress_timeout_in_minutes, 'in_progress_timeout_in_minutes')

    def to_map(self):
        result = dict()
        if self.in_progress_timeout_in_minutes is not None:
            result['InProgressTimeoutInMinutes'] = self.in_progress_timeout_in_minutes
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InProgressTimeoutInMinutes') is not None:
            self.in_progress_timeout_in_minutes = m.get('InProgressTimeoutInMinutes')
        return self


class QueryJobResponseDataJobFile(TeaModel):
    def __init__(self, file_url=None, sign_method=None, sign=None):
        self.file_url = TeaConverter.to_unicode(file_url)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.sign = TeaConverter.to_unicode(sign)  # type: unicode

    def validate(self):
        self.validate_required(self.file_url, 'file_url')
        self.validate_required(self.sign_method, 'sign_method')
        self.validate_required(self.sign, 'sign')

    def to_map(self):
        result = dict()
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.sign is not None:
            result['Sign'] = self.sign
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        return self


class QueryJobResponseDataTargetConfigTargetDevicesTargetDevices(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryJobResponseDataTargetConfigTargetDevices(TeaModel):
    def __init__(self, target_devices=None):
        self.target_devices = target_devices  # type: list[QueryJobResponseDataTargetConfigTargetDevicesTargetDevices]

    def validate(self):
        self.validate_required(self.target_devices, 'target_devices')
        if self.target_devices:
            for k in self.target_devices:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['targetDevices'] = []
        if self.target_devices is not None:
            for k in self.target_devices:
                result['targetDevices'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.target_devices = []
        if m.get('targetDevices') is not None:
            for k in m.get('targetDevices'):
                temp_model = QueryJobResponseDataTargetConfigTargetDevicesTargetDevices()
                self.target_devices.append(temp_model.from_map(k))
        return self


class QueryJobResponseDataTargetConfig(TeaModel):
    def __init__(self, target_group=None, target_product=None, target_type=None, target_devices=None):
        self.target_group = TeaConverter.to_unicode(target_group)  # type: unicode
        self.target_product = TeaConverter.to_unicode(target_product)  # type: unicode
        self.target_type = TeaConverter.to_unicode(target_type)  # type: unicode
        self.target_devices = target_devices  # type: QueryJobResponseDataTargetConfigTargetDevices

    def validate(self):
        self.validate_required(self.target_group, 'target_group')
        self.validate_required(self.target_product, 'target_product')
        self.validate_required(self.target_type, 'target_type')
        self.validate_required(self.target_devices, 'target_devices')
        if self.target_devices:
            self.target_devices.validate()

    def to_map(self):
        result = dict()
        if self.target_group is not None:
            result['TargetGroup'] = self.target_group
        if self.target_product is not None:
            result['TargetProduct'] = self.target_product
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_devices is not None:
            result['TargetDevices'] = self.target_devices.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetGroup') is not None:
            self.target_group = m.get('TargetGroup')
        if m.get('TargetProduct') is not None:
            self.target_product = m.get('TargetProduct')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetDevices') is not None:
            temp_model = QueryJobResponseDataTargetConfigTargetDevices()
            self.target_devices = temp_model.from_map(m['TargetDevices'])
        return self


class QueryJobResponseData(TeaModel):
    def __init__(self, job_id=None, job_name=None, utc_create=None, status=None, description=None, type=None,
                 job_document=None, utc_modified=None, rollout_config=None, timeout_config=None, job_file=None,
                 target_config=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.job_document = TeaConverter.to_unicode(job_document)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.rollout_config = rollout_config  # type: QueryJobResponseDataRolloutConfig
        self.timeout_config = timeout_config  # type: QueryJobResponseDataTimeoutConfig
        self.job_file = job_file  # type: QueryJobResponseDataJobFile
        self.target_config = target_config  # type: QueryJobResponseDataTargetConfig

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.status, 'status')
        self.validate_required(self.description, 'description')
        self.validate_required(self.type, 'type')
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.rollout_config, 'rollout_config')
        if self.rollout_config:
            self.rollout_config.validate()
        self.validate_required(self.timeout_config, 'timeout_config')
        if self.timeout_config:
            self.timeout_config.validate()
        self.validate_required(self.job_file, 'job_file')
        if self.job_file:
            self.job_file.validate()
        self.validate_required(self.target_config, 'target_config')
        if self.target_config:
            self.target_config.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config.to_map()
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config.to_map()
        if self.job_file is not None:
            result['JobFile'] = self.job_file.to_map()
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('RolloutConfig') is not None:
            temp_model = QueryJobResponseDataRolloutConfig()
            self.rollout_config = temp_model.from_map(m['RolloutConfig'])
        if m.get('TimeoutConfig') is not None:
            temp_model = QueryJobResponseDataTimeoutConfig()
            self.timeout_config = temp_model.from_map(m['TimeoutConfig'])
        if m.get('JobFile') is not None:
            temp_model = QueryJobResponseDataJobFile()
            self.job_file = temp_model.from_map(m['JobFile'])
        if m.get('TargetConfig') is not None:
            temp_model = QueryJobResponseDataTargetConfig()
            self.target_config = temp_model.from_map(m['TargetConfig'])
        return self


class QueryJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, description=None, timeout_config=None, rollout_config=None,
                 job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.timeout_config = timeout_config  # type: dict[unicode, any]
        self.rollout_config = rollout_config  # type: dict[unicode, any]
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class UpdateJobShrinkRequest(TeaModel):
    def __init__(self, iot_instance_id=None, description=None, timeout_config_shrink=None,
                 rollout_config_shrink=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.timeout_config_shrink = TeaConverter.to_unicode(timeout_config_shrink)  # type: unicode
        self.rollout_config_shrink = TeaConverter.to_unicode(rollout_config_shrink)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class UpdateJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, description=None, job_document=None, type=None, job_file=None,
                 job_name=None, timeout_config=None, rollout_config=None, target_config=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.job_document = TeaConverter.to_unicode(job_document)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.job_file = job_file  # type: dict[unicode, any]
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.timeout_config = timeout_config  # type: dict[unicode, any]
        self.rollout_config = rollout_config  # type: dict[unicode, any]
        self.target_config = target_config  # type: dict[unicode, any]

    def validate(self):
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.type, 'type')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.target_config, 'target_config')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        return self


class CreateJobShrinkRequest(TeaModel):
    def __init__(self, iot_instance_id=None, description=None, job_document=None, type=None, job_file_shrink=None,
                 job_name=None, timeout_config_shrink=None, rollout_config_shrink=None, target_config_shrink=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.job_document = TeaConverter.to_unicode(job_document)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.job_file_shrink = TeaConverter.to_unicode(job_file_shrink)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.timeout_config_shrink = TeaConverter.to_unicode(timeout_config_shrink)  # type: unicode
        self.rollout_config_shrink = TeaConverter.to_unicode(rollout_config_shrink)  # type: unicode
        self.target_config_shrink = TeaConverter.to_unicode(target_config_shrink)  # type: unicode

    def validate(self):
        self.validate_required(self.job_document, 'job_document')
        self.validate_required(self.type, 'type')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.target_config_shrink, 'target_config_shrink')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file_shrink is not None:
            result['JobFile'] = self.job_file_shrink
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.target_config_shrink is not None:
            result['TargetConfig'] = self.target_config_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file_shrink = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config_shrink = m.get('TargetConfig')
        return self


class CreateJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, job_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None, file_suffix=None, biz_code=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.file_suffix = TeaConverter.to_unicode(file_suffix)  # type: unicode
        self.biz_code = TeaConverter.to_unicode(biz_code)  # type: unicode

    def validate(self):
        self.validate_required(self.file_suffix, 'file_suffix')
        self.validate_required(self.biz_code, 'biz_code')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        return self


class GenerateFileUploadURLResponseData(TeaModel):
    def __init__(self, key=None, host=None, policy=None, oss_access_key_id=None, signature=None, object_storage=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.oss_access_key_id = TeaConverter.to_unicode(oss_access_key_id)  # type: unicode
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.object_storage = TeaConverter.to_unicode(object_storage)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.host, 'host')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.oss_access_key_id, 'oss_access_key_id')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.object_storage, 'object_storage')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GenerateFileUploadURLResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProductDistributeJobRequest(TeaModel):
    def __init__(self, source_instance_id=None, product_key=None, target_instance_id=None, target_uid=None,
                 target_aliyun_id=None):
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.target_aliyun_id = TeaConverter.to_unicode(target_aliyun_id)  # type: unicode

    def validate(self):
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        return self


class CreateProductDistributeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, job_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceOriginalPropertyDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None,
                 next_page_token=None, start_time=None, identifier=None, asc=None, iot_id=None, end_time=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.start_time = start_time  # type: long
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.asc = asc  # type: int
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.end_time = end_time  # type: long

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalPropertyDataResponseDataListPropertyInfo(TeaModel):
    def __init__(self, time=None, value=None):
        self.time = TeaConverter.to_unicode(time)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryDeviceOriginalPropertyDataResponseDataList(TeaModel):
    def __init__(self, property_info=None):
        self.property_info = property_info  # type: list[QueryDeviceOriginalPropertyDataResponseDataListPropertyInfo]

    def validate(self):
        self.validate_required(self.property_info, 'property_info')
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = QueryDeviceOriginalPropertyDataResponseDataListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalPropertyDataResponseData(TeaModel):
    def __init__(self, next_valid=None, next_page_token=None, list=None):
        self.next_valid = next_valid  # type: bool
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.list = list  # type: QueryDeviceOriginalPropertyDataResponseDataList

    def validate(self):
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_page_token is not None:
            result['nextPageToken'] = self.next_page_token
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('nextPageToken') is not None:
            self.next_page_token = m.get('nextPageToken')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalPropertyDataResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalPropertyDataResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceOriginalPropertyDataResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalPropertyDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalEventDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None,
                 next_page_token=None, start_time=None, identifier=None, asc=None, iot_id=None, end_time=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.start_time = start_time  # type: long
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.asc = asc  # type: int
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.end_time = end_time  # type: long

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalEventDataResponseDataListEventInfo(TeaModel):
    def __init__(self, time=None, identifier=None, name=None, event_type=None, output_data=None):
        self.time = TeaConverter.to_unicode(time)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.event_type = TeaConverter.to_unicode(event_type)  # type: unicode
        self.output_data = TeaConverter.to_unicode(output_data)  # type: unicode

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.name, 'name')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.output_data, 'output_data')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceOriginalEventDataResponseDataList(TeaModel):
    def __init__(self, event_info=None):
        self.event_info = event_info  # type: list[QueryDeviceOriginalEventDataResponseDataListEventInfo]

    def validate(self):
        self.validate_required(self.event_info, 'event_info')
        if self.event_info:
            for k in self.event_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EventInfo'] = []
        if self.event_info is not None:
            for k in self.event_info:
                result['EventInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_info = []
        if m.get('EventInfo') is not None:
            for k in m.get('EventInfo'):
                temp_model = QueryDeviceOriginalEventDataResponseDataListEventInfo()
                self.event_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalEventDataResponseData(TeaModel):
    def __init__(self, next_page_token=None, next_valid=None, list=None):
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.next_valid = next_valid  # type: bool
        self.list = list  # type: QueryDeviceOriginalEventDataResponseDataList

    def validate(self):
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalEventDataResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalEventDataResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceOriginalEventDataResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalEventDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalPropertyStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None,
                 next_page_token=None, iot_id=None, asc=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.asc = asc  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.asc, 'asc')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.asc is not None:
            result['Asc'] = self.asc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        return self


class QueryDeviceOriginalPropertyStatusResponseDataListPropertyStatusDataInfo(TeaModel):
    def __init__(self, identifier=None, value=None, time=None):
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode
        self.time = time  # type: long

    def validate(self):
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.value, 'value')
        self.validate_required(self.time, 'time')

    def to_map(self):
        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.value is not None:
            result['Value'] = self.value
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class QueryDeviceOriginalPropertyStatusResponseDataList(TeaModel):
    def __init__(self, property_status_data_info=None):
        self.property_status_data_info = property_status_data_info  # type: list[QueryDeviceOriginalPropertyStatusResponseDataListPropertyStatusDataInfo]

    def validate(self):
        self.validate_required(self.property_status_data_info, 'property_status_data_info')
        if self.property_status_data_info:
            for k in self.property_status_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyStatusDataInfo'] = []
        if self.property_status_data_info is not None:
            for k in self.property_status_data_info:
                result['PropertyStatusDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.property_status_data_info = []
        if m.get('PropertyStatusDataInfo') is not None:
            for k in m.get('PropertyStatusDataInfo'):
                temp_model = QueryDeviceOriginalPropertyStatusResponseDataListPropertyStatusDataInfo()
                self.property_status_data_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalPropertyStatusResponseData(TeaModel):
    def __init__(self, next_valid=None, next_page_token=None, list=None):
        self.next_valid = next_valid  # type: bool
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.list = list  # type: QueryDeviceOriginalPropertyStatusResponseDataList

    def validate(self):
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalPropertyStatusResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalPropertyStatusResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceOriginalPropertyStatusResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalPropertyStatusResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceOriginalServiceDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None,
                 next_page_token=None, start_time=None, identifier=None, asc=None, iot_id=None, end_time=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.start_time = start_time  # type: long
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.asc = asc  # type: int
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.end_time = end_time  # type: long

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceOriginalServiceDataResponseDataListServiceInfo(TeaModel):
    def __init__(self, time=None, identifier=None, name=None, input_data=None, output_data=None):
        self.time = TeaConverter.to_unicode(time)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.input_data = TeaConverter.to_unicode(input_data)  # type: unicode
        self.output_data = TeaConverter.to_unicode(output_data)  # type: unicode

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.name, 'name')
        self.validate_required(self.input_data, 'input_data')
        self.validate_required(self.output_data, 'output_data')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.input_data is not None:
            result['InputData'] = self.input_data
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('InputData') is not None:
            self.input_data = m.get('InputData')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceOriginalServiceDataResponseDataList(TeaModel):
    def __init__(self, service_info=None):
        self.service_info = service_info  # type: list[QueryDeviceOriginalServiceDataResponseDataListServiceInfo]

    def validate(self):
        self.validate_required(self.service_info, 'service_info')
        if self.service_info:
            for k in self.service_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ServiceInfo'] = []
        if self.service_info is not None:
            for k in self.service_info:
                result['ServiceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.service_info = []
        if m.get('ServiceInfo') is not None:
            for k in m.get('ServiceInfo'):
                temp_model = QueryDeviceOriginalServiceDataResponseDataListServiceInfo()
                self.service_info.append(temp_model.from_map(k))
        return self


class QueryDeviceOriginalServiceDataResponseData(TeaModel):
    def __init__(self, next_page_token=None, next_valid=None, list=None):
        self.next_page_token = TeaConverter.to_unicode(next_page_token)  # type: unicode
        self.next_valid = next_valid  # type: bool
        self.list = list  # type: QueryDeviceOriginalServiceDataResponseDataList

    def validate(self):
        self.validate_required(self.next_page_token, 'next_page_token')
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceOriginalServiceDataResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceOriginalServiceDataResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceOriginalServiceDataResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceOriginalServiceDataResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(self, script_content=None, iot_instance_id=None, product_key=None, script_type=None):
        self.script_content = TeaConverter.to_unicode(script_content)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.script_type = TeaConverter.to_unicode(script_type)  # type: unicode

    def validate(self):
        self.validate_required(self.script_content, 'script_content')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.script_type, 'script_type')

    def to_map(self):
        result = dict()
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateThingScriptRequest(TeaModel):
    def __init__(self, script_content=None, iot_instance_id=None, product_key=None, script_type=None):
        self.script_content = TeaConverter.to_unicode(script_content)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.script_type = TeaConverter.to_unicode(script_type)  # type: unicode

    def validate(self):
        self.validate_required(self.script_content, 'script_content')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.script_type, 'script_type')

    def to_map(self):
        result = dict()
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class UpdateThingScriptResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseData(TeaModel):
    def __init__(self, script_type=None, script_url=None):
        self.script_type = TeaConverter.to_unicode(script_type)  # type: unicode
        self.script_url = TeaConverter.to_unicode(script_url)  # type: unicode

    def validate(self):
        self.validate_required(self.script_type, 'script_type')
        self.validate_required(self.script_url, 'script_url')

    def to_map(self):
        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GetThingScriptResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAModuleVersionsByDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None, iot_id=None,
                 current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAModuleVersionsByDeviceResponseDataSimpleOTAModuleInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, iot_id=None, module_version=None, module_name=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.module_version = TeaConverter.to_unicode(module_version)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.module_version, 'module_version')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.module_version is not None:
            result['ModuleVersion'] = self.module_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ModuleVersion') is not None:
            self.module_version = m.get('ModuleVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAModuleVersionsByDeviceResponseData(TeaModel):
    def __init__(self, simple_otamodule_info=None):
        self.simple_otamodule_info = simple_otamodule_info  # type: list[ListOTAModuleVersionsByDeviceResponseDataSimpleOTAModuleInfo]

    def validate(self):
        self.validate_required(self.simple_otamodule_info, 'simple_otamodule_info')
        if self.simple_otamodule_info:
            for k in self.simple_otamodule_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAModuleInfo'] = []
        if self.simple_otamodule_info is not None:
            for k in self.simple_otamodule_info:
                result['SimpleOTAModuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otamodule_info = []
        if m.get('SimpleOTAModuleInfo') is not None:
            for k in m.get('SimpleOTAModuleInfo'):
                temp_model = ListOTAModuleVersionsByDeviceResponseDataSimpleOTAModuleInfo()
                self.simple_otamodule_info.append(temp_model.from_map(k))
        return self


class ListOTAModuleVersionsByDeviceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAModuleVersionsByDeviceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(self, iot_instance_id=None, device_name=None, product_key=None, qos=None, topic_short_name=None,
                 message_content=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.device_name = device_name  # type: list[unicode]
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.qos = qos  # type: int
        self.topic_short_name = TeaConverter.to_unicode(topic_short_name)  # type: unicode
        self.message_content = TeaConverter.to_unicode(message_content)  # type: unicode

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.topic_short_name, 'topic_short_name')
        self.validate_required(self.message_content, 'message_content')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class BatchPubResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class SpeechByCombinationRequest(TeaModel):
    def __init__(self, combination_list=None, iot_id=None, product_key=None, device_name=None, iot_instance_id=None):
        self.combination_list = combination_list  # type: list[unicode]
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.combination_list, 'combination_list')

    def to_map(self):
        result = dict()
        if self.combination_list is not None:
            result['CombinationList'] = self.combination_list
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CombinationList') is not None:
            self.combination_list = m.get('CombinationList')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class SpeechByCombinationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateThingModelValidationConfigRequest(TeaModel):
    def __init__(self, validate_type=None, iot_instance_id=None, product_key=None):
        self.validate_type = validate_type  # type: int
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.validate_type, 'validate_type')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class UpdateThingModelValidationConfigResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceBySQLRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sql=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.sql = TeaConverter.to_unicode(sql)  # type: unicode

    def validate(self):
        self.validate_required(self.iot_instance_id, 'iot_instance_id')
        self.validate_required(self.sql, 'sql')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sql is not None:
            result['SQL'] = self.sql
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SQL') is not None:
            self.sql = m.get('SQL')
        return self


class QueryDeviceBySQLResponseDataGroups(TeaModel):
    def __init__(self, group_id=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceBySQLResponseDataTags(TeaModel):
    def __init__(self, tag_name=None, tag_value=None):
        self.tag_name = TeaConverter.to_unicode(tag_name)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        self.validate_required(self.tag_name, 'tag_name')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceBySQLResponseDataOTAModules(TeaModel):
    def __init__(self, module_name=None, firmware_version=None):
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.firmware_version = TeaConverter.to_unicode(firmware_version)  # type: unicode

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.firmware_version, 'firmware_version')

    def to_map(self):
        result = dict()
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        return self


class QueryDeviceBySQLResponseData(TeaModel):
    def __init__(self, product_key=None, device_name=None, nickname=None, status=None, active_time=None, iot_id=None,
                 gmt_create=None, gmt_modified=None, groups=None, tags=None, otamodules=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.active_time = TeaConverter.to_unicode(active_time)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.groups = groups  # type: list[QueryDeviceBySQLResponseDataGroups]
        self.tags = tags  # type: list[QueryDeviceBySQLResponseDataTags]
        self.otamodules = otamodules  # type: list[QueryDeviceBySQLResponseDataOTAModules]

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.status, 'status')
        self.validate_required(self.active_time, 'active_time')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.groups, 'groups')
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        self.validate_required(self.otamodules, 'otamodules')
        if self.otamodules:
            for k in self.otamodules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['OTAModules'] = []
        if self.otamodules is not None:
            for k in self.otamodules:
                result['OTAModules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = QueryDeviceBySQLResponseDataGroups()
                self.groups.append(temp_model.from_map(k))
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = QueryDeviceBySQLResponseDataTags()
                self.tags.append(temp_model.from_map(k))
        self.otamodules = []
        if m.get('OTAModules') is not None:
            for k in m.get('OTAModules'):
                temp_model = QueryDeviceBySQLResponseDataOTAModules()
                self.otamodules.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total_count=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total_count = total_count  # type: long
        self.data = data  # type: list[QueryDeviceBySQLResponseData]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryDeviceBySQLResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAModuleByProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListOTAModuleByProductResponseData(TeaModel):
    def __init__(self, product_key=None, module_name=None, alias_name=None, desc=None, gmt_create=None,
                 gmt_modified=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.alias_name = TeaConverter.to_unicode(alias_name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.alias_name, 'alias_name')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListOTAModuleByProductResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: list[ListOTAModuleByProductResponseData]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListOTAModuleByProductResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, module_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseData(TeaModel):
    def __init__(self, key=None, host=None, policy=None, access_key_id=None, signature=None, file_url=None,
                 utc_create=None, object_storage=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.access_key_id = TeaConverter.to_unicode(access_key_id)  # type: unicode
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.file_url = TeaConverter.to_unicode(file_url)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.object_storage = TeaConverter.to_unicode(object_storage)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.host, 'host')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.file_url, 'file_url')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.object_storage, 'object_storage')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GenerateDeviceNameListURLResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateOTAModuleRequest(TeaModel):
    def __init__(self, alias_name=None, iot_instance_id=None, module_name=None, desc=None, product_key=None):
        self.alias_name = TeaConverter.to_unicode(alias_name)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class UpdateOTAModuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(self, alias_name=None, iot_instance_id=None, module_name=None, desc=None, product_key=None):
        self.alias_name = TeaConverter.to_unicode(alias_name)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.module_name, 'module_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryThingModelExtendConfigPublishedRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, model_version=None, function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelExtendConfigPublishedResponseData(TeaModel):
    def __init__(self, configuration=None):
        self.configuration = TeaConverter.to_unicode(configuration)  # type: unicode

    def validate(self):
        self.validate_required(self.configuration, 'configuration')

    def to_map(self):
        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        return self


class QueryThingModelExtendConfigPublishedResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryThingModelExtendConfigPublishedResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryThingModelExtendConfigPublishedResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, resource_group_id=None, simple=None,
                 model_version=None, function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.simple = simple  # type: bool
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslPublishedResponseData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = TeaConverter.to_unicode(tsl_str)  # type: unicode
        self.tsl_uri = TeaConverter.to_unicode(tsl_uri)  # type: unicode

    def validate(self):
        self.validate_required(self.tsl_str, 'tsl_str')
        self.validate_required(self.tsl_uri, 'tsl_uri')

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GetThingModelTslPublishedResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryThingModelPublishedRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, resource_group_id=None, model_version=None,
                 function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelPublishedResponseData(TeaModel):
    def __init__(self, thing_model_json=None):
        self.thing_model_json = TeaConverter.to_unicode(thing_model_json)  # type: unicode

    def validate(self):
        self.validate_required(self.thing_model_json, 'thing_model_json')

    def to_map(self):
        result = dict()
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        return self


class QueryThingModelPublishedResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, product_key=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.data = data  # type: QueryThingModelPublishedResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Data') is not None:
            temp_model = QueryThingModelPublishedResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryThingModelExtendConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, resource_group_id=None, model_version=None,
                 function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelExtendConfigResponseData(TeaModel):
    def __init__(self, configuration=None):
        self.configuration = TeaConverter.to_unicode(configuration)  # type: unicode

    def validate(self):
        self.validate_required(self.configuration, 'configuration')

    def to_map(self):
        result = dict()
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        return self


class QueryThingModelExtendConfigResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryThingModelExtendConfigResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryThingModelExtendConfigResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedDeviceRequest(TeaModel):
    def __init__(self, page_size=None, product_key=None, device_name=None, current_page=None, target_uid=None,
                 source_instance_id=None):
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.current_page = current_page  # type: int
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        return self


class ListDistributedDeviceResponseDataInfoItems(TeaModel):
    def __init__(self, source_uid=None, target_uid=None, product_key=None, device_name=None,
                 source_instance_id=None, target_instance_id=None, gmt_create=None, target_aliyun_id=None, source_region=None,
                 target_region=None, source_instance_name=None, target_instance_name=None, gmt_modified=None):
        self.source_uid = TeaConverter.to_unicode(source_uid)  # type: unicode
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode
        self.gmt_create = gmt_create  # type: long
        self.target_aliyun_id = TeaConverter.to_unicode(target_aliyun_id)  # type: unicode
        self.source_region = TeaConverter.to_unicode(source_region)  # type: unicode
        self.target_region = TeaConverter.to_unicode(target_region)  # type: unicode
        self.source_instance_name = TeaConverter.to_unicode(source_instance_name)  # type: unicode
        self.target_instance_name = TeaConverter.to_unicode(target_instance_name)  # type: unicode
        self.gmt_modified = gmt_modified  # type: long

    def validate(self):
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.target_aliyun_id, 'target_aliyun_id')
        self.validate_required(self.source_region, 'source_region')
        self.validate_required(self.target_region, 'target_region')
        self.validate_required(self.source_instance_name, 'source_instance_name')
        self.validate_required(self.target_instance_name, 'target_instance_name')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListDistributedDeviceResponseDataInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDistributedDeviceResponseDataInfoItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedDeviceResponseDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedDeviceResponseData(TeaModel):
    def __init__(self, total=None, info=None):
        self.total = total  # type: int
        self.info = info  # type: ListDistributedDeviceResponseDataInfo

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedDeviceResponseDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedDeviceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: ListDistributedDeviceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedProductRequest(TeaModel):
    def __init__(self, page_size=None, source_instance_id=None, product_key=None, target_instance_id=None,
                 target_uid=None, current_page=None):
        self.page_size = page_size  # type: int
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListDistributedProductResponseDataInfoItems(TeaModel):
    def __init__(self, source_uid=None, target_uid=None, product_key=None, source_instance_id=None,
                 target_instance_id=None, gmt_create=None, target_aliyun_id=None, source_region=None, target_region=None,
                 source_instance_name=None, target_instance_name=None):
        self.source_uid = TeaConverter.to_unicode(source_uid)  # type: unicode
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode
        self.gmt_create = gmt_create  # type: int
        self.target_aliyun_id = TeaConverter.to_unicode(target_aliyun_id)  # type: unicode
        self.source_region = TeaConverter.to_unicode(source_region)  # type: unicode
        self.target_region = TeaConverter.to_unicode(target_region)  # type: unicode
        self.source_instance_name = TeaConverter.to_unicode(source_instance_name)  # type: unicode
        self.target_instance_name = TeaConverter.to_unicode(target_instance_name)  # type: unicode

    def validate(self):
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.target_instance_id, 'target_instance_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.target_aliyun_id, 'target_aliyun_id')
        self.validate_required(self.source_region, 'source_region')
        self.validate_required(self.target_region, 'target_region')
        self.validate_required(self.source_instance_name, 'source_instance_name')
        self.validate_required(self.target_instance_name, 'target_instance_name')

    def to_map(self):
        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        return self


class ListDistributedProductResponseDataInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDistributedProductResponseDataInfoItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedProductResponseDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedProductResponseData(TeaModel):
    def __init__(self, total=None, info=None):
        self.total = total  # type: int
        self.info = info  # type: ListDistributedProductResponseDataInfo

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedProductResponseDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedProductResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: ListDistributedProductResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedProductResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QuerySubscribeRelationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, type=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QuerySubscribeRelationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, product_key=None, type=None,
                 device_data_flag=None, device_life_cycle_flag=None, device_status_change_flag=None,
                 device_topo_life_cycle_flag=None, found_device_list_flag=None, ota_event_flag=None, thing_history_flag=None,
                 mns_configuration=None, device_tag_flag=None, ota_version_flag=None, ota_job_flag=None, consumer_group_ids=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.device_data_flag = device_data_flag  # type: bool
        self.device_life_cycle_flag = device_life_cycle_flag  # type: bool
        self.device_status_change_flag = device_status_change_flag  # type: bool
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag  # type: bool
        self.found_device_list_flag = found_device_list_flag  # type: bool
        self.ota_event_flag = ota_event_flag  # type: bool
        self.thing_history_flag = thing_history_flag  # type: bool
        self.mns_configuration = TeaConverter.to_unicode(mns_configuration)  # type: unicode
        self.device_tag_flag = device_tag_flag  # type: bool
        self.ota_version_flag = ota_version_flag  # type: bool
        self.ota_job_flag = ota_job_flag  # type: bool
        self.consumer_group_ids = consumer_group_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')
        self.validate_required(self.device_data_flag, 'device_data_flag')
        self.validate_required(self.device_life_cycle_flag, 'device_life_cycle_flag')
        self.validate_required(self.device_status_change_flag, 'device_status_change_flag')
        self.validate_required(self.device_topo_life_cycle_flag, 'device_topo_life_cycle_flag')
        self.validate_required(self.found_device_list_flag, 'found_device_list_flag')
        self.validate_required(self.ota_event_flag, 'ota_event_flag')
        self.validate_required(self.thing_history_flag, 'thing_history_flag')
        self.validate_required(self.mns_configuration, 'mns_configuration')
        self.validate_required(self.device_tag_flag, 'device_tag_flag')
        self.validate_required(self.ota_version_flag, 'ota_version_flag')
        self.validate_required(self.ota_job_flag, 'ota_job_flag')
        self.validate_required(self.consumer_group_ids, 'consumer_group_ids')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = TeaConverter.to_unicode(consumer_group_id)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.consumer_group_id, 'consumer_group_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateSubscribeRelationRequest(TeaModel):
    def __init__(self, device_status_change_flag=None, iot_instance_id=None, thing_history_flag=None,
                 product_key=None, type=None, device_data_flag=None, consumer_group_ids=None, device_topo_life_cycle_flag=None,
                 found_device_list_flag=None, ota_event_flag=None, device_life_cycle_flag=None, mns_configuration=None,
                 device_tag_flag=None, ota_version_flag=None, ota_job_flag=None):
        self.device_status_change_flag = device_status_change_flag  # type: bool
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.thing_history_flag = thing_history_flag  # type: bool
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.device_data_flag = device_data_flag  # type: bool
        self.consumer_group_ids = consumer_group_ids  # type: list[unicode]
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag  # type: bool
        self.found_device_list_flag = found_device_list_flag  # type: bool
        self.ota_event_flag = ota_event_flag  # type: bool
        self.device_life_cycle_flag = device_life_cycle_flag  # type: bool
        self.mns_configuration = TeaConverter.to_unicode(mns_configuration)  # type: unicode
        self.device_tag_flag = device_tag_flag  # type: bool
        self.ota_version_flag = ota_version_flag  # type: bool
        self.ota_job_flag = ota_job_flag  # type: bool

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        return self


class UpdateSubscribeRelationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = TeaConverter.to_unicode(consumer_group_id)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.consumer_group_id, 'consumer_group_id')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ResetConsumerGroupPositionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class ResetConsumerGroupPositionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class UpdateConsumerGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, new_group_name=None, group_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.new_group_name = TeaConverter.to_unicode(new_group_name)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        self.validate_required(self.new_group_name, 'new_group_name')
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.new_group_name is not None:
            result['NewGroupName'] = self.new_group_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('NewGroupName') is not None:
            self.new_group_name = m.get('NewGroupName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class UpdateConsumerGroupResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_ids = channel_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_ids, 'channel_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList(TeaModel):
    def __init__(self, driver_id=None, iot_id=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_driver_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.device_driver_list = device_driver_list  # type: list[BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_driver_list, 'device_driver_list')
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, iot_id=None):
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_channel_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.device_channel_list = device_channel_list  # type: list[BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_channel_list, 'device_channel_list')
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        return self


class ReleaseEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class ReleaseEdgeDriverVersionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceDeviceByDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, instance_id=None, channel_id=None, driver_id=None,
                 current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryEdgeInstanceDeviceByDriverResponseDataDeviceList(TeaModel):
    def __init__(self, iot_id=None):
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryEdgeInstanceDeviceByDriverResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, device_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.device_list = device_list  # type: list[QueryEdgeInstanceDeviceByDriverResponseDataDeviceList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = QueryEdgeInstanceDeviceByDriverResponseDataDeviceList()
                self.device_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDeviceByDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeInstanceDeviceByDriverResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceDeviceByDriverResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class TriggerSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None, instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class TriggerSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class UnbindSceneRuleFromEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, rule_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class UnbindSceneRuleFromEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, current_page=None, page_size=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceSceneRuleResponseDataRuleList(TeaModel):
    def __init__(self, rule_id=None, rule_name=None, gmt_create=None, status=None, is_existed=None):
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode
        self.gmt_create = gmt_create  # type: long
        self.status = status  # type: int
        self.is_existed = is_existed  # type: int

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.status, 'status')
        self.validate_required(self.is_existed, 'is_existed')

    def to_map(self):
        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.status is not None:
            result['Status'] = self.status
        if self.is_existed is not None:
            result['IsExisted'] = self.is_existed
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IsExisted') is not None:
            self.is_existed = m.get('IsExisted')
        return self


class QueryEdgeInstanceSceneRuleResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, rule_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.rule_list = rule_list  # type: list[QueryEdgeInstanceSceneRuleResponseDataRuleList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.rule_list, 'rule_list')
        if self.rule_list:
            for k in self.rule_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['RuleList'] = []
        if self.rule_list is not None:
            for k in self.rule_list:
                result['RuleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.rule_list = []
        if m.get('RuleList') is not None:
            for k in m.get('RuleList'):
                temp_model = QueryEdgeInstanceSceneRuleResponseDataRuleList()
                self.rule_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeInstanceSceneRuleResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceSceneRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_name=None, rule_content=None, rule_description=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode
        self.rule_content = TeaConverter.to_unicode(rule_content)  # type: unicode
        self.rule_description = TeaConverter.to_unicode(rule_description)  # type: unicode

    def validate(self):
        self.validate_required(self.rule_name, 'rule_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, rule_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class QueryDetailSceneRuleLogRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None, start_time=None, end_time=None, trace_id=None,
                 page_size=None, current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.start_time = start_time  # type: int
        self.end_time = end_time  # type: int
        self.trace_id = TeaConverter.to_unicode(trace_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.trace_id, 'trace_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDetailSceneRuleLogResponseDataLogList(TeaModel):
    def __init__(self, code=None, message=None, pk_dn=None):
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.pk_dn = TeaConverter.to_unicode(pk_dn)  # type: unicode

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.pk_dn, 'pk_dn')

    def to_map(self):
        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.pk_dn is not None:
            result['PkDn'] = self.pk_dn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PkDn') is not None:
            self.pk_dn = m.get('PkDn')
        return self


class QueryDetailSceneRuleLogResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, log_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.log_list = log_list  # type: list[QueryDetailSceneRuleLogResponseDataLogList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.log_list, 'log_list')
        if self.log_list:
            for k in self.log_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['LogList'] = []
        if self.log_list is not None:
            for k in self.log_list:
                result['LogList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.log_list = []
        if m.get('LogList') is not None:
            for k in m.get('LogList'):
                temp_model = QueryDetailSceneRuleLogResponseDataLogList()
                self.log_list.append(temp_model.from_map(k))
        return self


class QueryDetailSceneRuleLogResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: QueryDetailSceneRuleLogResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryDetailSceneRuleLogResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class UpdateSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None, rule_name=None, rule_content=None, rule_description=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode
        self.rule_content = TeaConverter.to_unicode(rule_content)  # type: unicode
        self.rule_description = TeaConverter.to_unicode(rule_description)  # type: unicode

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class UpdateSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QuerySceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_name=None, page_size=None, current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QuerySceneRuleResponseDataRuleList(TeaModel):
    def __init__(self, rule_id=None, gmt_create=None, gmt_modified=None, rule_name=None, rule_description=None,
                 rule_status=None):
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode
        self.rule_description = TeaConverter.to_unicode(rule_description)  # type: unicode
        self.rule_status = rule_status  # type: int

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_description, 'rule_description')
        self.validate_required(self.rule_status, 'rule_status')

    def to_map(self):
        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class QuerySceneRuleResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, rule_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.rule_list = rule_list  # type: list[QuerySceneRuleResponseDataRuleList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.rule_list, 'rule_list')
        if self.rule_list:
            for k in self.rule_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['RuleList'] = []
        if self.rule_list is not None:
            for k in self.rule_list:
                result['RuleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.rule_list = []
        if m.get('RuleList') is not None:
            for k in m.get('RuleList'):
                temp_model = QuerySceneRuleResponseDataRuleList()
                self.rule_list.append(temp_model.from_map(k))
        return self


class QuerySceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QuerySceneRuleResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QuerySceneRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QuerySummarySceneRuleLogRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None, start_time=None, end_time=None, status=None,
                 page_size=None, current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.start_time = start_time  # type: int
        self.end_time = end_time  # type: int
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QuerySummarySceneRuleLogResponseDataLogListLogInfo(TeaModel):
    def __init__(self, log_time=None, result=None, trace_id=None):
        self.log_time = log_time  # type: int
        self.result = TeaConverter.to_unicode(result)  # type: unicode
        self.trace_id = TeaConverter.to_unicode(trace_id)  # type: unicode

    def validate(self):
        self.validate_required(self.log_time, 'log_time')
        self.validate_required(self.result, 'result')
        self.validate_required(self.trace_id, 'trace_id')

    def to_map(self):
        result = dict()
        if self.log_time is not None:
            result['LogTime'] = self.log_time
        if self.result is not None:
            result['Result'] = self.result
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogTime') is not None:
            self.log_time = m.get('LogTime')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class QuerySummarySceneRuleLogResponseDataLogList(TeaModel):
    def __init__(self, log_info=None):
        self.log_info = log_info  # type: list[QuerySummarySceneRuleLogResponseDataLogListLogInfo]

    def validate(self):
        self.validate_required(self.log_info, 'log_info')
        if self.log_info:
            for k in self.log_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['LogInfo'] = []
        if self.log_info is not None:
            for k in self.log_info:
                result['LogInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.log_info = []
        if m.get('LogInfo') is not None:
            for k in m.get('LogInfo'):
                temp_model = QuerySummarySceneRuleLogResponseDataLogListLogInfo()
                self.log_info.append(temp_model.from_map(k))
        return self


class QuerySummarySceneRuleLogResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, log_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.log_list = log_list  # type: QuerySummarySceneRuleLogResponseDataLogList

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.log_list, 'log_list')
        if self.log_list:
            self.log_list.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.log_list is not None:
            result['LogList'] = self.log_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('LogList') is not None:
            temp_model = QuerySummarySceneRuleLogResponseDataLogList()
            self.log_list = temp_model.from_map(m['LogList'])
        return self


class QuerySummarySceneRuleLogResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: QuerySummarySceneRuleLogResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QuerySummarySceneRuleLogResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseData(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, rule_name=None, rule_content=None, rule_description=None,
                 rule_status=None):
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode
        self.rule_content = TeaConverter.to_unicode(rule_content)  # type: unicode
        self.rule_description = TeaConverter.to_unicode(rule_description)  # type: unicode
        self.rule_status = rule_status  # type: int

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.rule_content, 'rule_content')
        self.validate_required(self.rule_description, 'rule_description')
        self.validate_required(self.rule_status, 'rule_status')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: GetSceneRuleResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, rule_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(self, resource_id=None, file_name=None, iot_instance_id=None, type=None, instance_id=None,
                 resource_version=None):
        self.resource_id = TeaConverter.to_unicode(resource_id)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.resource_version = TeaConverter.to_unicode(resource_version)  # type: unicode

    def validate(self):
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.resource_version, 'resource_version')

    def to_map(self):
        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        return self


class CreateEdgeOssPreSignedAddressResponseData(TeaModel):
    def __init__(self, oss_pre_signed_address=None, oss_address=None):
        self.oss_pre_signed_address = TeaConverter.to_unicode(oss_pre_signed_address)  # type: unicode
        self.oss_address = TeaConverter.to_unicode(oss_address)  # type: unicode

    def validate(self):
        self.validate_required(self.oss_pre_signed_address, 'oss_pre_signed_address')
        self.validate_required(self.oss_address, 'oss_address')

    def to_map(self):
        result = dict()
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: CreateEdgeOssPreSignedAddressResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None, edge_version=None,
                 description=None, source_config=None, driver_config=None, container_config=None, config_check_rule=None,
                 argument=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.edge_version = TeaConverter.to_unicode(edge_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.source_config = TeaConverter.to_unicode(source_config)  # type: unicode
        self.driver_config = TeaConverter.to_unicode(driver_config)  # type: unicode
        self.container_config = TeaConverter.to_unicode(container_config)  # type: unicode
        self.config_check_rule = TeaConverter.to_unicode(config_check_rule)  # type: unicode
        self.argument = TeaConverter.to_unicode(argument)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.edge_version, 'edge_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class UpdateEdgeDriverVersionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None, edge_version=None,
                 description=None, source_config=None, driver_config=None, container_config=None, config_check_rule=None,
                 argument=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.edge_version = TeaConverter.to_unicode(edge_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.source_config = TeaConverter.to_unicode(source_config)  # type: unicode
        self.driver_config = TeaConverter.to_unicode(driver_config)  # type: unicode
        self.container_config = TeaConverter.to_unicode(container_config)  # type: unicode
        self.config_check_rule = TeaConverter.to_unicode(config_check_rule)  # type: unicode
        self.argument = TeaConverter.to_unicode(argument)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.edge_version, 'edge_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, current_page=None, type=None, driver_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.type = type  # type: int
        self.driver_name = TeaConverter.to_unicode(driver_name)  # type: unicode

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.type is not None:
            result['Type'] = self.type
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        return self


class QueryEdgeDriverResponseDataDriverList(TeaModel):
    def __init__(self, driver_id=None, driver_name=None, driver_protocol=None, runtime=None, cpu_arch=None,
                 type=None, is_built_in=None, gmt_create_timestamp=None, gmt_modified_timestamp=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_name = TeaConverter.to_unicode(driver_name)  # type: unicode
        self.driver_protocol = TeaConverter.to_unicode(driver_protocol)  # type: unicode
        self.runtime = TeaConverter.to_unicode(runtime)  # type: unicode
        self.cpu_arch = TeaConverter.to_unicode(cpu_arch)  # type: unicode
        self.type = type  # type: int
        self.is_built_in = is_built_in  # type: bool
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.runtime, 'runtime')
        self.validate_required(self.cpu_arch, 'cpu_arch')
        self.validate_required(self.type, 'type')
        self.validate_required(self.is_built_in, 'is_built_in')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.type is not None:
            result['Type'] = self.type
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        return self


class QueryEdgeDriverResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, driver_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.driver_list = driver_list  # type: list[QueryEdgeDriverResponseDataDriverList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_list, 'driver_list')
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = QueryEdgeDriverResponseDataDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class QueryEdgeDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeDriverResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeDriverResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_ids = driver_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.driver_ids, 'driver_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeDriverResponseDriverList(TeaModel):
    def __init__(self, driver_id=None, driver_name=None, driver_protocol=None, runtime=None, cpu_arch=None,
                 type=None, is_built_in=None, gmt_create_timestamp=None, gmt_modified_timestamp=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_name = TeaConverter.to_unicode(driver_name)  # type: unicode
        self.driver_protocol = TeaConverter.to_unicode(driver_protocol)  # type: unicode
        self.runtime = TeaConverter.to_unicode(runtime)  # type: unicode
        self.cpu_arch = TeaConverter.to_unicode(cpu_arch)  # type: unicode
        self.type = type  # type: int
        self.is_built_in = is_built_in  # type: bool
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.runtime, 'runtime')
        self.validate_required(self.cpu_arch, 'cpu_arch')
        self.validate_required(self.type, 'type')
        self.validate_required(self.is_built_in, 'is_built_in')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.type is not None:
            result['Type'] = self.type
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, driver_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.driver_list = driver_list  # type: list[BatchGetEdgeDriverResponseDriverList]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.driver_list, 'driver_list')
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_name=None, driver_protocol=None, runtime=None, cpu_arch=None,
                 is_built_in=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_name = TeaConverter.to_unicode(driver_name)  # type: unicode
        self.driver_protocol = TeaConverter.to_unicode(driver_protocol)  # type: unicode
        self.runtime = TeaConverter.to_unicode(runtime)  # type: unicode
        self.cpu_arch = TeaConverter.to_unicode(cpu_arch)  # type: unicode
        self.is_built_in = is_built_in  # type: bool

    def validate(self):
        self.validate_required(self.driver_name, 'driver_name')
        self.validate_required(self.driver_protocol, 'driver_protocol')
        self.validate_required(self.runtime, 'runtime')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, driver_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class GetEdgeDriverVersionResponseData(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, version_state=None, edge_version=None, description=None,
                 source_config=None, driver_config=None, container_config=None, config_check_rule=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, argument=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.version_state = TeaConverter.to_unicode(version_state)  # type: unicode
        self.edge_version = TeaConverter.to_unicode(edge_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.source_config = TeaConverter.to_unicode(source_config)  # type: unicode
        self.driver_config = TeaConverter.to_unicode(driver_config)  # type: unicode
        self.container_config = TeaConverter.to_unicode(container_config)  # type: unicode
        self.config_check_rule = TeaConverter.to_unicode(config_check_rule)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.argument = TeaConverter.to_unicode(argument)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.version_state, 'version_state')
        self.validate_required(self.edge_version, 'edge_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.source_config, 'source_config')
        self.validate_required(self.driver_config, 'driver_config')
        self.validate_required(self.container_config, 'container_config')
        self.validate_required(self.config_check_rule, 'config_check_rule')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.argument, 'argument')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GetEdgeDriverVersionResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, current_page=None, driver_id=None, driver_version=None,
                 version_state=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.version_state = version_state  # type: int

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        return self


class QueryEdgeDriverVersionResponseDataDriverVersionList(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, version_state=None, edge_version=None, description=None,
                 source_config=None, driver_config=None, container_config=None, config_check_rule=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, argument=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.version_state = TeaConverter.to_unicode(version_state)  # type: unicode
        self.edge_version = TeaConverter.to_unicode(edge_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.source_config = TeaConverter.to_unicode(source_config)  # type: unicode
        self.driver_config = TeaConverter.to_unicode(driver_config)  # type: unicode
        self.container_config = TeaConverter.to_unicode(container_config)  # type: unicode
        self.config_check_rule = TeaConverter.to_unicode(config_check_rule)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.argument = TeaConverter.to_unicode(argument)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.version_state, 'version_state')
        self.validate_required(self.edge_version, 'edge_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.source_config, 'source_config')
        self.validate_required(self.driver_config, 'driver_config')
        self.validate_required(self.container_config, 'container_config')
        self.validate_required(self.config_check_rule, 'config_check_rule')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.argument, 'argument')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class QueryEdgeDriverVersionResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, driver_version_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.driver_version_list = driver_version_list  # type: list[QueryEdgeDriverVersionResponseDataDriverVersionList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_version_list, 'driver_version_list')
        if self.driver_version_list:
            for k in self.driver_version_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DriverVersionList'] = []
        if self.driver_version_list is not None:
            for k in self.driver_version_list:
                result['DriverVersionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.driver_version_list = []
        if m.get('DriverVersionList') is not None:
            for k in m.get('DriverVersionList'):
                temp_model = QueryEdgeDriverVersionResponseDataDriverVersionList()
                self.driver_version_list.append(temp_model.from_map(k))
        return self


class QueryEdgeDriverVersionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeDriverVersionResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeDriverVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetDeviceBindStatusResponseData(TeaModel):
    def __init__(self, iot_id=None, bind_status=None):
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.bind_status = bind_status  # type: int

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.bind_status, 'bind_status')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: list[BatchGetDeviceBindStatusResponseData]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, page_size=None, product_key=None, device_name=None,
                 current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseDataSimpleOTAJobInfo(TeaModel):
    def __init__(self, job_id=None, utc_create=None, utc_modified=None, product_key=None, firmware_id=None,
                 utc_start_time=None, utc_end_time=None, job_status=None, job_type=None, target_selection=None,
                 selection_type=None, tags=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.utc_start_time = TeaConverter.to_unicode(utc_start_time)  # type: unicode
        self.utc_end_time = TeaConverter.to_unicode(utc_end_time)  # type: unicode
        self.job_status = TeaConverter.to_unicode(job_status)  # type: unicode
        self.job_type = TeaConverter.to_unicode(job_type)  # type: unicode
        self.target_selection = TeaConverter.to_unicode(target_selection)  # type: unicode
        self.selection_type = TeaConverter.to_unicode(selection_type)  # type: unicode
        self.tags = tags  # type: ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_start_time, 'utc_start_time')
        self.validate_required(self.utc_end_time, 'utc_end_time')
        self.validate_required(self.job_status, 'job_status')
        self.validate_required(self.job_type, 'job_type')
        self.validate_required(self.target_selection, 'target_selection')
        self.validate_required(self.selection_type, 'selection_type')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByDeviceResponseData(TeaModel):
    def __init__(self, simple_otajob_info=None):
        self.simple_otajob_info = simple_otajob_info  # type: list[ListOTAJobByDeviceResponseDataSimpleOTAJobInfo]

    def validate(self):
        self.validate_required(self.simple_otajob_info, 'simple_otajob_info')
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByDeviceResponseDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAJobByDeviceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, identifier=None, thing_model_json=None,
                 function_block_id=None, function_block_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.thing_model_json = TeaConverter.to_unicode(thing_model_json)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.function_block_name = TeaConverter.to_unicode(function_block_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class UpdateThingModelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, thing_model_json=None, function_block_id=None,
                 function_block_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.thing_model_json = TeaConverter.to_unicode(thing_model_json)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.function_block_name = TeaConverter.to_unicode(function_block_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListOTATaskByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, task_status=None, job_id=None, current_page=None,
                 device_names=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.task_status = TeaConverter.to_unicode(task_status)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.device_names = device_names  # type: list[unicode]

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_names is not None:
            result['DeviceNames'] = self.device_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceNames') is not None:
            self.device_names = m.get('DeviceNames')
        return self


class ListOTATaskByJobResponseDataSimpleOTATaskInfo(TeaModel):
    def __init__(self, task_id=None, utc_modified=None, product_key=None, firmware_id=None, task_status=None,
                 job_id=None, product_name=None, device_name=None, src_version=None, dest_version=None, task_desc=None,
                 progress=None, iot_id=None, utc_create=None):
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.task_status = TeaConverter.to_unicode(task_status)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.src_version = TeaConverter.to_unicode(src_version)  # type: unicode
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.task_desc = TeaConverter.to_unicode(task_desc)  # type: unicode
        self.progress = TeaConverter.to_unicode(progress)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.task_status, 'task_status')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.src_version, 'src_version')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.task_desc, 'task_desc')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.task_desc is not None:
            result['TaskDesc'] = self.task_desc
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('TaskDesc') is not None:
            self.task_desc = m.get('TaskDesc')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class ListOTATaskByJobResponseData(TeaModel):
    def __init__(self, simple_otatask_info=None):
        self.simple_otatask_info = simple_otatask_info  # type: list[ListOTATaskByJobResponseDataSimpleOTATaskInfo]

    def validate(self):
        self.validate_required(self.simple_otatask_info, 'simple_otatask_info')
        if self.simple_otatask_info:
            for k in self.simple_otatask_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTATaskInfo'] = []
        if self.simple_otatask_info is not None:
            for k in self.simple_otatask_info:
                result['SimpleOTATaskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otatask_info = []
        if m.get('SimpleOTATaskInfo') is not None:
            for k in m.get('SimpleOTATaskInfo'):
                temp_model = ListOTATaskByJobResponseDataSimpleOTATaskInfo()
                self.simple_otatask_info.append(temp_model.from_map(k))
        return self


class ListOTATaskByJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTATaskByJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTATaskByJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListThingTemplatesRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListThingTemplatesResponseData(TeaModel):
    def __init__(self, category_key=None, category_name=None):
        self.category_key = TeaConverter.to_unicode(category_key)  # type: unicode
        self.category_name = TeaConverter.to_unicode(category_name)  # type: unicode

    def validate(self):
        self.validate_required(self.category_key, 'category_key')
        self.validate_required(self.category_name, 'category_name')

    def to_map(self):
        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        return self


class ListThingTemplatesResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: list[ListThingTemplatesResponseData]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListThingTemplatesResponseData()
                self.data.append(temp_model.from_map(k))
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, category_key=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.category_key = TeaConverter.to_unicode(category_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        return self


class GetThingTemplateResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, thing_model_json=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.thing_model_json = TeaConverter.to_unicode(thing_model_json)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.thing_model_json, 'thing_model_json')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.thing_model_json is not None:
            result['ThingModelJSON'] = self.thing_model_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ThingModelJSON') is not None:
            self.thing_model_json = m.get('ThingModelJSON')
        return self


class ListThingModelVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListThingModelVersionResponseDataModelVersions(TeaModel):
    def __init__(self, model_version=None, description=None, gmt_create=None):
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.gmt_create = gmt_create  # type: long

    def validate(self):
        self.validate_required(self.model_version, 'model_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.gmt_create, 'gmt_create')

    def to_map(self):
        result = dict()
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        return self


class ListThingModelVersionResponseData(TeaModel):
    def __init__(self, model_versions=None):
        self.model_versions = model_versions  # type: list[ListThingModelVersionResponseDataModelVersions]

    def validate(self):
        self.validate_required(self.model_versions, 'model_versions')
        if self.model_versions:
            for k in self.model_versions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ModelVersions'] = []
        if self.model_versions is not None:
            for k in self.model_versions:
                result['ModelVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.model_versions = []
        if m.get('ModelVersions') is not None:
            for k in m.get('ModelVersions'):
                temp_model = ListThingModelVersionResponseDataModelVersions()
                self.model_versions.append(temp_model.from_map(k))
        return self


class ListThingModelVersionResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: ListThingModelVersionResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListThingModelVersionResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportThingModelTslRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, tsl_str=None, tsl_url=None,
                 function_block_id=None, function_block_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.tsl_str = TeaConverter.to_unicode(tsl_str)  # type: unicode
        self.tsl_url = TeaConverter.to_unicode(tsl_url)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.function_block_name = TeaConverter.to_unicode(function_block_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_url is not None:
            result['TslUrl'] = self.tsl_url
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUrl') is not None:
            self.tsl_url = m.get('TslUrl')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class ImportThingModelTslResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class PublishThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, model_version=None,
                 description=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class PublishThingModelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, source_product_key=None,
                 target_product_key=None, source_model_version=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.source_product_key = TeaConverter.to_unicode(source_product_key)  # type: unicode
        self.target_product_key = TeaConverter.to_unicode(target_product_key)  # type: unicode
        self.source_model_version = TeaConverter.to_unicode(source_model_version)  # type: unicode

    def validate(self):
        self.validate_required(self.source_product_key, 'source_product_key')
        self.validate_required(self.target_product_key, 'target_product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, model_version=None,
                 simple=None, function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.simple = simple  # type: bool
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslResponseData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = TeaConverter.to_unicode(tsl_str)  # type: unicode
        self.tsl_uri = TeaConverter.to_unicode(tsl_uri)  # type: unicode

    def validate(self):
        self.validate_required(self.tsl_str, 'tsl_str')
        self.validate_required(self.tsl_uri, 'tsl_uri')

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GetThingModelTslResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, model_version=None,
                 function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryThingModelResponseData(TeaModel):
    def __init__(self, thing_model_json=None):
        self.thing_model_json = TeaConverter.to_unicode(thing_model_json)  # type: unicode

    def validate(self):
        self.validate_required(self.thing_model_json, 'thing_model_json')

    def to_map(self):
        result = dict()
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        return self


class QueryThingModelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, product_key=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.data = data  # type: QueryThingModelResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Data') is not None:
            temp_model = QueryThingModelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, property_identifier=None,
                 service_identifier=None, event_identifier=None, function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.property_identifier = property_identifier  # type: list[unicode]
        self.service_identifier = service_identifier  # type: list[unicode]
        self.event_identifier = event_identifier  # type: list[unicode]
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateProductFilterConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, property_timestamp_filter=None,
                 property_value_filter=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.property_timestamp_filter = property_timestamp_filter  # type: bool
        self.property_value_filter = property_value_filter  # type: bool

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.property_timestamp_filter, 'property_timestamp_filter')
        self.validate_required(self.property_value_filter, 'property_value_filter')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_timestamp_filter is not None:
            result['PropertyTimestampFilter'] = self.property_timestamp_filter
        if self.property_value_filter is not None:
            result['PropertyValueFilter'] = self.property_value_filter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyTimestampFilter') is not None:
            self.property_timestamp_filter = m.get('PropertyTimestampFilter')
        if m.get('PropertyValueFilter') is not None:
            self.property_value_filter = m.get('PropertyValueFilter')
        return self


class UpdateProductFilterConfigResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ListOTAJobByFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, page_size=None, current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseDataSimpleOTAJobInfo(TeaModel):
    def __init__(self, job_id=None, utc_create=None, utc_modified=None, product_key=None, firmware_id=None,
                 utc_start_time=None, utc_end_time=None, job_status=None, job_type=None, target_selection=None,
                 selection_type=None, tags=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.utc_start_time = TeaConverter.to_unicode(utc_start_time)  # type: unicode
        self.utc_end_time = TeaConverter.to_unicode(utc_end_time)  # type: unicode
        self.job_status = TeaConverter.to_unicode(job_status)  # type: unicode
        self.job_type = TeaConverter.to_unicode(job_type)  # type: unicode
        self.target_selection = TeaConverter.to_unicode(target_selection)  # type: unicode
        self.selection_type = TeaConverter.to_unicode(selection_type)  # type: unicode
        self.tags = tags  # type: ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_start_time, 'utc_start_time')
        self.validate_required(self.utc_end_time, 'utc_end_time')
        self.validate_required(self.job_status, 'job_status')
        self.validate_required(self.job_type, 'job_type')
        self.validate_required(self.target_selection, 'target_selection')
        self.validate_required(self.selection_type, 'selection_type')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByFirmwareResponseDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByFirmwareResponseData(TeaModel):
    def __init__(self, simple_otajob_info=None):
        self.simple_otajob_info = simple_otajob_info  # type: list[ListOTAJobByFirmwareResponseDataSimpleOTAJobInfo]

    def validate(self):
        self.validate_required(self.simple_otajob_info, 'simple_otajob_info')
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByFirmwareResponseDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAJobByFirmwareResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByFirmwareResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, page_size=None, current_page=None, dest_version=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        return self


class ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo(TeaModel):
    def __init__(self, firmware_name=None, firmware_id=None, src_version=None, dest_version=None, utc_create=None,
                 utc_modified=None, status=None, firmware_desc=None, firmware_sign=None, firmware_size=None, firmware_url=None,
                 product_key=None, sign_method=None, product_name=None, type=None, module_name=None):
        self.firmware_name = TeaConverter.to_unicode(firmware_name)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.src_version = TeaConverter.to_unicode(src_version)  # type: unicode
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status = status  # type: int
        self.firmware_desc = TeaConverter.to_unicode(firmware_desc)  # type: unicode
        self.firmware_sign = TeaConverter.to_unicode(firmware_sign)  # type: unicode
        self.firmware_size = firmware_size  # type: int
        self.firmware_url = TeaConverter.to_unicode(firmware_url)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.type = type  # type: int
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode

    def validate(self):
        self.validate_required(self.firmware_name, 'firmware_name')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.src_version, 'src_version')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')
        self.validate_required(self.firmware_desc, 'firmware_desc')
        self.validate_required(self.firmware_sign, 'firmware_sign')
        self.validate_required(self.firmware_size, 'firmware_size')
        self.validate_required(self.firmware_url, 'firmware_url')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.sign_method, 'sign_method')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAFirmwareResponseFirmwareInfo(TeaModel):
    def __init__(self, simple_firmware_info=None):
        self.simple_firmware_info = simple_firmware_info  # type: list[ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo]

    def validate(self):
        self.validate_required(self.simple_firmware_info, 'simple_firmware_info')
        if self.simple_firmware_info:
            for k in self.simple_firmware_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleFirmwareInfo'] = []
        if self.simple_firmware_info is not None:
            for k in self.simple_firmware_info:
                result['SimpleFirmwareInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_firmware_info = []
        if m.get('SimpleFirmwareInfo') is not None:
            for k in m.get('SimpleFirmwareInfo'):
                temp_model = ListOTAFirmwareResponseFirmwareInfoSimpleFirmwareInfo()
                self.simple_firmware_info.append(temp_model.from_map(k))
        return self


class ListOTAFirmwareResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, firmware_info=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.firmware_info = firmware_info  # type: ListOTAFirmwareResponseFirmwareInfo

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.firmware_info, 'firmware_info')
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FirmwareInfo') is not None:
            temp_model = ListOTAFirmwareResponseFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None, cancel_scheduled_task=None, cancel_queued_task=None,
                 cancel_in_progress_task=None, cancel_notified_task=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.cancel_scheduled_task = cancel_scheduled_task  # type: bool
        self.cancel_queued_task = cancel_queued_task  # type: bool
        self.cancel_in_progress_task = cancel_in_progress_task  # type: bool
        self.cancel_notified_task = cancel_notified_task  # type: bool

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateDeviceDistributeJobRequestTargetInstanceConfig(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateDeviceDistributeJobRequest(TeaModel):
    def __init__(self, device_name=None, source_instance_id=None, product_key=None, target_uid=None,
                 target_aliyun_id=None, target_instance_config=None, strategy=None):
        self.device_name = device_name  # type: list[unicode]
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.target_aliyun_id = TeaConverter.to_unicode(target_aliyun_id)  # type: unicode
        self.target_instance_config = target_instance_config  # type: list[CreateDeviceDistributeJobRequestTargetInstanceConfig]
        self.strategy = strategy  # type: int

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_instance_config, 'target_instance_config')
        if self.target_instance_config:
            for k in self.target_instance_config:
                if k:
                    k.validate()
        self.validate_required(self.strategy, 'strategy')

    def to_map(self):
        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        result['TargetInstanceConfig'] = []
        if self.target_instance_config is not None:
            for k in self.target_instance_config:
                result['TargetInstanceConfig'].append(k.to_map() if k else None)
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        self.target_instance_config = []
        if m.get('TargetInstanceConfig') is not None:
            for k in m.get('TargetInstanceConfig'):
                temp_model = CreateDeviceDistributeJobRequestTargetInstanceConfig()
                self.target_instance_config.append(temp_model.from_map(k))
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateDeviceDistributeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, job_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeDetailRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeDetailResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, file=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.file = TeaConverter.to_unicode(file)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.file, 'file')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.file is not None:
            result['File'] = self.file
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('File') is not None:
            self.file = m.get('File')
        return self


class ListDeviceDistributeJobRequest(TeaModel):
    def __init__(self, target_uid=None, current_page=None, page_size=None, status=None):
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.status = status  # type: int

    def validate(self):
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_configs=None):
        self.target_instance_configs = target_instance_configs  # type: list[ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs]

    def validate(self):
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseDataJobInfoItems(TeaModel):
    def __init__(self, gmt_create=None, source_uid=None, target_uid=None, job_id=None, source_instance_id=None,
                 product_key=None, total=None, status=None, strategy=None, target_instance_configs=None):
        self.gmt_create = gmt_create  # type: long
        self.source_uid = TeaConverter.to_unicode(source_uid)  # type: unicode
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.total = total  # type: int
        self.status = status  # type: int
        self.strategy = strategy  # type: int
        self.target_instance_configs = target_instance_configs  # type: ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.total, 'total')
        self.validate_required(self.status, 'status')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.total is not None:
            result['Total'] = self.total
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = ListDeviceDistributeJobResponseDataJobInfoItemsTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class ListDeviceDistributeJobResponseDataJobInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDeviceDistributeJobResponseDataJobInfoItems]

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDeviceDistributeJobResponseDataJobInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseData(TeaModel):
    def __init__(self, total=None, job_info=None):
        self.total = total  # type: int
        self.job_info = job_info  # type: ListDeviceDistributeJobResponseDataJobInfo

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.job_info, 'job_info')
        if self.job_info:
            self.job_info.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.job_info is not None:
            result['JobInfo'] = self.job_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('JobInfo') is not None:
            temp_model = ListDeviceDistributeJobResponseDataJobInfo()
            self.job_info = temp_model.from_map(m['JobInfo'])
        return self


class ListDeviceDistributeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: ListDeviceDistributeJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDeviceDistributeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDistributeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeJobResponseDataTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = TeaConverter.to_unicode(target_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.target_instance_id, 'target_instance_id')

    def to_map(self):
        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class QueryDeviceDistributeJobResponseDataTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_configs=None):
        self.target_instance_configs = target_instance_configs  # type: list[QueryDeviceDistributeJobResponseDataTargetInstanceConfigsTargetInstanceConfigs]

    def validate(self):
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = QueryDeviceDistributeJobResponseDataTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class QueryDeviceDistributeJobResponseData(TeaModel):
    def __init__(self, source_uid=None, target_uid=None, source_instance_id=None, job_id=None, product_key=None,
                 total=None, status=None, gmt_create=None, strategy=None, target_instance_configs=None):
        self.source_uid = TeaConverter.to_unicode(source_uid)  # type: unicode
        self.target_uid = TeaConverter.to_unicode(target_uid)  # type: unicode
        self.source_instance_id = TeaConverter.to_unicode(source_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.total = total  # type: int
        self.status = status  # type: int
        self.gmt_create = gmt_create  # type: long
        self.strategy = strategy  # type: int
        self.target_instance_configs = target_instance_configs  # type: QueryDeviceDistributeJobResponseDataTargetInstanceConfigs

    def validate(self):
        self.validate_required(self.source_uid, 'source_uid')
        self.validate_required(self.target_uid, 'target_uid')
        self.validate_required(self.source_instance_id, 'source_instance_id')
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.total, 'total')
        self.validate_required(self.status, 'status')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.target_instance_configs, 'target_instance_configs')
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.total is not None:
            result['Total'] = self.total
        if self.status is not None:
            result['Status'] = self.status
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = QueryDeviceDistributeJobResponseDataTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class QueryDeviceDistributeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceDistributeJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDistributeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteDeviceDistributeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteDeviceDistributeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceByStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, status=None, current_page=None, page_size=None,
                 resource_group_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.status = status  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.status is not None:
            result['Status'] = self.status
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class QueryDeviceByStatusResponseDataSimpleDeviceInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, status=None, iot_id=None, nickname=None, gmt_create=None,
                 gmt_modified=None, utc_create=None, utc_modified=None, device_secret=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.device_secret = TeaConverter.to_unicode(device_secret)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.device_secret, 'device_secret')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        return self


class QueryDeviceByStatusResponseData(TeaModel):
    def __init__(self, simple_device_info=None):
        self.simple_device_info = simple_device_info  # type: list[QueryDeviceByStatusResponseDataSimpleDeviceInfo]

    def validate(self):
        self.validate_required(self.simple_device_info, 'simple_device_info')
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByStatusResponseDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByStatusResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceByStatusResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByStatusResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None, file_suffix=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.file_suffix = TeaConverter.to_unicode(file_suffix)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        return self


class GenerateOTAUploadURLResponseData(TeaModel):
    def __init__(self, key=None, host=None, policy=None, ossaccess_key_id=None, signature=None, firmware_url=None,
                 utc_create=None, object_storage=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.ossaccess_key_id = TeaConverter.to_unicode(ossaccess_key_id)  # type: unicode
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.firmware_url = TeaConverter.to_unicode(firmware_url)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.object_storage = TeaConverter.to_unicode(object_storage)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.host, 'host')
        self.validate_required(self.policy, 'policy')
        self.validate_required(self.ossaccess_key_id, 'ossaccess_key_id')
        self.validate_required(self.signature, 'signature')
        self.validate_required(self.firmware_url, 'firmware_url')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.object_storage, 'object_storage')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GenerateOTAUploadURLResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryProductCertInfoRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class QueryProductCertInfoResponseProductCertInfo(TeaModel):
    def __init__(self, issue_model=None):
        self.issue_model = issue_model  # type: int

    def validate(self):
        self.validate_required(self.issue_model, 'issue_model')

    def to_map(self):
        result = dict()
        if self.issue_model is not None:
            result['IssueModel'] = self.issue_model
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IssueModel') is not None:
            self.issue_model = m.get('IssueModel')
        return self


class QueryProductCertInfoResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, product_cert_info=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.product_cert_info = product_cert_info  # type: QueryProductCertInfoResponseProductCertInfo

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_cert_info, 'product_cert_info')
        if self.product_cert_info:
            self.product_cert_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_cert_info is not None:
            result['ProductCertInfo'] = self.product_cert_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductCertInfo') is not None:
            temp_model = QueryProductCertInfoResponseProductCertInfo()
            self.product_cert_info = temp_model.from_map(m['ProductCertInfo'])
        return self


class SetProductCertInfoRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, issue_model=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.issue_model = issue_model  # type: int

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.issue_model, 'issue_model')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.issue_model is not None:
            result['IssueModel'] = self.issue_model
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IssueModel') is not None:
            self.issue_model = m.get('IssueModel')
        return self


class SetProductCertInfoResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_data_flag=None, device_life_cycle_flag=None,
                 device_status_change_flag=None, device_topo_life_cycle_flag=None, found_device_list_flag=None, mns_configuration=None,
                 type=None, consumer_group_ids=None, ota_event_flag=None, thing_history_flag=None, device_tag_flag=None,
                 ota_version_flag=None, ota_job_flag=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_data_flag = device_data_flag  # type: bool
        self.device_life_cycle_flag = device_life_cycle_flag  # type: bool
        self.device_status_change_flag = device_status_change_flag  # type: bool
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag  # type: bool
        self.found_device_list_flag = found_device_list_flag  # type: bool
        self.mns_configuration = TeaConverter.to_unicode(mns_configuration)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.consumer_group_ids = consumer_group_ids  # type: list[unicode]
        self.ota_event_flag = ota_event_flag  # type: bool
        self.thing_history_flag = thing_history_flag  # type: bool
        self.device_tag_flag = device_tag_flag  # type: bool
        self.ota_version_flag = ota_version_flag  # type: bool
        self.ota_job_flag = ota_job_flag  # type: bool

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.type is not None:
            result['Type'] = self.type
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, type=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryConsumerGroupStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupStatusResponseClientConnectionStatusListConsumerGroupClientConnectionInfo(TeaModel):
    def __init__(self, client_id=None, client_ip_port=None, online_time=None):
        self.client_id = TeaConverter.to_unicode(client_id)  # type: unicode
        self.client_ip_port = TeaConverter.to_unicode(client_ip_port)  # type: unicode
        self.online_time = online_time  # type: long

    def validate(self):
        self.validate_required(self.client_id, 'client_id')
        self.validate_required(self.client_ip_port, 'client_ip_port')
        self.validate_required(self.online_time, 'online_time')

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_ip_port is not None:
            result['ClientIpPort'] = self.client_ip_port
        if self.online_time is not None:
            result['OnlineTime'] = self.online_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientIpPort') is not None:
            self.client_ip_port = m.get('ClientIpPort')
        if m.get('OnlineTime') is not None:
            self.online_time = m.get('OnlineTime')
        return self


class QueryConsumerGroupStatusResponseClientConnectionStatusList(TeaModel):
    def __init__(self, consumer_group_client_connection_info=None):
        self.consumer_group_client_connection_info = consumer_group_client_connection_info  # type: list[QueryConsumerGroupStatusResponseClientConnectionStatusListConsumerGroupClientConnectionInfo]

    def validate(self):
        self.validate_required(self.consumer_group_client_connection_info, 'consumer_group_client_connection_info')
        if self.consumer_group_client_connection_info:
            for k in self.consumer_group_client_connection_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupClientConnectionInfo'] = []
        if self.consumer_group_client_connection_info is not None:
            for k in self.consumer_group_client_connection_info:
                result['ConsumerGroupClientConnectionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.consumer_group_client_connection_info = []
        if m.get('ConsumerGroupClientConnectionInfo') is not None:
            for k in m.get('ConsumerGroupClientConnectionInfo'):
                temp_model = QueryConsumerGroupStatusResponseClientConnectionStatusListConsumerGroupClientConnectionInfo()
                self.consumer_group_client_connection_info.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupStatusResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, accumulation_count=None,
                 consumer_speed=None, last_consumer_time=None, code=None, client_connection_status_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.accumulation_count = accumulation_count  # type: int
        self.consumer_speed = consumer_speed  # type: int
        self.last_consumer_time = TeaConverter.to_unicode(last_consumer_time)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.client_connection_status_list = client_connection_status_list  # type: QueryConsumerGroupStatusResponseClientConnectionStatusList

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.accumulation_count, 'accumulation_count')
        self.validate_required(self.consumer_speed, 'consumer_speed')
        self.validate_required(self.last_consumer_time, 'last_consumer_time')
        self.validate_required(self.code, 'code')
        self.validate_required(self.client_connection_status_list, 'client_connection_status_list')
        if self.client_connection_status_list:
            self.client_connection_status_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.accumulation_count is not None:
            result['AccumulationCount'] = self.accumulation_count
        if self.consumer_speed is not None:
            result['ConsumerSpeed'] = self.consumer_speed
        if self.last_consumer_time is not None:
            result['LastConsumerTime'] = self.last_consumer_time
        if self.code is not None:
            result['Code'] = self.code
        if self.client_connection_status_list is not None:
            result['ClientConnectionStatusList'] = self.client_connection_status_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AccumulationCount') is not None:
            self.accumulation_count = m.get('AccumulationCount')
        if m.get('ConsumerSpeed') is not None:
            self.consumer_speed = m.get('ConsumerSpeed')
        if m.get('LastConsumerTime') is not None:
            self.last_consumer_time = m.get('LastConsumerTime')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ClientConnectionStatusList') is not None:
            temp_model = QueryConsumerGroupStatusResponseClientConnectionStatusList()
            self.client_connection_status_list = temp_model.from_map(m['ClientConnectionStatusList'])
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class QueryConsumerGroupListRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, current_page=None, fuzzy=None, group_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.fuzzy = fuzzy  # type: bool
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy is not None:
            result['Fuzzy'] = self.fuzzy
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Fuzzy') is not None:
            self.fuzzy = m.get('Fuzzy')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryConsumerGroupListResponseDataConsumerGroupDTO(TeaModel):
    def __init__(self, group_id=None, group_name=None, create_time=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.create_time = TeaConverter.to_unicode(create_time)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupListResponseData(TeaModel):
    def __init__(self, consumer_group_dto=None):
        self.consumer_group_dto = consumer_group_dto  # type: list[QueryConsumerGroupListResponseDataConsumerGroupDTO]

    def validate(self):
        self.validate_required(self.consumer_group_dto, 'consumer_group_dto')
        if self.consumer_group_dto:
            for k in self.consumer_group_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupDTO'] = []
        if self.consumer_group_dto is not None:
            for k in self.consumer_group_dto:
                result['ConsumerGroupDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.consumer_group_dto = []
        if m.get('ConsumerGroupDTO') is not None:
            for k in m.get('ConsumerGroupDTO'):
                temp_model = QueryConsumerGroupListResponseDataConsumerGroupDTO()
                self.consumer_group_dto.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupListResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, page_size=None, page_count=None,
                 total=None, current_page=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.current_page = current_page  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: QueryConsumerGroupListResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupListResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupByGroupIdRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupByGroupIdResponseData(TeaModel):
    def __init__(self, group_id=None, group_name=None, create_time=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.create_time = TeaConverter.to_unicode(create_time)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupByGroupIdResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: QueryConsumerGroupByGroupIdResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, group_id=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, product_key=None, src_version=None,
                 retry_interval=None, retry_count=None, timeout_in_minutes=None, maximum_per_minute=None, overwrite_mode=None,
                 dynamic_mode=None, tag=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.src_version = src_version  # type: list[unicode]
        self.retry_interval = retry_interval  # type: int
        self.retry_count = retry_count  # type: int
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.overwrite_mode = overwrite_mode  # type: int
        self.dynamic_mode = dynamic_mode  # type: int
        self.tag = tag  # type: list[CreateOTADynamicUpgradeJobRequestTag]

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateOTADynamicUpgradeJobResponseData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: CreateOTADynamicUpgradeJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, product_key=None, target_selection=None,
                 src_version=None, schedule_time=None, retry_interval=None, retry_count=None, timeout_in_minutes=None,
                 maximum_per_minute=None, gray_percent=None, target_device_name=None, schedule_finish_time=None, overwrite_mode=None,
                 tag=None, dn_list_file_url=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.target_selection = TeaConverter.to_unicode(target_selection)  # type: unicode
        self.src_version = src_version  # type: list[unicode]
        self.schedule_time = schedule_time  # type: long
        self.retry_interval = retry_interval  # type: int
        self.retry_count = retry_count  # type: int
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.gray_percent = TeaConverter.to_unicode(gray_percent)  # type: unicode
        self.target_device_name = target_device_name  # type: list[unicode]
        self.schedule_finish_time = schedule_finish_time  # type: long
        self.overwrite_mode = overwrite_mode  # type: int
        self.tag = tag  # type: list[CreateOTAStaticUpgradeJobRequestTag]
        self.dn_list_file_url = TeaConverter.to_unicode(dn_list_file_url)  # type: unicode

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_selection, 'target_selection')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        return self


class CreateOTAStaticUpgradeJobResponseData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: CreateOTAStaticUpgradeJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_name=None, dest_version=None, firmware_url=None,
                 firmware_sign=None, sign_method=None, firmware_size=None, product_key=None, firmware_desc=None, type=None,
                 src_version=None, module_name=None, need_to_verify=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_name = TeaConverter.to_unicode(firmware_name)  # type: unicode
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.firmware_url = TeaConverter.to_unicode(firmware_url)  # type: unicode
        self.firmware_sign = TeaConverter.to_unicode(firmware_sign)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.firmware_size = firmware_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_desc = TeaConverter.to_unicode(firmware_desc)  # type: unicode
        self.type = type  # type: int
        self.src_version = TeaConverter.to_unicode(src_version)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.need_to_verify = need_to_verify  # type: bool

    def validate(self):
        self.validate_required(self.firmware_name, 'firmware_name')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.firmware_url, 'firmware_url')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.type is not None:
            result['Type'] = self.type
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        return self


class CreateOTAFirmwareResponseData(TeaModel):
    def __init__(self, firmware_id=None, utc_create=None):
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: CreateOTAFirmwareResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, timeout_in_minutes=None, product_key=None,
                 target_device_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.target_device_name = target_device_name  # type: list[unicode]

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.target_device_name, 'target_device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        return self


class CreateOTAVerifyJobResponseData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: CreateOTAVerifyJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryOTAJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryOTAJobResponseDataTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryOTAJobResponseDataTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[QueryOTAJobResponseDataTagsOtaTagDTO]

    def validate(self):
        self.validate_required(self.ota_tag_dto, 'ota_tag_dto')
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = QueryOTAJobResponseDataTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class QueryOTAJobResponseDataSrcVersions(TeaModel):
    def __init__(self, src_version=None):
        # SrcVersion
        self.src_version = src_version  # type: list[unicode]

    def validate(self):
        self.validate_required(self.src_version, 'src_version')

    def to_map(self):
        result = dict()
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        return self


class QueryOTAJobResponseData(TeaModel):
    def __init__(self, job_id=None, utc_create=None, utc_modified=None, product_key=None, firmware_id=None,
                 utc_start_time=None, utc_end_time=None, job_status=None, job_type=None, job_desc=None, name=None,
                 utc_schedule_time=None, retry_interval=None, retry_count=None, timeout_in_minutes=None, target_selection=None,
                 selection_type=None, gray_percent=None, maximum_per_minute=None, dest_version=None,
                 utc_schedule_finish_time=None, overwrite_mode=None, dynamic_mode=None, tags=None, src_versions=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.utc_start_time = TeaConverter.to_unicode(utc_start_time)  # type: unicode
        self.utc_end_time = TeaConverter.to_unicode(utc_end_time)  # type: unicode
        self.job_status = TeaConverter.to_unicode(job_status)  # type: unicode
        self.job_type = TeaConverter.to_unicode(job_type)  # type: unicode
        self.job_desc = TeaConverter.to_unicode(job_desc)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.utc_schedule_time = TeaConverter.to_unicode(utc_schedule_time)  # type: unicode
        self.retry_interval = retry_interval  # type: int
        self.retry_count = retry_count  # type: int
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.target_selection = TeaConverter.to_unicode(target_selection)  # type: unicode
        self.selection_type = TeaConverter.to_unicode(selection_type)  # type: unicode
        self.gray_percent = TeaConverter.to_unicode(gray_percent)  # type: unicode
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.utc_schedule_finish_time = TeaConverter.to_unicode(utc_schedule_finish_time)  # type: unicode
        self.overwrite_mode = overwrite_mode  # type: int
        self.dynamic_mode = dynamic_mode  # type: int
        self.tags = tags  # type: QueryOTAJobResponseDataTags
        self.src_versions = src_versions  # type: QueryOTAJobResponseDataSrcVersions

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.utc_start_time, 'utc_start_time')
        self.validate_required(self.utc_end_time, 'utc_end_time')
        self.validate_required(self.job_status, 'job_status')
        self.validate_required(self.job_type, 'job_type')
        self.validate_required(self.job_desc, 'job_desc')
        self.validate_required(self.name, 'name')
        self.validate_required(self.utc_schedule_time, 'utc_schedule_time')
        self.validate_required(self.retry_interval, 'retry_interval')
        self.validate_required(self.retry_count, 'retry_count')
        self.validate_required(self.timeout_in_minutes, 'timeout_in_minutes')
        self.validate_required(self.target_selection, 'target_selection')
        self.validate_required(self.selection_type, 'selection_type')
        self.validate_required(self.gray_percent, 'gray_percent')
        self.validate_required(self.maximum_per_minute, 'maximum_per_minute')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.utc_schedule_finish_time, 'utc_schedule_finish_time')
        self.validate_required(self.overwrite_mode, 'overwrite_mode')
        self.validate_required(self.dynamic_mode, 'dynamic_mode')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.src_versions, 'src_versions')
        if self.src_versions:
            self.src_versions.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.job_desc is not None:
            result['JobDesc'] = self.job_desc
        if self.name is not None:
            result['Name'] = self.name
        if self.utc_schedule_time is not None:
            result['UtcScheduleTime'] = self.utc_schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_schedule_finish_time is not None:
            result['UtcScheduleFinishTime'] = self.utc_schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.src_versions is not None:
            result['SrcVersions'] = self.src_versions.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('JobDesc') is not None:
            self.job_desc = m.get('JobDesc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UtcScheduleTime') is not None:
            self.utc_schedule_time = m.get('UtcScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcScheduleFinishTime') is not None:
            self.utc_schedule_finish_time = m.get('UtcScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        if m.get('Tags') is not None:
            temp_model = QueryOTAJobResponseDataTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('SrcVersions') is not None:
            temp_model = QueryOTAJobResponseDataSrcVersions()
            self.src_versions = temp_model.from_map(m['SrcVersions'])
        return self


class QueryOTAJobResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryOTAJobResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryOTAJobResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, product_key=None, device_name=None, job_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = device_name  # type: list[unicode]
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryOTAFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode

    def validate(self):
        self.validate_required(self.firmware_id, 'firmware_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class QueryOTAFirmwareResponseFirmwareInfo(TeaModel):
    def __init__(self, firmware_name=None, firmware_id=None, src_version=None, dest_version=None, utc_create=None,
                 utc_modified=None, status=None, firmware_desc=None, firmware_sign=None, firmware_size=None, firmware_url=None,
                 product_key=None, sign_method=None, product_name=None, type=None, verify_progress=None, module_name=None):
        self.firmware_name = TeaConverter.to_unicode(firmware_name)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.src_version = TeaConverter.to_unicode(src_version)  # type: unicode
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status = status  # type: int
        self.firmware_desc = TeaConverter.to_unicode(firmware_desc)  # type: unicode
        self.firmware_sign = TeaConverter.to_unicode(firmware_sign)  # type: unicode
        self.firmware_size = firmware_size  # type: int
        self.firmware_url = TeaConverter.to_unicode(firmware_url)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.type = type  # type: int
        self.verify_progress = verify_progress  # type: int
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode

    def validate(self):
        self.validate_required(self.firmware_name, 'firmware_name')
        self.validate_required(self.firmware_id, 'firmware_id')
        self.validate_required(self.src_version, 'src_version')
        self.validate_required(self.dest_version, 'dest_version')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status, 'status')
        self.validate_required(self.firmware_desc, 'firmware_desc')
        self.validate_required(self.firmware_sign, 'firmware_sign')
        self.validate_required(self.firmware_size, 'firmware_size')
        self.validate_required(self.firmware_url, 'firmware_url')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.sign_method, 'sign_method')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.verify_progress, 'verify_progress')
        self.validate_required(self.module_name, 'module_name')

    def to_map(self):
        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.verify_progress is not None:
            result['VerifyProgress'] = self.verify_progress
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VerifyProgress') is not None:
            self.verify_progress = m.get('VerifyProgress')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class QueryOTAFirmwareResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, firmware_info=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.firmware_info = firmware_info  # type: QueryOTAFirmwareResponseFirmwareInfo

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.firmware_info, 'firmware_info')
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FirmwareInfo') is not None:
            temp_model = QueryOTAFirmwareResponseFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class UnbindApplicationFromEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, application_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.application_id = TeaConverter.to_unicode(application_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.application_id, 'application_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class UnbindApplicationFromEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, application_id=None, application_version=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.application_id = TeaConverter.to_unicode(application_id)  # type: unicode
        self.application_version = TeaConverter.to_unicode(application_version)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.application_id, 'application_id')
        self.validate_required(self.application_version, 'application_version')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryCertUrlByApplyIdRequest(TeaModel):
    def __init__(self, iot_instance_id=None, apply_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.apply_id = apply_id  # type: long

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryCertUrlByApplyIdResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, cert_url=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.cert_url = TeaConverter.to_unicode(cert_url)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.cert_url, 'cert_url')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.cert_url is not None:
            result['CertUrl'] = self.cert_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CertUrl') is not None:
            self.cert_url = m.get('CertUrl')
        return self


class QueryDeviceCertRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryDeviceCertResponseDeviceCertInfo(TeaModel):
    def __init__(self, status=None, certificate=None, private_key=None, cert_sn=None):
        self.status = status  # type: int
        self.certificate = TeaConverter.to_unicode(certificate)  # type: unicode
        self.private_key = TeaConverter.to_unicode(private_key)  # type: unicode
        self.cert_sn = TeaConverter.to_unicode(cert_sn)  # type: unicode

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.certificate, 'certificate')
        self.validate_required(self.private_key, 'private_key')
        self.validate_required(self.cert_sn, 'cert_sn')

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.cert_sn is not None:
            result['CertSN'] = self.cert_sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('CertSN') is not None:
            self.cert_sn = m.get('CertSN')
        return self


class QueryDeviceCertResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_cert_info=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.device_cert_info = device_cert_info  # type: QueryDeviceCertResponseDeviceCertInfo

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_cert_info, 'device_cert_info')
        if self.device_cert_info:
            self.device_cert_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.device_cert_info is not None:
            result['DeviceCertInfo'] = self.device_cert_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeviceCertInfo') is not None:
            temp_model = QueryDeviceCertResponseDeviceCertInfo()
            self.device_cert_info = temp_model.from_map(m['DeviceCertInfo'])
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UnbindDriverFromEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class UnbindDriverFromEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ReplaceEdgeInstanceGatewayRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, current_gateway_id=None, new_gateway_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.current_gateway_id = TeaConverter.to_unicode(current_gateway_id)  # type: unicode
        self.new_gateway_id = TeaConverter.to_unicode(new_gateway_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_gateway_id, 'current_gateway_id')
        self.validate_required(self.new_gateway_id, 'new_gateway_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_gateway_id is not None:
            result['CurrentGatewayId'] = self.current_gateway_id
        if self.new_gateway_id is not None:
            result['NewGatewayId'] = self.new_gateway_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentGatewayId') is not None:
            self.current_gateway_id = m.get('CurrentGatewayId')
        if m.get('NewGatewayId') is not None:
            self.new_gateway_id = m.get('NewGatewayId')
        return self


class ReplaceEdgeInstanceGatewayResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, driver_version=None, order_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.order_id = TeaConverter.to_unicode(order_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(self, device_name=None, product_key=None, iot_instance_id=None):
        self.device_name = device_name  # type: list[unicode]
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchQueryDeviceDetailResponseDataData(TeaModel):
    def __init__(self, product_key=None, product_name=None, device_name=None, nickname=None, device_secret=None,
                 iot_id=None, utc_create=None, gmt_create=None, utc_active=None, gmt_active=None, status=None,
                 firmware_version=None, node_type=None, region=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.device_secret = TeaConverter.to_unicode(device_secret)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.utc_active = TeaConverter.to_unicode(utc_active)  # type: unicode
        self.gmt_active = TeaConverter.to_unicode(gmt_active)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.firmware_version = TeaConverter.to_unicode(firmware_version)  # type: unicode
        self.node_type = node_type  # type: int
        self.region = TeaConverter.to_unicode(region)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.nickname, 'nickname')
        self.validate_required(self.device_secret, 'device_secret')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.utc_create, 'utc_create')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.utc_active, 'utc_active')
        self.validate_required(self.gmt_active, 'gmt_active')
        self.validate_required(self.status, 'status')
        self.validate_required(self.firmware_version, 'firmware_version')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.region, 'region')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class BatchQueryDeviceDetailResponseData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[BatchQueryDeviceDetailResponseDataData]

    def validate(self):
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: BatchQueryDeviceDetailResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, deployment_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.deployment_id = TeaConverter.to_unicode(deployment_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.deployment_id, 'deployment_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, gmt_completed=None, snapshot_id=None, resource_type=None,
                 resource_id=None, resource_name=None, operate_type=None, stage=None, status=None, log=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, gmt_completed_timestamp=None):
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.gmt_completed = TeaConverter.to_unicode(gmt_completed)  # type: unicode
        self.snapshot_id = TeaConverter.to_unicode(snapshot_id)  # type: unicode
        self.resource_type = TeaConverter.to_unicode(resource_type)  # type: unicode
        self.resource_id = TeaConverter.to_unicode(resource_id)  # type: unicode
        self.resource_name = TeaConverter.to_unicode(resource_name)  # type: unicode
        self.operate_type = operate_type  # type: int
        self.stage = stage  # type: int
        self.status = status  # type: int
        self.log = TeaConverter.to_unicode(log)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_name, 'resource_name')
        self.validate_required(self.operate_type, 'operate_type')
        self.validate_required(self.stage, 'stage')
        self.validate_required(self.status, 'status')
        self.validate_required(self.log, 'log')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.log is not None:
            result['Log'] = self.log
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        return self


class GetEdgeInstanceDeploymentResponseDataTaskList(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, gmt_completed=None, gateway_id=None, task_id=None,
                 stage=None, status=None, gmt_create_timestamp=None, gmt_modified_timestamp=None,
                 gmt_completed_timestamp=None, resource_snapshot_list=None):
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.gmt_completed = TeaConverter.to_unicode(gmt_completed)  # type: unicode
        self.gateway_id = TeaConverter.to_unicode(gateway_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.stage = stage  # type: int
        self.status = status  # type: int
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.resource_snapshot_list = resource_snapshot_list  # type: list[GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList]

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.gateway_id, 'gateway_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.stage, 'stage')
        self.validate_required(self.status, 'status')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')
        self.validate_required(self.resource_snapshot_list, 'resource_snapshot_list')
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponseData(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, gmt_completed=None, deployment_id=None, description=None,
                 status=None, type=None, gmt_create_timestamp=None, gmt_modified_timestamp=None,
                 gmt_completed_timestamp=None, task_list=None):
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.gmt_completed = TeaConverter.to_unicode(gmt_completed)  # type: unicode
        self.deployment_id = TeaConverter.to_unicode(deployment_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.status = status  # type: int
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.task_list = task_list  # type: list[GetEdgeInstanceDeploymentResponseDataTaskList]

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.deployment_id, 'deployment_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')
        self.validate_required(self.task_list, 'task_list')
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GetEdgeInstanceDeploymentResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class QueryTaskResponseData(TeaModel):
    def __init__(self, job_id=None, job_name=None, task_id=None, product_key=None, device_name=None, iot_id=None,
                 progress=None, utc_queue_time=None, utc_modified=None, status_detail=None, status=None, message=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.progress = TeaConverter.to_unicode(progress)  # type: unicode
        self.utc_queue_time = TeaConverter.to_unicode(utc_queue_time)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status_detail = TeaConverter.to_unicode(status_detail)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode

    def validate(self):
        self.validate_required(self.job_id, 'job_id')
        self.validate_required(self.job_name, 'job_name')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.utc_queue_time, 'utc_queue_time')
        self.validate_required(self.utc_modified, 'utc_modified')
        self.validate_required(self.status_detail, 'status_detail')
        self.validate_required(self.status, 'status')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class QueryTaskResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryTaskResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryTaskResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(self, display_name=None, origin_sql=None, request_param=None, desc=None, response_param=None,
                 template_sql=None, api_path=None, iot_instance_id=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.origin_sql = TeaConverter.to_unicode(origin_sql)  # type: unicode
        self.request_param = request_param  # type: list[CreateDataAPIServiceRequestRequestParam]
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.response_param = response_param  # type: list[CreateDataAPIServiceRequestResponseParam]
        self.template_sql = TeaConverter.to_unicode(template_sql)  # type: unicode
        self.api_path = TeaConverter.to_unicode(api_path)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.display_name, 'display_name')
        self.validate_required(self.origin_sql, 'origin_sql')
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()
        self.validate_required(self.template_sql, 'template_sql')
        self.validate_required(self.api_path, 'api_path')

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        if self.desc is not None:
            result['Desc'] = self.desc
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDataAPIServiceResponseData(TeaModel):
    def __init__(self, api_srn=None, create_time=None, last_update_time=None):
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.last_update_time, 'last_update_time')

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: CreateDataAPIServiceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(self, api_srn=None, iot_instance_id=None):
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.required = required  # type: bool

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.example, 'example')
        self.validate_required(self.required, 'required')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(self, request_params=None):
        self.request_params = request_params  # type: list[GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams]

    def validate(self):
        self.validate_required(self.request_params, 'request_params')
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.required = required  # type: bool

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.example, 'example')
        self.validate_required(self.required, 'required')

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(self, response_params=None):
        self.response_params = response_params  # type: list[GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams]

    def validate(self):
        self.validate_required(self.response_params, 'response_params')
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseDataSqlTemplateDTO(TeaModel):
    def __init__(self, origin_sql=None, template_sql=None, request_params=None, response_params=None):
        self.origin_sql = TeaConverter.to_unicode(origin_sql)  # type: unicode
        self.template_sql = TeaConverter.to_unicode(template_sql)  # type: unicode
        self.request_params = request_params  # type: GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams
        self.response_params = response_params  # type: GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams

    def validate(self):
        self.validate_required(self.origin_sql, 'origin_sql')
        self.validate_required(self.template_sql, 'template_sql')
        self.validate_required(self.request_params, 'request_params')
        if self.request_params:
            self.request_params.validate()
        self.validate_required(self.response_params, 'response_params')
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        result = dict()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        return self


class GetDataAPIServiceDetailResponseData(TeaModel):
    def __init__(self, api_srn=None, status=None, display_name=None, api_path=None, create_time=None,
                 last_update_time=None, date_format=None, request_method=None, request_protocol=None, description=None,
                 sql_template_dto=None):
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.status = status  # type: int
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.api_path = TeaConverter.to_unicode(api_path)  # type: unicode
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long
        self.date_format = TeaConverter.to_unicode(date_format)  # type: unicode
        self.request_method = TeaConverter.to_unicode(request_method)  # type: unicode
        self.request_protocol = TeaConverter.to_unicode(request_protocol)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.sql_template_dto = sql_template_dto  # type: GetDataAPIServiceDetailResponseDataSqlTemplateDTO

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.status, 'status')
        self.validate_required(self.display_name, 'display_name')
        self.validate_required(self.api_path, 'api_path')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.last_update_time, 'last_update_time')
        self.validate_required(self.date_format, 'date_format')
        self.validate_required(self.request_method, 'request_method')
        self.validate_required(self.request_protocol, 'request_protocol')
        self.validate_required(self.description, 'description')
        self.validate_required(self.sql_template_dto, 'sql_template_dto')
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.status is not None:
            result['Status'] = self.status
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.description is not None:
            result['Description'] = self.description
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GetDataAPIServiceDetailResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeDataAPIServiceRequestParam(TeaModel):
    def __init__(self, param_type=None, list_param_value=None, list_param_type=None, param_name=None,
                 param_value=None):
        self.param_type = TeaConverter.to_unicode(param_type)  # type: unicode
        self.list_param_value = list_param_value  # type: list[unicode]
        self.list_param_type = TeaConverter.to_unicode(list_param_type)  # type: unicode
        self.param_name = TeaConverter.to_unicode(param_name)  # type: unicode
        self.param_value = TeaConverter.to_unicode(param_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.list_param_value is not None:
            result['ListParamValue'] = self.list_param_value
        if self.list_param_type is not None:
            result['ListParamType'] = self.list_param_type
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ListParamValue') is not None:
            self.list_param_value = m.get('ListParamValue')
        if m.get('ListParamType') is not None:
            self.list_param_type = m.get('ListParamType')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        return self


class InvokeDataAPIServiceRequest(TeaModel):
    def __init__(self, api_srn=None, param=None, iot_instance_id=None):
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.param = param  # type: list[InvokeDataAPIServiceRequestParam]
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.api_srn, 'api_srn')
        if self.param:
            for k in self.param:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        result['Param'] = []
        if self.param is not None:
            for k in self.param:
                result['Param'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        self.param = []
        if m.get('Param') is not None:
            for k in m.get('Param'):
                temp_model = InvokeDataAPIServiceRequestParam()
                self.param.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class InvokeDataAPIServiceResponseDataFieldNameList(TeaModel):
    def __init__(self, field_name_list=None):
        # FieldNameList
        self.field_name_list = field_name_list  # type: list[unicode]

    def validate(self):
        self.validate_required(self.field_name_list, 'field_name_list')

    def to_map(self):
        result = dict()
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FieldNameList') is not None:
            self.field_name_list = m.get('FieldNameList')
        return self


class InvokeDataAPIServiceResponseDataResultList(TeaModel):
    def __init__(self, result_list=None):
        # ResultList
        self.result_list = result_list  # type: list[dict[unicode, any]]

    def validate(self):
        self.validate_required(self.result_list, 'result_list')

    def to_map(self):
        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResultList') is not None:
            self.result_list = m.get('ResultList')
        return self


class InvokeDataAPIServiceResponseData(TeaModel):
    def __init__(self, page_no=None, page_size=None, api_srn=None, field_name_list=None, result_list=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.field_name_list = field_name_list  # type: InvokeDataAPIServiceResponseDataFieldNameList
        self.result_list = result_list  # type: InvokeDataAPIServiceResponseDataResultList

    def validate(self):
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.api_srn, 'api_srn')
        self.validate_required(self.field_name_list, 'field_name_list')
        if self.field_name_list:
            self.field_name_list.validate()
        self.validate_required(self.result_list, 'result_list')
        if self.result_list:
            self.result_list.validate()

    def to_map(self):
        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list.to_map()
        if self.result_list is not None:
            result['ResultList'] = self.result_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('FieldNameList') is not None:
            temp_model = InvokeDataAPIServiceResponseDataFieldNameList()
            self.field_name_list = temp_model.from_map(m['FieldNameList'])
        if m.get('ResultList') is not None:
            temp_model = InvokeDataAPIServiceResponseDataResultList()
            self.result_list = temp_model.from_map(m['ResultList'])
        return self


class InvokeDataAPIServiceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: InvokeDataAPIServiceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = InvokeDataAPIServiceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class UpdateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(self, format=None, content=None, key=None):
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.key = TeaConverter.to_unicode(key)  # type: unicode

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class UpdateEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_id=None, channel_name=None,
                 configs=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.configs = configs  # type: list[UpdateEdgeInstanceChannelRequestConfigs]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = UpdateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class UpdateEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_name=None, current_page=None,
                 page_size=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceChannelResponseDataChannelListChannelConfigListConfig(TeaModel):
    def __init__(self, config_id=None, format=None, content=None, key=None):
        self.config_id = TeaConverter.to_unicode(config_id)  # type: unicode
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.key = TeaConverter.to_unicode(key)  # type: unicode

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')
        self.validate_required(self.key, 'key')

    def to_map(self):
        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class QueryEdgeInstanceChannelResponseDataChannelListChannelConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[QueryEdgeInstanceChannelResponseDataChannelListChannelConfigListConfig]

    def validate(self):
        self.validate_required(self.config, 'config')
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = QueryEdgeInstanceChannelResponseDataChannelListChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceChannelResponseDataChannelListChannel(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, gmt_create=None, gmt_modified=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, config_list=None):
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.config_list = config_list  # type: QueryEdgeInstanceChannelResponseDataChannelListChannelConfigList

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('ConfigList') is not None:
            temp_model = QueryEdgeInstanceChannelResponseDataChannelListChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class QueryEdgeInstanceChannelResponseDataChannelList(TeaModel):
    def __init__(self, channel=None):
        self.channel = channel  # type: list[QueryEdgeInstanceChannelResponseDataChannelListChannel]

    def validate(self):
        self.validate_required(self.channel, 'channel')
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = QueryEdgeInstanceChannelResponseDataChannelListChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceChannelResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, channel_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.channel_list = channel_list  # type: QueryEdgeInstanceChannelResponseDataChannelList

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.channel_list, 'channel_list')
        if self.channel_list:
            self.channel_list.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.channel_list is not None:
            result['ChannelList'] = self.channel_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ChannelList') is not None:
            temp_model = QueryEdgeInstanceChannelResponseDataChannelList()
            self.channel_list = temp_model.from_map(m['ChannelList'])
        return self


class QueryEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeInstanceChannelResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceChannelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class SetEdgeInstanceDriverConfigsRequestConfigs(TeaModel):
    def __init__(self, format=None, content=None, key=None):
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.key = TeaConverter.to_unicode(key)  # type: unicode

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class SetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, configs=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.configs = configs  # type: list[SetEdgeInstanceDriverConfigsRequestConfigs]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = SetEdgeInstanceDriverConfigsRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class SetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(self, format=None, content=None, key=None):
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.key = TeaConverter.to_unicode(key)  # type: unicode

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_name=None, configs=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.configs = configs  # type: list[CreateEdgeInstanceChannelRequestConfigs]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = TeaConverter.to_unicode(data)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_ids = channel_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.channel_ids, 'channel_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig(TeaModel):
    def __init__(self, config_id=None, format=None, content=None, key=None):
        self.config_id = TeaConverter.to_unicode(config_id)  # type: unicode
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.key = TeaConverter.to_unicode(key)  # type: unicode

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')
        self.validate_required(self.key, 'key')

    def to_map(self):
        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceChannelResponseDataChannelConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig]

    def validate(self):
        self.validate_required(self.config, 'config')
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseDataChannel(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, config_list=None):
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.config_list = config_list  # type: BatchGetEdgeInstanceChannelResponseDataChannelConfigList

    def validate(self):
        self.validate_required(self.channel_id, 'channel_id')
        self.validate_required(self.channel_name, 'channel_name')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseData(TeaModel):
    def __init__(self, channel=None):
        self.channel = channel  # type: list[BatchGetEdgeInstanceChannelResponseDataChannel]

    def validate(self):
        self.validate_required(self.channel, 'channel')
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: BatchGetEdgeInstanceChannelResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(self, iot_id=None, content=None):
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, device_configs=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.device_configs = device_configs  # type: list[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.device_configs, 'device_configs')
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.iot_ids, 'iot_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig(TeaModel):
    def __init__(self, format=None, content=None):
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList(TeaModel):
    def __init__(self, iot_id=None, config=None):
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.config = config  # type: BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.config, 'config')
        if self.config:
            self.config.validate()

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_config_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.device_config_list = device_config_list  # type: list[BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.device_config_list, 'device_config_list')
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_ids=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_ids = driver_ids  # type: list[unicode]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_ids, 'driver_ids')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList(TeaModel):
    def __init__(self, config_id=None, format=None, content=None, key=None):
        self.config_id = TeaConverter.to_unicode(config_id)  # type: unicode
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.key = TeaConverter.to_unicode(key)  # type: unicode

    def validate(self):
        self.validate_required(self.config_id, 'config_id')
        self.validate_required(self.format, 'format')
        self.validate_required(self.content, 'content')
        self.validate_required(self.key, 'key')

    def to_map(self):
        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList(TeaModel):
    def __init__(self, driver_id=None, config_list=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.config_list = config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList]

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.config_list, 'config_list')
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, driver_config_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.driver_config_list = driver_config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.driver_config_list, 'driver_config_list')
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(self, dev_eui=None, pin_code=None):
        self.dev_eui = TeaConverter.to_unicode(dev_eui)  # type: unicode
        self.pin_code = TeaConverter.to_unicode(pin_code)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_info=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_info = device_info  # type: list[CreateLoRaNodesTaskRequestDeviceInfo]

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_info, 'device_info')
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, task_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseSuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[unicode]

    def validate(self):
        self.validate_required(self.success_dev_eui, 'success_dev_eui')

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, task_id=None, task_state=None,
                 total_count=None, success_count=None, success_dev_euis=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.task_state = TeaConverter.to_unicode(task_state)  # type: unicode
        self.total_count = total_count  # type: long
        self.success_count = success_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetLoraNodesTaskResponseSuccessDevEuis

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.task_state, 'task_state')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.success_count, 'success_count')
        self.validate_required(self.success_dev_euis, 'success_dev_euis')
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseSuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class QueryLoRaJoinPermissionsRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class QueryLoRaJoinPermissionsResponseJoinPermissionsJoinPermission(TeaModel):
    def __init__(self, join_permission_id=None, join_permission_name=None, join_permission_type=None,
                 owner_aliyun_pk=None, enabled=None, class_mode=None):
        self.join_permission_id = TeaConverter.to_unicode(join_permission_id)  # type: unicode
        self.join_permission_name = TeaConverter.to_unicode(join_permission_name)  # type: unicode
        self.join_permission_type = TeaConverter.to_unicode(join_permission_type)  # type: unicode
        self.owner_aliyun_pk = TeaConverter.to_unicode(owner_aliyun_pk)  # type: unicode
        self.enabled = enabled  # type: bool
        self.class_mode = TeaConverter.to_unicode(class_mode)  # type: unicode

    def validate(self):
        self.validate_required(self.join_permission_id, 'join_permission_id')
        self.validate_required(self.join_permission_name, 'join_permission_name')
        self.validate_required(self.join_permission_type, 'join_permission_type')
        self.validate_required(self.owner_aliyun_pk, 'owner_aliyun_pk')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.class_mode, 'class_mode')

    def to_map(self):
        result = dict()
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.join_permission_name is not None:
            result['JoinPermissionName'] = self.join_permission_name
        if self.join_permission_type is not None:
            result['JoinPermissionType'] = self.join_permission_type
        if self.owner_aliyun_pk is not None:
            result['OwnerAliyunPk'] = self.owner_aliyun_pk
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.class_mode is not None:
            result['ClassMode'] = self.class_mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('JoinPermissionName') is not None:
            self.join_permission_name = m.get('JoinPermissionName')
        if m.get('JoinPermissionType') is not None:
            self.join_permission_type = m.get('JoinPermissionType')
        if m.get('OwnerAliyunPk') is not None:
            self.owner_aliyun_pk = m.get('OwnerAliyunPk')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('ClassMode') is not None:
            self.class_mode = m.get('ClassMode')
        return self


class QueryLoRaJoinPermissionsResponseJoinPermissions(TeaModel):
    def __init__(self, join_permission=None):
        self.join_permission = join_permission  # type: list[QueryLoRaJoinPermissionsResponseJoinPermissionsJoinPermission]

    def validate(self):
        self.validate_required(self.join_permission, 'join_permission')
        if self.join_permission:
            for k in self.join_permission:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['JoinPermission'] = []
        if self.join_permission is not None:
            for k in self.join_permission:
                result['JoinPermission'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.join_permission = []
        if m.get('JoinPermission') is not None:
            for k in m.get('JoinPermission'):
                temp_model = QueryLoRaJoinPermissionsResponseJoinPermissionsJoinPermission()
                self.join_permission.append(temp_model.from_map(k))
        return self


class QueryLoRaJoinPermissionsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, product_key=None,
                 join_permissions=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.join_permissions = join_permissions  # type: QueryLoRaJoinPermissionsResponseJoinPermissions

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.join_permissions, 'join_permissions')
        if self.join_permissions:
            self.join_permissions.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.join_permissions is not None:
            result['JoinPermissions'] = self.join_permissions.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('JoinPermissions') is not None:
            temp_model = QueryLoRaJoinPermissionsResponseJoinPermissions()
            self.join_permissions = temp_model.from_map(m['JoinPermissions'])
        return self


class QueryEdgeInstanceDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, current_page=None, page_size=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceDriverResponseDataDriverList(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, order_id=None, gmt_create=None, gmt_modified=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.order_id = TeaConverter.to_unicode(order_id)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode

    def validate(self):
        self.validate_required(self.driver_id, 'driver_id')
        self.validate_required(self.driver_version, 'driver_version')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class QueryEdgeInstanceDriverResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, driver_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.driver_list = driver_list  # type: list[QueryEdgeInstanceDriverResponseDataDriverList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.driver_list, 'driver_list')
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = QueryEdgeInstanceDriverResponseDataDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDriverResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeInstanceDriverResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceDriverResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, nickname=None, iot_id=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(self, iot_instance_id=None, device_nickname_info=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.device_nickname_info = device_nickname_info  # type: list[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo]

    def validate(self):
        self.validate_required(self.device_nickname_info, 'device_nickname_info')
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceFileRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None, file_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class QueryDeviceFileResponseData(TeaModel):
    def __init__(self, file_id=None, name=None, size=None, utc_created_on=None, download_url=None):
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.size = TeaConverter.to_unicode(size)  # type: unicode
        self.utc_created_on = TeaConverter.to_unicode(utc_created_on)  # type: unicode
        self.download_url = TeaConverter.to_unicode(download_url)  # type: unicode

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.size, 'size')
        self.validate_required(self.utc_created_on, 'utc_created_on')
        self.validate_required(self.download_url, 'download_url')

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        return self


class QueryDeviceFileResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceFileResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceFileListRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None, iot_id=None,
                 current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceFileListResponseDataFileSummary(TeaModel):
    def __init__(self, file_id=None, name=None, size=None, utc_created_on=None):
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.size = TeaConverter.to_unicode(size)  # type: unicode
        self.utc_created_on = TeaConverter.to_unicode(utc_created_on)  # type: unicode

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.size, 'size')
        self.validate_required(self.utc_created_on, 'utc_created_on')

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        return self


class QueryDeviceFileListResponseData(TeaModel):
    def __init__(self, file_summary=None):
        self.file_summary = file_summary  # type: list[QueryDeviceFileListResponseDataFileSummary]

    def validate(self):
        self.validate_required(self.file_summary, 'file_summary')
        if self.file_summary:
            for k in self.file_summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FileSummary'] = []
        if self.file_summary is not None:
            for k in self.file_summary:
                result['FileSummary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_summary = []
        if m.get('FileSummary') is not None:
            for k in m.get('FileSummary'):
                temp_model = QueryDeviceFileListResponseDataFileSummary()
                self.file_summary.append(temp_model.from_map(k))
        return self


class QueryDeviceFileListResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, current_page=None,
                 page_count=None, page_size=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_count = page_count  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceFileListResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileListResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None, file_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode

    def validate(self):
        self.validate_required(self.file_id, 'file_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetNodesAddingTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetNodesAddingTaskResponseSuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[unicode]

    def validate(self):
        self.validate_required(self.success_dev_eui, 'success_dev_eui')

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetNodesAddingTaskResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, task_id=None, task_state=None,
                 total_count=None, success_count=None, success_dev_euis=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.task_state = TeaConverter.to_unicode(task_state)  # type: unicode
        self.total_count = total_count  # type: long
        self.success_count = success_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetNodesAddingTaskResponseSuccessDevEuis

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.task_state, 'task_state')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.success_count, 'success_count')
        self.validate_required(self.success_dev_euis, 'success_dev_euis')
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetNodesAddingTaskResponseSuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class SetDeviceDesiredPropertyRequest(TeaModel):
    def __init__(self, iot_instance_id=None, iot_id=None, device_name=None, product_key=None, items=None,
                 versions=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.items = TeaConverter.to_unicode(items)  # type: unicode
        self.versions = TeaConverter.to_unicode(versions)  # type: unicode

    def validate(self):
        self.validate_required(self.items, 'items')
        self.validate_required(self.versions, 'versions')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.items is not None:
            result['Items'] = self.items
        if self.versions is not None:
            result['Versions'] = self.versions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        if m.get('Versions') is not None:
            self.versions = m.get('Versions')
        return self


class SetDeviceDesiredPropertyResponseData(TeaModel):
    def __init__(self, message_id=None, versions=None):
        self.message_id = TeaConverter.to_unicode(message_id)  # type: unicode
        self.versions = TeaConverter.to_unicode(versions)  # type: unicode

    def validate(self):
        self.validate_required(self.message_id, 'message_id')
        self.validate_required(self.versions, 'versions')

    def to_map(self):
        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.versions is not None:
            result['Versions'] = self.versions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('Versions') is not None:
            self.versions = m.get('Versions')
        return self


class SetDeviceDesiredPropertyResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: SetDeviceDesiredPropertyResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = SetDeviceDesiredPropertyResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDesiredPropertyRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, identifier=None, iot_id=None,
                 function_block_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.identifier = identifier  # type: list[unicode]
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryDeviceDesiredPropertyResponseDataListDesiredPropertyInfo(TeaModel):
    def __init__(self, unit=None, identifier=None, data_type=None, time=None, value=None, name=None, version=None):
        self.unit = TeaConverter.to_unicode(unit)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.data_type = TeaConverter.to_unicode(data_type)  # type: unicode
        self.time = TeaConverter.to_unicode(time)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.version = version  # type: long

    def validate(self):
        self.validate_required(self.unit, 'unit')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.data_type, 'data_type')
        self.validate_required(self.time, 'time')
        self.validate_required(self.value, 'value')
        self.validate_required(self.name, 'name')
        self.validate_required(self.version, 'version')

    def to_map(self):
        result = dict()
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class QueryDeviceDesiredPropertyResponseDataList(TeaModel):
    def __init__(self, desired_property_info=None):
        self.desired_property_info = desired_property_info  # type: list[QueryDeviceDesiredPropertyResponseDataListDesiredPropertyInfo]

    def validate(self):
        self.validate_required(self.desired_property_info, 'desired_property_info')
        if self.desired_property_info:
            for k in self.desired_property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DesiredPropertyInfo'] = []
        if self.desired_property_info is not None:
            for k in self.desired_property_info:
                result['DesiredPropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.desired_property_info = []
        if m.get('DesiredPropertyInfo') is not None:
            for k in m.get('DesiredPropertyInfo'):
                temp_model = QueryDeviceDesiredPropertyResponseDataListDesiredPropertyInfo()
                self.desired_property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceDesiredPropertyResponseData(TeaModel):
    def __init__(self, list=None):
        self.list = list  # type: QueryDeviceDesiredPropertyResponseDataList

    def validate(self):
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceDesiredPropertyResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceDesiredPropertyResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryEdgeInstanceHistoricDeploymentRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, current_page=None, page_size=None, start_time=None,
                 end_time=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long
        self.end_time = end_time  # type: long

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryEdgeInstanceHistoricDeploymentResponseDataDeploymentList(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, gmt_completed=None, deployment_id=None, description=None,
                 status=None, type=None, gmt_create_timestamp=None, gmt_modified_timestamp=None,
                 gmt_completed_timestamp=None):
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.gmt_completed = TeaConverter.to_unicode(gmt_completed)  # type: unicode
        self.deployment_id = TeaConverter.to_unicode(deployment_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.status = status  # type: int
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long

    def validate(self):
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.gmt_completed, 'gmt_completed')
        self.validate_required(self.deployment_id, 'deployment_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.gmt_completed_timestamp, 'gmt_completed_timestamp')

    def to_map(self):
        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        return self


class QueryEdgeInstanceHistoricDeploymentResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, deployment_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.deployment_list = deployment_list  # type: list[QueryEdgeInstanceHistoricDeploymentResponseDataDeploymentList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.deployment_list, 'deployment_list')
        if self.deployment_list:
            for k in self.deployment_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DeploymentList'] = []
        if self.deployment_list is not None:
            for k in self.deployment_list:
                result['DeploymentList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.deployment_list = []
        if m.get('DeploymentList') is not None:
            for k in m.get('DeploymentList'):
                temp_model = QueryEdgeInstanceHistoricDeploymentResponseDataDeploymentList()
                self.deployment_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceHistoricDeploymentResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeInstanceHistoricDeploymentResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceHistoricDeploymentResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, product_tag=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.product_tag = product_tag  # type: list[CreateProductTagsRequestProductTag]

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseInvalidProductTagsProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsResponseInvalidProductTags(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[CreateProductTagsResponseInvalidProductTagsProductTag]

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, invalid_product_tags=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.invalid_product_tags = invalid_product_tags  # type: CreateProductTagsResponseInvalidProductTags

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.invalid_product_tags, 'invalid_product_tags')
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        return self


class UpdateProductTagsRequestProductTag(TeaModel):
    def __init__(self, tag_value=None, tag_key=None):
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class UpdateProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, product_tag=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.product_tag = product_tag  # type: list[UpdateProductTagsRequestProductTag]

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = UpdateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class UpdateProductTagsResponseInvalidProductTagsProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class UpdateProductTagsResponseInvalidProductTags(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[UpdateProductTagsResponseInvalidProductTagsProductTag]

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = UpdateProductTagsResponseInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class UpdateProductTagsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, invalid_product_tags=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.invalid_product_tags = invalid_product_tags  # type: UpdateProductTagsResponseInvalidProductTags

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.invalid_product_tags, 'invalid_product_tags')
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InvalidProductTags') is not None:
            temp_model = UpdateProductTagsResponseInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_tag_key=None, product_key=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_tag_key = product_tag_key  # type: list[unicode]
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.product_tag_key, 'product_tag_key')
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class ListProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListProductTagsResponseDataProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductTagsResponseData(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[ListProductTagsResponseDataProductTag]

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductTagsResponseDataProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductTagsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: ListProductTagsResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListProductTagsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListProductByTagsRequestProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductByTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, current_page=None, page_size=None, product_tag=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.product_tag = product_tag  # type: list[ListProductByTagsRequestProductTag]

    def validate(self):
        self.validate_required(self.product_tag, 'product_tag')
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductByTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseProductInfosProductInfo(TeaModel):
    def __init__(self, product_name=None, product_key=None, create_time=None, description=None, node_type=None):
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.create_time = create_time  # type: long
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.node_type = node_type  # type: int

    def validate(self):
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.description, 'description')
        self.validate_required(self.node_type, 'node_type')

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class ListProductByTagsResponseProductInfos(TeaModel):
    def __init__(self, product_info=None):
        self.product_info = product_info  # type: list[ListProductByTagsResponseProductInfosProductInfo]

    def validate(self):
        self.validate_required(self.product_info, 'product_info')
        if self.product_info:
            for k in self.product_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductInfo'] = []
        if self.product_info is not None:
            for k in self.product_info:
                result['ProductInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_info = []
        if m.get('ProductInfo') is not None:
            for k in m.get('ProductInfo'):
                temp_model = ListProductByTagsResponseProductInfosProductInfo()
                self.product_info.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, product_infos=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.product_infos = product_infos  # type: ListProductByTagsResponseProductInfos

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.product_infos, 'product_infos')
        if self.product_infos:
            self.product_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_infos is not None:
            result['ProductInfos'] = self.product_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductInfos') is not None:
            temp_model = ListProductByTagsResponseProductInfos()
            self.product_infos = temp_model.from_map(m['ProductInfos'])
        return self


class QueryDeviceGroupByTagsRequestTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceGroupByTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, tag=None, current_page=None, page_size=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.tag = tag  # type: list[QueryDeviceGroupByTagsRequestTag]
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceGroupByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceGroupByTagsResponseDataDeviceGroup(TeaModel):
    def __init__(self, group_id=None, group_name=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryDeviceGroupByTagsResponseData(TeaModel):
    def __init__(self, device_group=None):
        self.device_group = device_group  # type: list[QueryDeviceGroupByTagsResponseDataDeviceGroup]

    def validate(self):
        self.validate_required(self.device_group, 'device_group')
        if self.device_group:
            for k in self.device_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceGroup'] = []
        if self.device_group is not None:
            for k in self.device_group:
                result['DeviceGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_group = []
        if m.get('DeviceGroup') is not None:
            for k in m.get('DeviceGroup'):
                temp_model = QueryDeviceGroupByTagsResponseDataDeviceGroup()
                self.device_group.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupByTagsResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceGroupByTagsResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupByTagsResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(self, product_key=None, device_name=None, sign=None, sign_method=None, timestamp=None,
                 client_id=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.sign = TeaConverter.to_unicode(sign)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.timestamp = TeaConverter.to_unicode(timestamp)  # type: unicode
        self.client_id = TeaConverter.to_unicode(client_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.sign, 'sign')
        self.validate_required(self.sign_method, 'sign_method')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(self, iot_instance_id=None, topo_add_item=None, gw_product_key=None, gw_device_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.topo_add_item = topo_add_item  # type: list[BatchAddThingTopoRequestTopoAddItem]
        self.gw_product_key = TeaConverter.to_unicode(gw_product_key)  # type: unicode
        self.gw_device_name = TeaConverter.to_unicode(gw_device_name)  # type: unicode

    def validate(self):
        self.validate_required(self.topo_add_item, 'topo_add_item')
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()
        self.validate_required(self.gw_product_key, 'gw_product_key')
        self.validate_required(self.gw_device_name, 'gw_device_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryDeviceListByDeviceGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None, page_size=None, current_page=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceListByDeviceGroupResponseDataSimpleDeviceInfo(TeaModel):
    def __init__(self, product_name=None, product_key=None, device_name=None, iot_id=None):
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        self.validate_required(self.product_name, 'product_name')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceListByDeviceGroupResponseData(TeaModel):
    def __init__(self, simple_device_info=None):
        self.simple_device_info = simple_device_info  # type: list[QueryDeviceListByDeviceGroupResponseDataSimpleDeviceInfo]

    def validate(self):
        self.validate_required(self.simple_device_info, 'simple_device_info')
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceListByDeviceGroupResponseDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceListByDeviceGroupResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceListByDeviceGroupResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.page, 'page')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_count, 'page_count')
        self.validate_required(self.total, 'total')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceListByDeviceGroupResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDevicePropertiesDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None, start_time=None,
                 identifier=None, asc=None, iot_id=None, end_time=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.start_time = start_time  # type: long
        self.identifier = identifier  # type: list[unicode]
        self.asc = asc  # type: int
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.end_time = end_time  # type: long

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.asc, 'asc')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoListPropertyInfo(TeaModel):
    def __init__(self, time=None, value=None):
        self.time = time  # type: long
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        self.validate_required(self.time, 'time')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoList(TeaModel):
    def __init__(self, property_info=None):
        self.property_info = property_info  # type: list[QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoListPropertyInfo]

    def validate(self):
        self.validate_required(self.property_info, 'property_info')
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfo(TeaModel):
    def __init__(self, identifier=None, list=None):
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.list = list  # type: QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoList

    def validate(self):
        self.validate_required(self.identifier, 'identifier')
        self.validate_required(self.list, 'list')
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('List') is not None:
            temp_model = QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfoList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDevicePropertiesDataResponsePropertyDataInfos(TeaModel):
    def __init__(self, property_data_info=None):
        self.property_data_info = property_data_info  # type: list[QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfo]

    def validate(self):
        self.validate_required(self.property_data_info, 'property_data_info')
        if self.property_data_info:
            for k in self.property_data_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['PropertyDataInfo'] = []
        if self.property_data_info is not None:
            for k in self.property_data_info:
                result['PropertyDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.property_data_info = []
        if m.get('PropertyDataInfo') is not None:
            for k in m.get('PropertyDataInfo'):
                temp_model = QueryDevicePropertiesDataResponsePropertyDataInfosPropertyDataInfo()
                self.property_data_info.append(temp_model.from_map(k))
        return self


class QueryDevicePropertiesDataResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, next_valid=None, next_time=None,
                 property_data_infos=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.next_valid = next_valid  # type: bool
        self.next_time = next_time  # type: long
        self.property_data_infos = property_data_infos  # type: QueryDevicePropertiesDataResponsePropertyDataInfos

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.next_valid, 'next_valid')
        self.validate_required(self.next_time, 'next_time')
        self.validate_required(self.property_data_infos, 'property_data_infos')
        if self.property_data_infos:
            self.property_data_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.next_time is not None:
            result['NextTime'] = self.next_time
        if self.property_data_infos is not None:
            result['PropertyDataInfos'] = self.property_data_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('NextTime') is not None:
            self.next_time = m.get('NextTime')
        if m.get('PropertyDataInfos') is not None:
            temp_model = QueryDevicePropertiesDataResponsePropertyDataInfos()
            self.property_data_infos = temp_model.from_map(m['PropertyDataInfos'])
        return self


class UnbindRoleFromEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UnbindRoleFromEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class UpdateEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, name=None, tags=None, spec=None, biz_enable=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.tags = TeaConverter.to_unicode(tags)  # type: unicode
        self.spec = spec  # type: int
        self.biz_enable = biz_enable  # type: bool

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        return self


class UpdateEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEdgeInstanceResponseData(TeaModel):
    def __init__(self, instance_id=None, name=None, tags=None, type=None, spec=None, biz_enable=None, gmt_create=None,
                 gmt_modified=None, role_arn=None, role_name=None, role_attach_time=None, latest_deployment_status=None,
                 latest_deployment_type=None, gmt_create_timestamp=None, gmt_modified_timestamp=None, role_attach_timestamp=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.tags = TeaConverter.to_unicode(tags)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.spec = spec  # type: int
        self.biz_enable = biz_enable  # type: bool
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.role_arn = TeaConverter.to_unicode(role_arn)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode
        self.role_attach_time = TeaConverter.to_unicode(role_attach_time)  # type: unicode
        self.latest_deployment_status = latest_deployment_status  # type: int
        self.latest_deployment_type = TeaConverter.to_unicode(latest_deployment_type)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.role_attach_timestamp = role_attach_timestamp  # type: long

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.tags, 'tags')
        self.validate_required(self.type, 'type')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.biz_enable, 'biz_enable')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_name, 'role_name')
        self.validate_required(self.role_attach_time, 'role_attach_time')
        self.validate_required(self.latest_deployment_status, 'latest_deployment_status')
        self.validate_required(self.latest_deployment_type, 'latest_deployment_type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.role_attach_timestamp, 'role_attach_timestamp')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: GetEdgeInstanceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, name=None, tags=None, spec=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.tags = TeaConverter.to_unicode(tags)  # type: unicode
        self.spec = spec  # type: int

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, instance_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.code, 'code')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class QueryEdgeInstanceGatewayRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class QueryEdgeInstanceGatewayResponseGatewayList(TeaModel):
    def __init__(self, product_key=None, device_name=None, iot_id=None, edge_version=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.edge_version = TeaConverter.to_unicode(edge_version)  # type: unicode

    def validate(self):
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.edge_version, 'edge_version')

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        return self


class QueryEdgeInstanceGatewayResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, gateway_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.gateway_list = gateway_list  # type: list[QueryEdgeInstanceGatewayResponseGatewayList]

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.gateway_list, 'gateway_list')
        if self.gateway_list:
            for k in self.gateway_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['GatewayList'] = []
        if self.gateway_list is not None:
            for k in self.gateway_list:
                result['GatewayList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.gateway_list = []
        if m.get('GatewayList') is not None:
            for k in m.get('GatewayList'):
                temp_model = QueryEdgeInstanceGatewayResponseGatewayList()
                self.gateway_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, current_page=None, page_size=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.page_size, 'page_size')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryEdgeInstanceDeviceResponseDataDeviceList(TeaModel):
    def __init__(self, iot_id=None, product_key=None, device_name=None, driver_id=None):
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode

    def validate(self):
        self.validate_required(self.iot_id, 'iot_id')
        self.validate_required(self.product_key, 'product_key')
        self.validate_required(self.device_name, 'device_name')
        self.validate_required(self.driver_id, 'driver_id')

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class QueryEdgeInstanceDeviceResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, device_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.device_list = device_list  # type: list[QueryEdgeInstanceDeviceResponseDataDeviceList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.device_list, 'device_list')
        if self.device_list:
            for k in self.device_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['DeviceList'] = []
        if self.device_list is not None:
            for k in self.device_list:
                result['DeviceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.device_list = []
        if m.get('DeviceList') is not None:
            for k in m.get('DeviceList'):
                temp_model = QueryEdgeInstanceDeviceResponseDataDeviceList()
                self.device_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceDeviceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeInstanceDeviceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceDeviceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class QueryEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, current_page=None, name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.name = TeaConverter.to_unicode(name)  # type: unicode

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryEdgeInstanceResponseDataInstanceList(TeaModel):
    def __init__(self, instance_id=None, name=None, tags=None, type=None, gmt_create=None, gmt_modified=None,
                 role_arn=None, role_name=None, role_attach_time=None, spec=None, biz_enable=None,
                 latest_deployment_status=None, latest_deployment_type=None, gmt_create_timestamp=None, gmt_modified_timestamp=None,
                 role_attach_timestamp=None):
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.tags = TeaConverter.to_unicode(tags)  # type: unicode
        self.type = type  # type: int
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.role_arn = TeaConverter.to_unicode(role_arn)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode
        self.role_attach_time = TeaConverter.to_unicode(role_attach_time)  # type: unicode
        self.spec = spec  # type: int
        self.biz_enable = biz_enable  # type: bool
        self.latest_deployment_status = latest_deployment_status  # type: int
        self.latest_deployment_type = TeaConverter.to_unicode(latest_deployment_type)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.role_attach_timestamp = role_attach_timestamp  # type: long

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.tags, 'tags')
        self.validate_required(self.type, 'type')
        self.validate_required(self.gmt_create, 'gmt_create')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_name, 'role_name')
        self.validate_required(self.role_attach_time, 'role_attach_time')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.biz_enable, 'biz_enable')
        self.validate_required(self.latest_deployment_status, 'latest_deployment_status')
        self.validate_required(self.latest_deployment_type, 'latest_deployment_type')
        self.validate_required(self.gmt_create_timestamp, 'gmt_create_timestamp')
        self.validate_required(self.gmt_modified_timestamp, 'gmt_modified_timestamp')
        self.validate_required(self.role_attach_timestamp, 'role_attach_timestamp')

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        return self


class QueryEdgeInstanceResponseData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, instance_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.instance_list = instance_list  # type: list[QueryEdgeInstanceResponseDataInstanceList]

    def validate(self):
        self.validate_required(self.total, 'total')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.current_page, 'current_page')
        self.validate_required(self.instance_list, 'instance_list')
        if self.instance_list:
            for k in self.instance_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['InstanceList'] = []
        if self.instance_list is not None:
            for k in self.instance_list:
                result['InstanceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.instance_list = []
        if m.get('InstanceList') is not None:
            for k in m.get('InstanceList'):
                temp_model = QueryEdgeInstanceResponseDataInstanceList()
                self.instance_list.append(temp_model.from_map(k))
        return self


class QueryEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryEdgeInstanceResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryEdgeInstanceResponseData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, type=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, deployment_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.deployment_id = TeaConverter.to_unicode(deployment_id)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')
        self.validate_required(self.deployment_id, 'deployment_id')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, role_arn=None, role_name=None):
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.role_arn = TeaConverter.to_unicode(role_arn)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.role_arn, 'role_arn')
        self.validate_required(self.role_name, 'role_name')

    def to_map(self):
        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.error_message, 'error_message')

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get(