from .form_submissions import FormSubmissionGenerator, Submission
from .people import PersonProfileGenerator, PersonProfile
from .agrawal import AgrawalGeneratorDataset, LoanApplication
from .sine_generator import SineGeneratorDataset, Sine
from .led_generator import LEDGeneratorDataset, LED
from .phishing_dataset import PhisingDataset, Webpage
from .movie_ratings import MovieRatingDataset, MovieRating
from .restaurant_visitors import RestaurantVisitorsDataset, RestaurantDay

import importlib
pulsar_spec = importlib.util.find_spec("pulsar")

if pulsar_spec is not None:
    from .hosting import WebHostingDataset, ResourceEvent
    from .credit_card_transactions import CreditCardFraud, Transaction

#from .scikit_multiflow_classes import BaseEstimator, BaseSKMObject, SKStream, check_random_state
#from .stream import Stream
#from .record import Record, Field, Null, Boolean, Integer, Long, Float, Double, Bytes, String, Array, Map, \
#    JsonSchema, Schema, BytesSchema, StringSchema, JsonSchema, AvroSchema

#__all__ = ["FormSubmissionGenerator", "WebHostingDataset", "PersonProfileGenerator", "Submission", "ResourceEvent",
#           "PersonProfile", "AgrawalGenerator", "CreditCardFraud", "PhisingDataset", "LoanApplication", "Transaction",
#           "Webpage", "MovieRating", "MovieRatingDataset", "Stream", "Record", "Field", "Null", "Boolean", "Integer",
#           "Long", "Float", "Double", "Bytes", "String", "Array", "Map", "JsonSchema", "Schema", "BytesSchema",
#           "StringSchema", "AvroSchema"]

__all__ = ["FormSubmissionGenerator", "WebHostingDataset", "PersonProfileGenerator", "Submission", "ResourceEvent",
           "PersonProfile", "AgrawalGeneratorDataset", "CreditCardFraud", "PhisingDataset", "LoanApplication", "Transaction",
           "Webpage", "MovieRating", "MovieRatingDataset", "RestaurantVisitorsDataset", "RestaurantDay", "Sine",
           "SineGeneratorDataset", "LEDGeneratorDataset", "LED"]
