# Участие
Типов объектов метаданных в 1С много, свойств у них ещё больше. Можно бесконечно улучшать
качество и читаемость хранимых данных, до тех пор пока все объекты не будут расшифрованы.

На текущий момент в модуле реализованы только необходимые автору объекты. Если Вам не хватает
каких либо типов Вы можете самостоятельно их реализовать и добросить в этот репозиторий.

Для этого необходимо:

1. В тестовую конфигурацию приложенную к данному репозиторию добавить нужный вам объект в 
небольшом количестве (обычно по количеству его вариантов). В качестве название объекта 
необходимо использовать название типа и варианта, например РеквизитДокументаСтрока.

2. Добавить реализацию для сборки разборки нужного типа объект и добиться чтобы тест сборки 
разборки конфигурации проходил без ошибок (test_decode менять не нужно, можно  добавить
свои тесты конкретного объекта рядом).

2.1. Определить uuid типа и прописать соответствие в metadata_types по аналогии
с другими записаями. uuid типа метаданных будет виден тексте ошибки. Так же в ошибке вы 
увидите файл в котором описан объект этого типа. В содержимом файла вы сможете найти название
объекта и по нему понять что за тип вам попался. Английское название типа для metadata_types 
нужно взять из Синтаксис-помощника 1С (строка для поиска "ОбъектМетаданных: ХХХХ.YYYY").

Например видим ошибку неизвестный тип вложенных метаданных: 13134204-f60b-11d5-a3c7-0050bae0a776 
в файле 79b41fb6-cf3d-433c-83f2-a97b226178c4. 

Открываем файл 79b41fb6-cf3d-433c-83f2-a97b226178c4 (файл будет где-то 
в папке temp\decode_stage_2, используйте параметр temp при разборе). 

Открыв файл Вы в начале файла увидите название типа метаданных, например ФормаЗаписи. 

Далее ищем в конфигураторе данный объект, и понимаем какой у него тип. Например в нашем случае это
Регистры сведений -> Форма. В синтаксис помощнике ищем ОбъектМетаданных: РегистрСведений.Формы.

На найденной странице смотрим как называется это у 1С по английски - MetadataObject:InformationRegister.Forms

Под каждый тип метаданных в папке MetadataObject создается одноименный файл / класс, в нашем случае
InformationRegisterForm (имя переводим в динственное число). Для форм достаточно копирования
какой нибуть другой формы, они очень похожи.

добавляем в metadata_types InformationRegisterForm = '13134204-f60b-11d5-a3c7-0050bae0a776'

2.2. Если объект сложный и его свойства хранятся в отдельном файле нужно будет добавить 
парсер объекта в MetaDataObject. Для простых объектов типа Рексизит Документа достаточно 
добавить описание.

3. Создать под свой пример юниттест по аналогии с теми что есть в проекте, эти тесты
проверяют какая значимая информация теряется при сборке разборке. Кроме этого нужно убедиться,
что при разборке + сборке получается валидный файл который открывается в 1С.


4. Добросить изменения

4.1. Если вы просто добавили новый класс достаточно подтять версию path.

4.2. Запись в истории версий модуля обязательна. 
 