# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict
from typing_extensions import Required, Annotated, TypedDict

from .._utils import PropertyInfo

__all__ = ["DatasetFinalizeFileUploadParams", "S3PresignedPost"]


class DatasetFinalizeFileUploadParams(TypedDict, total=False):
    dataset_id: Required[Annotated[str, PropertyInfo(alias="datasetId")]]
    """The ID of the dataset corresponding to the file"""

    s3_presigned_post: Required[Annotated[S3PresignedPost, PropertyInfo(alias="s3PresignedPost")]]
    """The pre-signed S3 URL where the file was uploadeded"""


class S3PresignedPost(TypedDict, total=False):
    fields: Required[Dict[str, str]]
    """Fields required for the S3 presigned POST request generated by s3 sdk."""

    url: Required[str]
