# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MagicReport(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sha1': 'str',
        'sha256': 'str',
        'sha512': 'str',
        'md5': 'str',
        'unix_file_type': 'str',
        'object_class': 'str',
        'filename': 'list[str]',
        'first_seen': 'str',
        'is_owned': 'bool',
        'categories': 'MagicCategories',
        'labels': 'list[MagicLabel]',
        'tags': 'list[str]',
        'detection_stats': 'MagicReportDetectionStats',
        'av_names': 'list[str]',
        'campaign_id': 'str'
    }

    attribute_map = {
        'sha1': 'sha1',
        'sha256': 'sha256',
        'sha512': 'sha512',
        'md5': 'md5',
        'unix_file_type': 'unix_file_type',
        'object_class': 'object_class',
        'filename': 'filename',
        'first_seen': 'first_seen',
        'is_owned': 'is_owned',
        'categories': 'categories',
        'labels': 'labels',
        'tags': 'tags',
        'detection_stats': 'detection_stats',
        'av_names': 'av_names',
        'campaign_id': 'campaign_id'
    }

    def __init__(self, sha1=None, sha256=None, sha512=None, md5=None, unix_file_type=None, object_class=None, filename=None, first_seen=None, is_owned=None, categories=None, labels=None, tags=None, detection_stats=None, av_names=None, campaign_id=None):  # noqa: E501
        """MagicReport - a model defined in Swagger"""  # noqa: E501

        self._sha1 = None
        self._sha256 = None
        self._sha512 = None
        self._md5 = None
        self._unix_file_type = None
        self._object_class = None
        self._filename = None
        self._first_seen = None
        self._is_owned = None
        self._categories = None
        self._labels = None
        self._tags = None
        self._detection_stats = None
        self._av_names = None
        self._campaign_id = None
        self.discriminator = None

        if sha1 is not None:
            self.sha1 = sha1
        if sha256 is not None:
            self.sha256 = sha256
        if sha512 is not None:
            self.sha512 = sha512
        if md5 is not None:
            self.md5 = md5
        if unix_file_type is not None:
            self.unix_file_type = unix_file_type
        if object_class is not None:
            self.object_class = object_class
        if filename is not None:
            self.filename = filename
        if first_seen is not None:
            self.first_seen = first_seen
        if is_owned is not None:
            self.is_owned = is_owned
        if categories is not None:
            self.categories = categories
        if labels is not None:
            self.labels = labels
        if tags is not None:
            self.tags = tags
        if detection_stats is not None:
            self.detection_stats = detection_stats
        if av_names is not None:
            self.av_names = av_names
        if campaign_id is not None:
            self.campaign_id = campaign_id

    @property
    def sha1(self):
        """Gets the sha1 of this MagicReport.  # noqa: E501

        A SHA1 cryptographic hash  # noqa: E501

        :return: The sha1 of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this MagicReport.

        A SHA1 cryptographic hash  # noqa: E501

        :param sha1: The sha1 of this MagicReport.  # noqa: E501
        :type: str
        """
        if sha1 is not None and not re.search(r'[a-fA-F0-9]{40}', sha1):  # noqa: E501
            raise ValueError(r"Invalid value for `sha1`, must be a follow pattern or equal to `/[a-fA-F0-9]{40}/`")  # noqa: E501

        self._sha1 = sha1

    @property
    def sha256(self):
        """Gets the sha256 of this MagicReport.  # noqa: E501

        A SHA256 cryptographic hash  # noqa: E501

        :return: The sha256 of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this MagicReport.

        A SHA256 cryptographic hash  # noqa: E501

        :param sha256: The sha256 of this MagicReport.  # noqa: E501
        :type: str
        """
        if sha256 is not None and not re.search(r'[a-fA-F0-9]{64}', sha256):  # noqa: E501
            raise ValueError(r"Invalid value for `sha256`, must be a follow pattern or equal to `/[a-fA-F0-9]{64}/`")  # noqa: E501

        self._sha256 = sha256

    @property
    def sha512(self):
        """Gets the sha512 of this MagicReport.  # noqa: E501

        A SHA512 cryptographic hash  # noqa: E501

        :return: The sha512 of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._sha512

    @sha512.setter
    def sha512(self, sha512):
        """Sets the sha512 of this MagicReport.

        A SHA512 cryptographic hash  # noqa: E501

        :param sha512: The sha512 of this MagicReport.  # noqa: E501
        :type: str
        """
        if sha512 is not None and not re.search(r'[a-fA-F0-9]{128}', sha512):  # noqa: E501
            raise ValueError(r"Invalid value for `sha512`, must be a follow pattern or equal to `/[a-fA-F0-9]{128}/`")  # noqa: E501

        self._sha512 = sha512

    @property
    def md5(self):
        """Gets the md5 of this MagicReport.  # noqa: E501

        An MD5 cryptographic hash  # noqa: E501

        :return: The md5 of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this MagicReport.

        An MD5 cryptographic hash  # noqa: E501

        :param md5: The md5 of this MagicReport.  # noqa: E501
        :type: str
        """
        if md5 is not None and not re.search(r'[a-fA-F0-9]{32}', md5):  # noqa: E501
            raise ValueError(r"Invalid value for `md5`, must be a follow pattern or equal to `/[a-fA-F0-9]{32}/`")  # noqa: E501

        self._md5 = md5

    @property
    def unix_file_type(self):
        """Gets the unix_file_type of this MagicReport.  # noqa: E501

        Unix file type of the file.  # noqa: E501

        :return: The unix_file_type of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._unix_file_type

    @unix_file_type.setter
    def unix_file_type(self, unix_file_type):
        """Sets the unix_file_type of this MagicReport.

        Unix file type of the file.  # noqa: E501

        :param unix_file_type: The unix_file_type of this MagicReport.  # noqa: E501
        :type: str
        """

        self._unix_file_type = unix_file_type

    @property
    def object_class(self):
        """Gets the object_class of this MagicReport.  # noqa: E501

        An internal indicator of the type of object this file is.  # noqa: E501

        :return: The object_class of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._object_class

    @object_class.setter
    def object_class(self, object_class):
        """Sets the object_class of this MagicReport.

        An internal indicator of the type of object this file is.  # noqa: E501

        :param object_class: The object_class of this MagicReport.  # noqa: E501
        :type: str
        """

        self._object_class = object_class

    @property
    def filename(self):
        """Gets the filename of this MagicReport.  # noqa: E501

        The original file names associated with the file.  # noqa: E501

        :return: The filename of this MagicReport.  # noqa: E501
        :rtype: list[str]
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this MagicReport.

        The original file names associated with the file.  # noqa: E501

        :param filename: The filename of this MagicReport.  # noqa: E501
        :type: list[str]
        """

        self._filename = filename

    @property
    def first_seen(self):
        """Gets the first_seen of this MagicReport.  # noqa: E501

        Timestamp of when this file was first uploaded to MAGIC  # noqa: E501

        :return: The first_seen of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._first_seen

    @first_seen.setter
    def first_seen(self, first_seen):
        """Sets the first_seen of this MagicReport.

        Timestamp of when this file was first uploaded to MAGIC  # noqa: E501

        :param first_seen: The first_seen of this MagicReport.  # noqa: E501
        :type: str
        """

        self._first_seen = first_seen

    @property
    def is_owned(self):
        """Gets the is_owned of this MagicReport.  # noqa: E501

        Is this file owned by this user  # noqa: E501

        :return: The is_owned of this MagicReport.  # noqa: E501
        :rtype: bool
        """
        return self._is_owned

    @is_owned.setter
    def is_owned(self, is_owned):
        """Sets the is_owned of this MagicReport.

        Is this file owned by this user  # noqa: E501

        :param is_owned: The is_owned of this MagicReport.  # noqa: E501
        :type: bool
        """

        self._is_owned = is_owned

    @property
    def categories(self):
        """Gets the categories of this MagicReport.  # noqa: E501


        :return: The categories of this MagicReport.  # noqa: E501
        :rtype: MagicCategories
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """Sets the categories of this MagicReport.


        :param categories: The categories of this MagicReport.  # noqa: E501
        :type: MagicCategories
        """

        self._categories = categories

    @property
    def labels(self):
        """Gets the labels of this MagicReport.  # noqa: E501


        :return: The labels of this MagicReport.  # noqa: E501
        :rtype: list[MagicLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this MagicReport.


        :param labels: The labels of this MagicReport.  # noqa: E501
        :type: list[MagicLabel]
        """

        self._labels = labels

    @property
    def tags(self):
        """Gets the tags of this MagicReport.  # noqa: E501

        List of tags added to this binary.  # noqa: E501

        :return: The tags of this MagicReport.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this MagicReport.

        List of tags added to this binary.  # noqa: E501

        :param tags: The tags of this MagicReport.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def detection_stats(self):
        """Gets the detection_stats of this MagicReport.  # noqa: E501


        :return: The detection_stats of this MagicReport.  # noqa: E501
        :rtype: MagicReportDetectionStats
        """
        return self._detection_stats

    @detection_stats.setter
    def detection_stats(self, detection_stats):
        """Sets the detection_stats of this MagicReport.


        :param detection_stats: The detection_stats of this MagicReport.  # noqa: E501
        :type: MagicReportDetectionStats
        """

        self._detection_stats = detection_stats

    @property
    def av_names(self):
        """Gets the av_names of this MagicReport.  # noqa: E501

        List of names assigned to this binary by a Multi-Scanner.  # noqa: E501

        :return: The av_names of this MagicReport.  # noqa: E501
        :rtype: list[str]
        """
        return self._av_names

    @av_names.setter
    def av_names(self, av_names):
        """Sets the av_names of this MagicReport.

        List of names assigned to this binary by a Multi-Scanner.  # noqa: E501

        :param av_names: The av_names of this MagicReport.  # noqa: E501
        :type: list[str]
        """

        self._av_names = av_names

    @property
    def campaign_id(self):
        """Gets the campaign_id of this MagicReport.  # noqa: E501

        ID of the campaign this binary is in.  # noqa: E501

        :return: The campaign_id of this MagicReport.  # noqa: E501
        :rtype: str
        """
        return self._campaign_id

    @campaign_id.setter
    def campaign_id(self, campaign_id):
        """Sets the campaign_id of this MagicReport.

        ID of the campaign this binary is in.  # noqa: E501

        :param campaign_id: The campaign_id of this MagicReport.  # noqa: E501
        :type: str
        """

        self._campaign_id = campaign_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MagicReport, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MagicReport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
