import pathlib
from setuptools import setup, find_packages

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

setup(
    extras_require={
        "dev": [
            "appdirs==1.4.4",
            "attrs==21.4.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "autopep8==1.6.0",
            "black==19.10b0; python_version >= '3.6'",
            "bleach==4.1.0; python_version >= '3.6'",
            "build==0.7.0; python_version >= '3.6'",
            "cached-property==1.5.2",
            "cerberus==1.3.4",
            "certifi==2021.10.8",
            "cffi==1.15.0",
            "cfgv==3.3.1; python_full_version >= '3.6.1'",
            "chardet==4.0.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "charset-normalizer==2.0.12; python_version >= '3'",
            "check-manifest==0.47",
            "click==8.0.3; python_version >= '3.6'",
            "codespell==2.1.0",
            "colorama==0.4.4; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "coverage==6.3.1",
            "cryptography==36.0.1; python_version >= '3.6'",
            "distlib==0.3.4",
            "docutils==0.18.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "filelock==3.5.1; python_version >= '3.7'",
            "flake8==4.0.1",
            "identify==2.4.10; python_version >= '3.7'",
            "idna==3.3; python_version >= '3'",
            "importlib-metadata==4.11.1; python_version >= '3.7'",
            "iniconfig==1.1.1",
            "jeepney==0.7.1; sys_platform == 'linux'",
            "keyring==23.5.0; python_version >= '3.7'",
            "mccabe==0.6.1",
            "nodeenv==1.6.0",
            "orderedmultidict==1.0.1",
            "packaging==20.9; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "pathspec==0.9.0",
            "pep517==0.12.0",
            "pip==22.0.3; python_version >= '3.7'",
            "pip-shims==0.6.0; python_version >= '3.6'",
            "pipenv-setup==3.1.4",
            "pipfile==0.0.2",
            "pkginfo==1.8.2",
            "platformdirs==2.5.0; python_version >= '3.7'",
            "plette[validation]==0.2.3; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "pluggy==1.0.0; python_version >= '3.6'",
            "pre-commit==2.17.0",
            "py==1.11.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "pycodestyle==2.8.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "pycparser==2.21",
            "pyflakes==2.4.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "pygments==2.11.2; python_version >= '3.5'",
            "pyparsing==3.0.7; python_version >= '3.6'",
            "pytest==7.0.1",
            "pytest-mock==3.7.0",
            "python-dateutil==2.8.2",
            "pyyaml==6.0",
            "readme-renderer==32.0; python_version >= '3.6'",
            "regex==2022.1.18",
            "requests==2.27.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4, 3.5'",
            "requests-toolbelt==0.9.1",
            "requirementslib==1.6.1; python_version >= '3.6'",
            "rfc3986==2.0.0; python_version >= '3.7'",
            "secretstorage==3.3.1; sys_platform == 'linux'",
            "setuptools==60.9.2; python_version >= '3.7'",
            "six==1.16.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "toml==0.10.2; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "tomli==2.0.1; python_version >= '3.7'",
            "tomlkit==0.9.2; python_version >= '3.6' and python_version < '4'",
            "tox==3.24.5",
            "tqdm==4.62.3; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "twine==3.8.0",
            "typed-ast==1.5.2; python_version >= '3.6'",
            "urllib3==1.26.8; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4' and python_version < '4'",
            "virtualenv==20.13.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "vistir==0.5.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "webencodings==0.5.1",
            "wheel==0.37.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "yelp-gprof2dot==1.2.0",
            "zipp==3.7.0; python_version >= '3.7'",
        ]
    },
    name="squirrel-writer",
    version="0.0.4",
    author="Mohieddine Drissi",
    author_email="m.drissi@protonmail.com",
    url="https://github.com/squirrel-writer/squirrel",
    description="A command line program to track writing progress",
    long_description=README,
    long_description_content_type="text/markdown",
    packages=find_packages(exclude=("tests",)),
    install_requires=[
        "colorama==0.4.4; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        "commonmark==0.9.1",
        "daemonize==2.5.0",
        "pygments==2.11.2; python_version >= '3.5'",
        "python-dateutil==2.8.2",
        "pyyaml==6.0",
        "rich==11.2.0",
        "six==1.16.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "watchdog==2.1.6",
    ],
    classifiers=[
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Development Status :: 2 - Pre-Alpha",
    ],
    python_requires=">=3.8",
    entry_points={"console_scripts": ["squirrel=squirrel.squirrel:_main", ], },
)
