"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiCallHandler = exports.flatten = void 0;
/* eslint-disable no-console */
const base_1 = require("./base");
const utils_1 = require("./utils");
/**
 * Flattens a nested object
 *
 * @param object the object to be flattened
 * @returns a flat object with path as keys
 */
function flatten(object) {
    return Object.assign({}, ...function _flatten(child, path = []) {
        return [].concat(...Object.keys(child)
            .map(key => {
            let childKey = Buffer.isBuffer(child[key]) ? child[key].toString('utf8') : child[key];
            // if the value is a json string then treat it as an object
            // and keep recursing. This allows for easier assertions against complex json strings
            if (typeof childKey === 'string') {
                childKey = isJsonString(childKey);
            }
            return typeof childKey === 'object' && childKey !== null
                ? _flatten(childKey, path.concat([key]))
                : ({ [path.concat([key]).join('.')]: childKey });
        }));
    }(object));
}
exports.flatten = flatten;
class AwsApiCallHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        // eslint-disable-next-line
        const AWS = require('aws-sdk');
        console.log(`AWS SDK VERSION: ${AWS.VERSION}`);
        if (!Object.prototype.hasOwnProperty.call(AWS, request.service)) {
            throw Error(`Service ${request.service} does not exist in AWS SDK version ${AWS.VERSION}.`);
        }
        const service = new AWS[request.service]();
        const response = await service[request.api](request.parameters && utils_1.decode(request.parameters)).promise();
        console.log(`SDK response received ${JSON.stringify(response)}`);
        delete response.ResponseMetadata;
        const respond = {
            apiCallResponse: response,
        };
        const flatData = {
            ...flatten(respond),
        };
        let resp = respond;
        if (request.outputPaths) {
            resp = filterKeys(flatData, request.outputPaths);
        }
        else if (request.flattenResponse === 'true') {
            resp = flatData;
        }
        console.log(`Returning result ${JSON.stringify(resp)}`);
        return resp;
    }
}
exports.AwsApiCallHandler = AwsApiCallHandler;
function filterKeys(object, searchStrings) {
    return Object.entries(object).reduce((filteredObject, [key, value]) => {
        for (const searchString of searchStrings) {
            if (key.startsWith(`apiCallResponse.${searchString}`)) {
                filteredObject[key] = value;
            }
        }
        return filteredObject;
    }, {});
}
function isJsonString(value) {
    try {
        return JSON.parse(value);
    }
    catch {
        return value;
    }
}
//# sourceMappingURL=data:application/json;base64,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