import { IKey } from '@aws-cdk/aws-kms';
import { Construct } from 'constructs';
import { ITopic, TopicBase } from './topic-base';
/**
 * Properties for a new SNS topic.
 *
 * @stability stable
 */
export interface TopicProps {
    /**
     * A developer-defined string that can be used to identify this SNS topic.
     *
     * @default None
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * A name for the topic.
     *
     * If you don't specify a name, AWS CloudFormation generates a unique
     * physical ID and uses that ID for the topic name. For more information,
     * see Name Type.
     *
     * @default Generated name
     * @stability stable
     */
    readonly topicName?: string;
    /**
     * A KMS Key, either managed by this CDK app, or imported.
     *
     * @default None
     * @stability stable
     */
    readonly masterKey?: IKey;
}
/**
 * A new SNS topic.
 *
 * @stability stable
 */
export declare class Topic extends TopicBase {
    /**
     * Import an existing SNS topic provided an ARN.
     *
     * @param scope The parent creating construct.
     * @param id The construct's name.
     * @param topicArn topic ARN (i.e. arn:aws:sns:us-east-2:444455556666:MyTopic).
     * @stability stable
     */
    static fromTopicArn(scope: Construct, id: string, topicArn: string): ITopic;
    /**
     * The ARN of the topic.
     *
     * @stability stable
     */
    readonly topicArn: string;
    /**
     * The name of the topic.
     *
     * @stability stable
     */
    readonly topicName: string;
    /**
     * Controls automatic creation of policy objects.
     *
     * Set by subclasses.
     *
     * @stability stable
     */
    protected readonly autoCreatePolicy: boolean;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: TopicProps);
}
