"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import video.sfu.models.models_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class KickUserRequest(google.protobuf.message.Message):
    """A request message for KickUser endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_PK_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CALL_IDS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    NOT_BEFORE_FIELD_NUMBER: builtins.int
    app_pk: builtins.int
    """App PK"""
    user_id: builtins.str
    """An ID of the user to disconnect"""
    @property
    def call_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Call IDs to which this request applies.
        If empty, should be treated as "all calls"
        """
    message: builtins.str
    """A message to display to a user when its disconnected"""
    @property
    def not_before(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Optional. A timestamp which tells SFU to deny all tokens issued before this date"""
    def __init__(
        self,
        *,
        app_pk: builtins.int = ...,
        user_id: builtins.str = ...,
        call_ids: collections.abc.Iterable[builtins.str] | None = ...,
        message: builtins.str = ...,
        not_before: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["not_before", b"not_before"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_pk", b"app_pk", "call_ids", b"call_ids", "message", b"message", "not_before", b"not_before", "user_id", b"user_id"]) -> None: ...

global___KickUserRequest = KickUserRequest

class KickUserResponse(google.protobuf.message.Message):
    """A response message for KickUser endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___KickUserResponse = KickUserResponse

class InvalidateTokenRequest(google.protobuf.message.Message):
    """A request message for InvaludateUserToken endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_PK_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CALL_IDS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    NOT_BEFORE_FIELD_NUMBER: builtins.int
    app_pk: builtins.int
    """App PK"""
    user_id: builtins.str
    """An ID of the user to invalidate tokens for"""
    @property
    def call_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Call IDs to which this request applies.
        If empty, should be treated as "all calls"
        """
    message: builtins.str
    """A message to display to a user in the event of disconnect"""
    @property
    def not_before(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """A cut-off date for all the tokens"""
    def __init__(
        self,
        *,
        app_pk: builtins.int = ...,
        user_id: builtins.str = ...,
        call_ids: collections.abc.Iterable[builtins.str] | None = ...,
        message: builtins.str = ...,
        not_before: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["not_before", b"not_before"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_pk", b"app_pk", "call_ids", b"call_ids", "message", b"message", "not_before", b"not_before", "user_id", b"user_id"]) -> None: ...

global___InvalidateTokenRequest = InvalidateTokenRequest

class InvalidateTokenResponse(google.protobuf.message.Message):
    """A response message for InvaludateUserToken endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___InvalidateTokenResponse = InvalidateTokenResponse

class MuteParticipantsRequest(google.protobuf.message.Message):
    """A request message for MuteParticipants endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_PK_FIELD_NUMBER: builtins.int
    PARTICIPANTS_FIELD_NUMBER: builtins.int
    app_pk: builtins.int
    """App PK"""
    @property
    def participants(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[video.sfu.models.models_pb2.Participant]:
        """List of part"""
    def __init__(
        self,
        *,
        app_pk: builtins.int = ...,
        participants: collections.abc.Iterable[video.sfu.models.models_pb2.Participant] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_pk", b"app_pk", "participants", b"participants"]) -> None: ...

global___MuteParticipantsRequest = MuteParticipantsRequest

class MuteParticipantInput(google.protobuf.message.Message):
    """A message that tells which participant to mute"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    MUTE_AUDIO_FIELD_NUMBER: builtins.int
    MUTE_VIDEO_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """User ID to mute"""
    session_id: builtins.str
    """Session ID to mute
    If empty, all sessions of provided user ID should be muted
    """
    mute_audio: builtins.bool
    """Whether to mute video"""
    mute_video: builtins.bool
    """Whether to mute audio"""
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        session_id: builtins.str | None = ...,
        mute_audio: builtins.bool | None = ...,
        mute_video: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_mute_audio", b"_mute_audio", "_mute_video", b"_mute_video", "_session_id", b"_session_id", "mute_audio", b"mute_audio", "mute_video", b"mute_video", "session_id", b"session_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_mute_audio", b"_mute_audio", "_mute_video", b"_mute_video", "_session_id", b"_session_id", "mute_audio", b"mute_audio", "mute_video", b"mute_video", "session_id", b"session_id", "user_id", b"user_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_mute_audio", b"_mute_audio"]) -> typing_extensions.Literal["mute_audio"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_mute_video", b"_mute_video"]) -> typing_extensions.Literal["mute_video"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_session_id", b"_session_id"]) -> typing_extensions.Literal["session_id"] | None: ...

global___MuteParticipantInput = MuteParticipantInput

class MuteParticipantsResponse(google.protobuf.message.Message):
    """A response message for MuteParticipants endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___MuteParticipantsResponse = MuteParticipantsResponse

class GetCallRequest(google.protobuf.message.Message):
    """A request message for GetCall endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_PK_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    WITH_STATE_FIELD_NUMBER: builtins.int
    app_pk: builtins.int
    """App PK"""
    id: builtins.str
    """A call ID"""
    with_state: builtins.bool
    """Whether to include state information in the response"""
    def __init__(
        self,
        *,
        app_pk: builtins.int = ...,
        id: builtins.str = ...,
        with_state: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_pk", b"app_pk", "id", b"id", "with_state", b"with_state"]) -> None: ...

global___GetCallRequest = GetCallRequest

class GetCallResponse(google.protobuf.message.Message):
    """A response message for GetCall endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALL_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    @property
    def call(self) -> video.sfu.models.models_pb2.Call:
        """Call model"""
    @property
    def state(self) -> video.sfu.models.models_pb2.CallState:
        """Call state"""
    def __init__(
        self,
        *,
        call: video.sfu.models.models_pb2.Call | None = ...,
        state: video.sfu.models.models_pb2.CallState | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["call", b"call", "state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["call", b"call", "state", b"state"]) -> None: ...

global___GetCallResponse = GetCallResponse

class CreateCallRequest(google.protobuf.message.Message):
    """A request message for CreateCall endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_PK_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CASCADING_SFUS_HOSTNAMES_FIELD_NUMBER: builtins.int
    GOSSIP_RPC_AUTH_TOKEN_FIELD_NUMBER: builtins.int
    app_pk: builtins.int
    """App PK"""
    id: builtins.str
    """Call ID"""
    @property
    def cascading_sfus_hostnames(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of SFUs that are used for this call"""
    gossip_rpc_auth_token: builtins.str
    """The token the SFU can use to participate in the gossip protocol"""
    def __init__(
        self,
        *,
        app_pk: builtins.int = ...,
        id: builtins.str = ...,
        cascading_sfus_hostnames: collections.abc.Iterable[builtins.str] | None = ...,
        gossip_rpc_auth_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_pk", b"app_pk", "cascading_sfus_hostnames", b"cascading_sfus_hostnames", "gossip_rpc_auth_token", b"gossip_rpc_auth_token", "id", b"id"]) -> None: ...

global___CreateCallRequest = CreateCallRequest

class CreateCallResponse(google.protobuf.message.Message):
    """A response message for CreateCall endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALL_FIELD_NUMBER: builtins.int
    @property
    def call(self) -> video.sfu.models.models_pb2.Call:
        """A model of created call"""
    def __init__(
        self,
        *,
        call: video.sfu.models.models_pb2.Call | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["call", b"call"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["call", b"call"]) -> None: ...

global___CreateCallResponse = CreateCallResponse

class EndCallRequest(google.protobuf.message.Message):
    """A request message for EndCall endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_PK_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    app_pk: builtins.int
    """App PK"""
    id: builtins.str
    """Call ID"""
    message: builtins.str
    """A message to display to disconnected participants"""
    def __init__(
        self,
        *,
        app_pk: builtins.int = ...,
        id: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_pk", b"app_pk", "id", b"id", "message", b"message"]) -> None: ...

global___EndCallRequest = EndCallRequest

class EndCallResponse(google.protobuf.message.Message):
    """A response message for EndCall endpoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CALL_FIELD_NUMBER: builtins.int
    @property
    def call(self) -> video.sfu.models.models_pb2.Call:
        """A model of a call
        TODO: return some call stats?
        """
    def __init__(
        self,
        *,
        call: video.sfu.models.models_pb2.Call | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["call", b"call"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["call", b"call"]) -> None: ...

global___EndCallResponse = EndCallResponse
