"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Action(google.protobuf.message.Message):
    """Action is an action that is possible to grant to a user"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """A unique name of action"""
    description: builtins.str
    """Human-readable description, provided by Stream"""
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of tags associated with action"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "name", b"name", "tags", b"tags"]) -> None: ...

global___Action = Action

class Permission(google.protobuf.message.Message):
    """Permission defines a way to allow someone to perform an action
    Permission always governs one Action, and the set of actions is predefined by the product
    Also, Permission contains a condition which defines whether this permission applies to authorized user.
    There are builtin permissions that are provided by Stream with default permission settings. Builtin permissions cannot be deleted.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    SIMPLE_FIELD_NUMBER: builtins.int
    CUSTOM_MQ_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique permission ID"""
    name: builtins.str
    """Human readable permission name"""
    description: builtins.str
    """Human readable permission description"""
    action: builtins.str
    """Action name that this permission applies to"""
    @property
    def simple(self) -> global___SimpleCondition:
        """Simple condition based on resource ownership and user team"""
    custom_mq: builtins.bytes
    """JSON object containing custom MQ condition. When condition is evaluted to `true`, the permission is granted"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        action: builtins.str = ...,
        simple: global___SimpleCondition | None = ...,
        custom_mq: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["condition", b"condition", "custom_mq", b"custom_mq", "simple", b"simple"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "condition", b"condition", "custom_mq", b"custom_mq", "description", b"description", "id", b"id", "name", b"name", "simple", b"simple"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["condition", b"condition"]) -> typing_extensions.Literal["simple", "custom_mq"] | None: ...

global___Permission = Permission

class SimpleCondition(google.protobuf.message.Message):
    """A message containing simple permission condition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OWNER_FIELD_NUMBER: builtins.int
    SAME_TEAM_FIELD_NUMBER: builtins.int
    owner: builtins.bool
    """When set to true, a permission is only granted when authorized user owns the resource that it acts on"""
    same_team: builtins.bool
    """When set to true, a permission is only granted when authorized user interacts with a resource from the same team"""
    def __init__(
        self,
        *,
        owner: builtins.bool = ...,
        same_team: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["owner", b"owner", "same_team", b"same_team"]) -> None: ...

global___SimpleCondition = SimpleCondition

class Role(google.protobuf.message.Message):
    """Role is a role of an application user
    It can be assigned to a User itself or on a more granular level (channel member in chat or room member in video)
    There are builtin roles that are provided by Stream with default permission settings. Builtin roles cannot be deleted.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Role name"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Role creation date"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at", b"created_at", "name", b"name"]) -> None: ...

global___Role = Role

class Scope(google.protobuf.message.Message):
    """Scope is a top-level permission group which governs all resources in it
    In chat, scope is a Channel Type. In video - Room Type
    There is also special `.app` scope which governs all resources that cannot be assigned to any scope (e.g. users)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class GrantsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Grants: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Grants | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    GRANTS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique scope ID"""
    description: builtins.str
    """Human readable scope description, provided by Stream"""
    @property
    def grants(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Grants]:
        """A list of roles and their permissions in this scope
        If a role does not have any permissions, it will not be present in this list
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        grants: collections.abc.Mapping[builtins.str, global___Grants] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "grants", b"grants", "id", b"id"]) -> None: ...

global___Scope = Scope

class Grants(google.protobuf.message.Message):
    """Grants is set of permissions that belong to a particular role"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROLE_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    role: builtins.str
    """Role name that these grants apply to"""
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of Permission IDs"""
    def __init__(
        self,
        *,
        role: builtins.str = ...,
        permissions: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["permissions", b"permissions", "role", b"role"]) -> None: ...

global___Grants = Grants
