# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.5

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.storage.fileproperties
import winsdk.windows.storage.provider
import winsdk.windows.storage.search
import winsdk.windows.storage.streams
import winsdk.windows.system

class ApplicationDataCreateDisposition(enum.IntEnum):
    ALWAYS = 0
    EXISTING = 1

class ApplicationDataLocality(enum.IntEnum):
    LOCAL = 0
    ROAMING = 1
    TEMPORARY = 2
    LOCAL_CACHE = 3
    SHARED_LOCAL = 4

class CreationCollisionOption(enum.IntEnum):
    GENERATE_UNIQUE_NAME = 0
    REPLACE_EXISTING = 1
    FAIL_IF_EXISTS = 2
    OPEN_IF_EXISTS = 3

class FileAccessMode(enum.IntEnum):
    READ = 0
    READ_WRITE = 1

class FileAttributes(enum.IntFlag):
    NORMAL = 0
    READ_ONLY = 0x1
    DIRECTORY = 0x10
    ARCHIVE = 0x20
    TEMPORARY = 0x100
    LOCALLY_INCOMPLETE = 0x200

class KnownFolderId(enum.IntEnum):
    APP_CAPTURES = 0
    CAMERA_ROLL = 1
    DOCUMENTS_LIBRARY = 2
    HOME_GROUP = 3
    MEDIA_SERVER_DEVICES = 4
    MUSIC_LIBRARY = 5
    OBJECTS3_D = 6
    PICTURES_LIBRARY = 7
    PLAYLISTS = 8
    RECORDED_CALLS = 9
    REMOVABLE_DEVICES = 10
    SAVED_PICTURES = 11
    SCREENSHOTS = 12
    VIDEOS_LIBRARY = 13
    ALL_APP_MODS = 14
    CURRENT_APP_MODS = 15
    DOWNLOADS_FOLDER = 16

class KnownFoldersAccessStatus(enum.IntEnum):
    DENIED_BY_SYSTEM = 0
    NOT_DECLARED_BY_APP = 1
    DENIED_BY_USER = 2
    USER_PROMPT_REQUIRED = 3
    ALLOWED = 4
    ALLOWED_PER_APP_FOLDER = 5

class KnownLibraryId(enum.IntEnum):
    MUSIC = 0
    PICTURES = 1
    VIDEOS = 2
    DOCUMENTS = 3

class NameCollisionOption(enum.IntEnum):
    GENERATE_UNIQUE_NAME = 0
    REPLACE_EXISTING = 1
    FAIL_IF_EXISTS = 2

class StorageDeleteOption(enum.IntEnum):
    DEFAULT = 0
    PERMANENT_DELETE = 1

class StorageItemTypes(enum.IntFlag):
    NONE = 0
    FILE = 0x1
    FOLDER = 0x2

class StorageLibraryChangeType(enum.IntEnum):
    CREATED = 0
    DELETED = 1
    MOVED_OR_RENAMED = 2
    CONTENTS_CHANGED = 3
    MOVED_OUT_OF_LIBRARY = 4
    MOVED_INTO_LIBRARY = 5
    CONTENTS_REPLACED = 6
    INDEXING_STATUS_CHANGED = 7
    ENCRYPTION_CHANGED = 8
    CHANGE_TRACKING_LOST = 9

class StorageOpenOptions(enum.IntFlag):
    NONE = 0
    ALLOW_ONLY_READERS = 0x1
    ALLOW_READERS_AND_WRITERS = 0x2

class StreamedFileFailureMode(enum.IntEnum):
    FAILED = 0
    CURRENTLY_UNAVAILABLE = 1
    INCOMPLETE = 2

Self = typing.TypeVar('Self')

class AppDataPaths(_winrt.Object):
    cookies: str
    desktop: str
    documents: str
    favorites: str
    history: str
    internet_cache: str
    local_app_data: str
    program_data: str
    roaming_app_data: str
    @staticmethod
    def _from(obj: _winrt.Object) -> AppDataPaths: ...
    @staticmethod
    def get_default() -> typing.Optional[AppDataPaths]: ...
    @staticmethod
    def get_for_user(user: typing.Optional[winsdk.windows.system.User]) -> typing.Optional[AppDataPaths]: ...

class ApplicationData(_winrt.Object):
    local_folder: typing.Optional[StorageFolder]
    local_settings: typing.Optional[ApplicationDataContainer]
    roaming_folder: typing.Optional[StorageFolder]
    roaming_settings: typing.Optional[ApplicationDataContainer]
    roaming_storage_quota: _winrt.UInt64
    temporary_folder: typing.Optional[StorageFolder]
    version: _winrt.UInt32
    local_cache_folder: typing.Optional[StorageFolder]
    shared_local_folder: typing.Optional[StorageFolder]
    current: typing.Optional[ApplicationData]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> ApplicationData: ...
    @typing.overload
    def clear_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def clear_async(self, locality: ApplicationDataLocality) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def clear_publisher_cache_folder_async(self, folder_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def close(self) -> None: ...
    @staticmethod
    def get_for_user_async(user: typing.Optional[winsdk.windows.system.User]) -> winsdk.windows.foundation.IAsyncOperation[ApplicationData]: ...
    def get_publisher_cache_folder(self, folder_name: str) -> typing.Optional[StorageFolder]: ...
    def set_version_async(self, desired_version: _winrt.UInt32, handler: typing.Optional[ApplicationDataSetVersionHandler]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def signal_data_changed(self) -> None: ...
    def add_data_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ApplicationData, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_data_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ApplicationDataCompositeValue(_winrt.Object, typing.MutableMapping[str, _winrt.Object]):
    size: _winrt.UInt32
    def __len__(self) -> int: ...
    def __iter__(self) -> typing.Iterator[str]: ...
    def __contains__(self, key: object) -> bool:...
    def __setitem__(self, key: str, value: _winrt.Object) -> None: ...
    def __getitem__(self, key: str) -> _winrt.Object: ...
    def __delitem__(self, key: str) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> ApplicationDataCompositeValue: ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[winsdk.windows.foundation.collections.IKeyValuePair[str, _winrt.Object]]]: ...
    def get_view(self) -> typing.Optional[winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]]: ...
    def has_key(self, key: str) -> _winrt.Boolean: ...
    def insert(self, key: str, value: typing.Optional[_winrt.Object]) -> _winrt.Boolean: ...
    def lookup(self, key: str) -> typing.Optional[_winrt.Object]: ...
    def remove(self, key: str) -> None: ...
    def add_map_changed(self, vhnd: winsdk.windows.foundation.collections.MapChangedEventHandler[str, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_map_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ApplicationDataContainer(_winrt.Object):
    containers: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, ApplicationDataContainer]]
    locality: ApplicationDataLocality
    name: str
    values: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> ApplicationDataContainer: ...
    def close(self) -> None: ...
    def create_container(self, name: str, disposition: ApplicationDataCreateDisposition) -> typing.Optional[ApplicationDataContainer]: ...
    def delete_container(self, name: str) -> None: ...

class ApplicationDataContainerSettings(_winrt.Object, typing.MutableMapping[str, _winrt.Object]):
    size: _winrt.UInt32
    def __len__(self) -> int: ...
    def __iter__(self) -> typing.Iterator[str]: ...
    def __contains__(self, key: object) -> bool:...
    def __setitem__(self, key: str, value: _winrt.Object) -> None: ...
    def __getitem__(self, key: str) -> _winrt.Object: ...
    def __delitem__(self, key: str) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> ApplicationDataContainerSettings: ...
    def clear(self) -> None: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[winsdk.windows.foundation.collections.IKeyValuePair[str, _winrt.Object]]]: ...
    def get_view(self) -> typing.Optional[winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]]: ...
    def has_key(self, key: str) -> _winrt.Boolean: ...
    def insert(self, key: str, value: typing.Optional[_winrt.Object]) -> _winrt.Boolean: ...
    def lookup(self, key: str) -> typing.Optional[_winrt.Object]: ...
    def remove(self, key: str) -> None: ...
    def add_map_changed(self, vhnd: winsdk.windows.foundation.collections.MapChangedEventHandler[str, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_map_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class CachedFileManager(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> CachedFileManager: ...
    @staticmethod
    def complete_updates_async(file: typing.Optional[IStorageFile]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.provider.FileUpdateStatus]: ...
    @staticmethod
    def defer_updates(file: typing.Optional[IStorageFile]) -> None: ...

class DownloadsFolder(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> DownloadsFolder: ...
    @typing.overload
    @staticmethod
    def create_file_async(desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_file_async(desired_name: str, option: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_file_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_file_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str, option: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    @staticmethod
    def create_folder_async(desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    @staticmethod
    def create_folder_async(desired_name: str, option: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    @staticmethod
    def create_folder_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    @staticmethod
    def create_folder_for_user_async(user: typing.Optional[winsdk.windows.system.User], desired_name: str, option: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...

class FileIO(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> FileIO: ...
    @typing.overload
    @staticmethod
    def append_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def append_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def append_text_async(file: typing.Optional[IStorageFile], contents: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def append_text_async(file: typing.Optional[IStorageFile], contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @staticmethod
    def read_buffer_async(file: typing.Optional[IStorageFile]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(file: typing.Optional[IStorageFile]) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(file: typing.Optional[IStorageFile], encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_text_async(file: typing.Optional[IStorageFile]) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    @staticmethod
    def read_text_async(file: typing.Optional[IStorageFile], encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @staticmethod
    def write_buffer_async(file: typing.Optional[IStorageFile], buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @staticmethod
    def write_bytes_async(file: typing.Optional[IStorageFile], buffer: typing.Sequence[_winrt.UInt8]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_lines_async(file: typing.Optional[IStorageFile], lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_text_async(file: typing.Optional[IStorageFile], contents: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_text_async(file: typing.Optional[IStorageFile], contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...

class KnownFolders(_winrt.Object):
    camera_roll: typing.Optional[StorageFolder]
    playlists: typing.Optional[StorageFolder]
    saved_pictures: typing.Optional[StorageFolder]
    documents_library: typing.Optional[StorageFolder]
    home_group: typing.Optional[StorageFolder]
    media_server_devices: typing.Optional[StorageFolder]
    music_library: typing.Optional[StorageFolder]
    pictures_library: typing.Optional[StorageFolder]
    removable_devices: typing.Optional[StorageFolder]
    videos_library: typing.Optional[StorageFolder]
    app_captures: typing.Optional[StorageFolder]
    objects3_d: typing.Optional[StorageFolder]
    recorded_calls: typing.Optional[StorageFolder]
    @staticmethod
    def _from(obj: _winrt.Object) -> KnownFolders: ...
    @staticmethod
    def get_folder_async(folder_id: KnownFolderId) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def get_folder_for_user_async(user: typing.Optional[winsdk.windows.system.User], folder_id: KnownFolderId) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def request_access_async(folder_id: KnownFolderId) -> winsdk.windows.foundation.IAsyncOperation[KnownFoldersAccessStatus]: ...
    @staticmethod
    def request_access_for_user_async(user: typing.Optional[winsdk.windows.system.User], folder_id: KnownFolderId) -> winsdk.windows.foundation.IAsyncOperation[KnownFoldersAccessStatus]: ...

class PathIO(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> PathIO: ...
    @typing.overload
    @staticmethod
    def append_lines_async(absolute_path: str, lines: typing.Iterable[str]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def append_lines_async(absolute_path: str, lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def append_text_async(absolute_path: str, contents: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def append_text_async(absolute_path: str, contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @staticmethod
    def read_buffer_async(absolute_path: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IBuffer]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(absolute_path: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_lines_async(absolute_path: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVector[str]]: ...
    @typing.overload
    @staticmethod
    def read_text_async(absolute_path: str) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @typing.overload
    @staticmethod
    def read_text_async(absolute_path: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> winsdk.windows.foundation.IAsyncOperation[str]: ...
    @staticmethod
    def write_buffer_async(absolute_path: str, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @staticmethod
    def write_bytes_async(absolute_path: str, buffer: typing.Sequence[_winrt.UInt8]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_lines_async(absolute_path: str, lines: typing.Iterable[str]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_lines_async(absolute_path: str, lines: typing.Iterable[str], encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_text_async(absolute_path: str, contents: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    @staticmethod
    def write_text_async(absolute_path: str, contents: str, encoding: winsdk.windows.storage.streams.UnicodeEncoding) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...

class SetVersionDeferral(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> SetVersionDeferral: ...
    def complete(self) -> None: ...

class SetVersionRequest(_winrt.Object):
    current_version: _winrt.UInt32
    desired_version: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> SetVersionRequest: ...
    def get_deferral(self) -> typing.Optional[SetVersionDeferral]: ...

class StorageFile(_winrt.Object):
    content_type: str
    file_type: str
    is_available: _winrt.Boolean
    attributes: FileAttributes
    date_created: winsdk.windows.foundation.DateTime
    name: str
    path: str
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    provider: typing.Optional[StorageProvider]
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageFile: ...
    def copy_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder]) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def create_streamed_file_async(display_name_with_extension: str, data_requested: typing.Optional[StreamedFileDataRequestedHandler], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def create_streamed_file_from_uri_async(display_name_with_extension: str, uri: typing.Optional[winsdk.windows.foundation.Uri], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def delete_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    @staticmethod
    def get_file_from_application_uri_async(uri: typing.Optional[winsdk.windows.foundation.Uri]) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def get_file_from_path_async(path: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def get_file_from_path_for_user_async(user: typing.Optional[winsdk.windows.system.User], path: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    def get_parent_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    def is_equal(self, item: typing.Optional[IStorageItem]) -> _winrt.Boolean: ...
    def is_of_type(self, type: StorageItemTypes) -> _winrt.Boolean: ...
    def move_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def open_async(self, access_mode: FileAccessMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    @typing.overload
    def open_async(self, access_mode: FileAccessMode, options: StorageOpenOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def open_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType]: ...
    def open_sequential_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IInputStream]: ...
    @typing.overload
    def open_transacted_write_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...
    @typing.overload
    def open_transacted_write_async(self, options: StorageOpenOptions) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...
    @typing.overload
    def rename_async(self, desired_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @staticmethod
    def replace_with_streamed_file_async(file_to_replace: typing.Optional[IStorageFile], data_requested: typing.Optional[StreamedFileDataRequestedHandler], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @staticmethod
    def replace_with_streamed_file_from_uri_async(file_to_replace: typing.Optional[IStorageFile], uri: typing.Optional[winsdk.windows.foundation.Uri], thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...

class StorageFolder(_winrt.Object):
    attributes: FileAttributes
    date_created: winsdk.windows.foundation.DateTime
    name: str
    path: str
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    provider: typing.Optional[StorageProvider]
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageFolder: ...
    def are_query_options_supported(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions]) -> _winrt.Boolean: ...
    @typing.overload
    def create_file_async(self, desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_file_async(self, desired_name: str, options: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_file_query(self) -> typing.Optional[winsdk.windows.storage.search.StorageFileQueryResult]: ...
    @typing.overload
    def create_file_query(self, query: winsdk.windows.storage.search.CommonFileQuery) -> typing.Optional[winsdk.windows.storage.search.StorageFileQueryResult]: ...
    def create_file_query_with_options(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions]) -> typing.Optional[winsdk.windows.storage.search.StorageFileQueryResult]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str, options: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def create_folder_query(self) -> typing.Optional[winsdk.windows.storage.search.StorageFolderQueryResult]: ...
    @typing.overload
    def create_folder_query(self, query: winsdk.windows.storage.search.CommonFolderQuery) -> typing.Optional[winsdk.windows.storage.search.StorageFolderQueryResult]: ...
    def create_folder_query_with_options(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions]) -> typing.Optional[winsdk.windows.storage.search.StorageFolderQueryResult]: ...
    def create_item_query(self) -> typing.Optional[winsdk.windows.storage.search.StorageItemQueryResult]: ...
    def create_item_query_with_options(self, query_options: typing.Optional[winsdk.windows.storage.search.QueryOptions]) -> typing.Optional[winsdk.windows.storage.search.StorageItemQueryResult]: ...
    @typing.overload
    def delete_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def get_file_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def get_files_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    @typing.overload
    def get_files_async(self, query: winsdk.windows.storage.search.CommonFileQuery) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    @typing.overload
    def get_files_async(self, query: winsdk.windows.storage.search.CommonFileQuery, start_index: _winrt.UInt32, max_items_to_retrieve: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    def get_folder_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def get_folder_from_path_async(path: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @staticmethod
    def get_folder_from_path_for_user_async(user: typing.Optional[winsdk.windows.system.User], path: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def get_folders_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    @typing.overload
    def get_folders_async(self, query: winsdk.windows.storage.search.CommonFolderQuery) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    @typing.overload
    def get_folders_async(self, query: winsdk.windows.storage.search.CommonFolderQuery, start_index: _winrt.UInt32, max_items_to_retrieve: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    def get_indexed_state_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.search.IndexedState]: ...
    def get_item_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...
    @typing.overload
    def get_items_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IStorageItem]]: ...
    @typing.overload
    def get_items_async(self, start_index: _winrt.UInt32, max_items_to_retrieve: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IStorageItem]]: ...
    def get_parent_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    def is_common_file_query_supported(self, query: winsdk.windows.storage.search.CommonFileQuery) -> _winrt.Boolean: ...
    def is_common_folder_query_supported(self, query: winsdk.windows.storage.search.CommonFolderQuery) -> _winrt.Boolean: ...
    def is_equal(self, item: typing.Optional[IStorageItem]) -> _winrt.Boolean: ...
    def is_of_type(self, type: StorageItemTypes) -> _winrt.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def try_get_change_tracker(self) -> typing.Optional[StorageLibraryChangeTracker]: ...
    def try_get_item_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...

class StorageLibrary(_winrt.Object):
    folders: typing.Optional[winsdk.windows.foundation.collections.IObservableVector[StorageFolder]]
    save_folder: typing.Optional[StorageFolder]
    change_tracker: typing.Optional[StorageLibraryChangeTracker]
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageLibrary: ...
    def are_folder_suggestions_available_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @staticmethod
    def get_library_async(library_id: KnownLibraryId) -> winsdk.windows.foundation.IAsyncOperation[StorageLibrary]: ...
    @staticmethod
    def get_library_for_user_async(user: typing.Optional[winsdk.windows.system.User], library_id: KnownLibraryId) -> winsdk.windows.foundation.IAsyncOperation[StorageLibrary]: ...
    def request_add_folder_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    def request_remove_folder_async(self, folder: typing.Optional[StorageFolder]) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    def add_definition_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[StorageLibrary, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_definition_changed(self, event_cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class StorageLibraryChange(_winrt.Object):
    change_type: StorageLibraryChangeType
    path: str
    previous_path: str
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageLibraryChange: ...
    def get_storage_item_async(self) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...
    def is_of_type(self, type: StorageItemTypes) -> _winrt.Boolean: ...

class StorageLibraryChangeReader(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageLibraryChangeReader: ...
    def accept_changes_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def get_last_change_id(self) -> _winrt.UInt64: ...
    def read_batch_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageLibraryChange]]: ...

class StorageLibraryChangeTracker(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageLibraryChangeTracker: ...
    def disable(self) -> None: ...
    @typing.overload
    def enable(self) -> None: ...
    @typing.overload
    def enable(self, options: typing.Optional[StorageLibraryChangeTrackerOptions]) -> None: ...
    def get_change_reader(self) -> typing.Optional[StorageLibraryChangeReader]: ...
    def reset(self) -> None: ...

class StorageLibraryChangeTrackerOptions(_winrt.Object):
    track_change_details: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageLibraryChangeTrackerOptions: ...
    def __init__(self) -> None: ...

class StorageLibraryLastChangeId(_winrt.Object):
    unknown: _winrt.UInt64
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageLibraryLastChangeId: ...

class StorageProvider(_winrt.Object):
    display_name: str
    id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageProvider: ...
    def is_property_supported_for_partial_file_async(self, property_canonical_name: str) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...

class StorageStreamTransaction(_winrt.Object):
    stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> StorageStreamTransaction: ...
    def close(self) -> None: ...
    def commit_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...

class StreamedFileDataRequest(_winrt.Object):
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> StreamedFileDataRequest: ...
    def close(self) -> None: ...
    def fail_and_close(self, failure_mode: StreamedFileFailureMode) -> None: ...
    def flush_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    def write_async(self, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[_winrt.UInt32, _winrt.UInt32]: ...

class SystemAudioProperties(_winrt.Object):
    encoding_bitrate: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemAudioProperties: ...

class SystemDataPaths(_winrt.Object):
    fonts: str
    program_data: str
    public: str
    public_desktop: str
    public_documents: str
    public_downloads: str
    public_music: str
    public_pictures: str
    public_videos: str
    system: str
    system_arm: str
    system_host: str
    system_x64: str
    system_x86: str
    user_profiles: str
    windows: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemDataPaths: ...
    @staticmethod
    def get_default() -> typing.Optional[SystemDataPaths]: ...

class SystemGPSProperties(_winrt.Object):
    latitude_decimal: str
    longitude_decimal: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemGPSProperties: ...

class SystemImageProperties(_winrt.Object):
    horizontal_size: str
    vertical_size: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemImageProperties: ...

class SystemMediaProperties(_winrt.Object):
    duration: str
    producer: str
    publisher: str
    sub_title: str
    writer: str
    year: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemMediaProperties: ...

class SystemMusicProperties(_winrt.Object):
    album_artist: str
    album_title: str
    artist: str
    composer: str
    conductor: str
    display_artist: str
    genre: str
    track_number: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemMusicProperties: ...

class SystemPhotoProperties(_winrt.Object):
    camera_manufacturer: str
    camera_model: str
    date_taken: str
    orientation: str
    people_names: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemPhotoProperties: ...

class SystemProperties(_winrt.Object):
    audio: typing.Optional[SystemAudioProperties]
    author: str
    comment: str
    g_p_s: typing.Optional[SystemGPSProperties]
    image: typing.Optional[SystemImageProperties]
    item_name_display: str
    keywords: str
    media: typing.Optional[SystemMediaProperties]
    music: typing.Optional[SystemMusicProperties]
    photo: typing.Optional[SystemPhotoProperties]
    rating: str
    title: str
    video: typing.Optional[SystemVideoProperties]
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemProperties: ...

class SystemVideoProperties(_winrt.Object):
    director: str
    frame_height: str
    frame_width: str
    orientation: str
    total_bitrate: str
    @staticmethod
    def _from(obj: _winrt.Object) -> SystemVideoProperties: ...

class UserDataPaths(_winrt.Object):
    camera_roll: str
    cookies: str
    desktop: str
    documents: str
    downloads: str
    favorites: str
    history: str
    internet_cache: str
    local_app_data: str
    local_app_data_low: str
    music: str
    pictures: str
    profile: str
    recent: str
    roaming_app_data: str
    saved_pictures: str
    screenshots: str
    templates: str
    videos: str
    @staticmethod
    def _from(obj: _winrt.Object) -> UserDataPaths: ...
    @staticmethod
    def get_default() -> typing.Optional[UserDataPaths]: ...
    @staticmethod
    def get_for_user(user: typing.Optional[winsdk.windows.system.User]) -> typing.Optional[UserDataPaths]: ...

class IStorageFile(_winrt.Object):
    content_type: str
    file_type: str
    attributes: FileAttributes
    date_created: winsdk.windows.foundation.DateTime
    name: str
    path: str
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageFile: ...
    def copy_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder]) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def copy_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    def move_and_replace_async(self, file_to_replace: typing.Optional[IStorageFile]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def move_async(self, destination_folder: typing.Optional[IStorageFolder], desired_new_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def open_async(self, access_mode: FileAccessMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def open_transacted_write_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...
    @typing.overload
    def delete_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def is_of_type(self, type: StorageItemTypes) -> _winrt.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def open_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType]: ...
    def open_sequential_read_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IInputStream]: ...

class IStorageFile2(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageFile2: ...
    def open_async(self, access_mode: FileAccessMode, options: StorageOpenOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def open_transacted_write_async(self, options: StorageOpenOptions) -> winsdk.windows.foundation.IAsyncOperation[StorageStreamTransaction]: ...

class IStorageFilePropertiesWithAvailability(_winrt.Object):
    is_available: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageFilePropertiesWithAvailability: ...

class IStorageFolder(_winrt.Object):
    attributes: FileAttributes
    date_created: winsdk.windows.foundation.DateTime
    name: str
    path: str
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageFolder: ...
    @typing.overload
    def create_file_async(self, desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_file_async(self, desired_name: str, options: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    @typing.overload
    def create_folder_async(self, desired_name: str, options: CreationCollisionOption) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    def get_file_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFile]: ...
    def get_files_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFile]]: ...
    def get_folder_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    def get_folders_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[StorageFolder]]: ...
    def get_item_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...
    def get_items_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[IStorageItem]]: ...
    @typing.overload
    def delete_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def is_of_type(self, type: StorageItemTypes) -> _winrt.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...

class IStorageFolder2(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageFolder2: ...
    def try_get_item_async(self, name: str) -> winsdk.windows.foundation.IAsyncOperation[IStorageItem]: ...

class IStorageItem(_winrt.Object):
    attributes: FileAttributes
    date_created: winsdk.windows.foundation.DateTime
    name: str
    path: str
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageItem: ...
    @typing.overload
    def delete_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def is_of_type(self, type: StorageItemTypes) -> _winrt.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...

class IStorageItem2(_winrt.Object):
    attributes: FileAttributes
    date_created: winsdk.windows.foundation.DateTime
    name: str
    path: str
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageItem2: ...
    def get_parent_async(self) -> winsdk.windows.foundation.IAsyncOperation[StorageFolder]: ...
    def is_equal(self, item: typing.Optional[IStorageItem]) -> _winrt.Boolean: ...
    @typing.overload
    def delete_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def delete_async(self, option: StorageDeleteOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def get_basic_properties_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.BasicProperties]: ...
    def is_of_type(self, type: StorageItemTypes) -> _winrt.Boolean: ...
    @typing.overload
    def rename_async(self, desired_name: str) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    @typing.overload
    def rename_async(self, desired_name: str, option: NameCollisionOption) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...

class IStorageItemProperties(_winrt.Object):
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageItemProperties: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...

class IStorageItemProperties2(_winrt.Object):
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageItemProperties2: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_scaled_image_as_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...

class IStorageItemPropertiesWithProvider(_winrt.Object):
    provider: typing.Optional[StorageProvider]
    display_name: str
    display_type: str
    folder_relative_id: str
    properties: typing.Optional[winsdk.windows.storage.fileproperties.StorageItemContentProperties]
    @staticmethod
    def _from(obj: _winrt.Object) -> IStorageItemPropertiesWithProvider: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...
    @typing.overload
    def get_thumbnail_async(self, mode: winsdk.windows.storage.fileproperties.ThumbnailMode, requested_size: _winrt.UInt32, options: winsdk.windows.storage.fileproperties.ThumbnailOptions) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.fileproperties.StorageItemThumbnail]: ...

class IStreamedFileDataRequest(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> IStreamedFileDataRequest: ...
    def fail_and_close(self, failure_mode: StreamedFileFailureMode) -> None: ...

ApplicationDataSetVersionHandler = typing.Callable[[typing.Optional[SetVersionRequest]], None]

StreamedFileDataRequestedHandler = typing.Callable[[typing.Optional[StreamedFileDataRequest]], None]

