"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUrlIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpUrlIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param url the URL to proxy to
     * @param props properties to configure the integration
     */
    constructor(id, url, props = {}) {
        super(id);
        this.url = url;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpUrlIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(_) {
        var _b;
        return {
            method: (_b = this.props.method) !== null && _b !== void 0 ? _b : aws_apigatewayv2_alpha_1.HttpMethod.ANY,
            payloadFormatVersion: aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0,
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.url,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpUrlIntegration = HttpUrlIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpUrlIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpUrlIntegration", version: "2.27.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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