# How to contribute

Project contains abstraction of `pymongo` driver for automatic reconnect on master switch in remote MongoDB cluster. It
also provides data definition layer.

## Getting Started

* Make sure you have a GitLab account.
* Submit a ticket for your issue, assuming one does not already exist.
    * Clearly describe the issue including steps to reproduce when it is a bug.
    * Make sure you fill in the earliest version that you know has the issue.
* Clone the repository

## Making Changes

* Create a topic branch from where you want to base your work.
    * This is usually the `dev` branch.
    * Only target release branches if you are certain your fix must be on that
      branch.
    * Please avoid working directly on the `master` branch.
* Make commits of logical units.
* Make sure your commit messages are in the proper format.

## Submitting Changes

* Push your changes to a topic branch into the repository.
* Update your ticket to mark that you have submitted code and are ready for it to be reviewed (Status: Ready for Merge).
    * Include a link to the pull request in the ticket.
* The core team looks at Pull Requests on a regular basis.
* After feedback has been given we expect responses within two weeks. After two
  weeks we may close the pull request if it isn't showing any activity.
