from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "readme.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.1'
DESCRIPTION = 'Qalm is a way to handle Files IO in One-Line'
LONG_DESCRIPTION = '''We deal with files all the time 
& most of time handling files makes our
code NOT-DRY, with Qalm you can read/write & more in One-Line '''


setup(
    name="Qalm",
    version=VERSION,
    author="astroxiii (abderrahim mokhnache)",
    author_email="<abderrahimokhnache@gmail.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=[],
    keywords=['python'],
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)