# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetOrderCartProductOptionsResult',
    'AwaitableGetOrderCartProductOptionsResult',
    'get_order_cart_product_options',
    'get_order_cart_product_options_output',
]

@pulumi.output_type
class GetOrderCartProductOptionsResult:
    """
    A collection of values returned by getOrderCartProductOptions.
    """
    def __init__(__self__, cart_id=None, catalog_name=None, id=None, plan_code=None, product=None, results=None):
        if cart_id and not isinstance(cart_id, str):
            raise TypeError("Expected argument 'cart_id' to be a str")
        pulumi.set(__self__, "cart_id", cart_id)
        if catalog_name and not isinstance(catalog_name, str):
            raise TypeError("Expected argument 'catalog_name' to be a str")
        pulumi.set(__self__, "catalog_name", catalog_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plan_code and not isinstance(plan_code, str):
            raise TypeError("Expected argument 'plan_code' to be a str")
        pulumi.set(__self__, "plan_code", plan_code)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="cartId")
    def cart_id(self) -> str:
        return pulumi.get(self, "cart_id")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[str]:
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> str:
        """
        Product offer identifier
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter
    def product(self) -> str:
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetOrderCartProductOptionsResultResult']:
        """
        products results
        """
        return pulumi.get(self, "results")


class AwaitableGetOrderCartProductOptionsResult(GetOrderCartProductOptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrderCartProductOptionsResult(
            cart_id=self.cart_id,
            catalog_name=self.catalog_name,
            id=self.id,
            plan_code=self.plan_code,
            product=self.product,
            results=self.results)


def get_order_cart_product_options(cart_id: Optional[str] = None,
                                   catalog_name: Optional[str] = None,
                                   plan_code: Optional[str] = None,
                                   product: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrderCartProductOptionsResult:
    """
    Use this data source to retrieve information of order cart product options.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mycart = ovh.get_order_cart(ovh_subsidiary="fr",
        description="my cart")
    options = ovh.get_order_cart_product_options(cart_id=mycart.id,
        product="cloud",
        plan_code="project")
    ```


    :param str cart_id: Cart identifier
    :param str catalog_name: Catalog name
    :param str plan_code: Product offer identifier
    :param str product: Product
    """
    __args__ = dict()
    __args__['cartId'] = cart_id
    __args__['catalogName'] = catalog_name
    __args__['planCode'] = plan_code
    __args__['product'] = product
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getOrderCartProductOptions:getOrderCartProductOptions', __args__, opts=opts, typ=GetOrderCartProductOptionsResult).value

    return AwaitableGetOrderCartProductOptionsResult(
        cart_id=__ret__.cart_id,
        catalog_name=__ret__.catalog_name,
        id=__ret__.id,
        plan_code=__ret__.plan_code,
        product=__ret__.product,
        results=__ret__.results)


@_utilities.lift_output_func(get_order_cart_product_options)
def get_order_cart_product_options_output(cart_id: Optional[pulumi.Input[str]] = None,
                                          catalog_name: Optional[pulumi.Input[Optional[str]]] = None,
                                          plan_code: Optional[pulumi.Input[str]] = None,
                                          product: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrderCartProductOptionsResult]:
    """
    Use this data source to retrieve information of order cart product options.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mycart = ovh.get_order_cart(ovh_subsidiary="fr",
        description="my cart")
    options = ovh.get_order_cart_product_options(cart_id=mycart.id,
        product="cloud",
        plan_code="project")
    ```


    :param str cart_id: Cart identifier
    :param str catalog_name: Catalog name
    :param str plan_code: Product offer identifier
    :param str product: Product
    """
    ...
