CREATE TABLE IF NOT EXISTS experiments
(
    EXP_ID  VARCHAR(100) NOT NULL,
    NAME    VARCHAR(100),
    CREATOR VARCHAR(100),
    START   DOUBLE,
    END     DOUBLE,
    CREATED DOUBLE,
    STATUS  VARCHAR(30) NOT NULL,
    CONSTRAINT experiments_pk PRIMARY KEY (EXP_ID)
);

CREATE TABLE IF NOT EXISTS nodeinfo
(
    EXP_ID      VARCHAR(100) NOT NULL,
    NODE        VARCHAR(50) NOT NULL,
    INFO_KEY    VARCHAR(50),
    INFO_VALUE  VARCHAR(255)
);

CREATE TABLE IF NOT EXISTS telemetry
(
    EXP_ID    VARCHAR(100) NOT NULL,
    TIMESTAMP DOUBLE       NOT NULL,
    METRIC    varchar(100) NOT NULL,
    NODE      varchar(50) NOT NULL,
    VALUE     DOUBLE       NOT NULL
);

CREATE TABLE IF NOT EXISTS events
(
    EXP_ID      VARCHAR(100) NOT NULL,
    TIMESTAMP   DOUBLE       NOT NULL,
    NAME        VARCHAR(100) NOT NULL,
    VALUE       VARCHAR(255)
);

CREATE TABLE IF NOT EXISTS traces
(
    REQUEST_ID  VARCHAR(36)  NOT NULL,
    CLIENT      VARCHAR(50) NOT NULL,
    SERVICE     VARCHAR(50) NOT NULL,
    CREATED     DOUBLE       NOT NULL,
    SENT        DOUBLE       NOT NULL,
    DONE        DOUBLE       NOT NULL,
    STATUS      INT,
    RESPONSE    TEXT,
    SERVER      VARCHAR (50),
    EXP_ID      VARCHAR (100),
    CONSTRAINT traces_pk PRIMARY KEY (REQUEST_ID)
);
