# BasinMaker - An automated GIS toolbox for watershed delineation with lakes
 
# Overview
Before introducing the methodology and application procedure of the BasinMaker, the differences between routing structure without considering lake and routing structure with lakes defined by BasinMaker will be introduce in this section. 

A routing structure without considering lakes is shown in Figure 1A. Catchments defined by river reaches in this routing structure are showed in Figure 1A. In hydrological models, the streamflow is only explicitly simulated at the outlet of each catchment. It is not explicitly simulated at the mid of the river segment or any point inside each catchment. Thus, when using this routing structure to build hydrological model, we could obtain the simulated streamflow at the end of each reach or catchment outlet in Figure 1A, but the inflow and the outflow of each lake shown in Figure 1 cannot be simulated. Thus, the impact of lake on the routing process modeling such as flow attenuation can not be correctly modeled. 

An example of routing structure with lakes generated by the BasinMaker is shown in Figure 1B. Lakes are divided into two categories by the BasinMaker: (1) connected lakes (CL), which indicates lakes directly connected with the river network; and (2) non-connected lakes (NCL), which denotes lakes not connected with the river network (Figure 1B). The resolution of the river network is defined by user provided flow accumulation threshold. Both CL and NCL defined here are within the drainage area of the watershed and water released from both CL and NCL will move to the outlet of the watershed. Thus, the definition of NCL here is not the same as the definition of none contributing area, in which runoff generated will not move to the watershed outlet.  

For both CL and NCL, the BasinMaker will use lake polygon to identify each lake’s inlets and outlet and then represent each lake as a lake catchment (LC) shown Figure 1B. A lake catchment will fully cover the lake polygon and its outlet is the same as the outlet of the lake (Figure 1B). At the same time, each inlet of the CL will also be identified as a catchment outlet (Figure 1B). In this way, both inflow and outflow of each lake can be explicitly simulated by the semi-distributed hydrological models. 

<figure>
    <p align="center">
    <img src="https://github.com/dustming/RoutingTool/wiki/Figures/Figure1.png" width="100%" height="100%" />
    </p>
    <font size="1">
    <figcaption width="50%"> <b>Figure 1</b>: Lakes in the generated routing network by the lake river routing toolbox. A is the predefined river network and catchment boundary (Catchment boundary (River)) defined by the predefined river network without considering lakes. Figure B, the generated lake river routing structure by this toolbox using predefined river network and lake's polygons.<br>
    </figcaption>
    </font>
</figure>


# Installation 

Installation instructions for BasinMaker can be found [here](https://basinmaker.readthedocs.io/en/latest/installation.html)


# Examples

Examples of BasinMaker can be found [here](http://hydrology.uwaterloo.ca/basinmaker/index.html)


# Authors

BasinMaker and the associated river and lake routing product was developed by the hydrology research group at the University of Waterloo. Primary Contributors includes Ming Han, Hongren Shen, Bryan A. Tolson, James R. Craig, Juliane Mai, Simon Lin, Nandita B. Basu, Frezer Awol. We also want to thank Robert Chlumsky, Étienne Gaborit, Hongli Liu, Konhee Lee for their secondary support in development of this product and their contributions to our Pan-Canadian routing product.

# Citation

 - Han, M., J. Mai, B. A. Tolson, J. R. Craig, É. Gaborit, H. Liu, and K. Lee, Subwatershed-based lake and river routing products for hydrologic and land surface models applied over Canada, Canadian Water Resources Journal, 2020 (paper)

and/or cite the zenodo dataset directly:

 - Han, M., J. Mai, B. A. Tolson, J. R. Craig, É. Gaborit, H. Liu, and K. Lee. 2020. A Catchment-Based Lake and River Routing Product for Hydrologic and Land Surface Models in Canada. (routing product v1.0)
 
 - Han, M., H. Shen, B. A. Tolson, J. R. Craig, J. Mai, S. Lin, N. B. Basu, F. Awol. 2021. North American Lake-River Routing Product v 2.0, derived by BasinMaker GIS Toolbox (routing product v2.0)

- Han, M., H. Shen, B. A. Tolson, J. R. Craig, J. Mai, S. Lin, N. B. Basu, F. Awol. 2021. North American Lake-River Routing Product v 2.1, derived by BasinMaker GIS Toolbox (routing product v2.1)

# License

BasinMaker is open-source under the [Artistic License 2.0](https://opensource.org/licenses/Artistic-2.0). This sofware is freely distributed ’as is’ without warranties or conditions of any kind, either express or implied, including, without limitation, any warranties or conditions of title, non-infringement, merchantability, or fitness for a particular purpose.




