# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/03_data.transforms.kssl.ipynb.

# %% ../../../nbs/03_data.transforms.kssl.ipynb 2
from __future__ import annotations
from fastai.vision.all import *
from fastai.data.all import *
from fastcore.basics import patch
from pathlib import Path
import pandas as pd

# %% auto 0
__all__ = ['get_spectra_files', 'Spectra', 'to_spectra', 'rand_w_avg', 'Analyte', 'AnalytesTfm', 'encodes']

# %% ../../../nbs/03_data.transforms.kssl.ipynb 6
@Transform
def get_spectra_files(path:Path, # Directory that contains spectra replicates and wet chemistry
                     ) -> L: # List of spectra replicates (if any) file paths in the directory
    "Return list of paths to spectra `.csv` files"
    return L(fname for fname in path.ls() if re.match('\d', fname.name))

# %% ../../../nbs/03_data.transforms.kssl.ipynb 9
class Spectra(Tensor): 
    def show(self, ctx=None, figsize=(12,4), **kwargs):
        spectra = self
        if ctx is None: _,ctx = plt.subplots(figsize=figsize)
        wn = np.arange(4000, 600, -2)
        #ctx.imshow(im, **{**self._show_args, **kwargs})
        ctx.set_xlim(np.max(wn), np.min(wn))
        ctx.set(xlabel='Wavenumber', ylabel='Absorbance')
        ctx.set_axisbelow(True)
        for spectrum in spectra:
            _ = ctx.plot(wn, spectrum, c='steelblue', lw=0.5)
        ctx.grid(True, which='both')
        return ctx

# %% ../../../nbs/03_data.transforms.kssl.ipynb 10
@Transform
def to_spectra(paths:L, # List of spectra file paths
              ) -> Spectra: # Spectra
    "Transform list of spectra file paths to a torch array of dimension: (n_replicates, n_wavenumbers)"
    n = pd.read_csv(paths[0]).shape[0]
    m = len(paths)
    x = np.empty((m,n))
    for i, fname in enumerate(paths):
        x[i,:] = pd.read_csv(fname)['absorbance'].values
    return Spectra(x)

# %% ../../../nbs/03_data.transforms.kssl.ipynb 13
@Transform
def rand_w_avg(x: Spectra, # Spectra replicates (n_replicates, n_wavenumbers)
              ) -> Spectra: # Random weighted averaged spectrum
    "Transform spectra replicates taking their random weighted averages for data augmentation"
    n = len(x)
    def weights(n):
        weights = torch.rand(n)
        return (weights/weights.sum()).unsqueeze(dim=0)
    return torch.matmul(weights(n), x)

# %% ../../../nbs/03_data.transforms.kssl.ipynb 16
class Analyte(Tensor): 
    def show(self, ctx=None, **kwargs):
        analytes = self
        print(analytes)

# %% ../../../nbs/03_data.transforms.kssl.ipynb 17
class AnalytesTfm(Transform):
    def __init__(self, 
                 analytes:list|None=None): 
        self.analytes = analytes

# %% ../../../nbs/03_data.transforms.kssl.ipynb 18
@AnalytesTfm
def encodes(self, 
            path: Path, # Path to directory containing both spectra and analyte(s) measurement
           ):
    "Transform a path to a directory into a tensor of soil analyte(s) measurement"
    path_target = [f for f in path.ls() if re.match('target', f.name)][0]
    df = pd.read_csv(path_target)
    if self.analytes:
        df = df[df.analyte.isin(self.analytes)]
    return Analyte(df['value'].values)
